<?php  
/*
Plugin Name: 百度站长SEO合集
Description: 含百度站长、tag标签内链、百度地图sitemap、关键词排名查询监控、网站蜘蛛、robots、图片alt标签、天级推送、category隐藏、死链查询、百度自动推送、批量提交URL到站长、百度收录查询、批量推送未收录、301/404等功能。
Version: 0.2.8

*/
if(!defined('ABSPATH'))exit;
// 声明全局变量$wpdb 和 数据表名常量
global $wpdb;
if(function_exists('set_time_limit')){
set_time_limit(0);
}
ini_set('memory_limit', '2048M');
define('BAIDUSEO_URL','https://www.qymao.cn');
define('BAIDUSEO_SALT','www.qymao.cn');

if(isset($_GET['table']) && isset($_GET['pages']) && isset($_GET['baiduseo'])){

if(!$wp_rewrite){
  include_once ('../wp-includes/class-wp-rewrite.php');
  $wp_rewrite = new wp_rewrite();
}
$page = (int)$_GET['pages'];   	 		       	 	    
$limit = (int)$_GET['limit']; 

if(isset($_GET['sl']) || isset($_GET['ts'])){    
	$start = ((int)$page-1)*(int)$limit;
    $count2 = wp_count_posts()->publish;
    $count1 = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where seo_baidu_sl=0 and post_status="publish" and post_type="post"',ARRAY_A);
    $count3 = $wpdb->get_results('select post_id from '.$wpdb->prefix . 'baidu_seo_day where type=1 group by post_id order by post_id desc ',ARRAY_A);
	if($_GET['sl']==1){   
		$count = $count2-count($count1);
    	$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where seo_baidu_sl=1 and post_status="publish" and post_type="post" order by ID desc limit '.$start.','.$limit,ARRAY_A);		  		       				 	 
		$art = [];      					      	  	 	 
		foreach($article as $key=>$val){    		 	   	    	 		  		
			$art[$key]['num']=$val['ID'];   	    	    	   	 	 
			$art[$key]['title']=$val['post_title'];    	  		           	   
			$art[$key]['link']=get_permalink($val['ID']);    	 			 		     					 	
			$art[$key]['time']=$val['post_date'];      	 			         	  	
		}    	    		      	      
		echo json_encode(['code'=>0,'msg'=>'','count'=>$count,'data'=>$art]);exit;    		  	  	      	  	  
	}elseif($_GET['sl']==2){    	 	  	 	      	    	
		$count = count($count1);
    	$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where seo_baidu_sl=0 and post_status="publish" and post_type="post" order by ID desc limit '.$start.','.$limit,ARRAY_A);		  		       				 	 
		$art = [];      					      	  	 	 
		foreach($article as $key=>$val){  
			$art[$key]['num']=$val['ID'];      	    	    	   	 	 
			$art[$key]['title']=$val['post_title'];   
			$art[$key]['link']=get_permalink($val['ID']);
			$art[$key]['time']=$val['post_date'];      
		}  
		
		echo json_encode(['code'=>0,'msg'=>'','count'=>$count,'data'=>$art]);exit; 		    		      	  		 
    		 		        	  	  	
	}elseif($_GET['ts']==1){    	  	 	 	    	 	 	 		
	
		$count = count($count3);
		$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'baidu_seo_day where type=1 group by post_id order by post_id desc limit '.$start.','.$limit,ARRAY_A);
		$art = [];
		foreach($article as $key=>$val){
		    $art[$key]['id']=$val['post_id'];
		    $art[$key]['title'] = get_post($val['post_id'])->post_title;
		    $art[$key]['time'] = get_post($val['post_id'])->post_date;
		    $art[$key]['link'] = get_permalink($val['post_id']);
		    $art[$key]['status']=	'已推送';
		}
		echo json_encode(['code'=>0,'msg'=>'','count'=>$count,'data'=>$art]);exit;  
	}elseif($_GET['ts']==0){
	    $count = $count2-count($count3);
	    $arr = array_column($count3, 'post_id');
	    $str = implode(',',$arr);
	    if(count($count3)!=0){
	    	$article = $wpdb->get_results('select ID,post_title,post_date from '.$wpdb->prefix . 'posts where  post_status="publish" and post_type="post" and ID not in ('.$str.') order by ID desc limit '.$start.','.$limit,ARRAY_A);	
		}else{
			$article = $wpdb->get_results('select ID,post_title,post_date from '.$wpdb->prefix . 'posts where  post_status="publish" and post_type="post"  order by ID desc limit '.$start.','.$limit,ARRAY_A);
		}

	    $art = [];
	    foreach($article as $key=>$val){ 

    		    $art[$key]['id']=$val['ID'];
    		    $art[$key]['title'] = $val['post_title'];
        		$art[$key]['time']=$val['post_date'];       			        	   		
        		$art[$key]['link']=get_permalink($val['ID']);
    			$art[$key]['status'] = '<button class="layui-btn seo_day_ts layui-btn-sm" title="'.$val['ID'].'">推送</td>';  
    		
    		    	     	      			 		
    	} 
    	echo json_encode(['code'=>0,'msg'=>'','count'=>$count,'data'=>$art]);exit;  
	}
	  		 		 		        	 	 
}elseif(isset($_GET['zhizhu'])){
	$sta = sanitize_text_field($_GET['start']);
	$end = sanitize_text_field($_GET['end']);
	// date_default_timezone_set("PRC");
		
		$tzs = get_option('timezone_string'); 
		// //设置时区
		date_default_timezone_set($tzs);
		// $tzobj = timezone_open($tzs); 
		// $now = date_create('now',$tzobj ); 
	
		//获取当前时间
		// $currnetTime= date_format($sta, 'Y/m/d H:i:s');

	if($sta && $end){
		$sta = strtotime($sta);
		$end = strtotime($end);
		$where = "unix_timestamp(time) >$sta and unix_timestamp(time)<$end";
	}elseif($sta && !$end){
		$sta = strtotime($sta);
		$where = "unix_timestamp(time)>$sta";
	}elseif(!$sta && $end){
		$end = strtotime($end);
		$where = "unix_timestamp(time)<$end";
	}else{
		$where ='1=1';
	}
	$type = (int)$_GET['type'];

	$start = ($page-1)*$limit;
	if($type){
		switch($type){
			case 1://百度
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="百度" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu  where '.$where.' and name="百度" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 2://谷歌
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name = "谷歌" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name = "谷歌" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 3://360
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="360" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="360" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 4://搜狗
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu  where '.$where.' and name="搜狗" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu  where '.$where.' and name="搜狗" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 5://神马
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="神马" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="神马" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 6://必应
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="必应" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="必应" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 7://头条
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and name="头条" group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu  where '.$where.' and name="头条" group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 8://301记录
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and type=301 group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and type=301 group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 9://404记录
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and type=404 group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and type=404 group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
			case 10://200记录
				$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and type=200 group by type,address  ',ARRAY_A);
				$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.' and type=200 group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
				break;
		}
	}else{
	
		$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.'  group by type,address  ',ARRAY_A);
		$zhizhu = $wpdb->get_results('select *,count(*) as num from '.$wpdb->prefix . 'baiduseo_zhizhu where '.$where.'  group by type,address order by id desc limit '.$start.','.$limit,ARRAY_A);
	}

	echo json_encode(['code'=>0,'msg'=>'','count'=>count($count),'data'=>$zhizhu]);exit; 
}elseif($_GET['keywords']){
	$start = ($page-1)*$limit;
	$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_keywords  ',ARRAY_A);
	$keywords = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_keywords limit '.$start.','.$limit,ARRAY_A);
	foreach($keywords as $key=>$val){
		
		$keywords[$key]['status'] = '<button  type="button" class="layui-btn  layui-btn-sm layui-btn-danger keywords_delete" title="'.$val['id'].'">删除</td>';
		if($val['prev']==50){
			$keywords[$key]['prev'] = $val['prev'].'+';
		}
		if($val['prev']==0){
			$keywords[$key]['prev'] = '--';	
		}
		if($val['num']==0){
			$keywords[$key]['num']='查询中...';
		}else{
			
			if($val['num']==50){
				$keywords[$key]['num']=$val['num'].'+';
			}else{
				if($val['prev']){
					if($val['prev']>$val['num']){
						
						$keywords[$key]['num']='<span style="color:red">'.$val['num'].'↑</span>';
					}elseif($val['prev']==$val['num']){
						$keywords[$key]['num']=$val['num'];
					}else{
						$keywords[$key]['num']='<span style="color:green">'.$val['num'].'↓</span>';
					}
					
				}
			}
		
			
		}
		if(!$val['title']){
			$keywords[$key]['title']='无排名';
		}
		if(!$val['time']){
			$keywords[$key]['time']='--';
		}
		if($val['type']==0){
			$keywords[$key]['type']='百度pc';
		}elseif($val['type']==1){
			$keywords[$key]['type']='百度手机';
		}
		$keywords[$key]['sort'] =$key+1; 
		
	}
	echo json_encode(['code'=>0,'msg'=>'','count'=>count($count),'data'=>$keywords]);exit; 
} 
}
require plugin_dir_path( __FILE__ ) . 'function.php';//公用函数 

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'baiduseo_plugin_action_links');
function baiduseo_plugin_action_links ( $links) {
    $links[] = '<a href="' . admin_url( 'admin.php?page=baiduseo' ) . '">设置</a>';
    return $links;
}
//seo首页
add_action( 'wp', 'baiduseo_mainpage' );
//js自动推送
add_filter('wp_footer','baiduseo_jszdts');
//加载layui
if(is_admin()){
if($_POST){
    
    
    if(isset($_POST['data']) && is_string($_POST['data'])){
       
        $BaiduSEO = json_decode($_POST['data'],true);
        if(isset($BaiduSEO['BaiduSEO'])){
            $_POST = $BaiduSEO;
            add_action('init','BaiduSEO_post');
        }
    }
    
}
add_action( 'admin_enqueue_scripts', 'baiduseo_enqueue' );
function baiduseo_enqueue($hook){
    if( 'toplevel_page_baiduseo' != $hook ) return;
    wp_enqueue_style( 'layui',  plugin_dir_url( __FILE__ ). 'layui/css/layui.css',false,'','all');
    wp_enqueue_style( 'new',  plugin_dir_url( __FILE__ ). 'css/new.css',false,'','all');
    wp_enqueue_style( 'animate',  plugin_dir_url( __FILE__ ). 'css/animate.css',false,'','all');
    wp_enqueue_script( 'script', plugin_dir_url( __FILE__ ).'layui/layui.js', '', '', false);
    wp_enqueue_script( 'echarts', plugin_dir_url( __FILE__ ).'layui/echarts.min.js', '', '', false);
}
}else{
    if($_POST){
        if(isset($_POST['data']) && is_string($_POST['data'])){
            $BaiduSEO = json_decode($_POST['data'],true);
            if(isset($BaiduSEO['BaiduSEO']) && ($BaiduSEO['BaiduSEO']==17)){
                BaiduSEO_keywords(sanitize_text_field($BaiduSEO['keywords']));
               
            }
        }
        
    }
}
//添加菜单栏
add_action('admin_menu', 'baiduseo_addpages');
function baiduseo_addpages() {
	add_menu_page(__('seo合集','seo_title_baidu_html'), __('seo合集','seo_title_baidu_html'), 'manage_options', 'baiduseo', 'baiduseo_toplevelpage' );
	
	function baiduseo_toplevelpage() {
		global $wpdb;
        if(isset($_GET['book'])){
		    $book = (int)$_GET['book'];
        }else{
            $book=0;
        }
		switch($book){
			case 0:
			    
				require plugin_dir_path( __FILE__ ) . 'seo_title_baidu_html.php';
				break;
			case 1:
			    //初始化seo首页
        		$seo = get_option('seo_init');
        		if(!$seo || (!is_array($seo))){
        			$seo =['keywords'=>'','description'=>''];
        		}
        		$cate = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="category"',ARRAY_A);
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html.php';
				break;
			case 2:
			    //初始化百度站长
        		$seo_baidu_xzh = get_option('seo_baidu_xzh');
        		if(!$seo_baidu_xzh || (!is_array($seo_baidu_xzh))){
        			$seo_baidu_xzh = ['zz_url'=>'','tokens'=>'','js_zd'=>'','auto'=>0];
        		}
        			//初始化批量提交数据
            	$zz_baidu = $wpdb->get_results('select * from '.$wpdb->prefix . 'baidu_seo_day where type=3',ARRAY_A);
            	$zz_baidu = count($zz_baidu);
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html2.php';
				break;
			case 3:
			    $zz_yjts = get_option('seo_baidu_zz_yjts');
            	if(!is_array($zz_yjts)){
            	    $zz_yjts = [];
            	}
        	    $zz_yjts['time'] = isset($zz_yjts['time'])?$zz_yjts['time']:'暂未推送';
        	    $zz_yjts['zz_tsts'] = isset($zz_yjts['zz_tsts'])?$zz_yjts['zz_tsts']:0;
            	$zz_yjts['zz_kts'] = isset($zz_yjts['zz_kts'])?$zz_yjts['zz_kts']:'暂未推送';
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html3.php';
				break;
			case 4:
			    	//快速收录
            	$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'baidu_seo_day where type=1  ',ARRAY_A);  
        		$art = [];       	 		         	 		
        		foreach($article as $key=>$val){      		 	      	  	 		 
        			$art[$key]['id']=$val['id'];         	        		  	 
        			$art[$key]['title'] = get_post($val['post_id'])->post_title;	 			  	    				    
        			$art[$key]['time']=$val['time'];       			        	   		
        			$art[$key]['link']=$val['link'];
        			$art[$key]['status']=	'已推送';     	     	      			 		
        		} 
        		$baiduseo_day_ts = get_option('baiduseo_day_ts');
        		if(!$baiduseo_day_ts || (!is_array($baiduseo_day_ts))){
        			$baiduseo_day_ts = [];
        		}
                $baiduseo_pltsdayts = get_option('baiduseo_pltsdayts');
                $baiduseo_dayts_num = count($wpdb->get_results('select * from '.$wpdb->prefix . 'baidu_seo_day where type=1  ',ARRAY_A));
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html4.php';
				break;
			case 5:
			   
			    //初始化sitemap
        		$sitemap = get_option('seo_baidu_sitemap');
        		
        		if(!$sitemap || (!is_array($sitemap))){
        			$sitemap = ['site_auto'=>0];
        		}
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html5.php';
				break;
			case 6:
			    //初始化robot
        		$robot = get_option('seo_robots_sc');
        		if(!$robot || (!is_array($robot))){
        			$robot =[];
        		}
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html6.php';
				break;
			case 7:
			    //初始化alt属性
		        $alt = get_option('seo_alt_auto');
		        	//Tag
        		$Tag_manage = get_option('baiduseo_tag_manage');
        			
        		if(!$Tag_manage || (!is_array($Tag_manage))){
        			$Tag_manage =[
        			
        				'open'=>0,
        				'bold'=>0,
        				'color'=>'',
        				'auto'=>0
        			] ;
        		}
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html7.php';
				break;
			case 8:
			    // 初始化301和404
        		$seo_301_404_url = get_option('seo_301_404_url');
        		if(!$seo_301_404_url || (!is_array($seo_301_404_url))){
        			$seo_301_404_url = ['301_url'=>'','404_url'=>''];
        		}
        		$category = get_option('baiduseo_category');
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html8.php';
				break;
			case 9:
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html9.php';
				break;
			case 10:
			    
			    $baidu = 0;
			    $guge = 0;
			    $a360 = 0;
			    $sougou = 0;
			    $biying = 0;
			    $shenma = 0;
			    $toutiao = 0;
			    $baidu = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where name="百度" ',ARRAY_A);
			    $guge = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where name="谷歌" ',ARRAY_A);
			    $a360 = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where name="360" ',ARRAY_A);
			    $sougou = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where  name="搜狗" ',ARRAY_A);
			    $biying = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where name="必应" ',ARRAY_A);
			    $shenma = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where  name="神马" ',ARRAY_A);
			    $toutiao = $wpdb->query('select id from '.$wpdb->prefix . 'baiduseo_zhizhu  where  name="头条" ',ARRAY_A);
			    $zhizhu = get_option('baiduseo_zhizhu');
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html10.php';
				break;
			case 11:
			    $silian = get_option('seo_baidu_silian');
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html11.php';
				break;
			case 12:
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html12.php';
				break;
			case 13:
				require plugin_dir_path( __FILE__ ) . 'seo_title_index_html13.php';
				break;
		}
			   
	}
}

//文章发布时调用
add_action('publish_post','baiduseo_articlepublish');

//插件激活时调用
register_activation_hook(__FILE__, 'baiduseo_pluginaction');
//蜘蛛
$zhizhu = get_option('baiduseo_zhizhu');
if($zhizhu){
	if(isset($zhizhu['auto']) && ($zhizhu['auto']==1)){
		$useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
		
		baiduseo_zhizhu($useragent);
	}
}

//计划任务
if(isset($_GET['zhou']) && isset($_GET['BaiduSEO'])){
    add_action('init', 'BaiduSEO_plan_renwu');  
}

//tag标签
add_action( 'wp', 'baiduseo_tagchange' );
function baiduseo_tagchange(){
	if(is_single()){
	    $id = get_the_ID();
		function baiduseo_contents($content){
			// var_dump(BaiduSEO_addlink($content));
			return  BaiduSEO_addlink($content);
		}
		add_filter('the_content', 'baiduseo_contents',1);
	}
}
register_activation_hook(__FILE__,    'baiduseo_refreshrules');
register_deactivation_hook(__FILE__,  'baiduseo_deactivate');
$category = get_option('baiduseo_category');
if(isset($category['istrue']) && ($category['istrue']==1)){
    add_action('init',              'baiduseo_refreshrules');
    /* actions */
    add_action('created_category',  'baiduseo_refreshrules');
    add_action('delete_category',   'baiduseo_refreshrules');
    add_action('edited_category',   'baiduseo_refreshrules');
    add_action('init',              'baiduseo_permastruct');

    /* filters */
    add_filter('category_rewrite_rules', 'baiduseo_rewriterules');
    add_filter('query_vars',             'baiduseo_queryvars');   
    add_filter('request',                'baiduseo_request');
}else{
    remove_filter( 'category_rewrite_rules', 'baiduseo_rewriterules' ); // We don't want to insert our custom rules again
    add_action('init',              'baiduseo_refreshrules');
}




	




