<?php
if(!defined('ABSPATH'))exit;
//站长推送
function baiduseo_bdzzts($urls,$type=0,$datatype=1,$tishi=1,$count=0){
    global $wpdb;
    $baidu = get_option('seo_baidu_xzh');
    $api = "http://data.zz.baidu.com/urls?site={$baidu['zz_url']}&token={$baidu['tokens']}";
    $result = wp_remote_post($api,['body'=>implode("\n", $urls)]);
    if(is_wp_error($result)){
        if($tishi){
            echo json_encode(['msg'=>"推送失败，原因是服务器网络波动，请稍后重试",'status'=>0]);exit;
        }
    }
    $result = wp_remote_retrieve_body($result);
    $res = json_decode($result,true);
    if($datatype){
        if(isset($res['error'])){
        	if($tishi){
                echo json_encode(['msg'=>"推送失败，原因是{$res['message']}",'status'=>0]);exit;
        	}
        }elseif(isset($res['success'])){
            if(isset($res['not_same_site'])){
                $not_same_site = implode('\n',$res['not_same_site']);
                if($tishi){
                echo json_encode(['msg'=>"推送失败，原因是存在不是本站url:{$not_same_site}",'status'=>0]);exit;
                }
            }elseif(isset($res['not_valid'])){
                $not_valid = implode('\n',$res['not_valid']);
                if($tishi){
                echo json_encode(['msg'=>"推送失败，原因是不合法的url:{$not_valid}",'status'=>0]);exit;
                }
            }else{
            	$tzs = get_option('timezone_string'); 
				//设置时区
				$tzobj = timezone_open($tzs); 
				$now = date_create('now',$tzobj ); 
				//获取当前时间
				$currnetTime= date_format($now, 'Y/m/d H:i:s');
				
                foreach($urls as $key=>$val){
	                $data_array=[
	                    'time' => $currnetTime,
	                    'post_id'=>0,
	                    'link' => $val,
	                    'type' =>3
	                ];
	                $wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
	            }
                if($type==1){
                	if($count>0){
                		$data['zz_tsts']=$count;
                	}else{
                		$data['zz_tsts']=$res['success'];
                	}
	               
	                $data['zz_kts']=$res['remain'];
	                $data['time']= $currnetTime;
	                $baidu = get_option('seo_baidu_zz_yjts');
	
	                if($baidu){
	                  update_option('seo_baidu_zz_yjts',$data);
	                }else{
	                  add_option('seo_baidu_zz_yjts',$data);
	                }
	            }
	            if($tishi){
                	if($count>0){
                		echo json_encode(['msg'=>"推送成功，推送了{$count}条,剩余配额{$res['remain']}条",'status'=>1]);exit;
                	}else{
                		echo json_encode(['msg'=>"推送成功，推送了{$res['success']}条,剩余配额{$res['remain']}条",'status'=>1]);exit;
                	}
                }
            }
        }
    }
   
}
//死链查询
function baiduseo_siliansc($type=0){
	global $wpdb;    	   	  	    	 	 		  
    $silian = get_option('seo_baidu_silian');
    $tzs = get_option('timezone_string'); 
	//设置时区
	$tzobj = timezone_open($tzs); 
	$now = date_create('now',$tzobj ); 
	//获取当前时间
	$currnetTime= date_format($now, 'Y/m/d H:i:s');
	 $defaults = array(
        'timeout' => 3,
        'redirection' => 3,
        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
        'sslverify' => FALSE,
    );
    $data = [      	 	 		    		 	 			
        'silian_url'=>get_option('siteurl'). '/silian.xml',      	 		      							 
        'silian_htmlurl'=>get_option('siteurl').'/silian.txt',     	 			 	     		 	   
        'time'=>$currnetTime    	 	 		     	 	   	 
    ];
    if($silian){
        update_option('seo_baidu_silian',$data);
    }else{
        add_option('seo_baidu_silian',$data);
    }
    $zhizhu = $wpdb->get_results('select * from '.$wpdb->prefix . 'baiduseo_zhizhu where  type="404" group by address ',ARRAY_A);

	$xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    $xml .= "<urlset>\n";
    $txt = '';
    if($zhizhu){
    	foreach($zhizhu as $key=>$val){
            $xml .= "<url>\n";
            $xml .= "<loc>".htmlspecialchars($val['address'])."</loc>\n";
            $xml .= "</url>\n";
            $txt .=$val['address']."\n";
        }
    }else{
    	echo json_encode(['msg'=>0]);exit;
    }
    $xml .= "</urlset>\n";
    if($type==0){
        file_put_contents('../silian.xml',$xml);
        file_put_contents('../silian.txt',$txt);
    }elseif($type==1){
        file_put_contents('./silian.xml',$xml);
        file_put_contents('./silian.txt',$txt);
    }
    echo json_encode(['msg'=>1]);exit;
}
//seo js自动推送
function baiduseo_jszdts(){

     $baidu = get_option('seo_baidu_xzh');
     $content ='';
     if(isset($baidu['js_zd'])){
        $content .= $baidu['js_zd'];
     }
     echo  $content;
}
//文章发布时的调用
function  baiduseo_articlepublish($post_ID){
    global $wpdb;
    //ini_set('memory_limit','512M');
    //周级推送
    $url = get_permalink($post_ID);
    $urls =explode(',',$url);
    $day = get_option('baiduseo_day_ts');
	if($day){
		if(isset($day['auto']) && ($day['auto']==1)){
			 baiduseo_bddayts($urls,$post_ID,0);	
		}	
	}
	$baidu = get_option('seo_baidu_xzh');
    if(isset($baidu['auto']) && ($baidu['auto']==1)){
	    // //站长自动推送
	    baiduseo_bdzzts($urls,0,1,0);
    }
    
    $sitemap = get_option('seo_baidu_sitemap');
    if(isset($sitemap['open']) && ($sitemap['open']==1)){
    	baiduseo_sitemapsc_1(1);
    }
    //自动关联标签
    $baiduseo_tag_manage = get_option('baiduseo_tag_manage');
    
    if($baiduseo_tag_manage){
        if(isset($baiduseo_tag_manage['auto']) && $baiduseo_tag_manage['auto']){
            $tags=$wpdb->get_results('select * from '.$wpdb->prefix . 'terms',ARRAY_A);
            
            foreach($tags as $k=>$v){
        	    if(preg_match('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($v['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i',get_post($post_ID)->post_content,$matches))
        		{
        			$res = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_taxonomy where taxonomy="post_tag" and term_id='.$v['term_id'],ARRAY_A);
        			if($res){
        				$re = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_relationships where object_id='.$post_ID.' and term_taxonomy_id='.$res[0]['term_taxonomy_id'],ARRAY_A);
        				
        				if(!$re){
        				    
        					$wpdb->insert($wpdb->prefix."term_relationships",['object_id'=>$post_ID,'term_taxonomy_id'=>$res[0]['term_taxonomy_id']]);
        					$term_taxonomy = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_taxonomy where  term_taxonomy_id='.$res[0]['term_taxonomy_id'] ,ARRAY_A);
        				
        	                $count = $term_taxonomy[0]['count']+1;
        	                $res = $wpdb->update($wpdb->prefix . 'term_taxonomy',['count'=>$count],['term_taxonomy_id'=>$res[0]['term_taxonomy_id']]);
        				}
        			}
        		}
            }
        }
    }
}
//文章生成是sitemap自动生成
function baiduseo_sitemapsc_1($page=1,$plan=0){
	global $wpdb;
	
      //sitemap生成
    $sitemap = get_option('seo_baidu_sitemap');
    
    $tzs = get_option('timezone_string'); 
	//设置时区
	$tzobj = timezone_open($tzs); 
	$now = date_create('now',$tzobj ); 
	//获取当前时间
	$currnetTime= date_format($now, 'Y/m/d H:i:s');
    if(isset($sitemap['site_auto']) && ($sitemap['site_auto']==1)){
    	$data = $sitemap;
    	$data['time'] = $currnetTime;
    	if($page == 1){
        	$data['sitemap_url'] = [];
        	$data['sitemap_htmlurl'] = [];
        }
        if($page>1){
        	$page1 = $page-1;
	        $data['sitemap_url'][] = get_option('siteurl'). '/sitemap'.$page1.'.xml';
	        $data['sitemap_htmlurl'][] = get_option('siteurl').'/sitemap'.$page1.'.html';
        }else{
        	 $data['sitemap_url'][] = get_option('siteurl'). '/sitemap.xml';
	        $data['sitemap_htmlurl'][] = get_option('siteurl').'/sitemap.html';
        }
        $start = 2000*($page-1);
        if(($sitemap['type1']==1)&&($sitemap['type2']==1)&&($sitemap['type3']==1)){
            $type = 7;
        }elseif(($sitemap['type2']==1)&&($sitemap['type3']==1)){
            $type = 6;
        }elseif(($sitemap['type1']==1)&&($sitemap['type3']==1)){
             $type = 5;
        }elseif(($sitemap['type1']==1)&&($sitemap['type2']==1)){
             $type = 4;
        }elseif($sitemap['type3']==1){
             $type = 3;
        }elseif($sitemap['type2']==1){
             $type = 2;
        }elseif($sitemap['type1']==1){
             $type = 1;
        }
        switch($type){
            case 1:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                break;
            case 2:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                break;
            case 3:
                $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            case 4:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $pages = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                break;
            case 5:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            case 6:
                $pages = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                 $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            case 7:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $pages = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a inner join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            
        }
        $xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
         $xml .= "<urlset>\n";
           $html = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset='utf-8'>\n</head>\n<body>\n<ol>";
           if($page==1){
        		$xml .= "<url>\n";
                $xml .= "<loc>".get_option('siteurl')."</loc>\n";
                $xml .= "<lastmod>{$currnetTime}</lastmod>\n";
                $xml .= "<changefreq>daily</changefreq>\n";
                $xml .= "<priority>1.0</priority>\n";
                $xml .= "</url>\n";
                $html .="<li>".$currnetTime."<a href='".get_option('siteurl')."'>首页:".get_option('siteurl')."</a></li>\n";
           }
        $article = isset($article)?$article:[];
        $tag = isset($tag)?$tag:[];
        $pages = isset($pages)?$pages:[];
        if(!$article && !$tag && !$pages){
              
        }else{
            if($article){
            
    	        
    	        foreach($article as $key=>$val){
    	           
    	                $level1 = $sitemap['level1']/100;
    	                $xml .= "<url>\n";
    	                $xml .= "<loc>".get_permalink($val["ID"])."</loc>\n";
    	                $xml .= "<lastmod>{$val['post_date']}</lastmod>\n";
    	                $xml .= "<changefreq>{$sitemap['post_time']}</changefreq>\n";
    	                $xml .= "<priority>{$level1}</priority>\n";
    	                $xml .= "</url>\n";
    	            $html .="<li>".$val['post_date']."<a href='".get_permalink($val["ID"])."'>{$val['post_title']}:".get_permalink($val["ID"])."</a></li>\n";
    	           
    	        }
            }
            if($pages){
            
    	        
    	        foreach($pages as $key=>$val){
    	           
    	                $level2 = $sitemap['level2']/100;
    	                $xml .= "<url>\n";
    	                $xml .= "<loc>".get_permalink($val["ID"])."</loc>\n";
    	                $xml .= "<lastmod>{$val['post_date']}</lastmod>\n";
    	                $xml .= "<changefreq>{$sitemap['page_time']}</changefreq>\n";
    	                $xml .= "<priority>{$level2}</priority>\n";
    	                $xml .= "</url>\n";
    	            $html .="<li>".$val['post_date']."<a href='".get_permalink($val["ID"])."'>{$val['post_title']}:".get_permalink($val["ID"])."</a></li>\n";
    	           
    	        }
            }
            if($tag){
                foreach($tag as $key=>$val){
    	           
    	                $level3 = $sitemap['level3']/100;
    	                $xml .= "<url>\n";
    	                $xml .= "<loc>".get_tag_link($val["term_id"])."</loc>\n";
    	                $xml .= "<changefreq>{$sitemap['page_time']}</changefreq>\n";
    	                $xml .= "<priority>{$level3}</priority>\n";
    	                $xml .= "</url>\n";
    	            $html .="<li><a href='".get_tag_link($val["term_id"])."'>{$val['name']}:".get_tag_link($val["term_id"])."</a></li>\n";
    	           
    	        }
            }
    	        $xml .='</urlset>';
    	        $html .="</ol>\n</body>\n</html>";
    	        if($page>1){
            		$page1 = $page-1;
            		if($plan){
            		    file_put_contents('./sitemap'.$page1.'.xml',$xml);
    	        	    file_put_contents('./sitemap'.$page1.'.html',$html);
            		}else{
            		    file_put_contents('../sitemap'.$page1.'.xml',$xml);
    	        	    file_put_contents('../sitemap'.$page1.'.html',$html);
            		}
            		 
            		
    	        }else{
    	            if($plan){
    	                file_put_contents('./sitemap.xml',$xml);
    	        	    file_put_contents('./sitemap.html',$html);
    	            }else{
    	                file_put_contents('../sitemap.xml',$xml);
    	        	    file_put_contents('../sitemap.html',$html);
    	            }
    	        	
    	        }
    	        update_option('seo_baidu_sitemap',$data);
    	        if($plan){
    	            baiduseo_sitemapsc_1(++$page,1);
    	        }else{
    	            baiduseo_sitemapsc_1(++$page);
    	        }
        }
    }
           
        
}
//sitamap自动生成
function  baiduseo_sitemapsc($page=1){
    global $wpdb;
      //sitemap生成
    $sitemap = get_option('seo_baidu_sitemap');
    
    $tzs = get_option('timezone_string'); 
	//设置时区
	$tzobj = timezone_open($tzs); 
	$now = date_create('now',$tzobj ); 
	//获取当前时间
	$currnetTime= date_format($now, 'Y/m/d H:i:s');
    if(isset($sitemap['site_auto']) && ($sitemap['site_auto']==1)){
    	$data = $sitemap;
    	$data['time'] = $currnetTime;
    	if($page == 1){
        	$data['sitemap_url'] = [];
        	$data['sitemap_htmlurl'] = [];
        }
        if($page>1){
        	$page1 = $page-1;
	        $data['sitemap_url'][] = get_option('siteurl'). '/sitemap'.$page1.'.xml';
	        $data['sitemap_htmlurl'][] = get_option('siteurl').'/sitemap'.$page1.'.html';
        }else{
        	 $data['sitemap_url'][] = get_option('siteurl'). '/sitemap.xml';
	        $data['sitemap_htmlurl'][] = get_option('siteurl').'/sitemap.html';
        }
        $start = 2000*($page-1);
        if(($sitemap['type1']==1)&&($sitemap['type2']==1)&&($sitemap['type3']==1)){
            $type = 7;
        }elseif(($sitemap['type2']==1)&&($sitemap['type3']==1)){
            $type = 6;
        }elseif(($sitemap['type1']==1)&&($sitemap['type3']==1)){
             $type = 5;
        }elseif(($sitemap['type1']==1)&&($sitemap['type2']==1)){
             $type = 4;
        }elseif($sitemap['type3']==1){
             $type = 3;
        }elseif($sitemap['type2']==1){
             $type = 2;
        }elseif($sitemap['type1']==1){
             $type = 1;
        }
        switch($type){
            case 1:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                break;
            case 2:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                break;
            case 3:
                $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            case 4:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $pages  = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                break;
            case 5:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            case 6:
                $pages = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                 $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            case 7:
                $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $pages = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="page" order by post_date desc limit '.$start.', 2000',ARRAY_A);
                $tag = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag"  limit '.$start.', 2000',ARRAY_A);
                break;
            
        }
        $xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
         $xml .= "<urlset>\n";
           $html = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset='utf-8'>\n</head>\n<body>\n<ol>";
           if($page==1){
        		$xml .= "<url>\n";
                $xml .= "<loc>".get_option('siteurl')."</loc>\n";
                $xml .= "<lastmod>{$currnetTime}</lastmod>\n";
                $xml .= "<changefreq>daily</changefreq>\n";
                $xml .= "<priority>1.0</priority>\n";
                $xml .= "</url>\n";
                $html .="<li>".$currnetTime."<a href='".get_option('siteurl')."'>首页:".get_option('siteurl')."</a></li>\n";
           }
        $article = isset($article)?$article:[];
        $tag = isset($tag)?$tag:[];
        $pages = isset($pages)?$pages:[];
        if(!$article && !$tag && !$pages){
            echo json_encode(['msg'=>0]);exit;  
        }
        if($article){
        
	        
	        foreach($article as $key=>$val){
	           
	                $level1 = $sitemap['level1']/100;
	                $xml .= "<url>\n";
	                $xml .= "<loc>".get_permalink($val["ID"])."</loc>\n";
	                $xml .= "<lastmod>{$val['post_date']}</lastmod>\n";
	                $xml .= "<changefreq>{$sitemap['post_time']}</changefreq>\n";
	                $xml .= "<priority>{$level1}</priority>\n";
	                $xml .= "</url>\n";
	            $html .="<li>".$val['post_date']."<a href='".get_permalink($val["ID"])."'>{$val['post_title']}:".get_permalink($val["ID"])."</a></li>\n";
	           
	        }
        }
        if($pages){
        
	        
	        foreach($pages as $key=>$val){
	           
	                $level2 = $sitemap['level2']/100;
	                $xml .= "<url>\n";
	                $xml .= "<loc>".get_page_link($val["ID"])."</loc>\n";
	                $xml .= "<lastmod>{$val['post_date']}</lastmod>\n";
	                $xml .= "<changefreq>{$sitemap['page_time']}</changefreq>\n";
	                $xml .= "<priority>{$level2}</priority>\n";
	                $xml .= "</url>\n";
	            $html .="<li>".$val['post_date']."<a href='".get_page_link($val["ID"])."'>{$val['post_title']}:".get_page_link($val["ID"])."</a></li>\n";
	           
	        }
        }
        if($tag){
            foreach($tag as $key=>$val){
	           
	                $level3 = $sitemap['level3']/100;
	                $xml .= "<url>\n";
	                $xml .= "<loc>".get_tag_link($val["term_id"])."</loc>\n";
	                $xml .= "<changefreq>{$sitemap['page_time']}</changefreq>\n";
	                $xml .= "<priority>{$level3}</priority>\n";
	                $xml .= "</url>\n";
	            $html .="<li><a href='".get_tag_link($val["term_id"])."'>{$val['name']}:".get_tag_link($val["term_id"])."</a></li>\n";
	           
	        }
        }
	        $xml .='</urlset>';
	        $html .="</ol>\n</body>\n</html>";
	        if($page>1){
        		$page1 = $page-1;
        		 file_put_contents('../sitemap'.$page1.'.xml',$xml);
	        	 file_put_contents('../sitemap'.$page1.'.html',$html);
        		
	        }else{
	        	file_put_contents('../sitemap.xml',$xml);
	        	file_put_contents('../sitemap.html',$html);
	        }
	        update_option('seo_baidu_sitemap',$data);
	        echo json_encode(['msg'=>1,'num'=>$page,'open'=>$data['open']]);exit; 
        }else{
        	echo json_encode(['msg'=>0]);exit;  
        }
   
}

//插件激活时创建数据表
function baiduseo_pluginaction() {
    global $wpdb;
    $charset_collate = '';

    if (!empty($wpdb->charset)) {
      $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
    }

    if (!empty( $wpdb->collate)) {
      $charset_collate .= " COLLATE {$wpdb->collate}";
    }

    $sql = "CREATE TABLE " . $wpdb->prefix . "baidu_seo_day (
        id int(10) NOT NULL AUTO_INCREMENT,
        time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        post_id int(10) NOT NULL,
        link text NOT NULL,
        type int NOT NULL DEFAULT 1,
        UNIQUE KEY id (id)
    ) $charset_collate;";
	$sql1 = "CREATE TABLE " . $wpdb->prefix . "baiduseo_zhizhu   (
        id int(10) NOT NULL AUTO_INCREMENT,
        name varchar(100) NOT NULL ,
        ip varchar(100) NOT NULL,
        time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        address text NOT NULL,
        type int NOT NULL DEFAULT 200,
        UNIQUE KEY id (id)
    ) $charset_collate;";
    $sql2 = "CREATE TABLE " . $wpdb->prefix . "baiduseo_keywords   (
        id int(10) NOT NULL AUTO_INCREMENT,
        keywords varchar(255) ,
        title varchar(255) ,
        post_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    	time timestamp ,
        num int  NOT NULL DEFAULT 0,
        prev int  NOT NULL DEFAULT 0,
        type int NOT NULL DEFAULT 0,
        UNIQUE KEY id (id)
    ) $charset_collate;";
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta($sql);
    dbDelta($sql1);
    dbDelta($sql2);
    $sql3 = 'Describe '.$wpdb->prefix.'posts seo_baidu_sl' ;
    $res = $wpdb->query($sql3);
    
    if($res){
         
    }else{
       $wpdb->query(' ALTER TABLE '.$wpdb->prefix.'posts ADD COLUMN `seo_baidu_sl` int(10) DEFAULT 0');
    }
    $sql4 = 'Describe '.$wpdb->prefix.'terms tag_link' ;
    $res = $wpdb->query($sql4);
    
    if($res){
         
    }else{
        $wpdb->query(' ALTER TABLE '.$wpdb->prefix.'terms ADD COLUMN `tag_link` varchar(255) DEFAULT ""');
    }
    $sql5 = 'Describe '.$wpdb->prefix.'baiduseo_keywords type' ;
    $res = $wpdb->query($sql5);
    
    if($res){
         
    }else{
        $wpdb->query(' ALTER TABLE '.$wpdb->prefix.'baiduseo_keywords ADD COLUMN `type` int(10) DEFAULT 0');
    }
}

//授权
function baiduseo_paymoney($root){
	$data =  $_SERVER['SERVER_NAME'];
	$url = BAIDUSEO_URL.$root."?url={$data}&type=1&url1=".md5($data.BAIDUSEO_SALT);
	$defaults = array(
        'timeout' => 120,
        'connecttimeout'=>120,
        'redirection' => 3,
        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
        'sslverify' => FALSE,
    );
	$result = wp_remote_get($url,$defaults);
    $content = wp_remote_retrieve_body($result);
	$content = json_decode($content,true);
	if($content['status']==1){
		return $content;
	}

}

//百度收录查询
function baiduseo_baiduquery($url,$post_title,$in_cron = false){


    $siteurl = get_option('siteurl');
    if(!$siteurl){
        $siteurl = home_url();
    }

    $host = parse_url($siteurl,PHP_URL_HOST);

    $defaults = array(
        'timeout' => 3,
        'redirection' => 3,
        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
        'sslverify' => FALSE,
    );
    $search_url2 = null;
	// $search_url = 'http://www.baidu.com/s?ie=utf-8&f=8&rsv_bp=1&ch=&tn=baiduerr&bar=&wd='.urlencode($url);
    if($host && $post_title){
        $post_title = mb_substr($post_title,0,20);
        $search_url = 'https://www.baidu.com/s?ie=utf-8&f=8&rsv_bp=1&tn=monline_4_dg&wd='.urlencode($url);
        // $search_url = 'https://www.baidu.com/s?q1=&q2='.urlencode($post_title).'&q3=&q4=&gpc=stf&ft=&q5=1&q6='.$host.'&tn=baiduadv';
        // $search_url2 = 'http://www.baidu.com/s?ie=utf-8&f=8&rsv_bp=1&ch=&tn=baiduerr&bar=&wd='.urlencode($url);
    }else{
        // $search_url = 'http://www.baidu.com/s?ie=utf-8&f=8&rsv_bp=1&ch=&tn=baiduerr&bar=&wd='.urlencode($url);
    }
	 //do{
        
  //      $http = wp_remote_get($search_url,$defaults);

  //      if(wp_remote_retrieve_response_code($http)!=200){
  //          return -1;
  //          break;
  //      }
  //      $body = wp_remote_retrieve_body($http);
  //      if(!$body){
  //          return 0;
  //          break;
  //      }
  //      if(preg_match('#提交网址.+?给我们#is',$body)){
  //          break;
  //      }
  //      if(preg_match('#没有找到该URL#is',$body)){
           
  //          break;
  //      }


  //      if(preg_match('#<title>百度安全验证</title>#is',$body)){
           
  //          return 0;
  //          break;
  //      }

  //      if(preg_match('#没有找到与#i',$body)){
            
  //          break;
  //      }
  //      return 1;

  //  }while(false);

    do{

        $http = wp_remote_get($search_url,$defaults);

        if( !is_wp_error($http) && isset($http['response']['code']) && isset($http['body']) &&　200 == $http['response']['code'] && preg_match('#<title>百度安全验证</title>#is',$http['body'])){
            break;
        }

      if(!is_wp_error($http) && isset($http['response']['code']) && 200 == $http['response']['code'] && !preg_match('#没有找到#is',$http['body']) && preg_match('#百度快照#is',$http['body'])){
            return true;
        }
    }while(false);

    if($search_url2 && !$in_cron){

        sleep(1);
        $http = wp_remote_get($search_url2,$defaults);

        if(!is_wp_error($http) && isset($http['response']['code']) && isset($http['body']) &&　200 == $http['response']['code'] && preg_match('#<title>百度安全验证</title>#is',$http['body'])){
            return false;
        }

        if(!is_wp_error($http) && 200 == $http['response']['code'] && !preg_match('#没有找到#is',$http['body']) && preg_match('#百度快照#is',$http['body'])){
            return true;
        }
    }

    return 0;
}

//所有文章添加img标签添加alt属性
function baiduseo_altarticlechange($type){
    global $wpdb;
    $alt = get_option('seo_alt_auto');
    if($alt!=null){
    	update_option('seo_alt_auto',$type);
    }else{
        add_option('seo_alt_auto',$type);
    }
    $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post"',ARRAY_A);
    foreach($article as $key=>$val){
        if($type == 1){
             $wpdb->update($wpdb->prefix . 'posts',['post_content'=>str_replace('<img','<img alt="'.$val['post_title'].'"',$val['post_content'])],['ID'=>$val['ID']]);
         }else{
             $wpdb->update($wpdb->prefix . 'posts',['post_content'=>preg_replace('/alt=\".*?\"/','',$val['post_content'])],['ID'=>$val['ID']]);
         }
      
    }
    echo json_encode(['msg'=>1]);exit;
}
function baiduseo_pltsxzhzz($type,$wsl=0){
    global $wpdb;
    if($wsl==1){
    	$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" and  seo_baidu_sl=0',ARRAY_A);
    }else{
    	$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post"',ARRAY_A);
    }
    
    $urls = [];
    foreach($article as $key=>$val){
        $urls[] = get_permalink($val["ID"]);
    }
    
	if($type==1){
    	$count = count($urls);
    
    	if($count<2000){
    		baiduseo_bdzzts($urls,1);exit;
    	}
    	for( $i=0;$i<ceil($count/1500);$i++){
    		$start = $i*1500;
    		$url = array_slice($urls,$start,1500);
    		
    		if($i+1==ceil($count/1500)){
    			baiduseo_bdzzts($url,1,1,1,$count);
    		}else{
    			baiduseo_bdzzts($url,1,1,0);	
    		}
    	}
    }
}
function baiduseo_pltsxzhzz_1($type,$wsl=0,$num,$page,$shyu=0){
	global $wpdb;

	$no = $page*($num-1); 
	 if($wsl==1){
	 	
    	$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" and  seo_baidu_sl=0',ARRAY_A);
    	$article =  $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" and  seo_baidu_sl=0 limit '.$no.' ,'.$page,ARRAY_A);
    }else{
    
    	$count = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post"',ARRAY_A);
    	$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" limit '.$no.' ,'.$page,ARRAY_A);
    	
    }
    $count = count($count);
    $urls = [];
    foreach($article as $key=>$val){
        $urls[] = get_permalink($val["ID"]);
    }
    $baidu = get_option('seo_baidu_xzh');
    
    if($type==1){
    	
    	if($article){
		    $api = "http://data.zz.baidu.com/urls?site={$baidu['zz_url']}&token={$baidu['tokens']}";
		    $result = wp_remote_post($api,['body'=>implode("\n", $urls)]);
		    if(is_wp_error($result)){
		        echo json_encode(['msg'=>"推送失败，服务器网络波动，请稍后重试",'status'=>0]);exit;
		    }
		    $result = wp_remote_retrieve_body($result);
		    $res = json_decode($result,true);
	        if(isset($res['error'])){
	            echo json_encode(['msg'=>"推送失败，原因是{$res['message']}",'status'=>0]);exit;
	        }elseif(isset($res['success'])){
	            if(isset($res['not_same_site'])){
	                $not_same_site = implode('\n',$res['not_same_site']);
	                echo json_encode(['msg'=>"推送失败，原因是存在不是本站url:{$not_same_site}",'status'=>0]);exit;
	            }elseif(isset($res['not_valid'])){
	                $not_valid = implode('\n',$res['not_valid']);
	                echo json_encode(['msg'=>"推送失败，原因是不合法的url:{$not_valid}",'status'=>0]);exit;
	            }else{
	            	$tzs = get_option('timezone_string'); 
					//设置时区
					$tzobj = timezone_open($tzs); 
					$now = date_create('now',$tzobj ); 
					//获取当前时间
					$currnetTime= date_format($now, 'Y/m/d H:i:s');
					
	                foreach($urls as $key=>$val){
		                $data_array=[
		                    'time' => $currnetTime,
		                    'post_id'=>0,
		                    'link' => $val,
		                    'type' =>3
		                ];
		                $wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
		            }
	                if($wsl==0){
	                	if($count>0){
	                		$data['zz_tsts']=$count;
	                	}else{
	                		$data['zz_tsts']=$res['success'];
	                	}
		               
		                $data['zz_kts']=$res['remain'];
		                $data['time']= $currnetTime;
		                $baidu = get_option('seo_baidu_zz_yjts');
		
		                if($baidu){
		                  update_option('seo_baidu_zz_yjts',$data);
		                }else{
		                  add_option('seo_baidu_zz_yjts',$data);
		                }
		            }
	            	echo json_encode(['msg'=>1,'num'=>$num,'percent'=>round(100*($no+count($article))/$count,2).'%','shyu'=>$res['remain'],'status'=>1]);exit; 
	            }
	        }
        }else{
        	echo json_encode(['msg'=>"推送成功，推送成功：{$count}条，剩余配额：{$shyu}条",'status'=>0]);exit;
        }
    }
    
}
//快速收录提交
function baiduseo_bddayts($urls,$post_id,$tishi=1){
    global $wpdb;
    $baidu = get_option('seo_baidu_xzh');
	$api = "http://data.zz.baidu.com/urls?site={$baidu['zz_url']}&token={$baidu['tokens']}&type=daily";
	$result = wp_remote_post($api,['body'=>implode("\n", $urls)]);
	if(is_wp_error($result)){
	    if($tishi==1){
            echo json_encode(['msg'=>"推送失败，服务器网络波动，请稍后重试",'status'=>0]);exit;
	    }
    }
	$result = wp_remote_retrieve_body($result);
    $res = json_decode($result,true);
    if(isset($res['error'])){
    	if($tishi==1){
    		if($res['message']=='over quota'){
                echo json_encode(['msg'=>'当日配额已用完！','status'=>0]);exit;
            }else{
                echo json_encode(['msg'=>$res['message'],'status'=>0]);exit;
            }
    	}
    }elseif(isset($res['success'])){
        if(isset($res['not_same_site'])){
            $not_same_site = implode('\n',$res['not_same_site']);
            if($tishi==1){
                echo json_encode(['msg'=>"推送失败，原因是存在不是本站url:{$not_same_site}",'status'=>0]);exit;
            
            }
        }elseif(isset($res['not_valid'])){
            $not_valid = implode('\n',$res['not_valid']);
             if($tishi==1){
                 	
            	echo json_encode(['msg'=>"推送失败，原因是不合法的url:{$not_valid}",'status'=>0]);exit;
             }
        }else{
        	 $tzs = get_option('timezone_string'); 
			//设置时区
			$tzobj = timezone_open($tzs); 
			$now = date_create('now',$tzobj ); 
			//获取当前时间
			$currnetTime= date_format($now, 'Y/m/d H:i:s');
            $data_array=[
                'time' => $currnetTime,
                'post_id'=>intval($post_id),
                'link' => $urls[0]
            ];
			if($res['remain_daily']==0){
				 if($tishi==1){
					echo json_encode(['msg'=>"配额超出，请勿重复提交！",'status'=>1]);exit;
				 }
			}else{
				$wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
				if($tishi==1){
            		echo json_encode(['msg'=>"推送成功,剩余配额：{$res['remain_daily']}条",'status'=>1]);exit;
				}
			}
        }
    }
}


//设置首页seo
function  baiduseo_mainpage(){
    if(is_home() || is_front_page()){

        //首页seo加载
        function baiduseo_seo_change(){
          $seo = get_option('seo_init');
          if($seo){
            
            if(isset($seo['keywords']) && $seo['keywords']){
                echo '<meta name="keywords" content="'.$seo['keywords'].'">'."\n\r";
            }
            if(isset($seo['keywords']) && $seo['keywords']){
                echo '<meta name="description" content="'.$seo['description'].'">'."\n\r";
            }
            
            
          }
         
        }
       add_action( 'wp_head', 'baiduseo_seo_change',1 );
    }elseif(is_category()){
        
        $cate = get_the_category();
           
       
        function baiduseo_seo_change(){
            $cate = get_the_category();
            if(isset($cate[0]->cat_ID)){
                $seo = get_option('baiduseo_cate_'.$cate[0]->cat_ID);
                if($seo){
                    if(isset($seo['title']) && $seo['title']){
                        echo '<title>'.$seo['title'].'</title>'."\n";
                    }
                    if(isset($seo['keywords']) && $seo['keywords']){
                        echo sprintf('<meta name="keywords" content="%s" />'."\n",$seo['keywords']);
                    }
                    if(isset($seo['description']) && $seo['description']){
                        echo sprintf('<meta name="description" content="%s" />'."\n",$seo['description']);
                    }
                }
            }
         
        }
        add_action( 'wp_head', 'baiduseo_seo_change',1 );
        
    }
    
}


function baiduseo_zhizhu($type){

	global $wpdb;
	if (strpos($type, 'googlebot') !== false){
		$data_array['name'] ='谷歌';
	}
	if (strpos($type, 'baiduspider') !== false){
		$data_array['name'] ='百度';
	}
	if (strpos($type, '360spider') !== false){
		$data_array['name'] ='360';
	}
	if (strpos($type, 'sogou') !== false){
		$data_array['name'] ='搜狗';
	}
	if (strpos($type, 'yisouspider') !== false){
		$data_array['name'] ='神马';
	}
	if (strpos($type, 'bingbot') !== false){
		$data_array['name'] ='必应';
	}
	if (strpos($type, 'bytespider') !== false){
		$data_array['name'] ='头条';
	}
	if(isset($data_array['name'])){
		
		$tzs = get_option('timezone_string'); 
		//设置时区
		$tzobj = timezone_open($tzs); 
		$now = date_create('now',$tzobj ); 
		//获取当前时间
		$currnetTime= date_format($now, 'Y/m/d H:i:s');
		$http_type = ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') || (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) ? 'https://' : 'http://';
		if($_SERVER['REQUEST_URI']!='/' && $_SERVER['REQUEST_URI']!='' ){
    		$data_array['address'] = $http_type.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
    		if(strlen($data_array['address'])<1024){
        		$defaults = array(
        	        'timeout' => 3,
        	        'redirection' => 3,
        	        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
        	        'sslverify' => FALSE,
        	    );
        		$result = wp_remote_get($data_array['address'],$defaults);
        		$data_array['ip'] =$_SERVER['HTTP_X_FORWARDED_FOR']?$_SERVER['HTTP_X_FORWARDED_FOR']:$_SERVER['REMOTE_ADDR'];
        		$data_array['time'] = $currnetTime;
        		$data_array['type'] = $result['response']['code'];
        		$res = $wpdb->insert($wpdb->prefix."baiduseo_zhizhu",$data_array);
    		}
		}
	}
}
//计划任务
function BaiduSEO_plan_renwu(){
   
	if(isset($_GET['zz']) && $_GET['zz']){
	     $pay = baiduseo_paymoney('/api/index/pay_money');
        if(!$pay){
    		echo '授权功能，请授权后使用';exit;
    	}
        if($pay['msg']==1 && $pay['url']== md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
    	}else{
    		echo '授权功能，请授权后使用';exit;
    	}
	    global $wp_rewrite;
	    if(!$wp_rewrite){
	       include_once ('wp-includes/class-wp-rewrite.php');
	       $wp_rewrite = new wp_rewrite();
	    }
		baiduseo_pltsxzhzz(1);
	}elseif(isset($_GET['dayts']) && $_GET['dayts']){
	     $pay = baiduseo_paymoney('/api/index/pay_money');
        if(!$pay){
    		echo '授权功能，请授权后使用';exit;
    	}
        if($pay['msg']==1 && $pay['url']== md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
    	}else{
    		echo '授权功能，请授权后使用';exit;
    	}
	    global $wpdb;
	    global $wp_rewrite;
	    if(!$wp_rewrite){
	       include_once ('wp-includes/class-wp-rewrite.php');
	       $wp_rewrite = new wp_rewrite();
	    }
	    $article = $wpdb->get_results('select p.*,b.id from '.$wpdb->prefix . 'posts as p left join '.$wpdb->prefix . 'baidu_seo_day as b  on p.ID = b.post_id where  p.post_status="publish" and p.post_type="post" and b.id is null  order by p.ID desc limit 100',ARRAY_A);
		$baidu = get_option('seo_baidu_xzh');
		if(isset($baidu['zz_url']) && isset($baidu['tokens'])){
		    
        	$api = "http://data.zz.baidu.com/urls?site={$baidu['zz_url']}&token={$baidu['tokens']}&type=daily";
        	$count = 0;
            foreach($article as $key=>$val){
                
                $result = wp_remote_post($api,['body'=>get_permalink($val["ID"])]);
               
            	$result = wp_remote_retrieve_body($result);
                $res = json_decode($result,true);
                 
                if(isset($res['error'])){
                    break;
                }elseif(isset($res['success'])){
                    if(isset($res['not_same_site'])){
                        
                        break;
                    }elseif(isset($res['not_valid'])){
                        break;
                        
                    }else{
                        ++$count;
                    	$tzs = get_option('timezone_string'); 
            			//设置时区
            			$tzobj = timezone_open($tzs); 
            			$now = date_create('now',$tzobj ); 
            			//获取当前时间
            			$currnetTime= date_format($now, 'Y/m/d H:i:s');
                        $data_array=[
                            'time' => $currnetTime,
                            'post_id'=>intval($val["ID"]),
                            'link' => get_permalink($val["ID"])
                        ];
            			if($res['remain_daily']==0){
            			    $wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
            				break;
            			}
            			
                        $wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
                    }
                }
                
            }
            if($count>0){
                $tzs = get_option('timezone_string');
            	//设置时区
            	$tzobj = timezone_open($tzs); 
            	$now = date_create('now',$tzobj ); 
            	//获取当前时间
            	$currnetTime= date_format($now, 'Y/m/d H:i:s');
                $baiduseo_pltsdayts = get_option('baiduseo_pltsdayts');
                if($baiduseo_pltsdayts){
                    update_option('baiduseo_pltsdayts',['time'=>$currnetTime,'count'=>$count]);
                }else{
                    add_option('baiduseo_pltsdayts',['time'=>$currnetTime,'count'=>$count]);
                }
            }
		}
	}elseif(isset($_GET['silian']) && $_GET['silian']){
	     $pay = baiduseo_paymoney('/api/index/pay_money');
        if(!$pay){
    		echo '授权功能，请授权后使用';exit;
    	}
        if($pay['msg']==1 && $pay['url']== md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
    	}else{
    		echo '授权功能，请授权后使用';exit;
    	}
	    baiduseo_siliansc(1);
	}elseif(isset($_GET['sitemap']) && $_GET['sitemap']){
	     baiduseo_sitemapsc_1(1,1);
	    
	}
}
//关键词排名
function BaiduSEO_keywords($keywords){
	global $wpdb;
	$keywords = json_decode($keywords,true);
	$type = isset($keywords[0]['type'])?$keywords[0]['type']:0;
	$res = $wpdb->get_results(' select * from  '.$wpdb->prefix.'baiduseo_keywords where keywords="'.$keywords[0]['keywords'].'" and type="'.$type.'"',ARRAY_A);
	$wpdb->update($wpdb->prefix . 'baiduseo_keywords',['time'=>$keywords[0]['time'],'title'=>$keywords[0]['title'],'num'=>$keywords[0]['num'],'prev'=>$res[0]['num']],['id'=>$res[0]['id']]);
}
function BaiduSEO_addlink($content){
	global $wpdb;
	$post_title = get_the_title();
	$alt = get_option('seo_alt_auto');
    
	if((isset($alt['alt']) && $alt['alt']) || (isset($alt['title']) && $alt['title'])){
    	if(preg_match_all('#<img([^>]+)>#is',$content,$match)){
    
            $img_seo = array();
            $img_idx = -1;
            foreach($match[0] as $k=>$img){
                if(!preg_match('#src=.+#',$img)){
                    continue;
                }
    
                $src_img = $img;
                $img = str_replace(array('alt=""',"alt=''",'title=""',"title=''"),'',$img);
    
                $img_key = md5($img);
    
                if(!isset($img_seo[$img_key])){
                    $img_idx ++;
                    $img_seo[$img_key] = $img_idx;
                }
                $img_k = $img_seo[$img_key];
    
                $add_html = '';
    
                if(isset($alt['title']) && $alt['title'] && !preg_match('#\s+title=.+?#is',$img)){
    
                    if($alt['title']=='2'){
                        if(preg_match('#/.+?\.(jpg|jpeg|gif|webp|png|bmp)#is',$img,$name_match)){
                            $add_html .= ' title="'.esc_attr(basename($name_match[0])).'插图'.($img_k?'('.$img_k.')':'').'"';
                        }
                    }else if($post_title){
    
                        $add_html .= ' title="'.esc_attr($post_title).'插图'.($img_k?'('.$img_k.')':'').'"';
                    }
                }
                if(isset($alt['alt']) && $alt['alt'] && !preg_match('#\s+alt=.+?#is',$img)){
    
                    if($alt['alt'] == '2'){
                        if(preg_match('#/.+?\.(jpg|jpeg|gif|webp|png|bmp)#is',$img,$name_match)){
                            $add_html .= ' alt="'.esc_attr(basename($name_match[0])).'插图'.($img_k?'('.$img_k.')':'').'"';
                        }
                    }else if($post_title){
                        $add_html .= ' alt="'.esc_attr($post_title).'插图'.($img_k?'('.$img_k.')':'').'"';
                    }
                }
                if(!$add_html){
                    continue;
                }
    
                $original = str_replace(array('alt=""',"alt=''",'title=""',"title=''"),'',$match[1][$k]);
    
                $new_img = '<img'.$add_html.' '.$original.'>';
                $content = str_replace($src_img,$new_img,$content);
            }//end foreach match
    
        }
	}
	$id = get_the_ID();
	$Tag_manage = get_option('baiduseo_tag_manage');

    if($Tag_manage){
        
    	if(isset($Tag_manage['open']) && ($Tag_manage['open']==1)){
			$tags=$wpdb->get_results('select a.* from ('.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id) left join '.$wpdb->prefix . 'term_relationships as c on b.term_taxonomy_id =c.term_taxonomy_id  where b.taxonomy="post_tag" and c.object_id='.$id,ARRAY_A);
			$tags1 = $wpdb->get_results('select * from '.$wpdb->prefix.'terms where slug= "" and tag_link!=""',ARRAY_A);
			$tags = array_merge($tags,$tags1);
	        if(is_array($tags)||is_object($tags))
	        {
	            foreach ($tags as $val)
	            {
					
					$val['url'] =get_tag_link($val['term_id']);
	                if(preg_match('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i',$content,$matches))
	                { 
	                	if($val['tag_link']){
		                	if(isset($Tag_manage['bold']) && isset($Tag_manage['color']) && $Tag_manage['color']){
		                		if($Tag_manage['bold']==1){
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['tag_link'].'"><b style="color:'.$Tag_manage['color'].'">'.$val['name'].'</b></a>',$content,1);
		                		}else{
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['tag_link'].'" style="color:'.$Tag_manage['color'].'">'.$val['name'].'</a>',$content,1);
		                		}
		                		
		                	}elseif(isset($Tag_manage['bold']) && (!isset($Tag_manage['color'])||(!$Tag_manage['color']))){
		                		if($Tag_manage['bold']==1){
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['tag_link'].'"><b>'.$val['name'].'</b></a>',$content,1);
		                		}else{
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['tag_link'].'">'.$val['name'].'</a>',$content,1);
		                		}
		                	}elseif(!isset($Tag_manage['bold']) && isset($Tag_manage['color']) && $Tag_manage['color']){
		                		$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['tag_link'].'" style="color:'.$Tag_manage['color'].'">'.$val['name'].'</a>',$content,1);
		                	}else{
		                		$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['tag_link'].'">'.$val['name'].'</a>',$content,1);
		                	}
	                	}else{
	                		if(isset($Tag_manage['bold']) &&isset($Tag_manage['color']) && $Tag_manage['color']){
		                		if($Tag_manage['bold']==1){
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['url'].'"><b style="color:'.$Tag_manage['color'].'">'.$val['name'].'</b></a>',$content,1);
		                		}else{
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['url'].'" style="color:'.$Tag_manage['color'].'">'.$val['name'].'</a>',$content,1);
		                		}
		                		
		                	}elseif(isset($Tag_manage['bold']) && (!isset($Tag_manage['color'])||(!$Tag_manage['color']))){
		                		if($Tag_manage['bold']==1){
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['url'].'"><b>'.$val['name'].'</b></a>',$content,1);
		                		}else{
		                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['url'].'">'.$val['name'].'</a>',$content,1);
		                		}
		                	}elseif(!isset($Tag_manage['bold']) && isset($Tag_manage['color']) && $Tag_manage['color']){
		                		$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['url'].'" style="color:'.$Tag_manage['color'].'">'.$val['name'].'</a>',$content,1);
		                	}else{
		                		$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a href="'.$val['url'].'">'.$val['name'].'</a>',$content,1);
		                	}
	                	}
	                }
	            }
	
	        }
	    	return $content;
    	}else{
	    	$tags=$wpdb->get_results('select a.* from ('.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id) left join '.$wpdb->prefix . 'term_relationships as c on b.term_taxonomy_id =c.term_taxonomy_id  where b.taxonomy="post_tag" and c.object_id='.$id,ARRAY_A);
			$tags1 = $wpdb->get_results('select * from '.$wpdb->prefix.'terms where slug= "" and tag_link!=""',ARRAY_A);
			$tags = array_merge($tags,$tags1);
	        if(is_array($tags)||is_object($tags))
	        {
	            foreach ($tags as $val)
	            {
			
	                if(preg_match('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i',$content,$matches))
	                { 
	                	if(isset($Tag_manage['bold']) && isset($Tag_manage['color']) &&$Tag_manage['color']){
	                		if($Tag_manage['bold']==1){
	                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<b style="color:'.$Tag_manage['color'].'">'.$val['name'].'</b>',$content,1);
	                		}else{
	                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a  style="color:'.$Tag_manage['color'].'">'.$val['name'].'</a>',$content,1);
	                		}
	                		
	                	}elseif(isset($Tag_manage['bold']) && (!isset($Tag_manage['color']) || !$Tag_manage['color'])){
	                		if($Tag_manage['bold']==1){
	                			$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<b>'.$val['name'].'</b>',$content,1);
	                		}
	                	}elseif(!isset($Tag_manage['bold']) && isset($Tag_manage['color']) && $Tag_manage['color']){
	                		$content=preg_replace('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($val['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i','<a  style="color:'.$Tag_manage['color'].'">'.$val['name'].'</a>',$content,1);
	                	}
	                    
	                }
	            }
	
	        }
	        return $content;	
    	}
    }
    return $content;
}
function BaiduSEO_preg($str)
{
	$str=strtolower(trim($str));
	$replace=array('\\','+','*','?','[','^',']','$','(',')','{','}','=','!','<','>','|',':','-',';','\'','\"','/','%','&','_','`');
    return str_replace($replace,"",$str);
}
function BaiduSEO_post(){
    global $wpdb;
        $pay = baiduseo_paymoney('/api/index/pay_money');
    	$data =  $_POST;
    	if(isset($data['BaiduSEO'])){ 
                // var_dump(function_exists(wp_verify_nonce));exit;
		          
		        if(isset($data['nonce']) && isset($data['action']) && wp_verify_nonce($data['nonce'],$data['action'])){
		            
            		switch($data['BaiduSEO']){    		 		 		    		   	  
            			case 1://seo首页
            				$seo = ['keywords'=>sanitize_text_field($data['keywords']),'description'=>sanitize_textarea_field($data['description'])];     		  	       	 	  	 
            				$seo_init = get_option('seo_init');
            	            if($seo_init){
            	            	update_option('seo_init',$seo);
            	            }else{
            	            	add_option('seo_init',$seo);
                        	}   				  	       	   	
            				echo json_encode(['msg'=>1]);exit;       	 		     	   			 
            				break;    			 				     	  	 	 
            			case 2://站长保存 
            				
            				if(isset($data['close'])){
            				   
            					 $seo_baidu_xzh =[     		         	      	
            		                'zz_url'=>esc_url($data['zz_url']),     	 		           		  
            		                'auto'=>1,      		 	 	     	 		  	
            		                'tokens'=>sanitize_text_field($data['tokens']),    		   		     			     	    		     	  		  	
            		            ];     	 	  		     	     	
            				}else{    	  	 			    				 		 
            					 $seo_baidu_xzh =[    	 		  		    			    	
            		                'zz_url'=>esc_url($data['zz_url']),     	 			      	   	  	
            		                'auto'=>0,    	 					       		  	 
            		                'tokens'=>sanitize_text_field($data['tokens']),    			  		        				 
            		                		  			    	   		 	
            		            ];     	  		      	  	   	
            				}     	 				     	   				
            				$baidu = get_option('seo_baidu_xzh');
            	
            	            if($baidu){
            	              update_option('seo_baidu_xzh',$seo_baidu_xzh);
            	            }else{
            	              add_option('seo_baidu_xzh',$seo_baidu_xzh);
            	            }  			   	       				  
                            echo json_encode(['msg'=>1]);exit;      	    	      			 	 
            				break;     				 	       		 	  
            			case 4: 
            			
            				$urls = explode("\n",sanitize_textarea_field($data['url_zhan']));     			 	       		 				
            				baiduseo_bdzzts($urls);exit;    			 	     	 	 				
            				break;     		    	     		 		  
            			case 5: 
            				
    						$sitemap = get_option('seo_baidu_sitemap');
    						
						    if($sitemap){
						        $seo_baidu_sitemap = $sitemap;
						    }else{
						        $seo_baidu_sitemap = [];
						    }
    						
    						if(isset($data['close'])){  
    							$seo_baidu_sitemap['site_auto'] =1;
    						}else{
    						    $seo_baidu_sitemap['site_auto'] = 0;
    						}
    						if(isset($data['open'])){
    						    $seo_baidu_sitemap['open'] =1;  
    						}else{
								$seo_baidu_sitemap['open'] =0;
							}
							$seo_baidu_sitemap['post_time'] = sanitize_text_field($data['post_time']);
							$seo_baidu_sitemap['page_time'] = sanitize_text_field($data['page_time']);
							$seo_baidu_sitemap['tag_time'] = sanitize_text_field($data['tag_time']);
							$seo_baidu_sitemap['level1'] = sanitize_text_field($data['level1']);
							$seo_baidu_sitemap['level2'] = sanitize_text_field($data['level2']);
							$seo_baidu_sitemap['level3'] = sanitize_text_field($data['level3']);
							if(isset($data['type1'])){
    						    $seo_baidu_sitemap['type1'] =1;  
    						}else{
								$seo_baidu_sitemap['type1'] =0;
							}
							if(isset($data['type2'])){
    						    $seo_baidu_sitemap['type2'] =1;  
    						}else{
								$seo_baidu_sitemap['type2'] =0;
							}
							if(isset($data['type3'])){
    						    $seo_baidu_sitemap['type3'] =1;  
    						}else{
								$seo_baidu_sitemap['type3'] =0;
							}
				            if($sitemap){
					            update_option('seo_baidu_sitemap',$seo_baidu_sitemap);
					        }else{
					            add_option('seo_baidu_sitemap',$seo_baidu_sitemap);     
					        }
    				        baiduseo_sitemapsc((int)($data['page']));exit; 
            				break;    						 	       			  
            			case 6: 
            		
            				$tzs = get_option('timezone_string'); 
            				//设置时区
            				$tzobj = timezone_open($tzs); 
            				$now = date_create('now',$tzobj ); 
            				//获取当前时间
            				$currnetTime= date_format($now, 'Y/m/d H:i:s');
            				if(isset($data['close'])){     	 	 			    	  	  	 
            					$url =get_option('siteurl').'/robots.txt';   
            					
            
            	                $robot = [        				     		 	  	
            	                    'robot'=>sanitize_textarea_field($data['robot']),     			   	     							
            	                    'time'=>$currnetTime,    	 	 			       			 	 
            	                    'url'=>$url,      	   	     			 		 	
            	                    'robot_auto'=>1    	     		       	 	  
            	                ];         	 	      	 	  	
            	                 file_put_contents('../robots.txt',sanitize_textarea_field($data['robot'])); 		 				      			 	 	
            				}else{      				       	  		  
            					$robot = [    	 	  			    			  	  
            	                    'robot'=>sanitize_textarea_field($data['robot']),    	 	  			    	 		 		 
            	                    'time'=>$currnetTime,    	 	    	    		     	
            	                    'robot_auto'=>0        	 	     			 	   
            	                ];     		  		       				 	 
                                if(file_exists('../robots.txt')){    							      	 			 	
                                   unlink('../robots.txt');     		   	     	 		  	
                                }    	  	 	 	    	 	  	  
            	                     			  	      						 
            				}    	   			     			 	   
            			    $rootbot = get_option('seo_robots_sc');
            			    if($rootbot){
            	               update_option('seo_robots_sc',$robot); 
            	            }else{
            	                add_option('seo_robots_sc',$robot);
            	            }
                            echo json_encode(['msg'=>1]);exit;    	    		      						 
            				break;      			 	       	 	   
            			case 7:
            			    $alt_seo = ['alt'=>(int)$data['alt'],'title'=>(int)$data['title']];
            			    $alt = get_option('seo_alt_auto');
                            if($alt){
                            	update_option('seo_alt_auto',$alt_seo);
                            }else{
                                add_option('seo_alt_auto',$alt_seo);
                            } 
            			    echo json_encode(['msg'=>1]);exit;  			      							 
            				break;     		  	        	 				
            			case 8:     	    	     	 		  	 
            				   			    	 	 	 	 
            				if(isset($data['close'])){     	 				      	    		
            					$url_301 =1;       			 	     	  	 	 
            				}else{     	 		 	     			  	 	
            					$url_301 =0;    	     	       					 
            				}      	    	    			  			
            				if(isset($data['open'])){    	 					     	  		   
            					$url_404=1;
            					 file_put_contents('../404.html','<!DOCTYPE html>
            <html>
            <head>
            <meta charset="UTF-8">
            <title>System Error404</title>
            <meta name="robots" content="noindex,nofollow" />
            <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
            <style>
                    /* Base */
                    body {
                        color: #333;
                        font: 14px Verdana, "Helvetica Neue", helvetica, Arial, "Microsoft YaHei", sans-serif;
                        margin: 0;
                        padding: 0 20px 20px;
                        word-break: break-word;
                    }
                    h1{
                        margin: 10px 0 0;
                        font-size: 28px;
                        font-weight: 500;
                        line-height: 32px;
                    }
                    h2{
                        color: #4288ce;
                        font-weight: 400;
                        padding: 6px 0;
                        margin: 6px 0 0;
                        font-size: 18px;
                        border-bottom: 1px solid #eee;
                    }
                    h3.subheading {
                        color: #4288ce;
                        margin: 6px 0 0;
                        font-weight: 400;
                    }
                    h3{
                        margin: 12px;
                        font-size: 16px;
                        font-weight: bold;
                    }
                    abbr{
                        cursor: help;
                        text-decoration: underline;
                        text-decoration-style: dotted;
                    }
                    a{
                        color: #868686;
                        cursor: pointer;
                    }
                    a:hover{
                        text-decoration: underline;
                    }
                    .line-error{
                        background: #f8cbcb;
                    }
            
                    .echo table {
                        width: 100%;
                    }
            
                    .echo pre {
                        padding: 16px;
                        overflow: auto;
                        font-size: 85%;
                        line-height: 1.45;
                        background-color: #f7f7f7;
                        border: 0;
                        border-radius: 3px;
                        font-family: Consolas, "Liberation Mono", Menlo, Courier, monospace;
                    }
            
                    .echo pre > pre {
                        padding: 0;
                        margin: 0;
                    }
                    /* Layout */
                    .col-md-3 {
                        width: 25%;
                    }
                    .col-md-9 {
                        width: 75%;
                    }
                    [class^="col-md-"] {
                        float: left;
                    }
                    .clearfix {
                        clear:both;
                    }
                    @media only screen 
                    and (min-device-width : 375px) 
                    and (max-device-width : 667px) { 
                        .col-md-3,
                        .col-md-9 {
                            width: 100%;
                        }
                    }
                    /* Exception Info */
                    .exception {
                        margin-top: 20px;
                    }
                    .exception .message{
                        padding: 12px;
                        border: 1px solid #ddd;
                        border-bottom: 0 none;
                        line-height: 18px;
                        font-size:16px;
                        border-top-left-radius: 4px;
                        border-top-right-radius: 4px;
                        font-family: Consolas,"Liberation Mono",Courier,Verdana,"微软雅黑";
                    }
            
                    .exception .code{
                        float: left;
                        text-align: center;
                        color: #fff;
                        margin-right: 12px;
                        padding: 16px;
                        border-radius: 4px;
                        background: #999;
                    }
                    .exception .source-code{
                        padding: 6px;
                        border: 1px solid #ddd;
            
                        background: #f9f9f9;
                        overflow-x: auto;
            
                    }
                    .exception .source-code pre{
                        margin: 0;
                    }
                    .exception .source-code pre ol{
                        margin: 0;
                        color: #4288ce;
                        display: inline-block;
                        min-width: 100%;
                        box-sizing: border-box;
                    font-size:14px;
                        font-family: "Century Gothic",Consolas,"Liberation Mono",Courier,Verdana;
                        padding-left: 40px;
                    }
                    .exception .source-code pre li{
                        border-left: 1px solid #ddd;
                        height: 18px;
                        line-height: 18px;
                    }
                    .exception .source-code pre code{
                        color: #333;
                        height: 100%;
                        display: inline-block;
                        border-left: 1px solid #fff;
                    font-size:14px;
                        font-family: Consolas,"Liberation Mono",Courier,Verdana,"微软雅黑";
                    }
                    .exception .trace{
                        padding: 6px;
                        border: 1px solid #ddd;
                        border-top: 0 none;
                        line-height: 16px;
                    font-size:14px;
                        font-family: Consolas,"Liberation Mono",Courier,Verdana,"微软雅黑";
                    }
                    .exception .trace ol{
                        margin: 12px;
                    }
                    .exception .trace ol li{
                        padding: 2px 4px;
                    }
                    .exception div:last-child{
                        border-bottom-left-radius: 4px;
                        border-bottom-right-radius: 4px;
                    }
            
                    /* Exception Variables */
                    .exception-var table{
                        width: 100%;
                        margin: 12px 0;
                        box-sizing: border-box;
                        table-layout:fixed;
                        word-wrap:break-word;            
                    }
                    .exception-var table caption{
                        text-align: left;
                        font-size: 16px;
                        font-weight: bold;
                        padding: 6px 0;
                    }
                    .exception-var table caption small{
                        font-weight: 300;
                        display: inline-block;
                        margin-left: 10px;
                        color: #ccc;
                    }
                    .exception-var table tbody{
                        font-size: 13px;
                        font-family: Consolas,"Liberation Mono",Courier,"微软雅黑";
                    }
                    .exception-var table td{
                        padding: 0 6px;
                        vertical-align: top;
                        word-break: break-all;
                    }
                    .exception-var table td:first-child{
                        width: 28%;
                        font-weight: bold;
                        white-space: nowrap;
                    }
                    .exception-var table td pre{
                        margin: 0;
                    }
            
                    /* Copyright Info */
                    .copyright{
                        margin-top: 24px;
                        padding: 12px 0;
                        border-top: 1px solid #eee;
                    }
            
                    /* SPAN elements with the classes below are added by prettyprint. */
                    pre.prettyprint .pln { color: #000 }  /* plain text */
                    pre.prettyprint .str { color: #080 }  /* string content */
                    pre.prettyprint .kwd { color: #008 }  /* a keyword */
                    pre.prettyprint .com { color: #800 }  /* a comment */
                    pre.prettyprint .typ { color: #606 }  /* a type name */
                    pre.prettyprint .lit { color: #066 }  /* a literal value */
                    /* punctuation, lisp open bracket, lisp close bracket */
                    pre.prettyprint .pun, pre.prettyprint .opn, pre.prettyprint .clo { color: #660 }
                    pre.prettyprint .tag { color: #008 }  /* a markup tag name */
                    pre.prettyprint .atn { color: #606 }  /* a markup attribute name */
                    pre.prettyprint .atv { color: #080 }  /* a markup attribute value */
                    pre.prettyprint .dec, pre.prettyprint .var { color: #606 }  /* a declaration; a variable name */
                    pre.prettyprint .fun { color: red }  /* a function name */
                </style>
            </head>
            <body>
            <div class="echo">
            <script>setTimeout(function (){location.href="/";},2000);</script> </div>
            <div class="exception">
            <div class="info"><h1>404页面提醒您，该页面不存在！</h1></div>
            </div>
            <div class="copyright">
            </div>
            </body>
            </html>' );
            				}else{     	 		 		    	 	 	 		
            					$url_404=0;       			 	     	  			 
            				}
            				$seo_301_404_url = get_option('seo_301_404_url');
            				if($seo_301_404_url){
            					update_option('seo_301_404_url',['301_url'=>$url_301,'404_url'=>$url_404]);
            				}else{
            					add_option('seo_301_404_url',['301_url'=>$url_301,'404_url'=>$url_404]);
            				}
                            echo json_encode(['msg'=>1]);exit;     		  	 	    				 		 
            				break;    	  	 	 	     	 		 		
            			case 9:  
    						if(isset($data['seo_url_sl']) && isset($data['seo'])){    						      								
    							$num = (int)$data['page']*((int)$data['num']-1); 
    							
    		                	$post = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where seo_baidu_sl=0 and post_status="publish" and post_type="post"',ARRAY_A);
    							$count = count($post);
    							
    							$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where seo_baidu_sl=0 and post_status="publish" and post_type="post"  limit '.$num.' ,'.(int)$data['page'],ARRAY_A);
    							if($article){    	 	   		       	  	 
    									     	  		 	     		     
    								foreach($article as $key=>$val){    		 			        						
    								    		 	  	        	 		 
    						    		$url = get_permalink($val['ID']);    	  		          	 	  
    						                	  	 	       	  			
    						                		  	 	      	 				 
    									if(baiduseo_baiduquery($url,$val['post_title'])){    		  		 	    	   	 		
    								        $wpdb->update($wpdb->prefix . 'posts',['seo_baidu_sl'=>1],['ID'=>$val['ID']]);
    									}    	 		 			    	     		
    								    	    			         			
    						    	}     	 			       		  	 	
    						    	     		 		 	    	  		 		
    						    	echo json_encode(['msg'=>1,'num'=>(int)$data['num'],'percent'=>round(100*($num+count($article))/$count,2).'%']);exit;    		   			    	    	  
    							}else{     					 	     				 		
    								echo json_encode(['msg'=>0]);exit;    	 					     	  	    
    							}     	 				     	 			 		
    						}     		 
            				break;    	 		  	        					
                        case 10: 
                        	
            					
            						
            						
            						if($data['plts']==1){    	 	 			     	 		 			
            		                    if($data['type']=='zz'){    		     	     	 	 	  
            		                        if(isset($data['wsl']) && $data['wsl']){    			    	    			 			 
            		                            echo baiduseo_pltsxzhzz_1(1,1,(int)$data['num'],(int)$data['page'],(int)$data['shyu']); exit;     		  	      			 	 		
            		                        }else{    	  					       	   	
            		                            echo baiduseo_pltsxzhzz_1(1,0,(int)$data['num'],(int)$data['page'],(int)$data['shyu']); exit;         	 	    				  	 
            		                        }        				       	 		 
            		                             	   		      			  		
            		                    }    	 	   	     			  			
            		                } 
            					
                        		       		 		
                                   	        				 		
                            break;    		 	           					
                         case 11:
                        	
                            $url = get_permalink((int)$data['id']);
            		        $urls =explode(',',$url);
            		        $urls = array_map('esc_url',$urls);
            		        baiduseo_bddayts($urls,(int)$data['id']);exit;  	 	 	 		     	    		
                		 					    		 	    
                            break;
                        case 12:
    						$zhizhu = get_option('baiduseo_zhizhu');
    						if(isset($data['close'])){
    							$baiduseo_zhizhu['auto'] = 1;
    						}else{
    							$baiduseo_zhizhu['auto'] = 0;
    						}
    						if($zhizhu){
    							update_option('baiduseo_zhizhu',$baiduseo_zhizhu);
    						}else{
    							add_option('baiduseo_zhizhu',$baiduseo_zhizhu);
    						}
    						echo json_encode(['msg'=>1]);exit; 
            				break;
            			case 13:
            				
            						$res = $wpdb->query( "DELETE FROM " . $wpdb->prefix . "baiduseo_zhizhu  " );  
            
            						echo json_encode(['msg'=>1]);exit; 
            					
            			
            				break;
            			case 14:
            			   
            				
                                    
            						echo baiduseo_siliansc();exit;
            					
            				  
            				break;
            			case 15:
            				$defaults = array(
            			        'timeout' => 3,
            			        'redirection' => 3,
            			        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
            			        'sslverify' => FALSE,
            			    );
            			    
            			    // $http = get_headers(get_option('siteurl'));
            			   
            			    $search_url =str_replace('www.','', get_option('siteurl'));
            			    
            			    $http = wp_remote_get($search_url,$defaults);
            			    if(is_wp_error($http)){
            			        echo json_encode(['msg'=>0]);exit;
            			    }
            			    if(isset($http['headers']['link']) && $http['headers']['link']){
            			    	 echo json_encode(['msg'=>'恭喜您，您的301状态正常，无需设置！','status'=>1]);exit; 
            			    }else{
            			    	 echo json_encode(['msg'=>0]);exit; 
            			    }
            				break;
            			case 16:
            				
            						$keywords = sanitize_text_field($data['keywords']);
            						$list = $wpdb->query(' select * from  '.$wpdb->prefix.'baiduseo_keywords where type="'.(int)$data['type'].'"');
            							$defaults = array(
            					        'timeout' => 100,
            					        'redirection' => 3,
            					        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
            					        'sslverify' => FALSE,
            					    );
            						if($list>9){
            							$url = 'http://wp.seohnzz.com/api/keywords/num';
            							$result = wp_remote_get($url,$defaults);
            							$content = wp_remote_retrieve_body($result);
            							if($list>$content-1){
            								echo json_encode(['msg'=>4]);exit;
            							}
            						}
            						$re = $wpdb->query(' select * from  '.$wpdb->prefix.'baiduseo_keywords where keywords="'.$keywords.'" and type="'.(int)$data['type'].'"');
            						if($re>=1){
            							echo json_encode(['msg'=>5]);exit;
            						}
            						 $tzs = get_option('timezone_string'); 
            						//设置时区
            						$tzobj = timezone_open($tzs); 
            						$now = date_create('now',$tzobj ); 
            						//获取当前时间
            						$currnetTime= date_format($now, 'Y-m-d H:i:s');
            						$res = $wpdb->insert($wpdb->prefix."baiduseo_keywords",['post_time'=>$currnetTime,'keywords'=>$keywords,'type'=>(int)$data['type']]);
            						
            						$ids = $wpdb->get_results(' select * from  '.$wpdb->prefix.'baiduseo_keywords order by ID desc');
            						$id = $ids[0]->id;
            						if(!$res){
            							echo  json_encode(['msg'=>0]);exit;
            						}
            					
            					    $url = 'http://wp.seohnzz.com/api/keywords/log?url='.get_option('siteurl').'&keywords='.$keywords.'&type='.(int)$data['type'];
            					    
            						$result = wp_remote_get($url,$defaults);
            						if(is_wp_error($result)){
            							$wpdb->query( "DELETE FROM " . $wpdb->prefix . "baiduseo_keywords where id=  ".$id );  
            							echo  json_encode(['msg'=>0]);exit;
            						}
            						$content = wp_remote_retrieve_body($result);
            						
            						if($content){
            							echo  json_encode(['msg'=>1]);exit;
            						}else{
            							$wpdb->query( "DELETE FROM " . $wpdb->prefix . "baiduseo_keywords where id=  ".$id );  
            							echo  json_encode(['msg'=>0]);exit;
            						}
            					
            				
            				break;
            			case 17:
            			   
            			    
            				BaiduSEO_keywords(sanitize_text_field($data['keywords']));
            				break;
            			case 18:
            				if($pay){
            					if($pay['msg']==1 && $pay['url']== md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
            						$id = (int)$data['id'];
            						$list = $wpdb->get_results(' select * from  '.$wpdb->prefix.'baiduseo_keywords where id='.$id,ARRAY_A);
            						$res = $wpdb->query( "DELETE FROM " . $wpdb->prefix . "baiduseo_keywords where id=  ".$id );
            						if($res){
            							$defaults = array(
            						        'timeout' => 100,
            						        'redirection' => 3,
            						        'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36',
            						        'sslverify' => FALSE,
            						    );
            							$url = 'http://wp.seohnzz.com/api/keywords/delete?url='.get_option('siteurl').'&keywords='.$list[0]['keywords'].'&type='.$list[0]['type'];
            							wp_remote_get($url,$defaults);
            							echo  json_encode(['msg'=>'删除成功','status'=>1]);exit;
            						}else{
            							echo  json_encode(['msg'=>'删除失败,请稍后重试','status'=>0]);exit;
            						}
            					}else{
            						echo json_encode(['msg'=>3]);exit; 
            					}
            				}else{
            					echo json_encode(['msg'=>3]);exit; 	
            				} 
            					
            				break;
            			case 19:
            				if($pay){     	 	    
            					if($pay['msg']==1 && $pay['url']== md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){ 
            						if(isset($data['open'])){  
            							$tag['open']=1;   	
            						}else{
            							$tag['open']=0;   
            						}
            						$tag['bold'] = sanitize_text_field($data['bold']);
            						$tag['color'] = sanitize_text_field($data['color']);
            						if(isset($data['auto'])){
            						   $tag['auto']=1;   
            						}else{
            						   $tag['auto']=0;  
            						}
            						if(!$pay){
            							echo json_encode(['msg'=>3]);exit; 
            						}
            						
            						if($pay['msg']==1 && $pay['url']== md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
            						}else{
            							echo json_encode(['msg'=>3]);exit;	
            						}
            						$baiduseo_tag_manage = get_option('baiduseo_tag_manage');
            						if($baiduseo_tag_manage){
            							update_option('baiduseo_tag_manage',$tag);
            						}else{
            							add_option('baiduseo_tag_manage',$tag);
            						}
            					  			   	     					 		
            						echo json_encode(['msg'=>1]);exit;  
            					}else{
            						echo json_encode(['msg'=>3]);exit;	
            					}
            				}else{
            					echo json_encode(['msg'=>3]);exit;	
            				}
            				break;
            			case 20:
            				
            				$res = $wpdb->insert($wpdb->prefix."terms",['name'=>sanitize_text_field($data['tag']),'tag_link'=>esc_url($data['url'])]);
                           
                            if($res){ 
                                if(!$data['url']){
                                	$id = $wpdb->insert_id;
                                	$wpdb->update($wpdb->prefix . 'terms',['slug'=>$id],['term_id'=>$id]);
                                	$wpdb->insert($wpdb->prefix."term_taxonomy",['term_id'=>$id,'taxonomy'=>'post_tag']);
                                	$id_1 = $wpdb->insert_id;
                                	$baiduseo_tag_manage = get_option('baiduseo_tag_manage');
                                	if($baiduseo_tag_manage){
                                	    if(isset($baiduseo_tag_manage['auto']) && $baiduseo_tag_manage['auto']){
                                	        $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where  post_status="publish" and post_type="post" order by ID desc limit 10000',ARRAY_A);
                                	
                                        	foreach($article as $k=>$v){
                                        		if(preg_match('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg(sanitize_text_field($data['tag'])).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i',$v['post_content'],$matches))
                        	                	{
                        	                		$wpdb->insert($wpdb->prefix."term_relationships",['object_id'=>$v['ID'],'term_taxonomy_id'=>$id_1]);	
                        	                		$term_taxonomy = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_taxonomy where  term_taxonomy_id='.$id_1 ,ARRAY_A);
                        	                		
                        	                		$count = $term_taxonomy[0]['count']+1;
                        	                		
                        	                		$res = $wpdb->update($wpdb->prefix . 'term_taxonomy',['count'=>$count],['term_taxonomy_id'=>$id_1]);
                        	                		
                        	                	}
                                        	}
                                	    }
                                	}
                                	
                                	
                                	echo json_encode(['msg'=>1,'tag'=>sanitize_text_field($data['tag']),'url'=>esc_url($data['url'])]);exit;
                                }else{
                                    echo json_encode(['msg'=>1,'tag'=>sanitize_text_field($data['tag']),'url'=>esc_url($data['url'])]);exit;
                                }
                            }else{    	  	 	      	  	 	  
                            	echo json_encode(['msg'=>0]);exit;    		 	 		     	 	    	
                            }     		 
            				break;
            			case 21:
            				
            				if(isset($data['close'])){     	 	 	      	  		 	     	 	 	 	     	   		  
            					   	$list['auto'] = 1;	    		       	   	          	     							 
            				}else{      						    			 		 	     	 			       				 		
            					$list['auto'] = 0;	        			      							     			   	     			  		 
            				} 
            				
            				$baiduseo_day_ts = get_option('baiduseo_day_ts');
            				if($baiduseo_day_ts){
            					update_option('baiduseo_day_ts',$list);
            				}else{
            					add_option('baiduseo_day_ts',$list);
            				}
            				echo json_encode(['msg'=>1]);exit;
            				break;
            			case 22:
            			    
            				$res = $wpdb->query( "DELETE FROM " . $wpdb->prefix . "baidu_seo_day where type=  1" ); 
            				echo json_encode(['msg'=>1]);exit;
            			    break;
            			case 23:
            			    
            				$article = $wpdb->get_results('select p.*,b.id from '.$wpdb->prefix . 'posts as p left join '.$wpdb->prefix . 'baidu_seo_day as b  on p.ID = b.post_id where  p.post_status="publish" and p.post_type="post" and b.id is null  order by p.ID desc limit 100',ARRAY_A);
            				$baidu = get_option('seo_baidu_xzh');
            				if(!isset($baidu['zz_url']) || !isset($baidu['tokens']) || !$baidu['zz_url'] || !$baidu['tokens']){
            				    echo json_encode(['msg'=>'请填写站长信息！','status'=>0]);exit;
            				}
                        	$api = "http://data.zz.baidu.com/urls?site={$baidu['zz_url']}&token={$baidu['tokens']}&type=daily";
                        	$count  = 0;
                            foreach($article as $key=>$val){
                                $result = wp_remote_post($api,['body'=> get_permalink($val["ID"])]);
                                if(is_wp_error($result)){
                                    echo json_encode(['msg'=>'服务器网络波动，请稍后重试！','status'=>0]);exit;
                                }
                            	$result = wp_remote_retrieve_body($result);
                                $res = json_decode($result,true);
                                if(isset($res['error'])){
                                    if($res['message']=='over quota'){
                                        echo json_encode(['msg'=>'当日配额已用完！','status'=>0]);exit;
                                    }else{
                                        echo json_encode(['msg'=>$res['message'],'status'=>0]);exit;
                                    }
                                	
                                }elseif(isset($res['success'])){
                                    if(isset($res['not_same_site'])){
                                        $not_same_site = implode('\n',$res['not_same_site']);
                                        
                                        echo json_encode(['msg'=>"推送失败，原因是存在不是本站url:{$not_same_site}",'status'=>0]);exit;
                                        
                                    }elseif(isset($res['not_valid'])){
                                        $not_valid = implode('\n',$res['not_valid']);
                                        echo json_encode(['msg'=>"推送失败，原因是不合法的url:{$not_valid}",'status'=>0]);exit;
                                        
                                    }else{
                                        ++$count;
                                    	$tzs = get_option('timezone_string'); 
                            			//设置时区
                            			$tzobj = timezone_open($tzs); 
                            			$now = date_create('now',$tzobj ); 
                            			//获取当前时间
                            			$currnetTime= date_format($now, 'Y/m/d H:i:s');
                                        $data_array=[
                                            'time' => $currnetTime,
                                            'post_id'=>intval($val["ID"]),
                                            'link' => get_permalink($val["ID"])
                                        ];
                            			if($res['remain_daily']==0){
                            			    $wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
                            				break;
                            			}
                            			$wpdb->insert($wpdb->prefix."baidu_seo_day",$data_array);
                                    }
                                }
                            }
                            
                            $tzs = get_option('timezone_string');
                        	//设置时区
                        	$tzobj = timezone_open($tzs); 
                        	$now = date_create('now',$tzobj ); 
                        	//获取当前时间
                        	$currnetTime= date_format($now, 'Y/m/d H:i:s');
                            $baiduseo_pltsdayts = get_option('baiduseo_pltsdayts');
                            if($baiduseo_pltsdayts){
                                update_option('baiduseo_pltsdayts',['time'=>$currnetTime,'count'=>$count]);
                            }else{
                                add_option('baiduseo_pltsdayts',['time'=>$currnetTime,'count'=>$count]);
                            }
                            echo json_encode(['msg'=>"推送成功{$count}条,剩余配额：{$res['remain_daily']}条",'status'=>1]);exit;
            			    break;
            			case 24:
            			    
            				$num = (int)$data['num'];
            				$page = (int)$data['page'];
            				$tag_num = (int)$data['tag_num'];
            				$article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post"',ARRAY_A);
            				$total = count($article);
            				$start = ($num-1)*$page;
            				$list = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where post_status="publish" and post_type="post" limit '.$start.','.$page,ARRAY_A);
            				if(!empty($list)){
            				foreach($list as $key=>$val){
            				    // var_dump($val['ID'].',');
            				    $tag_article = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'term_relationships as a left join '.$wpdb->prefix.'term_taxonomy as b on a.term_taxonomy_id=b.term_taxonomy_id where  a.object_id='.$val['ID'].' and b.taxonomy="post_tag"' ,ARRAY_A);
            				    
            				    if(!empty($tag_article)){
            				        $count = count($tag_article);
            				    }else{
            				        $count = 0;
            				    }
            				//     var_dump($tag_num).',';
            				//   var_dump($count);
            				    if($count==$tag_num){
            				       
            				    }elseif($count<$tag_num){
            				        
            				        $tags=$wpdb->get_results('select * from '.$wpdb->prefix . 'terms',ARRAY_A);
                                    $nos =0;
                                    foreach($tags as $k=>$v){
                                        
                                        $term_taxonomy = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_taxonomy where term_id=  '.$v['term_id'].' and 	taxonomy="post_tag"',ARRAY_A);
                                      if(!empty($term_taxonomy)){
                                       
                                            $res = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_relationships where object_id=  '.$val['ID'].' and term_taxonomy_id='.$term_taxonomy[0]['term_taxonomy_id'],ARRAY_A);
                                            
                                            if(empty($res)){
                                               
                                                // var_dump($tag_num-$count);
                                                if($nos<($tag_num-$count)){
                                                    
                                                   
                                            	    if(preg_match('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($v['name']).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i',get_post($val['ID'])->post_content,$matches))
                                            		{
                                            		    
                                    					$re = $wpdb->insert($wpdb->prefix."term_relationships",['object_id'=>$val['ID'],'term_taxonomy_id'=>$term_taxonomy[0]['term_taxonomy_id']]);
                                    					if($re){
                                    					    ++$nos;
                                    					}
                                    					$counts = $wpdb->query('select * from '.$wpdb->prefix . 'term_relationships where  term_taxonomy_id='.$term_taxonomy[0]['term_taxonomy_id'],ARRAY_A);
    
                                    	                $wpdb->update($wpdb->prefix . 'term_taxonomy',['count'=>$counts],['term_taxonomy_id'=>$term_taxonomy[0]['term_taxonomy_id']]);
                                    	                
                                    	                
                                            		}
                                                }
                                            }
                                        }
                                    }
            				    }elseif($count>$tag_num){
            				       
            				        $no = 0;
            				        foreach($tag_article as $k=>$v){
            				     
            				            if($no<($count-$tag_num)){
            				                
            				                $re = $wpdb->query( "DELETE FROM " . $wpdb->prefix . "term_relationships where object_id=  ".$v['object_id'].' and term_taxonomy_id='.$v['term_taxonomy_id'] );
            				                if($re){
            				                    ++$no;
            				                }
            				                $counts = $wpdb->query('select * from '.$wpdb->prefix . 'term_relationships where  term_taxonomy_id='.$v['term_taxonomy_id'],ARRAY_A);
                        	                $wpdb->update($wpdb->prefix . 'term_taxonomy',['count'=>$counts],['term_taxonomy_id'=>$v['term_taxonomy_id']]);
            				                
            				            }
            				            
            				        }
            				        
            				    }
            				}
            			
            				echo json_encode(['num'=>$num,'percent'=>round(100*($start+count($list))/$total,2).'%','page'=>$page,'tag_num'=>$tag_num,'status'=>1]);exit;
            				}
            			   	
            				else{
            				    echo json_encode(['msg'=>"操作完成",'status'=>0]);exit;
            				}
            			    break;
            	        case 25:
            				$cate = (int)$data['cate'];
            				$seo = ['keywords'=>sanitize_text_field($data['keywords']),'description'=>sanitize_textarea_field($data['description']),'title'=>sanitize_text_field($data['title'])];   
            				$seo_init = get_option('baiduseo_cate_'.$cate);
            				
            	            if($seo_init){
            	            	update_option('baiduseo_cate_'.$cate,$seo);
            	            }else{
            	            	add_option('baiduseo_cate_'.$cate,$seo);
                        	} 
                        	echo json_encode(['msg'=>1]);exit;
            	            break;
            	           case 26:
            	               
            	               if(isset($data['open'])){
            	                   $cate = ['istrue'=>1];
            	               }else{
            	                   $cate = ['istrue'=>0];
            	               }
            	               $seo_init = get_option('baiduseo_category');
            				
                	            if($seo_init){
                	            	update_option('baiduseo_category',$cate);
                	            }else{
                	            	add_option('baiduseo_category',$cate);
                            	} 
                            	echo json_encode(['msg'=>1]);exit;
            	               break;
            	        case 27:
            	            $cate = (int)$data['id'];
            	            $baiduseo_cate = get_option('baiduseo_cate_'.$cate);
            	            if($baiduseo_cate){
            	                echo json_encode(['msg'=>1,'cate'=>$baiduseo_cate]);exit;
            	            }else{
            	                echo json_encode(['msg'=>0]);exit;
            	            }
            	            break;
            	       case 28:
            	           if(!$pay){
            					echo json_encode(['msg'=>3]);exit; 
            				}
                            if($pay['msg']==1 && $pay['url']= md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
            				}else{
            					echo json_encode(['msg'=>3]);exit;	
            				}
            			
            				$content = explode("\n",sanitize_textarea_field($data['content']));
            				
            				if($pay['msg']==1 && $pay['url']= md5($_SERVER['SERVER_NAME'].BAIDUSEO_SALT)){
            				}else{
            					echo json_encode(['msg'=>3]);exit;	
            				}
            				
            				
            				if($content){
            				    if(!$pay){
                					echo json_encode(['msg'=>3]);exit; 
                				}
                			
            				    foreach($content as $key=>$val){
            				        $tag = explode(',',$val);
            				        
            				        if(isset($tag[1])){
            				            $res = $wpdb->insert($wpdb->prefix."terms",['name'=>$tag[0],'tag_link'=>$tag[1]]);
            				        }else{
            				           $terms = $wpdb->get_results('select a.* from '.$wpdb->prefix . 'terms as a left join '.$wpdb->prefix . 'term_taxonomy as b on a.term_id=b.term_id   where b.taxonomy="post_tag" and a.name="'.$tag[0].'" ',ARRAY_A);
            				           if(!$terms){
            				                $res = $wpdb->insert($wpdb->prefix."terms",['name'=>$tag[0]]);
            				           }
            				        }
                	                if($res){ 
                	                    if(!isset($tag[1])){
                    	                	$id = $wpdb->insert_id;
                    	                	$wpdb->update($wpdb->prefix . 'terms',['slug'=>$id],['term_id'=>$id]);
                    	                	$wpdb->insert($wpdb->prefix."term_taxonomy",['term_id'=>$id,'taxonomy'=>'post_tag']);
                    	                
                                    		$id_1 = $wpdb->insert_id;
                    	                	$baiduseo_tag_manage = get_option('baiduseo_tag_manage');
                                        	if($baiduseo_tag_manage){
                                        	    
                                        	    if(isset($baiduseo_tag_manage['auto']) && $baiduseo_tag_manage['auto']){
                                        	        $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where  post_status="publish" and post_type="post" order by ID desc limit 10000',ARRAY_A);
                                        	        $article = $wpdb->get_results('select * from '.$wpdb->prefix . 'posts where  post_status="publish" and post_type="post" order by ID desc limit 10000',ARRAY_A);
                                        
                                                	foreach($article as $k=>$v){
                                                		if(preg_match('{(?!((<.*?)|(<a.*?)))('.BaiduSEO_preg($tag[0]).')(?!(([^<>]*?)>)|([^>]*?<\/a>))}i',$v['post_content'],$matches))
                                	                	{
                                	                		$wpdb->insert($wpdb->prefix."term_relationships",['object_id'=>$v['ID'],'term_taxonomy_id'=>$id_1]);	
                                	                		$term_taxonomy = $wpdb->get_results('select * from '.$wpdb->prefix . 'term_taxonomy where  term_taxonomy_id='.$id_1 ,ARRAY_A);
                                        	                		
                                        	                $count = $term_taxonomy[0]['count']+1;
                                        	                $res = $wpdb->update($wpdb->prefix . 'term_taxonomy',['count'=>$count],['term_taxonomy_id'=>$id_1]);
                                	                	}
                                                	}
                                        	    }
                                        	}
                    	                }
                	                }   	
            				    }
            				    echo json_encode(['msg'=>1]);exit;
            				}
            				
            				echo json_encode(['msg'=>0]);exit; 
            	           break;
            			
            		}
        	    }
    	
    
}


}
function baiduseo_refreshrules() {
	global $wp_rewrite;
	$wp_rewrite->flush_rules();
}

function baiduseo_deactivate() {
	remove_filter( 'category_rewrite_rules', 'baiduseo_rewriterules' ); // We don't want to insert our custom rules again
	baiduseo_refreshrules();
}

/**
 * Removes category base.
 *
 * @return void
 */
function baiduseo_permastruct()
{
	global $wp_rewrite;
	global $wp_version;

	if ( $wp_version >= 3.4 ) {
		$wp_rewrite->extra_permastructs['category']['struct'] = '%category%';
	} else {
		$wp_rewrite->extra_permastructs['category'][0] = '%category%';
	}
}

function baiduseo_rewriterules($category_rewrite) {
	global $wp_rewrite;
	$category_rewrite=array();

	/* WPML is present: temporary disable terms_clauses filter to get all categories for rewrite */
	if ( class_exists( 'Sitepress' ) ) {
		global $sitepress;

		remove_filter( 'terms_clauses', array( $sitepress, 'terms_clauses' ) );
		$categories = get_categories( array( 'hide_empty' => false ) );
		//Fix provided by Albin here https://wordpress.org/support/topic/bug-with-wpml-2/#post-8362218
		//add_filter( 'terms_clauses', array( $sitepress, 'terms_clauses' ) );
		add_filter( 'terms_clauses', array( $sitepress, 'terms_clauses' ), 10, 4 );
	} else {
		$categories = get_categories( array( 'hide_empty' => false ) );
	}

	foreach( $categories as $category ) {
		$category_nicename = $category->slug;

		if ( $category->parent == $category->cat_ID ) {
			$category->parent = 0;
		} elseif ( $category->parent != 0 ) {
			$category_nicename = get_category_parents( $category->parent, false, '/', true ) . $category_nicename;
		}

		$category_rewrite['('.$category_nicename.')/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$'] = 'index.php?category_name=$matches[1]&feed=$matches[2]';
		$category_rewrite["({$category_nicename})/{$wp_rewrite->pagination_base}/?([0-9]{1,})/?$"] = 'index.php?category_name=$matches[1]&paged=$matches[2]';
		$category_rewrite['('.$category_nicename.')/?$'] = 'index.php?category_name=$matches[1]';
	}

	// Redirect support from Old Category Base
	$old_category_base = get_option( 'category_base' ) ? get_option( 'category_base' ) : 'category';
	$old_category_base = trim( $old_category_base, '/' );
	$category_rewrite[$old_category_base.'/(.*)$'] = 'index.php?category_redirect=$matches[1]';

	return $category_rewrite;
}

function baiduseo_queryvars($public_query_vars) {
	$public_query_vars[] = 'category_redirect';
	return $public_query_vars;
}

/**
 * Handles category redirects.
 *
 * @param $query_vars Current query vars.
 *
 * @return array $query_vars, or void if category_redirect is present.
 */
function baiduseo_request($query_vars) {
	if( isset( $query_vars['category_redirect'] ) ) {
		$catlink = trailingslashit( get_option( 'home' ) ) . user_trailingslashit( $query_vars['category_redirect'], 'category' );
		status_header( 301 );
		header( "Location: $catlink" );
		exit();
	}

	return $query_vars;
}

    
