<?php
/**
 * +------------------------------------------------------------
 * | 管理员 (admin/controller/Admin.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 14:45:41
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 14:45:41
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\admin\controller;

use think\Validate;

class Admin extends Module
{
    /**
     * 管理员列表
     */
    public function index($keywords = '', $limit = 20)
    {
        $where = [];
        if ($keywords) $where[] = ['name', 'like', '%' . $keywords . '%'];
        $rs = model('app\admin\model\Admin')->where($where)->paginate($limit)->toArray();
        $role = array_column($this->role(0, 1), null, 'id');
        foreach ($rs['data'] as $k => &$v) $v['role'] = empty($role[$v['role_id']]) ? [] : $role[$v['role_id']];
        return json(['code' => 1, 'data' => $rs]);
    }

    /**
     * 添加/修改管理员
     */
    public function form($id)
    {
        if (request()->isPost()) {
            $data = input('post.');
            if ($id) {
                $validate = validate('Edit');
                if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
                unset($data['name']);
                if (!empty($data['pwd'])) {
                    $data['pwd'] = md5($data['pwd']);
                } else {
                    unset($data['pwd']);
                }
                model('app\admin\model\Admin')->allowField(true)->save($data, ['id' => $id]);
                action('Api/log', ['修改管理员', '帐号:' . input('post.name')]);
                return json(['code' => 1, 'msg' => '管理员《' . input('post.name') . '》已更新。']);
            } else {
                $validate = validate('Add');
                if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
                if (db('admin')->where('name', $data['name'])->find()) return json(['code' => 0, 'msg' => '管理员已存在,请更换管理员名称']);
                $data['pwd'] = md5($data['pwd']);
                model('app\admin\model\Admin')->allowField(true)->data($data)->save();
                action('Api/log', ['新增管理员', '帐号:' . $data['name']]);
                return json(['code' => 1, 'msg' => '管理员《' . $data['name'] . '》已新增。']);
            }
        } else {
            if ($id) {
                $rs = model('admin')->find($id);
                return json(['code' => 1, 'data' => $rs]);
            }
        }

    }

    /**
     * 删除管理员
     */
    public function delete($id = 0)
    {
        if ($id) {
            if (session('admin.id') == $id) return json(['code' => 0, 'msg' => '不能删除自己']);
            $rs = db('admin')->find($id);
            if ($rs) {
                action('Api/log', ['删除管理员', '帐号:' . $rs['name']]);
                db('admin')->delete($id);
            }
        }
        return json(['code' => 1, 'msg' => "删除成功"]);
    }

    /**
     * 日志管理
     */
    public function log()
    {
        if ($this->request->isPost()) {
            if (!empty(input('post.days')) && intval(input('post.days')) >= 30) {
                $delete_time = time() - (intval(input('post.days')) * 86400);
                db('admin_log')->where('create_time', '<', $delete_time)->delete();
                action('Api/log', ['日志清除', date('Y-m-d', $delete_time) . '之前的管理员日志']);
                return json(['code' => 1, 'msg' => "已清除 " . date('Y-m-d', $delete_time) . " 之前的管理员日志。"]);
            }
            return json(['code' => 0, 'msg' => '参数错误']);
        }
        $where = [];
        $rs = db('admin_log')->alias('l')
            ->join('admin a', 'l.admin_id= a.id')->field('l.*, a.name')->where($where)->order('create_time desc')->paginate(20)->toArray();
        return json(['code' => 1, 'msg' => $rs]);
    }

    /**
     * 修改密码
     */
    public function pwd()
    {
        if (request()->isPost()) {
            $data = input('post.');
            if (md5($data['old_pwd']) != session('admin.pwd')) {
                return json(['code' => 0, 'msg' => '您输入的旧密码不正确。']);
            }
            if (empty($data['pwd'])) {
                return json(['code' => 0, 'msg' => '请输入新密码。']);
            }
            if ($data['pwd'] != $data['confirm_pwd']) {
                return json(['code' => 0, 'msg' => '您两次新密码输入的不一致。']);
            }
            $data['pwd'] = md5($data['pwd']);
            unset($data['old_pwd']);
            unset($data['confirm_pwd']);
            db('admin')->where(['id' => session('admin.id')])->update($data);
            action('Api/log', ['管理员修改密码', '帐号:' . session('admin.name')]);
            return json(['code' => 1, 'msg' => '您的密码已修改。']);
        }
    }

    /**
     * 角色
     */
    public function role($return = 1, $refresh = 0, $status = '')
    {
        if ($refresh) cache('role', null);
        if (!empty(cache('role'))) {
            $rs = cache('role');
        } else {
            $rs = model('role')->select();
            $rs = array_merge(config('app.role'), empty($rs) ? [] : $rs->toArray());
            cache('role', $rs);
        }
        if ($status != '') {
            $data = [];
            foreach ($rs as $k => $v) {
                if (in_array($v['status'], (array)$status)) $data[] = $v;
            }
            $rs = $data;
        }
        return $return ? json(['code' => 1, 'data' => $rs]) : $rs;
    }

    /**
     * 新建/编辑角色
     */
    public function role_form($id)
    {
        if (request()->isPost()) {
            $validate = validate('Role');
            if (!$validate->check(input('post.'))) return json(['code' => 0, 'msg' => $validate->getError()]);
            $data = ['name' => input('post.name'), 'memo' => input('post.memo'), 'status' => input('post.status')];
            if (input('?post.power')) $data['power'] = implode(',', input('post.power/a'));
            if ($id) {
                db('admin_role')->where('id', $id)->update($data);
                action('Api/log', ['编辑角色', 'ID: ' . $id . ' / 名称:' . $data['name']]);
                cache('role', null);
                return json(['code' => 1, 'msg' => '角色《' . $data['name'] . '》已更新。']);
            } else {
                db('admin_role')->insert($data);
                action('Api/log', ['创建角色', '名称:' . $data['name']]);
                cache('role', null);
                return json(['code' => 1, 'msg' => '角色《' . $data['name'] . '》已新增。']);
            }
        } else {
            if ($id) {
                $rs = model('role')->find($id);
                return json(['code' => 1, 'data' => $rs]);
            }
        }
    }

    /**
     * 获得权限列表
     */
    public function navs()
    {
        return json(['code' => 1, 'data' => get_nav_map()]);
    }


    /**
     * 角色删除
     */
    public function role_delete($id = 0)
    {
        $count = db('admin')->where('role_id', $id)->count();
        if ($count == 0) {
            model('role')->where('id', $id)->delete();
            cache('role', null);
            return json(['code' => 1, 'msg' => '角色删除成功']);
        } else {
            return json(['code' => 0, 'msg' => '此角色包含' . $count . '位管理员，不可删除。']);
        }
    }

    /**
     * 空方法解析
     */
    public function _empty($name)
    {
        if (in_array($name, array('role_add', 'role_edit'))) {
            return $this->role_form(input('param.id', 0));
        }
        return parent::_empty($name);
    }

    /**
     * 当前登录管理员信息
     * @return \think\response\Json
     */
    function info()
    {
        return json(['code' => 1, 'data' => session('admin')]);
    }
}
