<?php
/**
 * +------------------------------------------------------------
 * | 管理员-接口 (admin/controller/Api.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 15:47:29
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 15:47:29
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\admin\controller;

use app\common\controller\Check;

class Api extends Module
{

    /**
     * 登录
     */
    public function login($user = '', $pwd = '', $captcha = '')
    {
        if (!empty($user) && !empty($pwd) && !empty($captcha)) {
            if (!captcha_check($captcha)) {
                return json(['code' => 0, 'msg' => '验证码错误']);
            }
            $where = ['a.name' => $user, 'pwd' => md5($pwd)];
            $rs = db('admin')->alias('a')->field('a.*, r.name role_name, r.power,r.status role_status')->join('__ADMIN_ROLE__ r', 'a.role_id=r.id', 'LEFT')->where($where)->find();
            if ($rs) {
                if ($rs['role_id'] != 0 && $rs['role_status'] != 1) return json(['code' => 0, 'msg' => '管理员禁止登录']);
                //if ($rs['role_id'] != 0 && (empty($rs['allow_week']) || !in_array(date('w'), explode(',', $rs['allow_weed'])))) return json(['code' => 0, 'msg' => '当前时间禁止登录']);
                //if ($rs['role_id'] != 0 && (empty($rs['allow_time']) || !in_array(date('H'), explode(',', $rs['allow_time'])))) return json(['code' => 0, 'msg' => '当前时间禁止登录']);
                db('admin')->where(['id' => $rs['id']])->update(['login_ip' => self::$sys['ip'], 'login_time' => time()]);
                $rs['message_count'] = db('message')->where('admin_id', 'neq', 0)->where('status', '=', 1)->count();
                session('admin', $rs);
                $this->log('登录成功', '', $user);
                return json(['code' => 1, 'msg' => '登录成功', 'data' => $rs]);
            } else {
                $this->log('登录失败', '用户名: ' . $user . '密码: ' . $pwd);
                return json(['code' => 0, 'msg' => '登录失败']);
            }
        }
        return '';
    }

    /**
     * 创建日志
     */
    public function log($event, $memo = '')
    {
        if (empty($event)) return;
        $ops['event'] = $event;
        $ops['memo'] = $memo;
        $ops['admin_id'] = intval(session('admin.id'));
        $ops['module'] = self::$sys['module'];
        $ops['action'] = self::$sys['action'];
        $ops['ip'] = self::$sys['ip'];
        $ops['os'] = get_client_os();
        $ops['browser'] = get_client_browser();
        $ops['create_time'] = time();
        return db('admin_log')->insert($ops);
    }

    /**
     * 退出
     */
    function logout()
    {
        if (session('admin.id')) action('Api/log', ['注销']);
        session('admin', null);
        return json(['code' => 1, 'msg' => '退出成功']);
    }

}