<?php
/**
 * +------------------------------------------------------------
 * | 数据 data/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/7/4
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/7/4
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\block\validate;

use think\Validate;

class Add extends Validate
{
    protected $rule = [
        'name' => 'require',
        'key' => 'require',
        'status' => 'number|in:0,1',
        'type' => 'require|in:0,1,2,3',
        'memo' => 'max:255'
    ];

    protected $message = [
        'name.require' => '区块名称不能为空',
        'key.require' => '区块标识不能为空',
        'status.number' => '区块状态必须为数字',
        'status.in' => '状态值数据非法',
        'type.require' => '区块类型不能为空',
        'type.in' => '区块类型数据非法',
        'memo.max' => '备注数据过长'
    ];
}