<?php
/**
 * +------------------------------------------------------------
 * | 财务 finance/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\controller;

use app\common\controller\Init;

class Module extends Init
{
    protected function initialize()
    {
        parent::initialize();
        $this->finance_setting = load_setting(self::$sys['module']);
        $this->finance_payment = config('')['finance']['offline'];
    }

    function query($attr = [])
    {
        is_string($attr) && $attr = \json_decode($attr, true);
        $where = [];
        if (!empty($attr['start_time']) && !empty($attr['end_time'])) {
            $where[] = ['update_time', 'between', [strtotime($attr['start_time']), strtotime($attr['end_time'])]];
        } else {
            if (!empty($attr['start_time'])) {
                $where[] = ['update_time', '>', strtotime($attr['start_time'])];
            }
            if (!empty($attr['end_time'])) {
                $where[] = ['update_time', '<', strtotime($attr['end_time'])];
            }
        }
        if (isset($attr['user_id'])) {
            $where[] = ['o.user_id', '=', $attr['user_id']];
        }
        if (isset($attr['type']) && $attr['type'] != '') {
            $where[] = ['o.type', '=', $attr['type']];
        }
        if (isset($attr['payment']) && $attr['payment'] != '') {
            $where[] = ['o.payment', '=', $attr['payment']];
        }
        if (isset($attr['balance']) && $attr['balance'] != '') {
            $where[] = ['o.balance', '=', $attr['balance']];
        }
        if (isset($attr['status']) && $attr['status'] != '') {
            $where[] = ['o.status', '=', $attr['status']];
        }
        if (!empty($attr['name'])) {
            $user_id = intval(model('app\user\model\User')->where('name', $attr['name'])->value('id'));
            $where[] = ['o.user_id', '=', $user_id];
        }
        if (isset($attr['token'])) {
            $where[] = ['o.user_id', '=', empty(session('user.id')) ? 0 : session('user.id')];
        }
        if (self::$sys['controller'] != 'admin') {
            $where[] = ['o.user_id', '=', intval(session('user.id'))];
        }
        $with = (isset($attr['with']) ? $attr['with'] : '');
        $field = (isset($attr['field']) ? $attr['field'] : '');
        $limit = (isset($attr['limit']) ? $attr['limit'] : 20);
        $order = (isset($attr['order']) ? $attr['order'] : 'create_time desc');
        $finance_order = model('app\finance\model\Order')->alias('o')->with($with)->where($where)->field($field)->order($order);
        if (isset($attr['join'])) {
            $finance_order = $finance_order->join($attr['join']['table'], $attr['join']['where']);
        }
        if (isset($attr['id'])) {
            $rs = $finance_order->where('id', $attr['id'])->find();
        } else if (isset($attr['page'])) {
            $rs = $finance_order->paginate($limit, '', ['page' => $attr['page']])->toArray();
        } else {
            $rs = $finance_order->select()->toArray();
        }
        return $rs;
    }

}