<?php
/**
 * +------------------------------------------------------------
 * | 站内信 message/controller/Admin.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/5/31
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/5/31
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\message\controller;

use app\common\controller\Init;

class Module extends Init
{
    function query($attr = [])
    {
        $where = [];
        if (isset($attr['start_time']) && isset($attr['end_time'])) {
            $where[] = ['create_time', 'between', [strtotime($attr['start_time']), strtotime($attr['end_time'])]];
        } else {
            if (isset($attr['start_time'])) {
                $where[] = ['create_time', '>', strtotime($attr['start_time'])];
            }
            if (isset($attr['end_time'])) {
                $where[] = ['create_time', '<', strtotime($attr['start_time'])];
            }
        }
        if (self::$sys['controller'] == 'admin') {
            $where[] = ['admin_id', 'neq', 0];
        } else {
            $where[] = ['user_id', '=', session('user.id')];
        }
        if (isset($attr['status'])) {
            $where[] = ['status', '=', $attr['status']];
        }
        $limit = (isset($attr['limit']) ? $attr['limit'] : 20);
        $order = (isset($attr['order']) ? $attr['order'] : 'create_time desc');
        $message = model('app\message\model\Message')->where($where)->order($order);
        if (isset($attr['id'])) {
            $rs = $message->where('id', $attr['id'])->find();
        } else if (isset($attr['page'])) {
            $rs = $message->paginate($limit)->toArray();
        } else {
            $rs = $message->select()->toArray();
        }
        return $rs;
    }
}