<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/Index.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

class Index extends Module
{

    /**
     * 登录
     */
    public function login()
    {
        if (request()->isPost()) {
            $result = action('user/api/login', [1, input('post.'), 0]);
            if (empty($result['code'])) {
                $this->log_user_login_error(1);
                return $this->error($result['msg']);
            }
            $this->redirect(url('user/user/index'));
        } else {
            if (!empty(session('user'))) $this->redirect('user/user/index');
            $this->assign('login_check', empty($this->user_setting['login_check']) ? 0 : 1);
            return view('../login');
        }
    }

    /**
     * 记录登录失败次数
     */
    public function log_user_login_error($count = '0')
    {
        $key = 'user_login_error_count';
        $result = !empty(session($key)) ? session($key) : 0;
        if ($count) {
            $result += 1;
            session($key, $result);
        }
        return $result;
    }

    /**
     * 退出登录
     */
    public function logout()
    {
        if (empty(session('user')))
            $this->redirect((self::$sys['referer'] ? self::$sys['referer'] : '/'));
        session('user', null);
        cookie(config('cookie_key') . md5(config('cookie_val')), null);
        $this->redirect((self::$sys['referer'] ? self::$sys['referer'] : '/'));
    }

    /**
     * 注册表单
     */
    public function register()
    {
        if (request()->isPost()) {
            $data = input('post.');
            $result = action('user/api/register', [1, $data, 0]);
            if ($result['code'] == 1) {
                $url = url('user/user/index');
                $this->success('注册成功，正在为您跳转...', $url);
            } else {
                $this->error($result['msg']);
            }
        } else {
            if (empty($this->user_setting['close_register'])) {
                $this->error('系统关闭注册,请稍后重试...');
            }
            if (!empty($this->user)) $this->redirect('/');
            $this->assign('reg_check', empty($this->user_setting['reg_check']) ? 0 : 1);
            return view('../register');
        }
    }

    /*
     * 忘记密码
     */
    function forget()
    {
        if ((time() - session('forget.time')) > 120)
            session('forget', null);
        $step = session('forget.step');
        $steps = input("?param.step") ? intval(input('param.step')) : 1;
        if (empty($step)) {
            $step = 1;
            if ($steps != 1) {
                $this->redirect(url('forget', ['step' => 1]));
            }
        } else {
            if ($step != $steps) {
                $this->redirect(url('forget', ['step' => $step]));
            }
        }
        if (request()->isPost()) {
            if (!input('?post.step') || !in_array(input('post.step'), [1, 2]))
                $this->error('数据非法');
            if (input('post.step') != $step) {
                $this->redirect(url('forget', ['step' => $step]));
            }
            $data = input('post.');
            if ($step == 1) {
                $phone = session('forget.phone');
                if (empty($data['phone']) || $data['phone'] != $phone)
                    $this->error('手机号码错误');
                $rs = db('user')->where('phone', $phone)->find();
                if (empty($rs))
                    $this->error('抱歉，此用户不存在，您可以重新注册。');
                session('forget.id', $rs['id']);
                session('forget.time', time());
                if (empty($data['code']))
                    $this->error('验证码错误');
                $code = $data['code'];
                if ($code != session('forget.code'))
                    $this->error('验证码错误');
                session('forget.step', 2);
                $this->redirect(url('forget', ['step' => 2]));
            }
            if ($step == 2) {
                if (empty($data['pwd']) || empty($data['repwd']))
                    $this->error('参数错误');
                if ($data['pwd'] != $data['repwd']) {
                    $this->error('您两次输入的密码不一致。');
                } else {
                    db('user')->where(['id' => session('forget.id')])->update(['pwd' => pwd_md5($data['pwd'])]);
                    session('forget', null);
                    $this->success('您新密码已设置成功，3秒后自动跳入登录页面。', url('login'));
                }
            }
        }
        $this->assign('phone', session('forget.phone'));
        $this->assign('step', $step);
        return view('../forget');
    }

    /*
     * 验证邮箱
     */
    public function verify_email($token = '')
    {
        if ($token) {
            $verify = explode("-", $token);
            $uid = decrypt($verify[0]);
            $email = decrypt($verify[1]);
            $time = $verify[2];
            if ($time + 3600 * 24 >= time()) {
                $email_info = db('user')->where('email', $email)->find();
                $user_info = db('user')->where('id', $uid)->find();
                if (!empty($email_info)) {
                    $this->error('邮箱已被注册');
                }
                if (empty($user_info))
                    $this->error('邮箱验证失败!', url('user/user/index'));
                if (false === $reg = db('user')->where('id', $uid)->update(['email' => $email]))
                    $this->error('邮箱验证失败!', url('user/user/index'));
                $log = db('user_log')->where('user_id', '=', $user_info['id'])->where('action', '=', 'verify_email')->count();
                if (empty($log)) {
                    if (!empty($this->user_setting['bind_email_credit'])) {
                        $credit = intval($this->user_setting['bind_email_credit']);
                        $attr = [
                            'balance' => 1,
                            'money' => $credit,
                            'user_id' => $user_info['id'],
                            'payment' => 4,
                            'type' => 0,
                            'memo' => '绑定邮箱赠送【' . $credit . '】积分'
                        ];
                        //创建赠送积分订单
                        $order = action('finance/api/order', [$attr, 0]);
                        if ($order['code'] == 1) {
                            //进行支付
                            action('finance/api/credit', [['order' => $order['order']]]);
                        }
                    }
                }
                action('user/api/log', ['绑定邮箱', '', $user_info['id']]);
                $this->success('邮箱验证通过!', url('user/user/index'));
            } else {
                $this->error('该链接已过期', url('user/user/index'));
            }
        } else {
            $this->error('链接无效', url('user/user/index'));
        }
    }

}
