<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

use app\common\controller\Init;

class Module extends Init
{

    protected function initialize()
    {
        parent::initialize();
        $this->assign('option', config('option'));
        self::$user = session('user');
        $this->user_setting = load_setting(self::$sys['module']);
    }

    function query($attr = [])
    {
        is_string($attr) && $attr = \json_decode($attr, true);
        $where = [];
        if (isset($attr['keywords']) && $attr['keywords'] != '') {
            $where[] = ['name', 'like', '%' . $attr['keywords'] . '%'];
        }
        if (isset($attr['group_id']) && $attr['group_id'] != '') {
            $where[] = ['group_id', '=', $attr['group_id']];
        }
        if (isset($attr['phone'])) {
            $where[] = ['phone', '=', $attr['phone']];
        }
        if (isset($attr['email'])) {
            $where[] = ['email', '=', $attr['email']];
        }
        if (isset($attr['openid'])) {
            $attr['id'] = model('app\user\model\oauth')->where('openid', $attr['openid'])->value('uid');
        }
        if (isset($attr['status'])) {
            $where[] = ['status', '=', $attr['status']];
        }
        if (isset($attr['name'])) {
            $where[] = ['name', '=', $attr['name']];
        }
        if (self::$sys['controller'] != 'admin') {
            if (!isset($attr['id'])) {
                $attr['id'] = intval(session('user.id'));
            }
        }
        $field = (isset($attr['field']) ? $attr['field'] : '');
        $limit = (isset($attr['limit']) ? $attr['limit'] : 20);
        $order = (isset($attr['order']) ? $attr['order'] : 'id desc');
        $user = model('app\user\model\User')->where($where)->field($field)->limit($limit)->order($order);
        if (isset($attr['with'])) $user = $user->with($attr['with']);
        if (isset($attr['id'])) {
            $rs = $user->where('id', $attr['id'])->find();
        } else if (isset($attr['page'])) {
            $rs = $user->paginate($limit)->toArray();
        } else {
            $rs = $user->select()->toArray();
        }
        return $rs;
    }

}
