<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/User.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

use app\user\model\User as U;

class User extends Module
{

    public function initialize()
    {
        parent::initialize();
        $this->_where = ['id' => session('user.id')];
    }

    /*
     * 首页
     */
    public function index()
    {
        $rs = session('user');
        $rs['total'] = [
            'info' => db('data')->where('user_id', '=', session('user.id'))->count(),
            'company' => 0,
            'comment' => 0
        ];
        return view('', ['rs' => $rs]);
    }

    /*
     * 修改密码
     */
    function pwd()
    {
        if (request()->isPost()) {
            $data = input('post.');
            $result = action('user/api/pwd', [$data, 0]);
            if ($result['code'] == 1) {
                session('user.pwd', pwd_md5($data['newpwd']));
                $this->success($result['msg']);
            } else {
                $this->error($result['msg']);
            }
        } else {
            return view('');
        }
    }

    /**
     * 修改资料
     */
    public function modify()
    {
        if (self::$sys['method'] == 'post') {
            $data = input('post.');
            model('user')->where($this->_where)->update($data);
            session('user', array_merge(session('user'), $data));
            $this->success('您的资料已更新');
        } else {
            return view();
        }
    }

    /*
     * 安全中心
     */
    function safe_center()
    {
        return view('', [
            'user' => U::get(session('user.id'))
        ]);
    }

    /*
     * 用户解绑手机号
     */
    function unbind_phone($phone = '')
    {
        $result = action('user/api/unbind_phone', [[
            'phone' => $phone,
        ], 0]);
        if ($result['code'] == 1) {
            $this->success($result['msg']);
        } else {
            $this->error($result['msg']);
        }
    }

    /*
     * 解绑邮箱
     */
    public function unbind_email($email = '')
    {
        $result = action('user/api/unbind_phone', [[
            'email' => $email,
        ], 0]);
        if ($result['code'] == 1) {
            $this->success($result['msg']);
        } else {
            $this->error($result['msg']);
        }
    }

    /*
     * 用户绑定手机号
     */
    function bind_phone($phone = '', $code = '')
    {
        $result = action('user/api/bind_phone', [[
            'phone' => $phone,
            'code' => $code
        ], 0]);
        if ($result['code'] == 1) {
            $this->success($result['msg']);
        } else {
            $this->error($result['msg']);
        }
    }



}
