<?php

namespace app\wechat\controller;

use EasyWeChat\Factory;

class Index extends Module
{
    protected $app;

    function initialize()
    {
        parent::initialize();
        $this->app = Factory::OfficialAccount($this->config['OfficialAccount']);
    }

    /**
     * js签名
     */
    function sign($url = '')
    {
        $js = $this->app->jssdk;
        if ($url) $js->setUrl($url);
        return ($js->buildConfig(array(), $debug = false, $beta = false, $json = true));
    }

    /**
     * 授权
     */
    function oauth()
    {
        $key = create_str();
        $url = 'https://open.weixin.qq.com/connect/oauth2/authorize?appid=' . config('')['wechat']['OfficialAccount']['app_id'] . '&redirect_uri=' . urlencode($this->request->domain() . '/wechat/index/oauth_callback') . '&response_type=code&scope=snsapi_userinfo&state=' . $key . '#wechat_redirect';
        if (!empty(input('param.url'))) {
            cache($key, ['url' => input('param.url')]);
        }
        Header("Location: $url");
        exit;
    }

    /**
     * 授权回调
     */
    function oauth_callback()
    {
        $param = input('param.');
        try {
            $oauth = $this->app->oauth;
            $user = $oauth->user()->toArray();
            if (!empty(cache($param['state'])['url'])) {
                $url = urldecode(cache($param['state'])['url']) . '?openid=' . $user['id'];
                cache($param['state'], null);
                Header("Location: $url");
                exit;
            }
        } catch (\Exception $e) {

        }
    }

}