<?php
/**
 * +------------------------------------------------------------
 * | 财务支付配置
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @docs: 具体配置信息请查阅 官网 > 文档 > 支付 章节。
 * +------------------------------------------------------------
 */


return [
    //支付宝
    'alipay' => [

        'app_id' => "",

        //商户私钥, 请把生成的私钥文件中字符串拷贝在此
        'private_key' => "",
        //支付宝公钥,查看地址：https://openhome.alipay.com/platform/keyManage.htm 对应APPID下的支付宝公钥。
        'ali_public_key' => "",

        'notify_url' => url('finance/alipay/notify', '', true, true),
        'return_url' => url('finance/alipay/return', '', true, true),

        'log' => [ // optional
            'file' => Env::get('runtime_path') . 'log/alipay.log',
            'level' => 'debug'
        ],
        'mode' => 'dev'
    ],
    //微信
    'wechat' => [
        'appid' => '', // APP APPID
        'app_id' => '', // 公众号 APPID
        'miniapp_id' => '', // 小程序 APPID
        'mch_id' => '',
        'key' => '',

        'notify_url' => url('finance/wechat/notify', '', true, true),
        'cert_client' => './cert/apiclient_cert.pem', // optional，退款等情况时用到
        'cert_key' => './cert/apiclient_key.pem',// optional，退款等情况时用到
        'log' => [ // optional
            'file' => Env::get('runtime_path') . 'log/wechat.log',
            'level' => 'debug'
        ],
        'mode' => '', // optional, dev/hk;当为 `hk` 时，为香港 gateway。
    ],
    //默认支付方式
    'offline' => [
        ['name' => '支付宝', 'url' => '/static/img/alipay.png'],
        ['name' => '微信', 'url' => '/static/img/wechat.png']
    ]
];
