-- --------------------------------------------------------
-- CIM城市信息聚合系统 0.6.1
--
-- MYSQL版本要求 >= 5.7
--
-- 感谢您关注CIM，获取更多信息请访问 http://cim.wandu.net
--
-- --------------------------------------------------------

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

--
-- Database: `cim`
-- Version: 0.6.0_180726
--

-- --------------------------------------------------------

--
-- 表的结构 `cim_admin`
--

CREATE TABLE `cim_admin` (
  `id` smallint(6) UNSIGNED NOT NULL,
  `role_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT '角色ID',
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '帐号',
  `pwd` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `title` varchar(10) NOT NULL DEFAULT '' COMMENT '姓名',
  `phone` varchar(20) NOT NULL DEFAULT '' COMMENT '电话',
  `qq` varchar(20) NOT NULL DEFAULT '' COMMENT 'qq',
  `email` varchar(50) NOT NULL DEFAULT '' COMMENT '邮箱',
  `memo` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `create_admin_id` smallint(5) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建者ID',
  `create_admin_name` varchar(20) NOT NULL DEFAULT '' COMMENT '创建者帐号',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间',
  `login_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '登录IP',
  `login_total` smallint(5) UNSIGNED NOT NULL DEFAULT '0' COMMENT '登录次数',
  `login_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '登录时间',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='管理员' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_admin_log`
--

CREATE TABLE `cim_admin_log` (
  `admin_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `action` varchar(20) NOT NULL DEFAULT '',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `os` varchar(20) NOT NULL DEFAULT '',
  `browser` varchar(50) NOT NULL DEFAULT '',
  `event` varchar(20) NOT NULL DEFAULT '',
  `memo` varchar(500) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='管理员日志' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_admin_role`
--

CREATE TABLE `cim_admin_role` (
  `id` tinyint(3) UNSIGNED NOT NULL,
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '角色类型',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '角色名称',
  `power` text NOT NULL COMMENT '角色权限',
  `memo` varchar(500) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '状态 0正常 1禁用'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='管理员角色' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_area`
--

CREATE TABLE `cim_area` (
  `id` smallint(6) UNSIGNED NOT NULL,
  `parent_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(20) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='地区' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_article`
--

CREATE TABLE `cim_article` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `author` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(80) NOT NULL DEFAULT '',
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据内容';

-- --------------------------------------------------------

--
-- 表的结构 `cim_block`
--

CREATE TABLE `cim_block` (
  `id` smallint(6) UNSIGNED NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(20) NOT NULL DEFAULT '' COMMENT '标识',
  `setting` text NOT NULL,
  `memo` varchar(255) NOT NULL DEFAULT '',
  `admin_id` varchar(255) NOT NULL DEFAULT '' COMMENT '具备权限的管理员，多个使用逗号分割',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `refresh_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区块' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_block_data`
--

CREATE TABLE `cim_block_data` (
  `id` int(11) UNSIGNED NOT NULL,
  `block_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `column_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `thumb` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `extend_fields` varchar(1000) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `end_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `list_order` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `delete_time` int(11) UNSIGNED NOT NULL DEFAULT  '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区块数据' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_column`
--

CREATE TABLE `cim_column` (
  `id` smallint(6) UNSIGNED NOT NULL,
  `parent_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `model` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(20) NOT NULL DEFAULT '',
  `key` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '外链URL',
  `setting` varchar(2000) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `list_order` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='栏目';

-- --------------------------------------------------------

--
-- 表的结构 `cim_column_fields`
--

CREATE TABLE `cim_column_fields` (
  `id` mediumint(8) UNSIGNED NOT NULL,
  `column_id` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(60) NOT NULL DEFAULT '',
  `key` varchar(20) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  `unit` varchar(32) NOT NULL DEFAULT '',
  `search` tinyint(1) NOT NULL DEFAULT '0',
  `list_order` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `list_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1列表显示，0不显示',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填，0否，1是'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='附加字段' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_comment`
--

CREATE TABLE `cim_comment` (
  `id` int(11) UNSIGNED NOT NULL,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户ID',
  `type` varchar(10) NOT NULL DEFAULT '' COMMENT '模块',
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '数据ID',
  `comment_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '评论ID',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '内容',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '发布时间',
  `at_uid` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '回复用户ID',
  `at_username` varchar(20) NOT NULL DEFAULT '' COMMENT '回复用户昵称',
  `reply_count` smallint(5) UNSIGNED NOT NULL DEFAULT '0' COMMENT '回复数',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态 0正常  1隐藏'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='评论' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_data`
--

CREATE TABLE `cim_data` (
  `id` int(11) UNSIGNED NOT NULL,
  `column_id` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `area_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `thumb` varchar(50) NOT NULL DEFAULT '',
  `hits` mediumint(9) UNSIGNED NOT NULL DEFAULT '0',
  `list_order` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `end_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `delete_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `fields` json DEFAULT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '' COMMENT 'ip',
  `port` varchar(6) NOT NULL DEFAULT '' COMMENT '端口',
  `os` varchar(20) NOT NULL DEFAULT '' COMMENT '来源',
  `behavior` json DEFAULT NULL COMMENT '行为'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据';

-- --------------------------------------------------------

--
-- 表的结构 `cim_data_behavior`
--

CREATE TABLE `cim_data_behavior` (
  `name` varchar(15) NOT NULL DEFAULT '' COMMENT '行为名称',
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '数据id',
  `extend` varchar(1000) NOT NULL DEFAULT '' COMMENT '扩展数据',
  `key` varchar(32) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `cim_data_image`
--

CREATE TABLE `cim_data_image` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(50) NOT NULL DEFAULT '',
  `intro` varchar(255) NOT NULL DEFAULT '',
  `list_order` smallint(5) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据图片' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_data_memo`
--

CREATE TABLE `cim_data_memo` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `memo` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据备注';

-- --------------------------------------------------------

--
-- 表的结构 `cim_data_text`
--

CREATE TABLE `cim_data_text` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `fields_id` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据扩展字段文本值';

-- --------------------------------------------------------

--
-- 表的结构 `cim_feedback`
--

CREATE TABLE `cim_feedback` (
  `id` smallint(6) UNSIGNED NOT NULL,
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `content` varchar(1000) NOT NULL DEFAULT '' COMMENT '反馈内容',
  `tags` varchar(50) NOT NULL DEFAULT '' COMMENT '标签',
  `linkway` varchar(30) NOT NULL DEFAULT '',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户id',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0待处理，1已查看，2已回复',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `cim_files`
--

CREATE TABLE `cim_files` (
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '路径',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '文件类型 0图片 1文件',
  `size` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '附件的大小',
  `ext` varchar(10) NOT NULL DEFAULT '' COMMENT '扩展名',
  `md5` varchar(32) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '附件添加时间',
  `extend` json DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='附件' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_info`
--

CREATE TABLE `cim_info` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `content` varchar(500) NOT NULL DEFAULT '',
  `linkman` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `qq` varchar(15) NOT NULL DEFAULT '',
  `phone` varchar(13) NOT NULL DEFAULT '',
  `phone_location` varchar(32) NOT NULL DEFAULT '',
  `address` varchar(255) NOT NULL DEFAULT '',
  `map` varchar(50) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `ip_location` varchar(32) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `top_type` tinyint(1) NOT NULL DEFAULT '0',
  `top_end_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `lat` varchar(10) NOT NULL DEFAULT '' COMMENT '纬度',
  `lon` varchar(10) NOT NULL DEFAULT '' COMMENT '经度'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='信息' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_keywords`
--

CREATE TABLE `cim_keywords` (
  `id` smallint(6) UNSIGNED NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='关键字' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_links`
--

CREATE TABLE `cim_links` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `url` varchar(100) NOT NULL DEFAULT '',
  `end_time` int(11) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='链接' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_message`
--

CREATE TABLE `cim_message` (
  `id` int(11) UNSIGNED NOT NULL,
  `content` varchar(100) NOT NULL DEFAULT '' COMMENT '消息内容',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '创建时间',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户id',
  `admin_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '管理员id',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未读，1已读',
  `extend` varchar(150) NOT NULL DEFAULT '',
  `module` varchar(15) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `cim_order`
--

CREATE TABLE `cim_order` (
  `id` varchar(32) NOT NULL COMMENT '系统订单',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户id',
  `balance` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0支出，1收入',
  `money` float(10,2) NOT NULL DEFAULT '0' COMMENT '金额',
  `memo` varchar(50) NOT NULL DEFAULT '' COMMENT '备注',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0，交易中，1交易完成，2交易失败',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '更新时间',
  `payment` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0系统总送，1积分，2余额，3微信，4支付宝',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0积分，1余额',
  `trade_no` varchar(32) NOT NULL DEFAULT '' COMMENT '第三方订单',
  `behavior` varchar(100) NOT NULL DEFAULT '' COMMENT '行为',
  `extend` varchar(200) NOT NULL DEFAULT '' COMMENT '附加数据'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `cim_order_log`
--

CREATE TABLE `cim_order_log` (
  `order_id` varchar(32) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `memo` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `cim_pages`
--

CREATE TABLE `cim_pages` (
  `column_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `content` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='页面' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_phone`
--

CREATE TABLE `cim_phone` (
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `intro` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='便民电话' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_report`
--

CREATE TABLE `cim_report` (
  `id` int(11) UNSIGNED NOT NULL,
  `column_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `data_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='举报' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_setting`
--

CREATE TABLE `cim_setting` (
  `id` varchar(20) NOT NULL COMMENT '缓存id',
  `value` varchar(2000) NOT NULL DEFAULT '' COMMENT '值',
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设置' ROW_FORMAT=COMPACT;

--
-- 转存表中的数据 `cim_setting`
--

INSERT INTO `cim_setting` (`id`, `value`, `update_time`) VALUES
('cim', '{\"name\":\"CIM\\u57ce\\u5e02\\u4fe1\\u606f\\u805a\\u5408\\u7cfb\\u7edf\",\"domain\":\"http:\\/\\/cim.demo.wandu.net\",\"mobile_domain\":\"\",\"title\":\"CIM\\u57ce\\u5e02\\u4fe1\\u606f\\u805a\\u5408\\u7cfb\\u7edf\",\"keywords\":\"cim,\\u5206\\u7c7b\\u4fe1\\u606f,\\u5357\\u9633,\\u5b9b\\u90fd\\u79d1\\u6280\",\"description\":\"CIM\\u57ce\\u5e02\\u4fe1\\u606f\\u805a\\u5408\\u7cfb\\u7edf\",\"close\":\"0\",\"close_tips\":\"\\u7f51\\u7ad9\\u5347\\u7ea7\\u4e2d\\uff0c\\u8bf7\\u7a0d\\u540e\\u8bbf\\u95ee\\u3002\",\"onlyarea\":\"\\u5185\\u7f51\",\"map\":{\"key\":\"\",\"zoom\":\"15\",\"city\":\"\"}}', 1532079645);

-- --------------------------------------------------------

--
-- 表的结构 `cim_temp`
--

CREATE TABLE `cim_temp` (
  `id` tinyint(3) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `cim_temp`
--

INSERT INTO `cim_temp` (`id`) VALUES
(0),
(1),
(2),
(3),
(4),
(5),
(6),
(7),
(8),
(9),
(10),
(11),
(12),
(13),
(14),
(15),
(16),
(17),
(18),
(19),
(20),
(21),
(22),
(23),
(24),
(25),
(26),
(27),
(28),
(29),
(30),
(31),
(32),
(33),
(34),
(35),
(36),
(37),
(38),
(39),
(40),
(41),
(42),
(43),
(44),
(45),
(46),
(47),
(48),
(49),
(50),
(51),
(52),
(53),
(54),
(55),
(56),
(57),
(58),
(59),
(60),
(61),
(62),
(63),
(64),
(65),
(66),
(67),
(68),
(69),
(70),
(71),
(72),
(73),
(74),
(75),
(76),
(77),
(78),
(79),
(80),
(81),
(82),
(83),
(84),
(85),
(86),
(87),
(88),
(89),
(90),
(91),
(92),
(93),
(94),
(95),
(96),
(97),
(98),
(99),
(100);

-- --------------------------------------------------------

--
-- 表的结构 `cim_user`
--

CREATE TABLE `cim_user` (
  `id` int(11) UNSIGNED NOT NULL,
  `group_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0' COMMENT '组id',
  `name` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `pwd` varchar(32) NOT NULL DEFAULT '',
  `qq` varchar(15) NOT NULL DEFAULT '',
  `phone` varchar(11) NOT NULL DEFAULT '',
  `address` varchar(100) NOT NULL DEFAULT '',
  `mappoint` varchar(50) NOT NULL DEFAULT '',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `credit` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `cim_user_group`
--

CREATE TABLE `cim_user_group` (
  `id` smallint(6) NOT NULL,
  `name` varchar(20) NOT NULL DEFAULT '',
  `setting` varchar(500) NOT NULL DEFAULT '',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0系统内置，1自定义',
  `memo` varchar(30) NOT NULL DEFAULT '' COMMENT '注释'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户组';

-- --------------------------------------------------------

--
-- 表的结构 `cim_user_log`
--

CREATE TABLE `cim_user_log` (
  `id` int(11) UNSIGNED NOT NULL,
  `user_id` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `action` varchar(20) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `port` varchar(6) NOT NULL DEFAULT '',
  `os` varchar(20) NOT NULL DEFAULT '',
  `browser` varchar(50) NOT NULL DEFAULT '',
  `event` varchar(20) NOT NULL DEFAULT '',
  `memo` varchar(500) NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户日志' ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- 表的结构 `cim_user_oauth`
--

CREATE TABLE `cim_user_oauth` (
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(32) NOT NULL DEFAULT '' COMMENT '凭证',
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '类型(1=微信 2=小程序)',
  `nickname` varchar(30) NOT NULL DEFAULT '' COMMENT '昵称'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `cim_words`
--

CREATE TABLE `cim_words` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `fields` varchar(200) NOT NULL DEFAULT '',
  `level` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='词库';

--
-- Indexes for dumped tables
--

--
-- Indexes for table `cim_admin`
--
ALTER TABLE `cim_admin`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_admin_log`
--
ALTER TABLE `cim_admin_log`
  ADD KEY `admin_id` (`admin_id`),
  ADD KEY `create_time` (`create_time`);

--
-- Indexes for table `cim_admin_role`
--
ALTER TABLE `cim_admin_role`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_area`
--
ALTER TABLE `cim_area`
  ADD PRIMARY KEY (`id`),
  ADD KEY `parent_id` (`parent_id`);

--
-- Indexes for table `cim_article`
--
ALTER TABLE `cim_article`
  ADD PRIMARY KEY (`data_id`);

--
-- Indexes for table `cim_block`
--
ALTER TABLE `cim_block`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_block_data`
--
ALTER TABLE `cim_block_data`
  ADD PRIMARY KEY (`id`),
  ADD KEY `column_id` (`column_id`),
  ADD KEY `block_id` (`block_id`);

--
-- Indexes for table `cim_column`
--
ALTER TABLE `cim_column`
  ADD PRIMARY KEY (`id`),
  ADD KEY `parent_id` (`parent_id`),
  ADD KEY `module` (`model`);

--
-- Indexes for table `cim_column_fields`
--
ALTER TABLE `cim_column_fields`
  ADD PRIMARY KEY (`id`),
  ADD KEY `catid` (`column_id`);

--
-- Indexes for table `cim_comment`
--
ALTER TABLE `cim_comment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `status` (`status`),
  ADD KEY `type` (`type`),
  ADD KEY `type_data_id` (`type`,`data_id`),
  ADD KEY `type_uid` (`type`,`user_id`),
  ADD KEY `user_id` (`user_id`) USING BTREE;

--
-- Indexes for table `cim_data`
--
ALTER TABLE `cim_data`
  ADD PRIMARY KEY (`id`),
  ADD KEY `column_id` (`column_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `area_id` (`area_id`),
  ADD KEY `update_time` (`update_time`);

--
-- Indexes for table `cim_data_behavior`
--
ALTER TABLE `cim_data_behavior`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `cim_data_image`
--
ALTER TABLE `cim_data_image`
  ADD KEY `id` (`data_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `cim_data_memo`
--
ALTER TABLE `cim_data_memo`
  ADD PRIMARY KEY (`data_id`);

--
-- Indexes for table `cim_data_text`
--
ALTER TABLE `cim_data_text`
  ADD PRIMARY KEY (`data_id`,`fields_id`),
  ADD KEY `id` (`data_id`);

--
-- Indexes for table `cim_feedback`
--
ALTER TABLE `cim_feedback`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_files`
--
ALTER TABLE `cim_files`
  ADD PRIMARY KEY (`path`);

--
-- Indexes for table `cim_info`
--
ALTER TABLE `cim_info`
  ADD PRIMARY KEY (`data_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `cim_keywords`
--
ALTER TABLE `cim_keywords`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_links`
--
ALTER TABLE `cim_links`
  ADD PRIMARY KEY (`data_id`);

--
-- Indexes for table `cim_message`
--
ALTER TABLE `cim_message`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_order`
--
ALTER TABLE `cim_order`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_pages`
--
ALTER TABLE `cim_pages`
  ADD PRIMARY KEY (`column_id`);

--
-- Indexes for table `cim_phone`
--
ALTER TABLE `cim_phone`
  ADD PRIMARY KEY (`data_id`),
  ADD KEY `phone` (`phone`) USING BTREE;

--
-- Indexes for table `cim_report`
--
ALTER TABLE `cim_report`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `data_id` (`data_id`),
  ADD KEY `type` (`type`),
  ADD KEY `column_id` (`column_id`);

--
-- Indexes for table `cim_setting`
--
ALTER TABLE `cim_setting`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_user`
--
ALTER TABLE `cim_user`
  ADD PRIMARY KEY (`id`),
  ADD KEY `group_id` (`group_id`);

--
-- Indexes for table `cim_user_group`
--
ALTER TABLE `cim_user_group`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_user_log`
--
ALTER TABLE `cim_user_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cim_words`
--
ALTER TABLE `cim_words`
  ADD PRIMARY KEY (`name`);

--
-- 在导出的表使用AUTO_INCREMENT
--

--
-- 使用表AUTO_INCREMENT `cim_admin`
--
ALTER TABLE `cim_admin`
  MODIFY `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_admin_role`
--
ALTER TABLE `cim_admin_role`
  MODIFY `id` tinyint(3) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_area`
--
ALTER TABLE `cim_area`
  MODIFY `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_block`
--
ALTER TABLE `cim_block`
  MODIFY `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_block_data`
--
ALTER TABLE `cim_block_data`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_column`
--
ALTER TABLE `cim_column`
  MODIFY `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_column_fields`
--
ALTER TABLE `cim_column_fields`
  MODIFY `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_comment`
--
ALTER TABLE `cim_comment`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_data`
--
ALTER TABLE `cim_data`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_feedback`
--
ALTER TABLE `cim_feedback`
  MODIFY `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_keywords`
--
ALTER TABLE `cim_keywords`
  MODIFY `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_message`
--
ALTER TABLE `cim_message`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_report`
--
ALTER TABLE `cim_report`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_user`
--
ALTER TABLE `cim_user`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `cim_user_log`
--
ALTER TABLE `cim_user_log`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;
COMMIT;
