<?php
/**
 * +------------------------------------------------------------
 * | 区块-接口 (block/controller/Api.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-19 17:40:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-07-14 18:02:58
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */


namespace app\Block\controller;

use app\common\controller\Init;


class Api extends Init
{

    /*
     * 加载区块数据
     */
    public function index($block_id = 0)
    {
        $block_id = input('?param.block_id') ? intval(input('param.block_id')) : $block_id;
        if (!$block_id) return json(['code' => 0, 'msg' => '数据加载失败']);
        $block = db('block')->where([(is_numeric($block_id) ? 'id' : 'key') => $block_id])->find();
        $block['setting'] = json_decode($block['setting'], true);
        $num = $block['setting']['display_number'];
        $num <= 0 && $num = 20;
        $where = ["d.block_id" => $block['id'], "d.status" => 1];
        $count = db('block_data')->alias('d')->where($where)->count();
        if (!$count) return json(['code' => 0, 'msg' => '数据加载失败']);
        $this->init_pager($count, $num);
        if (isset($block['setting']['link_fields'])) {
            $link_fields = 'l.' . join(', l.', array_keys($block['setting']['link_fields']));
            $_rs = db("block_data")->alias("d")->join("__" . strtoupper($block['module']) . "__ l", "d.id=l.id")->field("*, $link_fields ")->where($where)->order('d.add_time desc')->limit($num)->page($this->page)->select();
        } else {
            $_rs = db("block_data")->alias("d")->where($where)->limit($num)->order('d.add_time desc')->page($this->page)->select();
        }
        foreach ($_rs as $k => $v) {
            $_rs[$k]["extend_fields"] = json_decode($_rs[$k]["extend_fields"], true);
        }
        return json(['code' => 1, 'msg' => '数据加载成功', 'data' => $_rs]);
    }


    public function read($id = '')
    {
        if (!$id) return;
        $cache_id = 'block_id_' . $id;
        $rs = cache($cache_id);
        if (empty($rs)) {
            $block = db('block')->where([(is_numeric($id) ? 'id' : 'key') => $id, 'status' => 1])->find();
            if (empty($block)) return;
            //代码
            if ($block['type'] == 0) {
                $rs = $block;
                cache($cache_id, $block);
                $rs['setting'] = $this->display($rs['setting']);
            }
            //数据
            if ($block['type'] == 1) {
                $setting = json_decode($block['setting'], true);
                $where[] = ['block_id', '=', $block['id']];
                $where[] = ['status', '=', 1];
                $where[] = ['end_time', '>', time()];
                $rs = model('\app\block\model\Data')->where($where)->limit($setting['limit'])->select();
                foreach ($rs as $k => $v) {
                    $rs[$k] = [
                        'name' => $v['name'],
                        'thumb' => $v['thumb']['url'],
                        'url' => $v['url'],
                    ];
                }
                cache($cache_id, $rs, $setting['cache'] * 60);
            }
        } else {
            if (isset($rs['type']) && $rs['type'] == 0) $rs['setting'] = $this->display($rs['setting']);
        }
        return $rs;
    }

}