<?php
/**
 * +------------------------------------------------------------
 * | 管理中心 index/controller/Admin.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 11:32:24
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 11:32:24
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\cim\controller;

use app\index\model\Area;
use app\index\model\Words;
use think\Db;
use think\Hook;
use think\facade\Cache;

class Admin extends Module
{

    /**
     * 模块设置
     */
    public function setting($id = '')
    {
        if (!$id) $id = self::$sys['module'];
        if (request()->isPost()) {
            $data = input('post.');
            if (!empty($data)) {
                $where = ['id' => $id];
                $data = ['value' => json_encode($data), 'update_time' => time()];
                if (db('setting')->where($where)->count()) {
                    db('setting')->where($where)->update($data);
                } else {
                    $data['id'] = $id;
                    db('setting')->insert($data);
                }
                load_setting($id, 1);
            }
            return json(['code' => 1, 'msg' => '模块设置已更新']);
        } else {
            $data = load_setting($id);
            return json(['code' => 1, 'data' => $data]);
        }
    }



    /**
     * 缓存
     */
    public function cache($id = [], $tag = [], $remove = '')
    {
        if (!empty($id)) {
            if (is_string($id)) $id = [$id];
            if (in_array('temp', $id)) clear_file(\Env::get('runtime_path') . 'temp/');
            if (in_array('log', $id)) clear_file(\Env::get('runtime_path') . 'log/');
            if (in_array('columns', $id)) \load_columns(0, 1);
            action('admin/Api/log', ['清理缓存', join(',', $id)]);
            return json(['code' => 1, 'msg' => '所选缓存已刷新']);
        }
        if (!empty($tag)) {
            foreach ($tag as $k => $v) Cache::clear($v);
        }
        if ($remove) {
            action('admin/Api/log', ['清理缓存', '全部清除']);
            clear_file(\Env::get('runtime_path') . 'temp/');
            clear_file(\Env::get('runtime_path') . 'log/');
            Cache::clear();
            return json(['code' => 1, 'msg' => '全部缓存项已清理。']);
        }
    }

    /**
     * 词库
     */
    public function words($keyword = '', $limit = 20)
    {
        if (input('param.cache')) {
            load_words(1);
            return json(['code' => 1, 'msg' => '词库缓存已刷新']);
        }
        $where = [];
        if ($keyword) {
            $where [] = ['name', 'like', '%' . $keyword . '%'];
        }
        $data = Words::where($where)->paginate($limit)->toArray();
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 返回配置项
     */
    function configs()
    {
        return json(['code' => 1, 'data' => [
            'words' => config('app.words'),
            'cim' => config('')['cim']
        ]]);
    }

    /**
     * 词库表单
     * @return \think\response\Json
     */
    function words_form($name = '')
    {
        if (request()->isPost()) {
            $data = input('post.');
            $validate = validate('Words');
            if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
            $_model = new Words();
            $rs = $_model->where('name', '=', $data['name'])->find();
            if ($rs) {
                $_model->allowField(true)->save($data, ['name' => $data['name']]);
            } else {
                $_model->data($data)->allowField(true)->save();
            }
            load_words(1);
            return json(['code' => 1, 'msg' => '词库已更新']);
        }
        if ($name) {
            $rs = Words::where('name', '=', $name)->find();
            return json(['code' => 1, 'data' => $rs]);
        }
    }

    /**
     * 更新词库状态
     * @param array $name
     * @param int $status
     */
    public function words_status($name = [], $status = 0)
    {
        if (!empty($name)) {
            db('words')->where('name', 'in', (array)$name)->update(['status' => $status]);
            load_words(1);
            return json(['code' => 1, 'msg' => '更新成功']);
        }
        return json(['code' => 0, 'msg' => '参数错误']);
    }

    /**
     * 删除敏感词
     */
    function words_delete($name = [])
    {
        model('app\index\model\Words')->where('name', 'in', (array)$name)->delete();
        load_words(1);
        return json(['code' => 1, 'msg' => '敏感词删除成功']);
    }

    /**
     * 地区管理
     */
    public function area()
    {
        if (input('param.cache')) {
            load_areas(1, 1);
            return json(['code' => 1, 'msg' => '地区缓存已刷新']);
        }
        $data = model('app\index\model\Area')->order('parent_id asc')->select();
        if (!empty($data)) {
            $data = array_values(array_to_tree(array_column($data->toArray(), null, 'id')));
            foreach ($data as $k => $v) {
                if (!empty($v['child'])) $data[$k]['child'] = array_values($v['child']);
            }
        }
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 地区
     */
    function area_form($id = 0)
    {
        if (request()->isPost()) {
            $data = input('post.');
            $validate = validate('Area');
            if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
            $area = new Area();
            if ($id) {
                $area->allowField(true)->save($data, ['id' => $id]);
            } else {
                $area->data($data)->allowField(true)->save();
            }
            load_areas(1, 1);
            return json(['code' => 1, 'msg' => '地区信息已更新']);
        } else {
            if ($id) {
                return json(['code' => 1, 'data' => db('area')->where('id', '=', $id)->find()]);
            }
        }
    }

    /**
     *  地区状态
     * @param int $id
     * @return int
     */
    public function area_status($id = [], $status = 0)
    {
        if (!empty($id)) {
            db('area')->where('id', 'in', (array)$id)->update(['status' => $status]);
            load_areas(1, 1);
            return json(['code' => 1, 'msg' => '更新成功']);
        }
        return json(['code' => 0, 'msg' => '参数错误']);
    }

    /**
     * 删除地区
     */
    public function area_delete($id = [])
    {
        if (!empty($id)) {
            $count = db('area')->where('parent_id', 'in', (array)$id)->count();
            if (!$count) {
                db('area')->where('id', 'in', $id)->delete();
                load_areas(1, 1);
                return json(['code' => 1, 'msg' => '地区删除成功']);
            }
            return json(['code' => 0, 'msg' => '请先删除子级地区后重试...']);
        }
        return json(['code' => 0, 'msg' => '参数错误']);
    }

    /**
     * 导出词库
     */
    function export()
    {
        $file_name = '词库配置' . date('Y-m-d');
        $words = db('words')->select();
        if (!empty($words)) {
            $data = [];
            foreach ($words as $k => $v) {
                $data[$k] = [
                    'name' => $v['name'],
                    'fields' => $v['fields'] ?: ' ',
                    'status' => $v['status']
                ];
            }
            $this->save_excel($file_name, ['词', '操作行为', '状态（1：启用，0：禁用）'], $data);
        }
        return json(['code' => 0, 'msg' => '数据为空']);
    }

    /**
     * 导入词库
     */
    function import()
    {
        $files = request()->file();
        if (!empty($files)) {
            $fileinfo = $files['file']->getInfo();
            $result = $this->load_excel($fileinfo['tmp_name']);
            if (!empty($result)) {
                try {
                    $field = ['name', 'fields', 'status'];
                    foreach ($result as $k => $v) {
                        $words [] = array_combine($field, array_values($v));
                    }
                    if (!empty($words)) {
                        $name = array_column($words, 'name');
                        $exists = model('app\index\model\Words')->where('name', 'in', $name)->column('name');
                        if (!empty($exists)) {
                            foreach ($words as $k => $v) {
                                if (in_array($v['name'], $exists)) {
                                    $update[] = $v;
                                    unset($words[$k]);
                                }
                            }
                        }
                        model('app\index\model\Words')->insertAll($words);
                        if (!empty($update)) model('app\index\model\Words')->saveAll($update);
                        \load_words(1);
                    }
                } catch (\Exception $e) {
                    return json(['code' => 0, 'msg' => '文件格式错误，请检查后重试...']);
                }
                return json(['code' => 1, 'msg' => '词库导入成功']);
            }
        }
        return json(['code' => 0, 'msg' => '词库导入失败']);
    }

    /**
     * 空方法解析
     */
    public function _empty($name)
    {
        if (in_array($name, array('area_add', 'area_edit'))) {
            return $this->area_form(input('param.id'));
        }
        if (in_array($name, array('words_add', 'workds_edit'))) {
            return $this->words_form();
        }
        return parent::_empty($name);
    }

}
