<?php
/**
 * +------------------------------------------------------------
 * | 应用公共文件
 * +------------------------------------------------------------
 * | @author zhx (10630650@qq.com)
 * +------------------------------------------------------------
 * | @copyright CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @todo
 * +------------------------------------------------------------
 */

/**
 * 分析返回用户操作系统名称
 * @return string
 */
function get_client_os()
{
    $sys = $_SERVER['HTTP_USER_AGENT'];
    if (stripos($sys, "NT 6.1")) {
        $os = "Windows 7";
    } elseif (stripos($sys, "NT 6.0")) {
        $os = "Windows Vista";
    } elseif (stripos($sys, "NT 5.1")) {
        $os = "Windows XP";
    } elseif (stripos($sys, "NT 5.2")) {
        $os = "Windows Server 2003";
    } elseif (stripos($sys, "NT 5")) {
        $os = "Windows 2000";
    } elseif (stripos($sys, "NT 4.9")) {
        $os = "Windows ME";
    } elseif (stripos($sys, "NT 4")) {
        $os = "Windows NT 4.0";
    } elseif (stripos($sys, "98")) {
        $os = "Windows 98";
    } elseif (stripos($sys, "95")) {
        $os = "Windows 95";
    } elseif (stripos($sys, "NT 10")) {
        $os = "Windows 10";
    } elseif (stripos($sys, "Mac")) {
        $os = "Mac";
    } elseif (stripos($sys, "Linux")) {
        $os = "Linux";
    } elseif (stripos($sys, "Unix")) {
        $os = "Unix";
    } elseif (stripos($sys, "FreeBSD")) {
        $os = "FreeBSD";
    } elseif (stripos($sys, "SunOS")) {
        $os = "SunOS";
    } elseif (stripos($sys, "BeOS")) {
        $os = "BeOS";
    } elseif (stripos($sys, "OS/2")) {
        $os = "OS/2";
    } elseif (stripos($sys, "PC")) {
        $os = "Macintosh";
    } elseif (stripos($sys, "AIX")) {
        $os = "AIX";
    } else {
        $os = "unknown";
    }
    return $os;
}

/**
 * 分析返回用户网页浏览器名称
 * $return 浏览器类型
 */
function get_client_browser()
{
    $browser = $_SERVER['HTTP_USER_AGENT'];
    if (strpos(strtolower($browser), "netcaptor")) {
        $exp = "NetCaptor";
    } elseif (stripos(strtolower($browser), "firefox")) {
        preg_match("/Firefox\/([^;)]+)+/i", $browser, $b);
        $exp = "Mozilla Firefox " . $b[1];
    } elseif (stripos(strtolower($browser), "maxthon")) {
        preg_match("/MAXTHON\s+([^;)]+)+/i", $browser, $b);
        preg_match("/MSIE\s+([^;)]+)+/i", $agent, $ie);
        $exp = $b[0] . " (IE" . $ie[1] . ")";
    } elseif (stripos(strtolower($browser), "msie")) {
        preg_match("/MSIE\s+([^;)]+)+/i", $browser, $ie);
        $exp = "Internet Explorer " . $ie[1];
    } elseif (stripos(strtolower($browser), "netscape")) {
        $exp = "Netscape";
    } elseif (stripos(strtolower($browser), "opera")) {
        $exp = "Opera";
    } elseif (stripos(strtolower($browser), 'chrome')) {
        preg_match('/Chrome\/(\d+)\..*/i', $browser, $regs);
        $exp = 'Chrome ' . $regs[1];
    } else {
        $exp = 'unknown';
    }
    return $exp;
}

/**
 * 头像
 */
function avatar($id = '')
{
    if ($id) {
        $path = DS . 'uploads' . DS . 'user' . DS . 'avatar' . DS;
        $path .= ceil($id / 10000) . DS . $id . '.jpg';
        if (is_file(ROOT_PATH . 'public' . $path)) {
            echo $path;
            exit;
        }
    }
    echo '/static/img/user/avatar.gif';
}


/**
 * get_dir() 获取路径下的文件夹
 * @param string $path 路径
 * @return array
 */
function get_dir($path)
{
    $dir = [];
    if (!file_exists(realpath($path))) {
        return $dir;
    }
    $rs = scandir(realpath($path));
    if (!empty($rs)) {
        foreach ($rs as $v) {
            if ($v != "." && $v != ".." && is_dir($path . '/' . $v)) {
                array_push($dir, $v);
            }
        }
    }
    return $dir;
}

/**
 * 获取路径下的文件
 */
function get_files($path)
{
    $files = [];
    if (!file_exists(realpath($path))) {
        return $files;
    }
    $rs = scandir(realpath($path));
    if (!empty($rs)) {
        foreach ($rs as $v) {
            if ($v != "." && $v != ".." && is_file($path . '/' . $v)) {
                array_push($files, $v);
            }
        }
    }
    return $files;
}

/**
 * 提示消息
 * @param array $ops
 * $ops['status'] 状态，默认 success
 * 'message'='提示','success'='成功','error'='出错','warning'='警告','stop'='阻止','wait'='等待','question'='疑问'
 */
function msg($ops, $msg = '', $url = '', $time = 1)
{
    if (is_array($ops)) {
        if (isset($ops['status'])) {
            $status = $ops['status'];
        }
        if (isset($ops['msg'])) {
            $msg = $ops['msg'];
        }
        if (isset($ops['url'])) {
            $url = $ops['url'];
        }
        if (isset($ops['time'])) {
            $time = $ops['time'];
        }
    } else {
        $status = $ops;
    }
    if ($status == '') {
        $status = 'success';
    }
    if ($url == '' && in_array($status, ['message', 'success'])) {
        $url = (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '');
    }
    return view('common@:msg', [
        'status' => $status,
        'msg' => $msg,
        'url' => $url,
        'time' => $time
    ]);
}

/**
 * 通用方法 函数限制输出字符串的数目，该方法接收一个字符串作为第一个参数以及该字符串最大输出字符数作为第二个参数：以及最后一个参数为超出省略号
 * @param $str
 * @param int $limit
 * @param string $arg
 * @return string
 */
function str_limit($value, $limit = 100, $end = '...')
{
    $value = strip_tags($value);
    if (mb_strwidth($value, 'UTF-8') <= $limit) {
        return $value;
    }
    return rtrim(mb_strimwidth($value, 0, $limit, '', 'UTF-8')) . $end;
}


/**
 * 为数组树形排序
 * @param $data   数组
 * @param $parent 父级字段
 * @param $key    键名
 * @return array
 */
function array_to_tree($data, $parent = 'parent_id', $key = 'id')
{
    if (!is_array($data)) {
        return;
    }
    $result = array();
    //定义索引数组，用于记录节点在目标数组的位置
    $I = array();
    foreach ($data as $val) {
        if ($val[$parent] == 0) {
            $i = count($result);
            $result[$val[$key]] = $val;
            $I[$val[$key]] = &$result[$val[$key]];
        } else {
            $i = isset($I[$val[$parent]]['child']) ? count($I[$val[$parent]]['child']) : 0;
            $I[$val[$parent]]['child'][$val[$key]] = $val;
            $I[$val[$key]] = &$I[$val[$parent]]['child'][$val[$key]];
        }
    }
    return $result;
}


/**
 * 友好时间显示
 * 多久以前 / 以后
 */
function from_now($timestamp, $dateformat = 'Y年m月d日 H:i:s')
{
    if (is_string($timestamp)) $timestamp = strtotime($timestamp);
    $_now = time();
    $_time = abs($_now - $timestamp);
    $_end = ($timestamp > $_now ? '后' : '前');
    if ($_time < 60) {
        return $_time . '秒' . $_end;
    } elseif ($_time < 3600 && $_time > 60) {
        return intval($_time / 60) . '分钟' . $_end;
    } elseif ($_time < 86400 && $_time > 3600) {
        return intval($_time / 3600) . '小时' . $_end;
    } elseif ($_time < 604800 && $_time > 86400) {
        return intval($_time / 86400) . '天' . $_end;
    } elseif ($_time < 2592000 && $_time > 604800) {
        return intval($_time / 604800) . '周' . $_end;
    } elseif ($_time < 7776000 && $_time > 2592000) {
        return intval($_time / 2592000) . '个月' . $_end;
    } else {
        return date($dateformat, $timestamp);
    }
}


/**
 * response_code 输出函数
 * @param $errCode 错误码
 * @return void
 */
function response_code($errCode, $errMessage = '')
{
    $_httpCode = array(
        100 => 'Continue',
        101 => 'Switching Protocols',
        200 => 'OK',
        201 => 'Created',
        202 => 'Accepted',
        203 => 'Non-Authoritative Information',
        204 => 'No Content',
        205 => 'Reset Content',
        206 => 'Partial Content',
        300 => 'Multiple Choices',
        301 => 'Moved Permanently',
        302 => 'Found',
        303 => 'See Other',
        304 => 'Not Modified',
        305 => 'Use Proxy',
        307 => 'Temporary Redirect',
        400 => 'Bad Request',
        401 => 'Unauthorized',
        402 => 'Payment Required',
        403 => 'Forbidden',
        404 => 'Not Found',
        405 => 'Method Not Allowed',
        406 => 'Not Acceptable',
        407 => 'Proxy Authentication Required',
        408 => 'Request Timeout',
        409 => 'Conflict',
        410 => 'Gone',
        411 => 'Length Required',
        412 => 'Precondition Failed',
        413 => 'Request Entity Too Large',
        414 => 'Request-URI Too Long',
        415 => 'Unsupported Media Type',
        416 => 'Requested Range Not Satisfiable',
        417 => 'Expectation Failed',
        500 => 'Internal Server Error',
        501 => 'Not Implemented',
        502 => 'Bad Gateway',
        503 => 'Service Unavailable',
        504 => 'Gateway Timeout',
        505 => 'HTTP Version Not Supported'
    );

    // 清除输出缓存
    @ob_end_clean();

    if (array_key_exists($errCode, $_httpCode)) {
        $errMessage = $_httpCode[$errCode];
        @header("HTTP/1.1 {$errCode} {$errMessage}");
        @header("status: {$errCode} {$errMessage}");
    }
}

/**
 * 模板是否存在
 */
function template_exists($path)
{
    $path = config('template.view_base') . $path . '.' . config('template.view_suffix');
    if (is_file($path)) {
        return $path;
    }
}

/**
 * @param string $cache_id
 * 设置缓存数据
 */
function load_setting($cache_id = '', $refresh = 0)
{
    if (!$cache_id) return '';
    if ($refresh) cache($cache_id, null);
    $data = cache($cache_id);
    if (empty($data)) {
        $data = db('setting')->where('id', $cache_id)->find();
        if (!empty($data)) {
            $data = json_decode($data['value'], 1);
            cache($cache_id, $data);
        } else {
            $data = '';
        }
    }
    return $data;
}

/**
 * 获取栏目
 */
function load_columns($tree = 1, $refresh = 0, $key = '')
{
    $cache_id = 'columns';
    if ($refresh) cache($cache_id, null);
    $rs = cache($cache_id);
    if (empty($rs)) {
        $rs = model('\app\index\model\Column')->order('parent_id asc,list_order asc,id asc')->column('*', 'id');
        if (!empty($rs)) {
            cache($cache_id, $rs, 0);
        } else {
            $rs = [];
        }
    }
    foreach ($rs as $k => $v) {
        if ($v['key'] == '') $v['key'] = $k;
        $v['setting'] = json_decode($rs[$k]['setting'], true);
        $v['url'] = url('index/index/column', ['key' => $v['key']]);
        $rs[$k] = $v;
    }
    if ($key) $rs = array_column($rs, NULL, $key);
    return ($tree ? array_to_tree($rs) : $rs);
}

/**
 * 获取单个栏目
 */
function load_column($cid, $child = 0)
{
    if (is_numeric($cid)) {
        $columns = load_columns(0);
    } else {
        $columns = load_columns(0, 0, 'key');
    }
    if (isset($columns[$cid])) {
        $column = $columns[$cid];
        if ($column['parent_id'] > 0) {
            if (!is_numeric($cid)) $columns = array_column($columns, null, 'id');
            $column['parent'] = isset($columns[$column['parent_id']]) ? $columns[$column['parent_id']] : [];
        } else {
            if ($child) {
                $columns = load_columns(1, 0);
                if (!is_numeric($cid)) $columns = array_column($columns, null, 'key');
                $column['child'] = empty($columns[$cid]['child']) ? '' : $columns[$cid]['child'];
            }
        }
        return $column;
    }
}

/**
 * 获取地区
 */
function load_areas($tree = 1, $refresh = 0)
{
    $cache_id = 'areas';
    if ($refresh) cache($cache_id, null);
    $rs = cache($cache_id);
    if (empty($rs)) {
        $data = db('area')->field('id,name,parent_id')->where('status', 1)->order('id asc')->select();
        if (!empty($data)) {
            $rs = array_column($data, null, 'id');
            cache($cache_id, $rs, 0);
        }
    }
    if ($tree && !empty($rs)) {
        $rs = array_to_tree($rs);
    }
    return $rs;
}


/**
 * 格式化时间
 */
function time_format($val)
{
    if (is_string($val)) $val = strtotime($val);
    return [
        'ymd' => date("Y-m-d", $val),
        'md' => date("m-d", $val),
        'his' => date("H:i:s", $val),
        'full' => date("Y-m-d H:i:s", $val),
        'short' => date("m-d H:i", $val),
        'from_now' => from_now($val)
    ];
}


/**
 * 获取 IP  地理位置
 * 淘宝IP接口
 * @Return: array
 */
function get_ip_address($ip = '')
{
    if ($ip == '') {
        $ip = request()->ip();
    }
    $url = "http://ip.taobao.com/service/getIpInfo.php?ip=" . $ip;
    $ip = json_decode(file_get_contents($url));
    if ((string)$ip->code == '1') {
        return false;
    }
    $data = (array)$ip->data;
    return $data;
}

function get_token($data)
{
    //通过计算生成随机token
    $tmpStr = md5(date('YmdHis') . rand(10000, 99999));
    $data['time'] = time();
    cache($tmpStr, $data, 7200);
    return $tmpStr;
}

function create_str()
{
    return md5(microtime(true) . rand(10000, 99999));
}

/**
 * @删除文件夹
 */
function clear_file($path)
{
    if (!file_exists($path)) return;
    if (is_dir($path)) {
        $op = dir($path);
        while (false != ($item = $op->read())) {
            if ($item == '.' || $item == '..') continue;
            if (is_dir($op->path . '/' . $item)) {
                clear_file($op->path . '/' . $item);
                @rmdir($op->path . '/' . $item);
            } else {
                @unlink($op->path . '/' . $item);
            }
        }
        @rmdir($path);
    } else {
        @unlink($path);
    }
}

function load_words($refresh = 0, $key = '', $action = '')
{
    $cache_key = 'sys_words';
    if ($refresh) cache($cache_key, null);
    if (!empty(cache($cache_key))) {
        $rs = cache($cache_key);
    } else {
        $rs = db('words')->alias('w')->field('w.name,w.level,w.status,substring_index(substring_index(w.fields,\',\',b.id+1),\',\',-1) fields')->join('__TEMP__ b', 'b.id<(length(w.fields)-length(replace(w.fields,\',\',\'\'))+1)')->where('w.fields', 'neq', '')->where('w.status', '=', 1)->select();
        if (!empty($rs)) {
            cache($cache_key, $rs, 3600);
        }
    }
    if (!empty($rs) && !empty($key)) {
        $data = [];
        if (!$action) {
            $key = $action . '_' . $key;
        } else {
            $key = '_' . $key;
        }
        foreach ($rs as $k => $v) {
            if (strpos($v['fields'], $key)) {
                $data[] = $v;
            }
        }
        $rs = $data;
    }
    return $rs;
}

function filter_words($content = '', $behavior = '', $action = '')
{
    $result = [
        'content' => $content,
        'level' => 0,
        'words' => []
    ];
    if (!$content || !$behavior) return $result;
    $data = load_words(0, $behavior, $action);
    if (!empty($data)) {
        foreach ($data as $k => $v) $words[str_replace('_' . $behavior, '', $v['fields'])][] = $v['name'];
        foreach ($words as $k => $v) {
            switch ($k) {
                case 'forbid':
                    foreach ($v as $kk => $vv) {
                        if (strpos($content, $vv) !== false) {
                            if ($result['level'] < 3) $result['level'] = 3;
                            $result['words']['3'][] = $vv;
                        }
                    }
                    break;
                case 'check':
                    foreach ($v as $kk => $vv) {
                        if (strpos($content, $vv) !== false) {
                            if ($result['level'] < 2) $result['level'] = 2;
                            if (strpos($content, $vv) !== false) $result['words'][2][] = $vv;
                        }
                    }
                    break;
                case 'replace':
                    foreach ($v as $kk => $vv) {
                        if (strpos($content, $vv) !== false) {
                            if ($result['level'] < 1) $result['level'] = 1;
                            $result['words'][1][] = $vv;
                            $result['content'] = str_replace($vv, implode('', array_fill(0, strlen($vv), '*')), $content);
                        }
                    }
                    break;
            }
        }
    }
    return $result;
}

function object_to_array($data)
{
    $data = (array)$data;
    foreach ($data as $k => $v) {
        if (gettype($v) == 'resource') return;
        if (gettype($v) == 'object' || gettype($v) == 'array')
            $data[$k] = (array)object_to_array($v);
    }
    return $data;
}