<?php
/**
 * +------------------------------------------------------------
 * | 邮件类 (common/controller/Mail.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-07 15:55:08
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-07 15:55:08
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\common\controller;

use PHPMailer\PHPMailer\PHPMailer;

class Mail extends Init
{

    private $mail;

    protected function initialize()
    {
        parent::initialize();
        $config = config('')['mail'];
        $this->mail = new PHPMailer();
        //邮件调试模式
        $this->mail->SMTPDebug = 0;
        //设置邮件使用SMTP
        $this->mail->isSMTP();
        //邮件格式为HTML
        $this->mail->isHTML(true);
        // 设置邮件程序以使用SMTP
        $this->mail->Host = $config['host'];
        // 设置邮件内容的编码
        $this->mail->CharSet = 'UTF-8';
        // 启用SMTP验证
        $this->mail->SMTPAuth = true;
        // SMTP username
        $this->mail->Username = $config['username'];
        // SMTP password
        $this->mail->Password = $config['password'];
        // 启用TLS加密，`ssl`也被接受
        $this->mail->SMTPSecure = 'ssl';
        // 连接的TCP端口
        $this->mail->Port = $config['port'];
        //设置发件人
        $this->mail->setFrom($config['from'], 'cim');
        //收件人回复的邮箱
        $this->mail->addReplyTo($config['from'], 'cim');
    }

    //添加收件人
    public function address($data)
    {
        if (is_string($data)) {
            $this->mail->addAddress($data);
            $this->email = $data;
        }
        if (is_array($data)) {
            foreach ($data as $k => $v) {
                $this->mail->addAddress($v, $k);
            }
        }
        return $this;
    }

    public function type($type, $data = '')
    {
        $data = $this->$type($data);
        $this->body = $this->fetch('mail@/' . $type, $data);
        return $this;
    }

    public function send()
    {
        //实例化
        try {
            $this->mail->Subject = $this->subject;
            $this->mail->Body = $this->body;
            $result = $this->mail->send();
            if ($result) {
                return ['code' => 1, 'msg' => '邮件发送成功'];
            } else {
                return ['code' => 0, 'msg' => 'Mailer Error: ' . $this->mail->ErrorInfo];
            }
        } catch (Exception $e) {
            return ['code' => 0, 'msg' => 'Mailer Error: ' . $this->mail->ErrorInfo];
        }
    }

    /**
     * 验证码类邮件
     */
    function code()
    {
        $data = [
            'code' => rand(100000, 999999)
        ];
        $this->subject = empty(self::$cim['name']) ? '' : self::$cim['name'] . '验证码';
        cache($this->email, $data['code']);
        return $data;
    }

    /**
     * 链接类邮件
     */
    function url()
    {
        $token = encrypt((string)session('user.id')) . '-' . encrypt($this->email) . '-' . time();
        $data = [
            'content' => '请点击以下链接进行邮箱验证，邮件验证成功后您可以通过邮箱找回密码并登录网站会员：' . $this->request->domain() . '/user/index/verify_email?token=' . $token
        ];
        $this->subject = empty(self::$cim['name']) ? '' : self::$cim['name'] . '绑定邮箱';
        cache($this->email, ['time' => time()], 180);
        return $data;
    }

    /**
     * 反馈回复
     */
    function reply($data = '')
    {
        $this->subject = '反馈回复';
        return $data;
    }

}