<?php
/**
 * Created by PhpStorm.
 * User: baishuhao
 * Date: 2018/4/19
 * Time: 11:40
 */

namespace app\common\controller;

use Overtrue\EasySms\EasySms;

class Sms extends Init
{
    private $sms;
    private $template;
    private $data;
    private $phone;
    private $content;
    private $gateways;

    function initialize()
    {
        parent::initialize();
        $this->config = config('')['sms'];
        $this->sms = new EasySms($this->config);
    }

    /**
     * 设置短信类型
     * 根据类型获得模板id
     * SMS_1，短信
     */
    function type($type)
    {
        $types = explode('_', $type);
        $this->template = $this->config[$types[0]][$this->config['default']['gateways'][0]];
        $this->$type();
        return $this;
    }

    /**
     * 设置短信内容
     * @param $content
     * @return $this
     */
    function content($content)
    {
        $this->content = $content;
        return $this;
    }

    /**
     * 设置接受短信手机号
     * @param $data
     * @return $this
     */
    function phone($data)
    {
        $this->phone = $data;
        return $this;
    }

    /**
     * 设置网关
     * @param $data
     */
    function gateways($data)
    {
        if (is_array($data)) {
            $this->gateways = $data;
        }
        return $this;
    }

    /**
     * 设置验证码
     */
    function verify($verify)
    {
        $this->verify = $verify;
        return $this;
    }

    /**
     * 发送短信
     * @return mixed
     */
    function send()
    {
        if ((!empty($this->verify) && captcha_check($this->verify))) {
            $ip_key = self::$sys['ip'] . '_phone_verify';
            $cache = cache($ip_key);
            if (empty($cache) || in_array($this->phone, $cache['phone']) || count($cache['phone']) < 3 || time() > $cache['time'] + 86400) {
                $phone_key = $this->phone . '_phone_verify';
                if (empty(cache($phone_key)) || cache($phone_key)['time'] + 180 < time()) {
                    if (!empty($this->data) && !empty($this->template)) {
                        if (!empty($this->phone) && $this->validate(['phone' => $this->phone], ['phone' => 'mobile']) == true) {
                            $this->result = $this->sms->send($this->phone, [
                                'content' => $this->content,
                                'template' => $this->template,
                                'data' => $this->data
                            ], $this->gateways);
                            if (empty($cache) || time() > $cache['time'] + 86400) {
                                $cache = [
                                    'phone' => [
                                        $this->phone
                                    ],
                                    'time' => time()
                                ];
                            } else {
                                if (!in_array($this->phone, $cache['phone'])) {
                                    $cache['phone'][] = $this->phone;
                                }
                            }
                            cache($phone_key, ['time' => time()]);
                            cache($ip_key, $cache);
                            $r = array('code' => '1', 'msg' => '验证码发送成功');
                        } else {
                            $r = array('code' => '0', 'msg' => '不存在的手机号');
                        }
                    } else {
                        $r = array('code' => -1, 'msg' => '参数错误，不存在模板id或者模板value!');
                    }
                } else {
                    $r = array('code' => 0, 'msg' => '短信已发送，请注意查收....');
                }
            } else {
                $r = array('code' => 0, 'msg' => '操作过于频繁，请稍后重试....');
            }
        } else {
            $r = array('code' => 0, 'msg' => '验证码错误');
        }
        return $r;
    }

    /**
     * 验证码类短信
     */
    function SMS_1()
    {
        $code = rand(100000, 999999);
        $data = [
            'code' => $code
        ];
        $this->data = $data;
        $data['time'] = time();
        cache($this->phone, $data, 180);
    }

    /**
     * 忘记密码
     */
    function SMS_2()
    {
        $code = rand(100000, 999999);
        $data = [
            'code' => $code
        ];
        $this->data = $data;
        session('forget', ['code' => $code, 'time' => time(), 'phone' => $this->phone]);
    }

}