<?php
/**
 * +------------------------------------------------------------
 * | 数据-接口 (index/controller/Api.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 22:56:48
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 22:56:48
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\controller;

use think\facade\Hook;
use app\common\controller\Qrcode;
use app\index\model\Data;
use think\Db;
use app\common\controller\Redpacket as Packet;

class Api extends Module
{

    public function phone_image($id)
    {
        $rs = model('info')->where('data_id', $id)->value('phone');
        if (empty($rs)) return;
        $width = strlen($rs) * 15;
        $height = 30;
        $font = \Env::get('app_path') . 'phone.ttf';
        $im = @imagecreate($width, $height) or die("Cannot Initialize new GD image stream");
        $background_color = imagecolorallocate($im, 255, 255, 255);
        $grey = imagecolorallocate($im, 128, 128, 128);
        $text_color = imagecolorallocate($im, mt_rand(0, 200), mt_rand(0, 120), mt_rand(0, 120));
        // 画干扰线     
        for ($i = 0; $i < 5; $i++) {
            $font_color = imagecolorallocate($im, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
            imagearc($im, mt_rand(-$width, $width), mt_rand(-$height, $height), mt_rand(30, $width * 2), mt_rand(20, $height * 2), mt_rand(0, 360), mt_rand(0, 360), $font_color);
        }
        // 画干扰点     
        for ($i = 0; $i < 50; $i++) {
            $font_color = imagecolorallocate($im, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
            imagesetpixel($im, mt_rand(0, $width), mt_rand(0, $height), $font_color);
        }
        imagettftext($im, 16, 0, 5, 21, $grey, $font, $rs);
        imagettftext($im, 16, 0, 5, 21, $text_color, $font, $rs);
        ob_start();
        imagepng($im);
        $content = ob_get_clean();
        imagedestroy($im);

        return response($content, 200, ['Content-Length' => strlen($content)])->contentType('image/png');
    }

    /**
     * 读取
     */
    public function read($attr = [])
    {
        is_string($attr) && $attr = \json_decode($attr, true);
        if (!isset($attr['id']) && isset($attr['cid'])) {
            $column = load_column($attr['cid']);
            if (empty($column)) return;
            $attr['cid'] = $column['id'];
            $attr['key'] = $column['key'];
        }
        //移动端信息模型排序
        if (((isset($attr['model']) && $attr['model'] == 'info') || (!empty($column) && $column['model'] == 'info'))) {
            $filter = $this->filters($attr);
            isset($filter['order']) && $attr['order'] = $filter['order'];
            isset($filter['where']) && $attr['where'] = $filter['where'];
        }
        if (isset($attr['top'])) {
            $attr['model'] = 'info';
            $attr['where'][] = ['top_end_time', '>', time()];
        }
        if ((isset($attr['id']) || isset($attr['cid']))) $this->check_login();
        $rs = $this->query($attr);
        if (!empty($rs)) $rs = $this->_init_mobile_data($rs);
        if (isset($attr['id']) && isset($attr['share_key']) && isset($attr['user_id'])) {
            $this->share_redpacket($attr, $rs);
        }
        return json($rs);
    }

    /**
     * 处理分享红包
     */
    function share_redpacket($attr, $rs)
    {
        //分享红包行为处理
        $behavior = db('data_behavior')->where('key', '=', $attr['share_key'])->find();
        if (!empty($behavior)) {
            $extend = json_decode($behavior['extend'], 1);
            if ($extend[0]['type']) {
                //随机红包
                $extend[0]['rand'] = array_values($extend[0]['rand']);
                if (empty($extend[0]['rand'][0])) return '';
                $money = $extend[0]['rand'][0];
            } else {
                //等额红包
                $money = $extend[0]['money'] / $extend[0]['num'];
            }
            if ($extend[0]['balance'] > 0 && $extend[0]['balance'] >= $money) {
                $where = [
                    ['ip', '=', self::$sys['ip']],
                    ['memo', '=', $attr['id'] . '+' . $attr['share_key']]
                ];
                $log = db('user_log')->where($where)->find();
                if (empty($log)) {
                    //增加分享人余额
                    $order = action('finance/api/order', [
                        [
                            'payment' => 4,
                            'money' => $money,
                            'balance' => 1,
                            'type' => 1,
                            'memo' => '分享红包获得余额',
                            'user_id' => $attr['user_id'],
                            'extend' => [
                                'key' => $attr['share_key']
                            ]
                        ], 0]);
                    if ($order['code'] == 1) action('finance/api/pay', [['order' => $order['order']]]);
                    //减少红包余额
                    $extend[0]['balance'] -= $money;
                    //随机红包，删除红包队列
                    if ($extend[0]['type'] == 1) {
                        unset($extend[0]['rand'][0]);
                        if (empty($extend[0]['rand'])) unset($extend[0]['rand']);
                    }
                    db('data_behavior')->where('key', '=', $attr['share_key'])->update(['extend' => json_encode($extend)]);
                    if ($extend[0]['balance'] == 0) {
                        if (!empty($rs['behavior'])) {
                            $data_behavior = '';
                            foreach ($rs['behavior'] as $k => $v) {
                                if ($v['key'] != $attr['share_key']) $data_behavior[] = $v;
                            }
                            db('data')->where('id', '=', $attr['id'])->update(['behavior' => empty($data_behavior) ? '' : json_encode($data_behavior)]);
                        }
                    }
                    //增加日志记录
                    action('user/api/log', ['分享红包', $attr['id'] . '+' . $attr['share_key'], $attr['user_id']]);
                }
            }
        }
    }

    /**
     * 发布
     */
    public function add($id = 0)
    {
        if (!empty(self::$column)) {
            if (self::$column['setting']['group'][self::$user['group_id']]['add_limit'] < 0) {
                $this->error('您暂时不能在《' . self::$column['name'] . '》发布信息。');
            }
        }
        if (request()->isPost()) {
            $data = request()->except(['create_time', 'update_time']);
            if (!$id) $data['id'] = 0;
            $rs = $this->_add($data);
            return json($rs);
        } else {
            $rs['step'] = 1;
            if (!empty(self::$column)) {
                if (input('param.id')) {
                    $rs['step'] = 3;
                } else {
                    $rs['step'] = 2;
                    if (isset(self::$column['setting']['group'][self::$user['group_id']]['upload_limit'])) {
                        $rs['upload_limit'] = self::$column['setting']['group'][self::$user['group_id']]['upload_limit'];
                    } else {
                        $rs['upload_limit'] = 3;
                    }
                    $rs['fields'] = $this->load_fields(self::$column['id']);
                }
                if (self::$column['model'] == 'info') $rs['areas'] = \load_areas();
            }
            $rs['columns'] = action('api/columns', ['use' => 'form', 'return' => 0]);
            return json($rs);
        }
    }

    /**
     * 栏目
     */
    public function columns($tree = 0, $refresh = 0, $key = 'key', $id = '', $use = '', $return = 1, $child = 0)
    {
        if ($use == 'form') {
            $rs = $this->allow_post_columns();
        } else {
            if ($id) {
                $rs = load_column($id, $child);
            } else {
                $rs = \load_columns($tree, $refresh, $key);
            }
        }
        if ($return) {
            return $id ? json($rs) : json(array_values($rs));
        } else {
            return $rs;
        }
    }


    public function hits($id)
    {
        db('data')->where('id', $id)->setInc('hits', 1);
        return db('data')->where('id', $id)->value('hits');
    }

    /**
     * 举报
     */
    public function report()
    {
        if (request()->isPost()) {
            $data = input('post.');
            $result = $this->validate($data, 'app\index\validate\Report');
            if (true !== $result) {
                return $this->error($result);
            }
            if (!empty(self::$user['id'])) {
                $data['user_id'] = self::$user['id'];
                //action('user/api/log', [$this->_module['report_type'][$data['module']] . '举报', '举报']);
            }
            $data['ip'] = self::$sys['ip'];
            model('report')->allowField(true)->save($data);
            $info = model('app\index\model\Data')->get($data['data_id']);
            $attr = [
                'content' => '用户举报信息【' . $info['name'] . '】:' . config('app.report')[$data['type']],
                'extend' => $data,
                'admin_id' => 1
            ];
            action('message/api/send', [$attr]);
            return json(['code' => 1]);
        } else {
            return json(['code' => 0]);
        }
    }

    /**
     * 初始化移动端数据
     */
    function _init_mobile_data($rs)
    {
        //详情
        if (isset($rs['id'])) {
            //兼容小程序0.1，稍后删除
            $rs['values'] = $this->_init_fields($rs['fields'], $this->load_fields($rs['column_id']));
            $rs['fields'] = $this->_init_fields($rs['fields'], $this->load_fields($rs['column_id']));
            $rs['hits'] = $this->hits($rs['id']);
            if (isset($rs['area_id'])) $rs['area'] = empty(self::$areas[$rs['area_id']]) ? '' : self::$areas[$rs['area_id']];
            if (!empty($rs['behavior'])) $rs['behavior'] = json_decode($rs['behavior'], 1);
            return $rs;
        }
        //列表
        $data = isset($rs['total']) ? $rs['data'] : $rs;
        foreach ($data as $k => &$v) {
            $v['thumb'] = action('files/api/_init_thumb', [$v['thumb']]);
            $v['column'] = self::$columns[$v['column_id']];
            if (isset($v['area_id'])) $v['area'] = empty(self::$areas[$v['area_id']]) ? '' : self::$areas[$v['area_id']];
            if (!empty($v['fields'])) $v['fields'] = $this->_init_fields($v['fields'], $this->load_fields($v['column_id'], 0, 1));
            if (!empty($v['behavior'])) $v['behavior'] = json_decode($v['behavior'], 1);
        }
        isset($rs['total']) ? $rs['data'] = $data : $rs = $data;
        return $rs;
    }


    private function allow_post_columns()
    {
        $data = [];
        foreach (self::$columns as $k => $v) {
            if (!in_array($v['model'], ['article', 'info', 'phone'])) continue;
            if (isset($v['setting']['group'][self::$user['group_id']]) && $v['setting']['group'][self::$user['group_id']]['add_limit'] > -1) $data[$k] = $v;
        }
        return array_to_tree($data);
    }

    /**
     * 提交反馈信息
     */
    function feedback_form()
    {
        if (request()->isPost()) {
            $data = input('post.');
            if (!self::$sys['is_mobile']) {
                if (empty($data['captcha']) || !captcha_check($data['captcha'])) return json(['code' => 0, 'msg' => '验证码错误']);
            }
            $result = $this->validate($data, [
                'title' => 'require',
                'content' => 'require'
            ], [
                'title.require' => '反馈标题不能为空',
                'content.require' => '反馈内容不能为空'
            ]);
            if ($result !== true) return json(['code' => 0, 'msg' => '反馈内容不能为空']);
            if (session('user . id')) {
                $data['user_id'] = session('user.id');
            } else {
                if (!empty($data['linkway'])) {
                    $user_id = model('app\user\model\User')->where('phone|email', '=', $data['linkway'])->value('id');
                    if ($user_id) $data['user_id'] = $user_id;
                }
            }
            $id = model('app\index\model\Feedback')->data($data)->allowField(true)->save();
            $message = [
                'content' => "收到用户反馈的问题:" . $data['title'],
                'admin_id' => 1,
                'extend' => [
                    'id' => $id,
                    'action' => 'feedback'
                ]
            ];
            action('message/api/send', [$message]);
            return json(['code' => 1, 'msg' => '保存成功，感谢您的反馈...']);
        }
    }

    /**
     * 关闭信息
     */
    function close($id = 0, $key = '')
    {
        $data = Data::get($id);
        if ($this->check_power($data, $key)) {
            db('data')->where('id', $id)->update(['status' => 4]);
        }
        return json(['code' => 1, 'msg' => '关闭成功']);
    }

    /**
     * 刷新
     */
    public function refresh($id = 0, $payment = '', $return = 1, $currency = '')
    {
        $credit = empty(self::$column['setting']['group'][self::$user['group_id']]['refresh_credit']) ? 0 : self::$column['setting']['group'][self::$user['group_id']]['refresh_credit'];
        $money = empty(self::$column['setting']['group'][self::$user['group_id']]['refresh_money']) ? 0 : self::$column['setting']['group'][self::$user['group_id']]['refresh_money'];
        //线上支付
        if (in_array($payment, [2, 3])) {
            //创建置顶订单
            $order = [
                'payment' => $payment,
                'money' => $money,
                'balance' => 0,
                'type' => 1,
                'behavior' => 'refresh',
                'extend' => [
                    'id' => $id,
                ]
            ];
            $order = action('finance/api/order', [$order, 0]);
            if ($order['code'] == 1) {
                $result = ['code' => 2, 'msg' => '订单创建成功', 'order' => $order['order']];
            } else {
                $result = ['code' => 0, 'msg' => '订单创建失败，请重试'];
            }
        } else {
            //账号支付
            Db::startTrans();
            $result = $this->handle_info('refresh', $money, $credit, '', $currency);
            if ($result['code'] == 1 && Db::name('data')->where('id', $id)->update(['update_time' => time()])) {
                Db::commit();
                $result = ['code' => 1, 'msg' => '刷新成功'];
            } else {
                Db::rollback();
                $result = ['code' => 0, 'msg' => $result['msg']];
            }
        }
        return $return ? json($result) : $result;
    }

    /**
     * 置顶
     */
    function top($id = 0, $days = 0, $payment = '', $return = 1, $currency = '')
    {
        if (!is_numeric($days) || $days <= 0) {
            $result = ['code' => 0, 'msg' => '置顶天数必须大于0'];
        } else {
            if (empty(self::$column)) return json(['code' => 0, 'msg' => '获取信息失败']);
            $credit = intval(self::$column['setting']['group'][self::$user['group_id']]['top_credit']) * $days;
            $money = intval(self::$column['setting']['group'][self::$user['group_id']]['top_money']) * $days;
            //线上支付
            if (in_array($payment, [2, 3])) {
                //创建置顶订单
                $order = [
                    'payment' => $payment,
                    'money' => $money,
                    'balance' => 0,
                    'type' => 1,
                    'behavior' => 'top',
                    'extend' => [
                        'id' => $id,
                        'days' => $days
                    ]
                ];
                $order = action('finance/api/order', [$order, 0]);
                if ($order['code'] == 1) {
                    $result = ['code' => 2, 'msg' => '订单创建成功', 'order' => $order['order']];
                } else {
                    $result = ['code' => 0, 'msg' => $order['msg']];
                }
            } else {
                //账号支付
                Db::startTrans();
                $result = $this->handle_info('top', $money, $credit, '', $currency);
                if ($result['code']) {
                    $info = Db::name('info')->where('data_id', $id)->find();
                    if (!empty($info)) {
                        $top_end_time = $info['top_end_time'];
                        if ($top_end_time < time()) $top_end_time = time();
                        $data['top_end_time'] = $top_end_time + $days * 86400;
                        $rs = Db::name('info')->where('data_id', $id)->update($data);
                        if ($rs) $top_end_status = 1;
                    }
                    if (!empty($top_end_status)) {
                        Db::commit();
                        $result = ['code' => 1, 'msg' => '置顶成功'];
                    } else {
                        Db::rollback();
                        $result = ['code' => 0, 'msg' => '置顶失败'];
                    }
                } else {
                    Db::rollback();
                    $result = ['code' => 0, 'msg' => $result['msg']];
                }
            }
        }
        return $return ? json($result) : $result;
    }


    /**
     * 信息加红包
     */
    function redpacket($id = 0, $money = 0, $num = 0, $payment = '', $type = '', $return = 1)
    {
        if (is_numeric($money) && $money > 0) {
            if (!$id || !$num || $type == '') return json(['code' => 0, 'msg' => '请设置红包数量和红包类型']);
            if (in_array($payment, [2, 3])) {
                $redpacket = new Packet(['money' => $money, 'num' => $num]);
                if (!$redpacket->isCanBuilder()) return json(['code' => 0, 'msg' => '红包均值小于0.01']);
                //创建置顶订单
                $order = [
                    'payment' => $payment,
                    'money' => $money,
                    'balance' => 0,
                    'type' => 1,
                    'behavior' => 'redpacket',
                    'extend' => [
                        'id' => $id,
                        'num' => $num,
                        'type' => $type
                    ]
                ];
                $order = action('finance/api/order', [$order, 0]);
                if ($order['code'] == 1) {
                    $result = ['code' => 2, 'msg' => '订单创建成功', 'order' => $order['order']];
                } else {
                    $result = ['code' => 0, 'msg' => $order['msg']];
                }
            } else {
                Db::startTrans();
                try {
                    $result = $this->handle_info('redpacket', $money, 0, '', 1);
                    if ($result['code']) {
                        //执行红包行为
                        Hook::exec('app\\index\\behavior\\Redpacket', [
                            'id' => $id,
                            'num' => $num,
                            'type' => $type,
                            'money' => $money
                        ]);
                        Db::commit();
                    } else {
                        Db::rollback();
                        $result = ['code' => 0, 'msg' => $result['msg']];
                    }
                } catch (\Exception $e) {
                    Db::rollback();
                    $result = ['code' => 0, 'msg' => $e->getMessage()];
                }
            }
        } else {
            $result = ['code' => 0, 'msg' => '金额必须大于0'];
        }
        return $return ? json($result) : $result;
    }


    /**
     * 信息操作，置顶，刷新,发红包账号支付
     */
    public function handle_info($action = '', $money = 0, $credit = 0, $msg = '', $currency)
    {
        if (empty(self::$user['id'])) return ['code' => 1000, 'msg' => '请登录'];
        if ($currency == '') return ['code' => 0, 'msg' => '请选择支付货币'];
        $status = 1;
        $config = [
            'top' => ['message' => '信息置顶', 'msg' => '置顶成功'],
            'refresh' => ['message' => '信息刷新', 'msg' => '刷新成功'],
            'redpacket' => ['message' => '发红包', 'msg' => '操作成功'],
        ];
        $message = $config[$action]['message'];
        $msg = $config[$action]['msg'];
        if ($currency == 0) {
            if (empty($credit) || self::$user['credit'] < $credit) return ['code' => 0, 'msg' => '积分不足'];
            $attr = [
                'balance' => 0,
                'money' => $credit,
                'user_id' => self::$user['id'],
                'payment' => 0,
                'type' => 0,
                'memo' => $message . '扣除【' . $credit . '】积分'
            ];
            $result = action('finance/api/credit', [$attr, 0]);
            if ($result['code'] == 0) {
                $status = 0;
                $msg = $result['msg'];
            }
        } else if ($currency == 1) {
            if (empty($money) || self::$user['money'] < $money) return ['code' => 0, 'msg' => '余额不足'];
            $attr = [
                'balance' => 0,
                'money' => $money,
                'user_id' => self::$user['id'],
                'payment' => 1,
                'type' => 1,
                'memo' => $message . '扣除【' . $money . '】余额'
            ];
            $result = action('finance/api/money', [$attr, 0]);
            if ($result['code'] == 0) {
                $status = 0;
                $msg = $result['msg'];
            }
        } else {
            return ['code' => 0, 'msg' => '非法参数'];
        }
        return ['code' => $status, 'msg' => $msg];
    }

    /**
     * 个人发布信息
     */
    function user_data($cid = 0, $return = 1, $user_id = 0)
    {
        if (empty(self::$user['id']) && empty($user_id)) return json(['code' => 1000, 'msg' => '请登录...']);
        $user_id = $user_id ?: self::$user['id'];
        $where[] = ['user_id', '=', $user_id];
        if ($cid) $where[] = ['column_id', '=', $cid];
        $rs = model('data')->where($where)->where('status', '<', 4)->order('create_time desc, status desc')->paginate(20)->toArray();
        $rs['data'] = $this->_init_user_data($rs['data']);
        return $return ? json($rs) : $rs;
    }

    /**
     * 检测区域是否允许发布
     * @return int
     */
    function allow_area()
    {
        $status = 0;
        $ip_info = get_ip_address();
        if (!empty($ip_info)) {
            if (!empty(self::$cim['onlyarea'])) {
                $allow_area = explode(',', self::$cim['onlyarea']);
                $area_str = $ip_info['region'] . '省' . $ip_info['city'] . '市' . $ip_info['county'] . '县';
                foreach ($allow_area as $k => $v) {
                    if (strpos($area_str, $v) !== false) {
                        $status = 1;
                        break;
                    }
                }
            }
        }
        return $status;
    }

    /**
     * 数据行为详情
     */
    function view_behavior($key = '', $cid = 0, $id = 0)
    {
        if ($key && $cid && $id) {
            $data = db('data_behavior')->where('key', '=', $key)->find();
            if (empty($data)) return '';
            $data = array_merge($data, json_decode($data['extend'], 1)[0]);
            $data['count'] = 0;
            if ($data['name'] == 'share_redpacket') {
                //红包获得历史
                $data['history'] = db('order')
                    ->alias('o')
                    ->join('__USER__ u', 'u.id=o.user_id')
                    ->where('o.extend', 'neq', '')
                    ->where('extend->key', '=', $key)
                    ->field('round(sum(o.money),2) total_money,u.name,count(*) count,o.user_id')
                    ->group('user_id')
                    ->select();
            }
            if (!empty($data['history'])) {
                foreach ($data['history'] as $k => &$v) {
                    $v['avatar'] = action('user/api/avatar', [$v['user_id']]);
                }
                $data['count'] = array_sum(array_column($data['history'], 'count'));
            }
            $data['mini_url'] = urlencode($this->request->domain() . '/info_view/info_view?cid=' . $cid . '&id=' . $id);
            $data['mobile_url'] = urlencode($this->request->domain() . '/mobile/#/info/view/cid/' . $cid . '/id/' . $id);
            return json($data);
        }
    }

    /**
     * 移动端筛选项接口
     */
    public function load_filter()
    {
        $data['columns'] = array_values(load_columns());
        $data['areas'] = array_values(load_areas());
        if (!empty($data['columns'])) {
            foreach ($data['columns'] as $k => $v) {
                if (!empty($v['child'])) $data['columns'][$k]['child'] = array_values($v['child']);
            }
        }
        if (!empty($data['areas'])) {
            foreach ($data['areas'] as $k => $v) {
                if (!empty($v['child'])) $data['areas'][$k]['child'] = array_values($v['child']);
            }
        }
        return json($data);
    }

    /**
     * 筛选项
     */
    function filters($attr = [])
    {
        $rs = [];
        if (!isset($attr['order'])) {
            $rs['order'] = 'top_end_time desc,create_time desc';
        } else {
            //最新
            if ($attr['order'] == '1') $rs['order'] = 'create_time desc';
            //点击量
            if ($attr['order'] == '2') $rs['order'] = 'hits desc';
            //红包
            if ($attr['order'] == '3') {
                $rs['order'] = 'create_time desc';
                $rs['where'][] = ['behavior', 'neq', ''];
            }
        }
        if (isset($attr['area_id'])) {
            $areas = load_areas(1);
            if (!empty($areas[$attr['area_id']]['child'])) {
                $area_ids = array_merge([$attr['area_id']], array_keys($areas[$attr['area_id']]['child']));
                $rs['where'][] = ['area_id', 'in', $area_ids];
            } else {
                $rs['where'][] = ['area_id', '=', $attr['area_id']];
            }
        }
        return $rs;
    }

    /**
     * 生成二维码
     */
    function qr_code($content = '')
    {
        $text = urldecode($content);
        return response(QRcode::png($text, false, QR_ECLEVEL_L, $size = 8, $margin = 2, false))->header(['Content-type' => 'image/png']);
    }

    /**
     * 移动端搜索
     */
    public function search($attr = [])
    {
        if (empty($attr['keyword'])) return json(['code' => 0, 'msg' => '参数错误']);
        $data = $this->_search($attr);
        if (!empty($data['data'])) $data['data'] = $this->_init_mobile_data($data['data']);
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 反馈热门标签
     * @return \think\response\Json
     */
    function feedback_tags($num = 20)
    {
        $tags = db('feedback')->alias('f')->field('f.id,substring_index(substring_index(f.tags,\',\',b.id+1),\',\',-1) tags')->join('__TEMP__ b', 'b.id<(length(f.tags)-length(replace(f.tags,\',\',\'\'))+1)')->where('f.tags', 'neq', '')->select();
        if (!empty($tags)) {
            $count = array_count_values(array_column($tags, 'tags'));
            arsort($count);
            $data = [];
            $i = 0;
            foreach ($count as $k => $v) {
                if ($i < $num) {
                    $data[$i] = [
                        'name' => $k,
                        'count' => $v
                    ];
                    $i++;
                } else {
                    break;
                }
            }
        } else {
            $data = [];
        }
        return json(['code' => 1, 'data' => $data]);
    }

}
