<?php
/**
 * +------------------------------------------------------------
 * | 数据-会员 (index/controller/User.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-12 22:51:41
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\controller;

use think\Db;
use app\index\model\Data;

class User extends Module
{

    public function initialize()
    {
        parent::initialize();
        $this->_where = ['user_id' => session('user.id')];
    }

    /**
     * 信息
     */
    public function index()
    {
        $rs = action('index/api/user_data', [0, 0]);
        $this->init_pager($rs['total'], 20);
        return view('', [
            'data' => $rs['data']
        ]);
    }

    /**
     * 编辑
     */
    public function edit($key, $id)
    {
        if (request()->isPost()) {
            $data = input('post.');
            self::$column = load_column($data['column_id']);
            //更新数据
            $result = $this->_add($data);
            if ($result['code'] == 1) {
                return $this->success('信息《' . $data['name'] . '》已更新。');
            } else {
                return $this->error($result['msg']);
            }
        }
        $rs = $this->query(['key' => $key, 'id' => $id, 'where' => [['user_id', '=', session('user.id')]]]);
        if (empty($rs)) $this->redirect('index');
        if (isset(self::$column['setting']['group'][self::$user['group_id']]['upload_limit'])) {
            $this->assign('upload_limit', self::$column['setting']['group'][self::$user['group_id']]['upload_limit']);
        } else {
            $this->assign('upload_limit', 3);
        }
        $this->assign('fields', $this->load_fields(self::$column['id']));
        if (!empty($rs['value'])) $rs['value'] = array_column($rs['value']->toArray(), null, 'fields_id');
        return view('edit', [
            'rs' => $rs,
            'column' => self::$column,
            'area_tree' => \load_areas(),
        ]);
    }

    /**
     * 关闭
     */
    public function close($id)
    {
        action('index/api/close', [$id]);
        return $this->redirect('index');
    }

    /*
    * 评论
    */
    function comment()
    {
        $rs = db('comment')->where($this->_where)->order('id desc')->paginate(10)->toArray();
        $this->init_pager($rs['total'], 10);
        return view('', ['data' => $rs['data']]);
    }

    /*
    * 评论删除
    */
    function comment_delete()
    {
        Comment::where('id', $this->id)->update(['status' => 1]);
        return $this->success('删除成功');
    }

    /**
     * 置顶
     */
    function top($id = 0, $days = 0, $payment = '', $currency = '1')
    {
        $result = action('index/api/top', [$id, $days, $payment, 0, $currency]);
        if ($result['code'] == 1) {
            $this->success('置顶成功');
        } else {
            $this->error($result['msg']);
        }
    }

    /**
     * 刷新
     */
    function refresh($id = 0, $payment = '', $currency = '1')
    {
        $result = action('index/api/refresh', [$id, $payment, 0, $currency]);
        if ($result['code'] == 1) {
            $this->success('刷新成功');
        } else {
            $this->error($result['msg']);
        }
    }

}
