<?php
/**
 * +------------------------------------------------------------
 * | 用户 user/controller/Admin.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;

use app\user\model\Company;
use app\user\model\Info;
use app\user\model\User;
use app\user\model\Auth;
use app\user\model\Evaluate;
use app\user\model\Log;
use think\Hook;

class Admin extends Module
{

    /**
     * 账号管理
     */
    public function index()
    {
        $attr = input('param.');
        $attr['page'] = max(1, input('param.page', 0));
        $attr['status'] = 1;
        $attr['with'] = 'register';
        $rs = $this->query($attr);
        return json(['code' => 1, 'data' => $rs]);
    }

    /**
     * 改变用户状态
     */
    function change_status($id = [], $status = 0)
    {
        if (!empty($id)) {
            db('user')->where('id', 'in', (array)$id)->update(['status' => $status]);
            action('admin/Api/log', ['批量' . $status == 0 ? '锁定' : '解锁' . '用户', '用户ID:' . join(',', (array)$id)]);
            return json(['code' => 1, 'msg' => '操作成功']);
        }
    }

    /**
     * 用户日志
     */
    function log($user_id = 0, $return = 1)
    {
        $data = model('app\user\model\Log')->where('user_id', '=', $user_id)->order('create_time desc')->paginate(20)->toArray();
        return $return ? json(['code' => 1, 'data' => $data]) : $data;
    }

    /**
     * 用户详情
     */
    public function view($id)
    {
        $rs = $this->query(['id' => $id, 'field' => 'id,group_id,name,email,qq,phone,address,mappoint,money,credit,status']);
        $rs['logs'] = $this->log($id, 0);
        $index = model('app\index\model\Data')->where('user_id', '=', $id)->where('status', '<', 4)->order('create_time desc, status desc')->paginate(20)->toArray();
        if (!empty($index['data'])) {
            $columns = load_columns(0);
            foreach ($index['data'] as $k => &$v) {
                $v['column'] = $columns[$v['column_id']];
                $v['url'] = empty($columns[$v['column_id']]['key']) ? '' : url('index/index/view', ['key' => $columns[$v['column_id']]['key'], 'id' => $id], true, true);
                $v['time'] = time_format($v['create_time']);
            }
        }
        $rs['index'] = $index;
        return json(['code' => 1, 'data' => $rs]);
    }

    /**
     * 数据概览
     */
    public function overview()
    {
        $count = [];
        $count['total'] = User::count();
        $count['blacklist'] = User::where('status', 0)->count();
        $count['week_create'] = db('user_log')->where('action', '=', 'register')->where('create_time', '>', (time() - 60 * 60 * 24 * 7))->count();
        $count['week_login'] = db('user_log')->where('action', '=', 'login')->where('create_time', '>', (time() - 60 * 60 * 24 * 7))->group('user_id')->count();
        $count['month_create'] = db('user_log')->where('action', '=', 'register')->where('create_time', '>', (time() - 60 * 60 * 24 * 30))->count();
        $count['month_login'] = db('user_log')->where('action', '=', 'login')->where('create_time', '>', (time() - 60 * 60 * 24 * 30))->group('user_id')->count();
        $data['count'] = $count;
        $login = array_column(db('user_log')->where("`create_time`>UNIX_TIMESTAMP(DATE_SUB(CURDATE(), INTERVAL 7 DAY))")->where('action', '=', 'login')->group('day')->field("count(*) as count,FROM_UNIXTIME(create_time,'%m-%d') as day")->select(), null, 'day');
        $register = array_column(db('user_log')->where("`create_time`>UNIX_TIMESTAMP(DATE_SUB(CURDATE(), INTERVAL 7 DAY))")->where('action', '=', 'register')->group('day')->field("count(*) as count,FROM_UNIXTIME(create_time,'%m-%d') as day")->select(), null, 'day');
        for ($i = 7; $i > 0; $i--) {
            $day = date("m-d", strtotime("-" . $i . " day"));
            $data['chart']['data'][] = [
                'day' => $day,
                '登陆' => empty($login[$day]['count']) ? 0 : $login[$day]['count'],
                '注册' => empty($register[$day]['count']) ? 0 : $register[$day]['count']
            ];
        }
        $group = action('user/api/group');
        $group_data = array_column(db('user')->field('group_id,count(*) count')->group('group_id')->select(), null, 'group_id');
        foreach ($group as $k => $v) {
            $data['chart']['group'][] = [
                'item' => $v['name'],
                'count' => empty($group_data[$v['id']]['count']) ? 0 : $group_data[$v['id']]['count']
            ];
        }
        $data['chart']['fields'] = ['登陆', '注册'];
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 登录用户
     */
    public function login($id = 0)
    {
        $user = model('app\user\model\User')->with('register')->where('id', $id)->find();
        session('user', $user->append(['login'])->toArray());
        return json(['code' => 1, 'msg' => '登录成功']);
    }

    /**
     * 用户组
     */
    public function group()
    {
        $group = action('user/api/group');
        return json(['code' => 1, 'data' => $group]);
    }

    /**
     * @param int $id
     */
    function move($id = [], $group_id = 0)
    {
        if (!empty($id)) {
            db('user')->where('id', 'in', (array)$id)->update(['group_id' => $group_id]);
            action('admin/Api/log', ['批量移动用户', '用户ID:' . join(',', (array)$id) . ' 用户组ID:' . $group_id]);
            return json(['code' => 1, 'msg' => '移动成功...']);
        }
    }

    /**
     * 黑名单
     */
    function blacklist()
    {
        $attr = input('param.');
        $attr['page'] = max(1, input('param.page', 0));
        $attr['status'] = 0;
        $attr['with'] = 'register';
        $rs = $this->query($attr);
        return json(['code' => 1, 'data' => $rs]);
    }

    /**
     * 删除用户
     * @param int $id
     */
    function delete($id = 0)
    {
        $where[] = ['id', 'in', (array)$id];
        $user = db('user')->where($where)->select();
        db('user')->where($where)->delete();
        action('admin/api/log', ['删除用户【' . implode(',', array_column($user, 'name')) . '】']);
        return json(['code' => 1, 'msg' => '删除成功']);
    }

    function group_form($id = '')
    {
        if (request()->isPost()) {
            $data = [
                'name' => input('post.name', ''),
                'memo' => input('post.memo', ''),
                'status' => input('post.status', 0),
                'setting' => input('post.setting/a', [])
            ];
            $validate = validate('Group');
            if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
            if ($id != '') {
                $setting = model('Group')->where('id', $id)->value('setting');
                if (!empty($setting)) {
                    $data['setting'] = json_encode(array_replace(json_decode($setting, 1), $data['setting']));
                    db('user_group')->where('id', $id)->update($data);
                    cache('user_group', null);
                } else {
                    $data['setting'] = json_encode($data['setting']);
                    $data['id'] = $id;
                    db('user_group')->insert($data);
                    cache('user_group', null);
                }
            } else {
                $data['type'] = 1;
                $max_id = intval(db('user_group')->max('id'));
                $data['id'] = $max_id + ($max_id == 0 ? 2 : 1);
                $data['setting'] = json_encode($data['setting']);
                db('user_group')->insert($data);
            }
            action('user/api/group', [1]);
            return json(['code' => 1, 'msg' => '用户组更新成功']);
        } else {
            if ($id != '') {
                $data = array_column(action('user/api/group', ['', $id]), null, 'id')[$id];
                if (!empty($data['setting'])) $data['setting'] = json_decode($data['setting'], 1);
                return json(['code' => 1, 'data' => $data]);
            }
        }
    }

    function group_delete($id = '')
    {
        if ($id != '') {
            if (!empty(model('app\user\model\User')->where('group_id', '=', $id)->count())) {
                return json(['code' => 0, 'msg' => '请先移出该用户组下的用户']);
            }
            db('user_group')->where('id', '=', $id)->delete();
            cache('user_group', null);
        }
        return json(['code' => 1, 'msg' => '操作成功']);
    }

    function _empty($name)
    {
        if (in_array($name, ['group_add', 'group_edit'])) {
            return $this->group_form(input('param.id', ''));
        }
    }

    /**
     * 检测用户名是否存在
     */
    public function search($name = '')
    {
        $data = db('user')->where('name', 'like', '%' . $name . '%')->field('id,name value')->select();
        return json(['code' => 1, 'data' => $data]);
    }

}
