<?php
/**
 * +------------------------------------------------------------
 * | 用户 注册验证
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\validate;

use think\Validate;

class Register extends Validate
{
    protected $rule = [
        'name' => 'require|chsDash|length:4,20',
        'email' => 'email',
        'pwd' => 'require|length:6,20',
        'repwd' => 'confirm:pwd',
    ];
    protected $message = [
        'name.require' => '用户名不能为空',
        'name.chsDash' => '用户名仅可使用汉字、字母、数字、中划线或下划线。',
        'email' => '邮箱格式不正确。',
        'pwd.length' => '请输入在6~20位字符的密码。',
        'repwd.confirm' => '两次密码输入不同，请修正后重试。',
    ];

}