<?php
/**
 * +------------------------------------------------------------
 * | 数据 data/controller/Module.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018/5/28
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018/5/28
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\wechat\controller;

use EasyWeChat\Factory;

class Apps extends Module
{
    protected $app;

    function initialize()
    {
        parent::initialize();
        $this->app = Factory::miniProgram($this->config['apps']);
    }

    /**
     * 根据code获取用户openid
     * @param string $code
     * @return \think\response\Json
     */
    function session($code = '')
    {
        $result = $this->app->auth->session($code);
        if (!empty($result['openid'])) {
            $attr = [
                'oauth_type' => 2,
                'openid' => $result['openid']
            ];
            $login = action('user/api/login', [2, $attr, 0]);
            if ($login['code'] == 1) {
                $login['data']['openid'] = $result['openid'];
                return json($login);
            } else {
                return json(['code' => 1, 'data' => ['openid' => $result['openid']]]);
            }
        } else {
            return json(['code' => 0, 'msg' => $result['errmsg']]);
        }
    }

    /**
     * 生成小程序码
     */
    function qrcode($width = 200, $page = 'pages/third/third', $cache = 0)
    {
        if ($cache == 'apps_qrcode') cache($cache, null);
        $cache_key = 'apps_qrcode';
        $cache_data = cache($cache_key);
        if (!empty($cache_data)) {
            //同一ip有效期内只生成一个小程序码
            $ip_data = array_column($cache_data, null, 'ip');
            if (!empty($ip_data[self::$sys['ip']]) && $ip_data[self::$sys['ip']]['time'] > time()) return json(['code' => 1, 'data' => $ip_data[self::$sys['ip']]]);
        }
        //生成key
        $key = create_str();
        //生成二维码
        $qrcode = $this->app->app_code->getUnlimit($key, ['width' => $width, 'page' => $page]);
        //保存到文件
        $file_path = config('')['files']['path'] . DIRECTORY_SEPARATOR . 'apps' . DIRECTORY_SEPARATOR . 'qrcode';
        $qrcode->save($file_path, $key . '.png');
        //生成缓存
        $result = [
            'key' => $key,
            'time' => time() + 600,
            'ip' => self::$sys['ip'],
            'url' => $this->request->domain() . '/uploads/apps/qrcode/' . $key . '.png'
        ];
        if (empty($cache_data)) {
            $cache_data[] = $result;
        } else {
            //循环判断删除过期小程序码 todo 待优化
            foreach ($cache_data as $k => $v) {
                if ($v['time'] < time()) {
                    //清理图片文件
                    @unlink($file_path . DIRECTORY_SEPARATOR . $key . '.png');
                    //删除缓存
                    unset($cache_data[$k]);
                }
            }
            $cache_data = array_values($cache_data);
            $cache_data[] = $result;
        }
        cache($cache_key, $cache_data);
        return json(['code' => 1, 'data' => $result]);
    }


}