require.config({
    baseUrl: '/static/js/',
    paths: {
        'async': 'plugin/requirejs-plugins/src/async',
        'axios': 'plugin/axios/axios.min',
        'BMap': 'http://api.map.baidu.com/api?v=2.0&ak=ELqu3GBvSfI6mTyQ9ZX8RdTMxKehwQHh',
        'context': 'plugin/jquery/jquery.contextMenu.min',
        'cropper': 'plugin/cropper/cropper.min',
        'echarts': 'plugin/echarts/echarts.min',
        'jquery': 'plugin/jquery/jquery-1.12.1.min',
        'jquery.upload': 'plugin/jquery/jquery.upload',
        'jstorage': 'jStorage.min',
        'laydate': 'plugin/laydate/laydate',
        'layer': 'plugin/layer/layer',
        'md5': 'plugin/md5/browser-md5-file.min',
        'moment': 'plugin/moment/moment-with-locales.min',
        'sortable': 'plugin/sortable/sortable.min',
        'swiper': 'plugin/swiper/swiper.min',
        'tagging': 'plugin/tagging',
        'template': 'plugin/baiduTemplate',
        'validator': 'plugin/validator/local/zh-CN',
        'vue': 'plugin/vue/vue.min',
        'wangEditor': 'plugin/wangeditor/js/wangeditor.min',
    },
    map: {
        '*': {
            css: 'plugin/require-css/css.min'
        }
    },
    shim: {
        'BMap': {
            deps: ['jquery'],
            exports: 'BMap'
        },
        'context': ['jquery', 'css!plugin/jquery/jquery.contextMenu.min.css'],
        'cropper': ['jquery', 'css!plugin/cropper/cropper.min.css'],
        'jquery.upload': ['jquery'],
        'jstorage': {
            exports: '$.jStorage'
        },
        'laydate': {
            deps: ['jquery', 'css!plugin/laydate/theme/default/laydate.css'],
            exports: 'laydate'
        },
        'layer': ['jquery', 'css!plugin/layer/theme/default/layer.css'],
        'moment': ['/static/js/plugin/moment/moment.min.js'],
        'swiper': {
            deps: ['css!plugin/swiper/swiper.css', 'jquery'],
            exports: 'Swiper'
        },
        'tagging': ['jquery'],
        'validator': ['/static/js/plugin/validator/jquery.validator.js?css'],
        'wangEditor': ['jquery', 'css!plugin/wangeditor/css/wangEditor.min.css'],
    },
    urlArgs: 'v=0511',
    waitSeconds: 200
});