define(['require', 'common'], function(require, common) {

    if ($.inArray(sys.action, ['index']) > -1) {
        require(['swiper'], function(Swiper) {
            var mySwiper = new Swiper('#swiper', {
                // 如果需要分页器
                pagination: '.swiper-pagination',
                speed: 1000,
                autoplay: 5000,
                loop: true,
                // 如果需要前进后退按钮
                nextButton: '.swiper-button-next',
                prevButton: '.swiper-button-prev',
                paginationClickable: true,
                // 如果需要滚动条
                // scrollbar: '.swiper-scrollbar',
            })
        });
    }

    if ($.inArray(sys.action, ['manage']) > -1) {
        require(['layer', 'laydate', 'axios', 'vue'], function(layer, laydate, axios, Vue) {
            //获取搜索信息
            new Vue({
                el: '#manage',
                data: {
                    infoList: [], //信息列表
                    phone: '',
                    pwd: '', //预留密码
                    sms: { text: '获取验证码', lock: false, captcha: '', code: '' },
                    info: {}, //缓存信息
                    step: 1,
                    phoneImg: '', //手机图片
                    imgChange: false, //图片上传
                    infoView: {
                        info: {
                            phone: {},
                        },
                        end_time: {},
                        image: [],
                    }, //信息详情
                    form: '', //信息提交
                },
                created() {
                    if (sys.data.id) {
                        this.info.id = sys.data.id;
                        this.info.cid = sys.data.cid;
                        this.step = 2;
                        this.phoneImg = '/index/api/phone_image/id/' + this.info.id;
                    }
                    // this.step = 3;
                    common.captcha();
                },
                mounted: function() {
                    var _this = this;
                    laydate.render({
                        elem: "#end_time",
                        type: 'datetime',
                        change: function(value, date) {
                            _this.infoView.end_time = value;
                        }
                    });
                },
                methods: {
                    //信息搜索  15237928159
                    search() {
                        axios.post('/manage/', {
                            'attr': {
                                'phone': this.phone
                            }
                        }).then(response => {
                            if (response.data.code == 1) {
                                this.infoList = response.data.data;
                            } else if (response.data.code == 0) {
                                layer.msg(response.data.msg);
                            }
                        }).catch(response => {
                            console.log(response);
                        });
                    },
                    //选择信息显示验证方式
                    verifyInfo(id, cid, name) {
                        this.info.id = id;
                        this.info.cid = cid;
                        this.info.name = name;
                        this.phoneImg = '/index/api/phone_image/id/' + this.info.id;
                        this.step = 2;

                    },
                    //切换图片验证码
                    changeImgCode(event) {
                        var img = event.target;
                        img.src = '/captcha?' + Math.random();
                    },
                    //显示图片验证码弹窗
                    getVerify() {
                        var _this = this;
                        if (!this.sms.captcha) {
                            layer.msg('请填写图片验证码');
                            return false;
                        }
                        axios.post('/manage/', {
                                'attr': {
                                    'data_id': this.info.id,
                                    'cid': this.info.cid,
                                    'captcha': this.sms.captcha,
                                }
                            }).then(response => {
                                if (response.data.code == 2) {
                                    layer.msg('验证码发送成功，请注意查收');
                                    var num = 60;
                                    _this.sms.lock = true;
                                    var timer = setInterval(function() {
                                        _this.sms.text = num + 's后重新获取';
                                        num--;
                                        if (num <= 0) {
                                            _this.sms.text = '重新获取验证码';
                                            _this.btnLock = false;
                                        }
                                    }, 1000)
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    },

                    // 验证并获取信息详情
                    checkVerify() {
                        var param = {
                            'attr': {
                                'data_id': this.info.id,
                                'cid': this.info.cid,
                                'password': this.pwd,
                                'code': this.sms.code,
                                'captcha': this.sms.captcha,
                            }
                        };
                        axios.post('/manage/', param).then(response => {
                                if (response.data.code == 1) {
                                    this.info.key = response.data.key;
                                    this.infoView = response.data.data;
                                    this.step = 3;
                                } else if (response.data.code == 0) {
                                    layer.msg(response.data.msg)
                                }
                            })
                            .catch(response => {
                                console.log(response);
                            });
                    },
                    //图片预览
                    preview(event) {
                        var _this = this;
                        var data = event.target.files;
                        var arrFile = Array.from(data);
                        _this.form = new FormData();
                        arrFile.forEach(function(item) {
                            _this.form.append('image[]', item, item.name);
                        })
                        _this.imgChange = true;
                        if (typeof FileReader !== 'undefined') { //浏览器能力检测
                            _this.infoView.image = [];
                            for (var i = 0; i < arrFile.length; i++) {
                                if (!/image\/\w+/.test(arrFile[i].type)) {
                                    require(['layer'], function(layer) {
                                        layer.msg('请上传图片格式')
                                    })
                                    return false;
                                }
                                var reader = new FileReader();
                                //将文件以Data URL形式读入页面  
                                reader.readAsDataURL(arrFile[i]);
                                reader.onload = function(e) {
                                    _this.infoView.image.push({ 'url': this.result });
                                }
                            }
                        }
                    },
                    //信息提交
                    onSubmit() {
                        var formData;
                        if (this.imgChange) {
                            //如果图片修改传图片对象
                            for (var key in this.infoView.info) {
                                this.form.set(key, this.infoView.info[key]);
                            }
                            this.form.set('area_id', this.infoView['area_id']);
                            this.form.set('name', this.infoView.name);
                            this.form.set('key', this.info.key);
                            this.form.set('id', this.infoView.id);
                            this.form.set('image', '[]');
                            this.form.set('column_id', this.infoView.column_id);
                            formData = this.form;
                        } else {
                            var imgArr = [];
                            for (var key in this.infoView.image) {
                                imgArr.push(this.infoView.image[key].path);
                            }
                            this.infoView.key = this.info.key;
                            this.infoView.info.phone = this.infoView.info.phone.value;
                            formData = this.infoView;
                            formData.image = imgArr;
                        }
                        axios.post('/index/api/add/', formData).then(response => {
                            if (response.data.code == 1) {
                                layer.msg('修改成功');
                            }
                        }).catch(function(error) {
                            console.log(error)
                        })
                    },
                    //信息删除
                    delInfo() {
                        var param = {
                            id: this.info.id,
                            key: this.info.key
                        };
                        var html = '<div class="text-center mt-md">确定要删除此条信息吗？</div>';
                        layer.open({
                            type: 1,
                            title: '温馨提示',
                            shadeClose: true,
                            resize: false,
                            area: ['260px', '160px'], //宽高
                            content: html,
                            btn: ['确定'],
                            yes: function(index, layero) {
                                axios.post('/index/api/close/', param).then(function(response) {
                                    if (response.code == 1) {
                                        window.location.href = '/index'
                                    }
                                }).catch(function(error) {
                                    console.log(error)
                                })
                            }
                        })
                    },
                    //信息置顶
                    setTop() {
                        var url = '/index/index/top/' + this.info.cid + '/' + this.info.id;
                        window.location.href = url;
                    },
                    //设置红包
                    setRedPacket() {
                        var red = '/index/index/redpacket/' + this.info.cid + '/' + this.info.id;;
                        window.location.href = red;
                    }
                }
            });

        });
        // 信息删除
        // common.confirm();

    }
})