define(['require', 'common'], function(require, common) {

    switch (sys.action) {
        case 'top': //置顶
            var topInfo = sys.data;
            var imoney = topInfo.top_money;
            $('[rel=resume]').text(imoney);
            $('[rel=name]').text(topInfo.name);
            $('[name="days"]').bind('input propertychange', function() {
                if (Number($('[name="days"]').val()) >= 99999999) {
                    $('[name="days"]').val(99999999); //限制置顶最大天数
                }
                add();
            });

            //判断信息是否支持置顶
            if (!imoney) {
                require(['layer'], function(layer) {
                    layer.confirm(('该条信息不支持置顶'), {
                            btn: ['回首页', '再发布一条']
                        },
                        function() {
                            window.location = '/index';
                        },
                        function() {
                            window.location = '/fabu';
                        })
                })
            }

            // 提交
            $('[rel=onSubmit]').click(function() {
                var pay_way = $("input[name='payment']:checked").val(); //支付方式
                var pay_type = pay_way == 0 ? 0 : 1; //付款类型
                var $this = $(this);
                var days = parseInt($('[name="days"]').val()); //置顶时间
                var info = {
                    'id': topInfo.id, //信息id
                    'cid': topInfo.cid, //栏目id
                    'days': days,
                    'payment': pay_way,
                };
                if (!days) {
                    require(['layer'], function(layer) {
                        layer.msg('置顶天数要大于0');
                        return false;
                    })
                } else {
                    // 生成订单
                    generateOrder('/index/api/top', info)
                }
            });

            break;
        case 'redpacket': //红包
            var info = sys.data;
            $('[rel=name]').text(info.name);
            // 提交
            $('[rel=onSubmit]').click(function() {
                var pay_way = $("input[name='payment']:checked").val(); //支付方式
                var pay_type = pay_way == 0 ? 0 : 1; //付款类型
                var $this = $(this);
                var money = parseFloat($('[name="money"]').val()); //置顶时间
                var number = $("input[name='num']").val();
                var param = {
                    'id': info.id, //信息id
                    'cid': info.cid, //栏目id
                    'money': money,
                    'payment': pay_way,
                    'num': number
                };
                if (!money) {
                    require(['layer'], function(layer) {
                        layer.msg('红包金额要大于0');
                        return false;
                    })
                } else {
                    // 生成红包订单
                    generateOrder('/index/api/redpacket', param)
                }
            });
            break;
    }
    // 简易观察者模式
    var Bus = {
        event: {},
        on: function(ev, callback) {
            if (this.event[ev]) {
                this.event[ev].push(callback);
            } else {
                this.event[ev] = [callback];
            }
        },
        emit: function(ev, ...param) {
            if (this.event[ev]) {
                this.event[ev].forEach(item => {
                    item(...param);
                });
            }
        },
        off: function(ev, callback) {
            this.event[ev].filter(item => item != callback);
        }
    }

    //注册事件

    Bus.on('payorder', handle); //(支付订单)
    Bus.on('isfinish', outTradeNoTimer); //支付是否完成

    // 计算总花费
    function add() {
        var im = imoney;
        var smoney = 0;
        smoney = parseInt(Number($('[name="days"]').val())) * im;
        if (smoney >= 0) {
            $('[rel=money]').html(smoney);
        }
    }

    //生成订单
    function generateOrder(url, param) {
        $.post(url, param, function(rs) {
            if (rs.code == 2) {
                require(['layer'], function(layer) {
                    var orderId = rs.order;
                    layer.open({
                        type: 1,
                        title: '订单支付',
                        area: ['360px', '210px'], //宽高
                        content: '<div class="p-lg">订单已生成，订单号为：' + orderId + '</div>',
                        cancel: function(index, layero) {
                            window.parent.location.reload();
                            layer.closeAll();
                        },
                        btn: ['立即支付', '取消'],
                        btnAlign: 'c',
                        yes: function(index, layero) {
                            Bus.emit('payorder', orderId)
                        },
                        btn2: function() {
                            layer.open({
                                type: 1,
                                title: '请选择',
                                btn: ['继续支付', '支付有问题'],
                                yes: function() {
                                    Bus.emit('payorder', orderId)
                                },
                                btn2: function() {
                                    window.location.href = "/feedback"; //跳转帮助页面
                                }
                            })
                        }
                    });
                })
            }
        })
    }

    //支付订单
    function handle(order) {
        var param = {
            'order': order,
        };
        var settings = {
            auto_outTradeNoTimer: true,
        };
        param.method = 'scan';
        $.post('/finance/api/pay', { 'attr': param }, function(rs) {
            if (rs.code == 1) {
                if (rs.data) {
                    layer.open({
                        type: 1,
                        title: '扫码支付',
                        area: ['360px', '400px'], //宽高
                        btn: ['已完成', '未完成'],
                        btnAlign: 'c',
                        content: "<div class='text-center' style='margin-top:40px'><img style='width:60%' src=/finance/api/qrcode?text=" + rs.data + " alt=''></div>",
                        yes: function(index, layero) {
                            settings.auto_outTradeNoTimer = false;
                            window.parent.location.reload();
                            layer.closeAll();
                        },
                        btn2: function() {
                            layer.open({
                                type: 1,
                                title: '请选择',
                                btn: ['继续支付', '支付有问题'],
                                yes: function() {
                                    layer.closeAll();
                                },
                                btn2: function() {
                                    window.location.href = "/feedback";
                                }
                            })
                        }
                    });
                    // 查询支付是否成功
                    Bus.emit('isfinish', rs.order, settings);
                } else {
                    layer.msg('支付成功');
                    setTimeout(function() {
                        layer.closeAll();
                    }, 1000)
                }
            } else if (rs.code == 0) {
                layer.msg('积分或余额不足');
            }
        });
    }

    // 查询支付是否成功
    function outTradeNoTimer(out_trade_no, settings) {
        $.ajax({
            url: '/finance/api/read',
            method: 'post',
            data: {
                'attr': {
                    id: out_trade_no,
                }
            },
            cache: false,
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    layer.closeAll();
                    layer.open({
                        title: '信息提示',
                        btnAlign: 'c',
                        content: '<p class="text-center">支付成功</p>',
                        btn: ['确定']
                    });
                } else {
                    //轮询
                    setTimeout(function() {
                        if (settings.auto_outTradeNoTimer) {
                            outTradeNoTimer(out_trade_no, settings);
                        }
                    }, 3000);
                }
            }
        });
    }
});