<?php
/**
 * +------------------------------------------------------------
 * | 数据 data/controller/Module.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-04-19 11:31:21
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-04-19 11:31:21
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\cim\controller;

use app\common\controller\Init;

class Module extends Init {

    public static $models;

    public static $area = ['id'=>'', 'name'=>'', 'parent_id'=>0];

    public static $areas = [];

    public static $column = [];

    public static $columns = [];

    protected function initialize() {
        parent::initialize();
        self::$models = config('app.models');
        if (empty(self::$models)) self::$models = $this->load_config('models');
        self::$columns = load_columns(0, 0, 'id');
        self::$column = $this->_init_column(input('param.cid'), self::$columns);
        if (empty(self::$column)) self::$column = $this->_init_column(input('param.key'), \load_columns(0, 0, 'key'));
    }

    /**
     * 获取扩展字段
     */
    public function load_fields($cid, $refresh=0) {
        $cache_id = 'column_fields_'.$cid;
        if ($refresh) cache($cache_id, null);
        $rs = cache($cache_id);
        if (empty($rs)) {
            $rs = model('\app\data\model\Fields')->where('column_id', $cid)->order('list_order asc')->column('*', 'id');
            if (!empty($rs)) {
                foreach ($rs as $k=>$v) {
                    if (in_array($v['type'], [1, 2])) {
                        $rs[$k]['options'] = explode("\n", $v['value']);
                    }
                }
                cache($cache_id, $rs, 0);
                return $rs;
            }else{
                $rs = [];
            }
        }
        return $rs;
    }

    /**
     * 查询
     */
    protected function query($attr=[]) {
        is_string($attr) && $attr = \json_decode($attr, true);
        $cache_id = 'data_query_'.md5(json_encode($attr));
        if (isset($attr['cache'])) {
            $rs = cache($cache_id);
            if (!empty($rs)) return $rs;
        }
        //未设置栏目
        if (empty(self::$columns)) return [];
        //非管理员加载审核后的数据
        if (self::$sys['controller']!='admin') $attr['where'][] = ['status', '=', 1];
        //页面模型直接返回
        if (isset($attr['model'])&&$attr['model']=='pages') {
            return model('\app\data\model\Pages')->get($attr['cid']);
        }
        //处理cid
        if (isset($attr['cid'])) {
            if (count(explode(',', $attr['cid']))==1) {
                //未找到栏目
                if (!isset(self::$columns[$attr['cid']])) return [];
                self::$column = self::$columns[$attr['cid']];
                $columns = \load_columns(1, 0, 'id');
                if (!empty($columns[$attr['cid']]['child']) ) {
                    $cids = array_merge([$attr['cid']], array_keys($columns[$attr['cid']]['child']));
                    $attr['where'][] = ['column_id', 'in', $cids];
                }else{
                    $attr['where'][] = ['column_id', '=', $attr['cid']];
                }
            }else{
                $cids = \explode(',', $attr['cid']);
                $attr['where'][] = ['column_id', 'in', $cids];
            }
        }
        if (isset($attr['key'])) {
            self::$column = $this->_init_column($attr['key'], \load_columns(0, 0, 'key'));
        }
        //如果栏目为空并且没有关键字，则返回空数据
        if (empty(self::$column)&&!isset($attr['keyword'])) return [];
        //如果栏目模型与标签模型不符，则返回空数组
        if (isset($attr['model'])&&self::$column['model']!=$attr['model']) return [];
        if (isset($attr['thumb'])) {
            if ($attr['thumb']==1) $attr['where'][] = ['thumb', '<>', ''];
            if ($attr['thumb']==0) $attr['where'][] = ['thumb', '=', ''];
        }
        if (isset($attr['keyword']) && !empty($attr['keyword'])) $attr['where'][] = ['name', 'LIKE', '%'.$attr['keyword'].'%'];
        if (!isset($attr['with'])) {
            $attr['with'] = '';
            if (isset(self::$column['model'])) {
                if (isset(self::$models[self::$column['model']]['table'])) {
                    if (in_array(self::$column['model'], ['links', 'phone']) || in_array(self::$sys['action'], ['edit', 'view'])) {
                        $attr['with'] = join(',', self::$models[self::$column['model']]['table']);
                    }else{
                        if (in_array('seo', self::$models[self::$column['model']]['table'])) $attr['with'] = 'seo';
                    }
                }
            }
        }
        !isset($attr['field']) && $attr['field'] = '';
        !isset($attr['limit']) && $attr['limit'] = 10;
        !isset($attr['order']) && $attr['order'] = 'id desc';
        if (!empty(self::$column) && method_exists($this, $_method = '_'.self::$column['model'])) {
            $rs = $this->$_method($attr);
        }else{
            if (isset($attr['id'])) {
                $rs = model('\app\data\model\Data')->with($attr['with'])->where($attr['where'])->find($attr['id']);
                if ($rs->image) $this->_init_image($rs->image);
            }else if (isset($attr['page'])) {
                $rs = model('\app\data\model\Data')->with($attr['with'])->field($attr['field'])->where($attr['where'])->order($attr['order'])->paginate($attr['limit'])->toArray();
            }else{
                $rs = model('\app\data\model\Data')->with($attr['with'])->field($attr['field'])->where($attr['where'])->limit($attr['limit'])->order($attr['order'])->select()->toArray();
            }
        }
        if (!empty($rs)) $rs = $this->_init_data($rs);
        if (isset($attr['cache'])) cache($cache_id, $rs, ($attr['cache']*60));
        return $rs;
    }

    /**
     * 解析栏目
     */
    public function _init_column($val='', $columns) {
        if (!$val) return [];
        return isset($columns[$val]) ? $columns[$val] : [];
    }

    /**
     * 初始化数据
     */
    private function _init_data($rs) {
        if (isset($rs['id'])) {
            $rs['thumb'] = $this->_init_thumb($rs['thumb']);
            return $rs;
        }
        if (isset($rs['current_page'])) {
            foreach ($rs['data'] as $k=>$v) {
                $rs['data'][$k]['thumb'] = $this->_init_thumb($rs['data'][$k]['thumb']);
            }
        }else{
            foreach ($rs as $k=>$v) {
                $rs[$k]['thumb'] = $this->_init_thumb($rs[$k]['thumb']);
            }
        }
        return $rs;
    }

    public function _init_thumb($val) {
        $rs = ['value'=>$val];
        $rs['url'] = ($val ? config('files.url').$val : config('files.nopic'));
        return $rs;
    }

    private function _init_image($rs) {
        foreach ($rs as $k=>$v) $rs[$k]['url'] = config('files.url').$v['path'];
    }

    /**
     * 解析url
     */
    public function _init_url($id, $key='') {
        if (!$key) $key = self::$column['key'];
        return url('index/index/view', ['key'=>$key, 'id'=>$id ]);
    }

    /**
     * 解析关键词
     */
    private function tags($val=[]) {
        if (empty($val)) return [];
        $tags = explode(',', $val);
        foreach ($tags as $k => $v) {
            $tags[$k] = [
                'name' => $v,
                'url' => url('index/index/search', ['keyword' => $v]),
            ];
        }
        return $tags;
    }

    /**
     * 加载配置
     */
    private function load_config($key='') {
        $_cfg = include_once(\Env::get('app_path').'data/config/app.php');
        if ($key) {
            if (isset($_cfg[$key])) return $_cfg[$key];
            return;
        }
        return $_cfg;
    }

}