<?php
/**
 * +------------------------------------------------------------
 * | 财务 finance/controller/Behavior.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\finance\controller;

use think\facade\Hook;

class Behavior extends Module
{
    //置顶行为
    function top($order)
    {
        $data = json_decode($order['extend'], 1);
        return Hook::exec('app\\index\\behavior\\Top', $data);
    }

    //红包行为
    function redpacket($order)
    {
        $data = json_decode($order['extend'], 1);
        $data = array_merge($data, ['money' => $order['money']]);
        return Hook::exec('app\\index\\behavior\\Redpacket', $data);
    }

    //充值置顶行为
    function recharge_top($order)
    {
        $behavior = $order['behavior'];
        //创建置顶扣款订单
        $attr = [
            'user_id' => $order['user_id'],
            'balance' => '0',
            'type' => '1',
            'payment' => '1',
            'money' => $order['money'],
            'memo' => '置顶信息扣款',
            'behavior' => $behavior,
            'extend' => $order['extend']
        ];
        $api = new Api();
        $create_order = $api->order($attr, 0);
        if ($create_order['code'] == 1) {
            //进行支付操作
            return $api->pay(['order' => $attr['order']], 0);
        } else {
            return ['code' => 0, 'msg' => '置顶失败:' . $create_order['msg']];
        }
    }
}