<?php
/**
 * +------------------------------------------------------------
 * |
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-05-23 10:49:54
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-05-23 10:49:54
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

/**
 * 加载配置
 */
function load_config($key = '')
{
    $_cfg = include_once(\Env::get('app_path') . 'index/config/app.php');
    if ($key) {
        if (isset($_cfg[$key])) return $_cfg[$key];
        return;
    }
    return $_cfg;
}

/**
 * 处理标签
 */
function tags($val = [])
{
    if (is_array($val)) {
        return join(',', $val);
    }
    if (is_string($val)) {
        $tags = explode(',', $val);
        foreach ($tags as $k => $v) {
            $tags[$k] = [
                'name' => $v,
                'url' => url('index/index/search', ['keyword' => $v]),
            ];
        }
        return $tags;
    }
    return $val;
}

/**
 * 接口处理栏目
 */
function columns_to_array($columns = [])
{
    if (empty($columns)) return $columns;
    $columns = array_values(array_to_tree($columns));
    foreach ($columns as $kk => $vv) {
        if (!empty($vv['child'])) $columns[$kk]['child'] = array_values($vv['child']);
    }
    return $columns;
}
