<?php
/**
 * +------------------------------------------------------------
 * | 数据-管理 (index/controller/Admin.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 11:32:24
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 11:32:24
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\controller;

use think\Db;
use think\Exception;
use think\Hook;
use think\facade\Cache;
use app\index\model\Data;
use app\index\model\Column;

class Admin extends Module
{

    protected function initialize()
    {
        parent::initialize();
        $this->assign('column', self::$column);
    }


    /**
     * 管理首页
     */
    public function overview()
    {
        $data = [];
        //统计
        $data['count'] = [
            'info' => db('info')->count(),
            'phone' => db('phone')->count(),
            'article' => db('article')->count(),
            'user' => db('user')->count(),
            'column' => db('column')->count(),
            'links' => db('links')->count(),
        ];
        //举报
        $data['reports'] = model('report')->with('datas')->order('create_time desc')->limit(10)->select();
        if (!empty($data['reports'])) {
            $columns = load_columns(0);
            foreach ($data['reports'] as $k => &$v) $v['column_name'] = $columns[$v['column_id']]['name'];
        }
        //图表
        $result = [];
        $model = config('app.models');
        unset($model['common'], $model['pages']);
        $columns = db('column')->field('group_concat(id) id,model')->group('model')->column('group_concat(id) id,model', 'model');
        if (!empty($columns)) {
            foreach ($columns as $k => $v) {
                $column[$k] = array_column(db('data')->where("`create_time`>UNIX_TIMESTAMP(DATE_SUB(CURDATE(), INTERVAL 7 DAY))")->where('column_id', 'in', explode(',', $v))->group("day")->field("count(*) as count,FROM_UNIXTIME(create_time, '%m-%d') as day")->select(), null, 'day');
            }
            for ($i = 7; $i >= 1; $i--) {
                $day = date("m-d", strtotime("-" . $i . " day"));
                foreach ($model as $k => $v) $rs[$v['name']] = empty($column[$k][$day]['count']) ? 0 : $column[$k][$day]['count'];
                $result['data'][] = array_merge(['day' => $day], $rs);
            }
        }
        $result['fields'] = array_column($model, 'name');
        $data['chart'] = $result;
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 内容管理
     */
    public function data($cid = '', $keyword = '', $page = 1, $status = '', $limit = 20)
    {
        $attr = ['cid' => $cid, 'model' => self::$column['model'], 'page' => $page, 'limit' => $limit];
        if (self::$column['model'] == 'info') $attr['with'] = 'info';
        $attr['where'][] = ['id', 'neq', ''];
        if (!empty($keyword)) $attr['where'][] = ['name', 'like', '%' . $keyword . '%'];
        if ($status != '') $attr['where'][] = ['status', '=', $status];
        $attr['field'] = ', status,list_order';
        $attr['where'][] = ['delete_time', '=', '0'];
        $rs = $this->query($attr);
        $rs = $this->_init_data($rs);
        $columns = columns_to_array(load_columns());
        return json(['code' => 1, 'data' => $rs, 'columns' => $columns]);
    }


    /**
     * 数据新增 / 修改
     */
    public function form($cid = 0, $id = 0)
    {
        if (!$cid) return json(['code' => 0, 'msg' => '参数错误']);
        if (request()->isPost()) {
            $data = input('post.');
            $data['column_id'] = $cid;
            $data['id'] = $id;
            self::$column = self::$columns[$data['column_id']];
            if (in_array(self::$column['model'], ['article', 'links'])) $data['area_id'] = 0;
            $result = $this->_add($data);
            if ($result['code']) {
                cache('data_view_' . $id, null);
                return json(['code' => 1, 'msg' => '数据《' . $data['name'] . '》已更新。']);
            } else {
                return json(['code' => 0, 'msg' => '出了点问题，重新提交试试.. [' . $result['msg'] . ']']);
            }
        } else {
            if ($id) {
                $rs = $this->query(['cid' => $cid, 'id' => $id, 'where' => [['id', 'neq', '']]]);
                if (!empty($rs)) {
                    $rs['end_time_day'] = $rs['end_time_day'];
                    $rs = $rs->toArray();
                    if (isset($rs['info']['ip'])) {
                        $rs['ip_location'] = \get_ip_address($rs['info']['ip']);
                    }
                }
            }
            //处理自定义字段
            $column_fields = array_values($this->load_fields($cid));
            if (!empty($column_fields)) {
                $fields = empty($rs['fields']) ? '' : (array)$rs['fields'];
                foreach ($column_fields as $k => $v) $column_fields[$k]['values'] = empty($fields[$v['key']]) ? ($v['type'] == 2 ? [] : '') : $fields[$v['key']];
            }
            $rs['column_fields'] = $column_fields;
            //处理地区
            $areas = array_values(load_areas());
            if (!empty($areas)) {
                foreach ($areas as $k => $v) {
                    if (!empty($v['child'])) $areas[$k]['child'] = array_values($v['child']);
                }
            }
            $rs['areas'] = $areas;
            $rs['column'] = load_column($cid);
            return json(['code' => 1, 'data' => $rs]);
        }
    }

    /**
     * 栏目
     * @todo
     */
    public function column()
    {
        //栏目发布数据总数
        $counts = db('data')->field("count(*) as total, column_id")->where('delete_time', 'eq', '0')->group("column_id")->column('count(*)', 'column_id');
        //栏目今天发布数量
        $t_counts = db('data')->field('count(*) as total,column_id')->where("FROM_UNIXTIME(create_time, '%Y%m%d')=" . date('Ymd'))->where('delete_time', '=', 0)->group('column_id')->column('count(*)', 'column_id');
        //栏目今日刷新数量
        $t_counts_up = db('data')->field('count(*) as total,column_id')->where("FROM_UNIXTIME(update_time, '%Y%m%d')=" . date('Ymd'))->where('delete_time', '=', 0)->group('column_id')->column('count(*)', 'column_id');
        //栏目昨日发布数量
        $y_counts = db('data')->field('count(*) as total,column_id')->where("FROM_UNIXTIME(create_time, '%Y%m%d')=" . date('Ymd', time() - 86400))->where('delete_time', '=', 0)->group('column_id')->column('count(*)', 'column_id');
        $columns = load_columns(0);
        if (!empty($columns)) {
            $models = config('app.models');
            foreach ($columns as $k => &$v) {
                $v['model_name'] = $models[$v['model']]['name'];
                $v['count'] = empty($counts[$v['id']]) ? 0 : $counts[$v['id']];
                $v['t_counts'] = empty($t_counts[$v['id']]) ? 0 : $t_counts[$v['id']];
                $v['t_counts_up'] = empty($t_counts_up[$v['id']]) ? 0 : $t_counts_up[$v['id']];
                $v['y_counts'] = empty($y_counts[$v['id']]) ? 0 : $y_counts[$v['id']];
            }
            $columns = columns_to_array($columns);
        }
        return json(['code' => 1, 'data' => $columns]);
    }

    /**
     * 栏目新建/修改
     */
    public function column_form($id = 0)
    {
        if (request()->isPost()) {
            $data = input('post.');
            $validate = validate('Column');
            if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
            if ($id > 0 && $data['parent_id'] == $id) return json(['code' => 0, 'msg' => '上级栏目不能选择自己。']);
            if (!empty($data['sync_column_id'])) {
                model('Column')->allowField(true)->save(['setting' => $data['setting']], [['id', 'in', $data['sync_column_id']]]);
            }
            $column = Column::where('key', '=', $data['key'])->find();
            if ($id) {
                if (!empty($column) && $column['id'] != $id) return json(['code' => 0, 'msg' => '栏目标识已存在,请更换...']);
                $_model = Column::get($id);
                $_model->allowField(true)->update($data, ['id' => $id]);
                if (isset($data[$_model->model])) {
                    $_tmp = $_model->model;
                    if (model($_tmp)->where('column_id', $id)->count()) {
                        $_model->$_tmp->save($data[$_model->model]);
                    } else {
                        $_model->$_tmp()->save($data[$_model->model]);
                    }
                }
                \load_columns(0, 1);
                return json(['code' => 1, 'msg' => '栏目《' . $data['name'] . '》已更新。', 'column']);
            } else {
                if (!empty($column)) return json(['code' => 0, 'msg' => '栏目标识已存在,请更换...']);
                $rs = Column::create($data, true);
                if ($rs->id) {
                    if (isset($data[$data['model']])) {
                        $_tmp = $data['model'];
                        $data[$data['model']]['column_id'] = $rs->id;
                        $rs->$_tmp()->save($data[$data['model']]);
                    }
                    \load_columns(0, 1);
                    return json(['code' => 1, 'msg' => '栏目《' . $data['name'] . '》已创建。']);
                } else {
                    return json(['code' => 0, 'msg' => '出了点问题，返回重新提交试试..']);
                }
            }
        } else {
            $rs = ['name' => '', 'list_order' => 0, 'keywords' => '', 'description' => '', 'parent_id' => 0];
            if ($id == 0) $rs['list_order'] = db('column')->max('id') + 1;
            if ($id) {
                $rs = model('column')->find($id);
                if ($rs['model'] == 'pages') $rs['pages'] = model('pages')->find($id);
            }
            $groups = action('user/api/group');
            if (!empty($groups)) {
                foreach ($groups as $k => $v) $groups[$k]['column_setting'] = empty($rs['setting']['group'][$v['id']]) ? [] : $rs['setting']['group'][$v['id']];
            }
            return json(['code' => 1, 'data' => [
                'rs' => $rs,
                'columns' => columns_to_array(\load_columns()),
                'models' => config('app.models'),
                'groups' => $groups,
                'template' => [
                    'list' => $this->load_tpls('column'),
                    'view' => $this->load_tpls('view'),
                    'add' => $this->load_tpls('add'),
                ],
            ]]);
        }
    }

    /**
     * 删除栏目
     */
    public function column_delete($id)
    {
        $count = model('data')->where('column_id', $id)->count();
        if ($count == 0) {
            db('column')->where('id', $id)->delete();
            \load_columns(0, 1);
            return json(['code' => 1, 'msg' => '栏目删除成功']);
        } else {
            return json(['code' => 0, 'msg' => '此栏目包含' . $count . '条数据，不可删除。']);
        }
    }


    /**
     * 评论管理
     */
    public function comment()
    {
        $rs = model('comment')->with('user,item')->paginate(20)->toArray();
        return json(['code' => 1, 'data' => $rs]);
    }

    /**
     * 举报
     */
    public function report()
    {
        $rs = db('report')->alias('r')->leftJoin('data d', 'r.data_id = d.id')->field('r.*, d.name')->paginate(20)->toArray();
        if (!empty($rs['data'])) {
            $types = config('app.report');
            $columns = load_columns(0);
            foreach ($rs['data'] as $k => &$v) {
                $v['type_name'] = $types[$v['type']];
                $v['url'] = $this->request->domain() . '/' . (empty($columns[$v['column_id']]['key']) ? $v['data_id'] : $columns[$v['column_id']]['key']) . '/' . $v['data_id'];
            }
        }
        return json(['code' => 1, 'data' => $rs]);
    }

    /**
     * 锁定举报信息
     */
    public function report_delete($id = [], $data_id = [])
    {
        //删除举报信息
        if ($id) {
            db('report')->where('id', 'in', (array)$id)->delete();
        }
        //关闭被举报信息
        if ($data_id) {
            db('report')->where('data_id', 'in', (array)$data_id)->setField(['status' => -1]);
            db('data')->where('id', 'in', (array)$data_id)->setField(['status' => -1]);
        }
        return json(['code' => 1, 'msg' => '操作成功']);
    }

    /**
     * 扩展字段
     */
    public function fields($cid = 0)
    {
        $column_id = [$cid];
        $columns = load_columns(0);
        if (!empty($columns[$cid]['parent_id']) && !empty($columns[$cid]['setting']['fields']['extends'])) {
            array_push($column_id, $columns[$cid]['parent_id']);
        }
        $where[] = ['column_id', 'in', $column_id];
        $rs = model('fields')->where($where)->select();
        if (!empty($rs)) {
            $rs = $rs->toArray();
            foreach ($rs as $k => $v) {
                $rs[$k]['parent_id'] = $columns[$v['column_id']]['parent_id'];
                if ($v['column_id'] == $cid) {
                    $self[$v['key']] = $rs[$k];
                    $rs[$k]['self'] = 1;
                } else {
                    $parent[$v['key']] = $rs[$k];
                    $rs[$k]['self'] = 0;
                }
            }
            if (!empty($parent) && !empty($self)) {
                $intersect = array_intersect(array_keys($parent), array_keys($self));
                if (!empty($intersect)) {
                    foreach ($rs as $k => $v) {
                        if (in_array($v['key'], $intersect) && $v['self'] != 1) unset($rs[$k]);
                    }
                    $rs = array_values($rs);
                }
            }
            array_multisort(array_column($rs, 'self'), SORT_ASC, $rs);
        }
        return json(['code' => 1, 'data' => [
            'fields' => $rs,
            'fields_types' => config('app.fields.types')
        ]]);
    }

    /**
     * 继承自定义字段禁用
     */
    function fields_forbid($fields_id = 0, $column_id = 0)
    {
        if ($fields_id && $column_id) {
            $fields = db('column_fields')->where('id', '=', $fields_id)->find();
            $column = load_column($column_id);
            if (!empty($fields) && !empty($column) && $fields['column_id'] == $column['parent_id']) {
                if (db('column_fields')->where('column_id', '=', $column_id)->where('key', '=', $fields['key'])->find()) return json(['code' => 0, 'msg' => '您已禁用']);
                unset($fields['id']);
                $fields['column_id'] = $column_id;
                $fields['status'] = 0;
                model('app\index\model\Fields')->allowField(true)->data($fields)->save();
                return json(['code' => 1, 'msg' => '禁用成功']);
            }
        }
        return json(['code' => 0, 'msg' => '操作失败']);
    }

    /**
     * 扩展字段 添加 / 修改
     */
    function fields_form($id = 0)
    {
        if (request()->isPost()) {
            $data = input('post.');
            $validate = validate('Fields');
            if (!$validate->check($data)) return json(['code' => 0, 'msg' => $validate->getError()]);
            if ($data['type'] > 0 && $data['value'] == '') $this->error('当类型为列表框或复选框时请填写列表值');
            cache('column_fields_' . $data['column_id'], null);
            if ($id) {
                model('fields')->allowField(true)->save($data, ['id' => $id]);
                $this->load_fields($data['column_id'], 1);
                return json(['code' => 1, 'msg' => '字段《' . $data['name'] . '》已更新。']);
            } else {
                $rs = model('fields')->allowField(true)->save($data);
                if ($rs) {
                    return json(['code' => 1, 'msg' => '字段《' . $data['name'] . '》已新增。']);
                } else {
                    return json(['code' => 0, 'msg' => '出了点问题，返回重新提交试试..']);
                }
            }
        } else {
            if ($id) {
                $rs = model('fields')->get($id);
                return json(['code' => 1, 'msg' => $rs]);
            }
        }
    }

    /**
     * 扩展字段 删除
     */
    public function fields_delete($id = [])
    {
        $fields = db('column_fields')->where('id', 'in', (array)$id)->select();
        if (!empty($fields)) {
            db('column_fields')->where('id', 'in', (array)$id)->delete();
            foreach ($fields as $k => $v) $this->load_fields($v['column_id'], 1);
        }
        return json(['code' => 1, 'msg' => '扩展字段删除成功']);
    }

    /**
     * 移动
     */
    public function move($id = [], $column_id = 0)
    {
        if (!empty($column_id)) {
            db('data')->where('id', 'in', $id)->update(['column_id' => $column_id]);
            action('admin/Api/log', ['批量移动信息', '信息ID:' . join(',', $id) . ' 新栏目ID:' . $column_id]);
            return json(['code' => 1, 'msg' => '您选择的信息已移动到新栏目。']);
        }
    }

    /**
     * 审核
     */
    public function check($id = [])
    {
        db('data')->where('id', 'in', $id)->update(['status' => 1]);
        return json(['code' => 1, 'msg' => '信息审核成功']);
    }

    /**
     * 待审核内容
     */
    function review()
    {
        $data = db('data')
            ->where('status', '=', 0)
            ->where('delete_time', '=', 0)
            ->order('create_time desc')
            ->paginate(20)->toArray();
        if (!empty($data['data'])) {
            $data = $this->_init_data($data);
            $columns = load_columns(0);
            $areas = load_areas(0);
            $models = config('app.models');
            foreach ($data['data'] as $k => &$v) {
                $v['model_name'] = $models[$columns[$v['column_id']]['model']]['name'];
                $v['column_name'] = $columns[$v['column_id']]['name'];
                $v['area_name'] = !empty($v['area_id']) ? $areas[$v['area_id']]['name'] : '';
            }
        }
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 置顶
     */
    public function top($data_id = 0)
    {
        if (request()->isPost()) {
            $data = input('post.');
            if (isset($data['top_end_time'])) $data['top_end_time'] = strtotime($data['top_end_time']);
            db('info')->where('data_id', $data_id)->update(['top_end_time' => $data['top_end_time']]);
            return json(['code' => 1]);
        } else {
            $rs = db('info')->alias('i')->join('data d', 'i.data_id=d.id')->field('d.id, d.name, i.linkman, i.phone, i.email, i.top_type, i.top_end_time')->find($data_id);
            if ($rs['top_end_time']) $rs['top_end_time'] = date('Y-m-d H:i:s', $rs['top_end_time']);
            return json(['code' => 1, 'data' => $rs]);
        }
    }

    /**
     * 删除
     */
    public function delete($id = [], $delete = 0)
    {
        if ($delete) {
            $rs = db('data')->where('id', 'in', (array)$id)->column('*', 'id');
            //删除
            db('data')->where('id', 'in', (array)$id)->delete();
            $source = [];
            foreach ($rs as $k => $v) {
                //清除缓存

                $rss = db('data_image')->where('data_id', '=', $k)->select();
                //删除附件数据
                db('data_image')->where('data_id', '=', $k)->delete();
                if (!empty($rss)) {
                    $source[] = [
                        'data_id' => $k,
                        'path' => array_column($rss, 'path'),
                        'fields' => 'data_image|path'
                    ];
                }
                if (!empty($v['thumb'])) {
                    $source[] = [
                        'data_id' => $k,
                        'path' => $v['thumb'],
                        'fields' => 'data|thumb'
                    ];
                }
                if (!empty($source)) action('files/api/update_file_info', [[], $source]);
                action('admin/Api/log', ['删除数据', '数据ID:' . $k . ' 标题:' . $v['name']]);
            }
        } else {
            //软删除
            Db::name('data')->where('id', 'in', (array)$id)->useSoftDelete('delete_time', time())->delete();
        }
        return json(['code' => 1, 'msg' => '操作成功']);
    }

    /**
     * 回收站
     */
    function recycle($limit = 20, $keyword = '')
    {
        $where = [
            ['delete_time', 'neq', 0]
        ];
        if ($keyword) $where[] = ['name', 'like', '%' . $keyword . '%'];
        $data = db('data')
            ->where($where)
            ->order('delete_time desc')
            ->paginate($limit)->toArray();
        if (!empty($data['data'])) {
            $data = $this->_init_data($data);
            $columns = load_columns(0);
            $areas = load_areas(0);
            $models = config('app.models');
            foreach ($data['data'] as $k => &$v) {
                $v['model_name'] = $models[$columns[$v['column_id']]['model']]['name'];
                $v['column_name'] = $columns[$v['column_id']]['name'];
                $v['area_name'] = !empty($areas[$v['area_id']]['name']) ? $areas[$v['area_id']]['name'] : '';
            }
        }
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 数据恢复
     */
    function recover($id = [])
    {
        db('data')->where('id', 'in', $id)->update(['delete_time' => 0]);
        return json(['code' => 1, 'msg' => '数据恢复成功']);
    }

    /**
     * 加载模板
     */
    private function load_tpls($path)
    {
        $rs = [];
        $files = get_files(config('template.view_base') . $path);
        foreach ($files as $v) {
            $rs[] = basename($v, '.' . config('template.view_suffix'));
        }
        return $rs;
    }

    /**
     * 解析栏目
     */
    private function _column($val = '', $type = 'key')
    {
        $columns = \load_columns(0, 0, $type);
        return isset($columns[$val]) ? $columns[$val] : [];
    }

    /**
     * 空方法解析
     */
    public function _empty($name)
    {
        if (in_array($name, array('area_add', 'area_edit'))) {
            return $this->area_form(input('param.id'));
        }
        if (in_array($name, array('fields_add', 'fields_edit'))) {
            return $this->fields_form(input('param.id', 0));
        }
        if (in_array($name, array('column_add', 'column_edit'))) {
            return $this->column_form(input('param.id', 0));
        }
        if (in_array($name, array('add', 'edit'))) {
            if (!input('?param.cid')) $this->error('目标栏目错误');
            return $this->form(input('param.cid'), input('param.id', 0));
        }
        return parent::_empty($name);
    }


    /**
     * 系统设置
     */
    public function setting($cache_id = 'cfg')
    {
        return parent::setting($cache_id);
    }

    public function group_data($data = '', $field = 'create_time')
    {
        if (!empty($data)) {
            for ($i = 6; $i >= 0; $i--) {
                $time[] = [strtotime(date('Y-m-d', time() - ($i + 1) * 24 * 3600)), strtotime(date('Y-m-d', time() - $i * 24 * 3600))];
            }
            $result = array_fill(0, 7, '0');
            foreach ($data as $k => $v) {
                foreach ($time as $kk => $vv) {
                    if ($v[$field] >= $vv[0] && $v[$field] <= $vv[1]) {
                        $result[$kk] += 1;
                        continue;
                    }
                }
            }
        } else {
            $result = array_fill(0, 7, '0');
        }
        return $result;
    }

    /**
     * 发送整改信息
     */
    public function send_modify()
    {
        $rule = ['content' => 'require|max:500', 'id' => 'require|number', 'module' => 'require'];
        $data = request()->only(['module', 'content', 'id']);
        $result = $this->validate($data, $rule);
        if (true !== $result) {
            return json(['code' => 0, 'message' => $result]);
        }
        $rs = db($data['module'])->field('uid')->where('id', $data['id'])->find();
        $param = [$rs['uid'], $data['module'], $data['content']];
        Hook::listen('message', $param);
        return json(['code' => 1, 'message' => '发送成功']);
    }

    /** 举报详情信息
     * @return mixed
     */
    public function report_detail()
    {
        $param = request()->only('module,id');
        $data = Report::where($param)
            ->order('create_time desc')
            ->paginate();
        return json(['code' => 1, 'data' => $data]);
    }

    /**
     * 删除反馈
     * @param array $id
     */
    function feedback_delete($id = [])
    {
        $where = [];
        if ($id) {
            $where [] = ['id', 'in', (array)$id];
        }
        model('app\index\model\Feedback')->where($where)->delete();
        return json(['code' => 1, 'msg' => '删除成功']);
    }


    /**
     * 反馈回复
     * @return \think\response\Json
     */
    function feedback_reply()
    {
        $data = input('post.');
        $result = $this->validate($data, [
            'feedback_id' => 'require',
            'content' => 'require',
            'type' => 'require'
        ], [
            'feedback_id.require' => '请选择要回复的反馈信息',
            'content.require' => '回复内容不能为空',
            'type.require' => '请选择回复方式',
        ]);
        if ($result !== true) $this->error($result);
        $feedback = action('index/admin/feedback', [[
            'id' => $data['feedback_id'],
            'with' => 'user'
        ], 0]);
        if ($feedback['status'] == 2) return json(['code' => 0, 'msg' => '您已回复']);
        //type: 1站内信，2邮箱
        $type = $data['type'];
        if (is_array($data['type'])) {
            $data['type'] = join(',', $data['type']);
        }
        $data['admin_id'] = session('admin.id');
        foreach ((array)$type as $k => $v) {
            if ($v == 1) {
                $message = [
                    'content' => $data['content'],
                    'user_id' => $feedback['user_id'],
                    'extend' => [
                        'id' => $data['feedback_id']
                    ]
                ];
                action('message/api/send', [$message]);
            }
            if ($v == 2) {
                $email = ($this->validate(['email' => $feedback['linkway']], ['email' => 'require|email']) === true) ? $feedback['linkway'] : (empty($feedback['user']['email']) ? '' : $feedback['user']['email']);
                if ($email) {
                    $attr['email'] = $email;
                    $attr['type'] = 'reply';
                    $attr['data'] = ['content' => $data['content']];
                    action('user/api/send_email', [$attr]);
                }
            }
        }
        model('app\index\model\Feedback')->where('id', '=', $data['feedback_id'])->update(['status' => 2]);
        return json(['code' => 1, 'msg' => '回复成功']);
    }

    /**
     * 导出栏目
     * @param array $id
     */
    function export($id = [])
    {
        if (!empty($id)) {
            $file_name = '栏目配置' . date('Y-m-d');
            if (is_string($id)) $id = explode(',', $id);
            $column = model('column')->with('fields')->where('id', 'in', $id)->select()->toArray();
            if (!empty($column)) {
                $data = [];
                foreach ($column as $k => $v) {
                    $data[$k] = [
                        'model' => $v['model'] ?: ' ',
                        'name' => $v['name'] ?: ' ',
                        'key' => $v['key'] ?: ' ',
                        'title' => $v['title'] ?: ' ',
                        'keywords' => $v['keywords'] ?: ' ',
                        'description' => $v['description'] ?: ' ',
                        'url' => $v['url'] ?: ' ',
                        'setting' => $v['setting'] ? json_encode($v['setting']) : ' ',
                        'list_order' => $v['list_order'],
                        'status' => $v['status'],
                        'fields' => $v['fields'] ? json_encode($v['fields']) : ' '
                    ];
                }
                $this->save_excel($file_name, ['模型', '名称', '标识', '标题', '关键字', '描述', '链接', '栏目配置', '列表排序', '状态', '扩展字段'], $data);
            }
        }
        return json(['code' => 0, 'msg' => '请选择要导出的数据']);
    }

    /**
     * 导入栏目
     */
    function import()
    {
        if (request()->isPost()) {
            $files = request()->file();
            if (!empty($files)) {
                $fileinfo = $files['file']->getInfo();
                $result = $this->load_excel($fileinfo['tmp_name']);
                if (!empty($result)) {
                    $field = ['model', 'name', 'key', 'title', 'keywords', 'description', 'url', 'setting', 'list_order', 'status', 'fields'];
                    try {
                        foreach ($result as $k => $v) {
                            $data = array_combine($field, array_values($v));
                            $column [] = $data;
                        }
                        return json(['code' => 1, 'data' => [
                            'data' => $column,
                            'columns' => columns_to_array(load_columns())
                        ]]);
                    } catch (\Exception $e) {
                        return json(['code' => 0, 'msg' => '导入文件格式错误']);
                    }
                } else {
                    return json(['code' => 0, 'msg' => '导入数据为空']);
                }
            }
            $column = input('post.column/a', '');
            if (!empty($column)) {
                if (count($column) != count(array_column($column, 'key'))) return json(['code' => 0, 'msg' => '栏目标识不能为空']);
                foreach ($column as $k => &$v) {
                    if (empty($v['name']) || empty($v['key'])) return json(['code' => 0, 'msg' => '栏目名称和标识不能为空,请检查后重试....']);
                    if (!empty($v['setting'])) $v['setting'] = json_decode($v['setting'], 1);
                    if (!empty(trim($v['fields']))) {
                        $fields[$v['key']] = $v['fields'];
                    }
                    unset($column[$k]['fields']);
                }
                $key = array_column($column, 'key');
                if (!empty($key)) {
                    $data = db('column')->where('key', 'in', $key)->column('key');
                    $intersect = array_intersect($key, $data);
                    if (!empty($intersect)) return json(['code' => 0, 'msg' => '栏目标识不能重复，请更改标识【' . join(',', $intersect) . '】']);
                }
                //写入栏目
                model('app\index\model\Column')->saveAll($column);
                //写入栏目自定义字段
                if (!empty($fields)) {
                    $column = db('column')->where('key', 'in', array_keys($fields))->column('id', 'key');
                    $fields_data = [];
                    foreach ($fields as $k => $v) {
                        $v = json_decode($v, 1);
                        foreach ($v as $kk => $vv) {
                            unset($v[$kk]['id']);
                            $v[$kk]['column_id'] = $column[$k];
                        }
                        $fields_data = array_merge($fields_data, $v);
                    }
                    model('app\index\model\Fields')->insertAll($fields_data);
                }
                \load_columns(0, 1);
                return json(['code' => 1, 'msg' => '栏目导入成功']);
            }
        }
    }

    /**
     * 返回配置项
     */
    function configs()
    {
        return json(['code' => 1, 'data' => [
            'search' => config('app.search'),
            'reply' => config('app.reply'),
            'feedback_status' => config('app.feedback_status'),
            'report' => config('app.report'),
            'fields_types' => config('app.fields')['types']]
        ]);
    }

    /**
     * 反馈数据
     * @param array $attr
     * @param int $return
     * @return array|null|\PDOStatement|string|\think\Model|\think\response\Json
     */
    function feedback($attr = [], $return = 1)
    {
        if (is_string($attr)) $attr = json_decode($attr, 1);
        $where = [];
        if (isset($attr['start_time']) && isset($attr['end_time'])) {
            $where[] = ['create_time', 'between', [strtotime($attr['start_time']), strtotime($attr['end_time'])]];
        } else {
            if (isset($attr['start_time'])) {
                $where[] = ['create_time', '>', strtotime($attr['start_time'])];
            }
            if (isset($attr['end_time'])) {
                $where[] = ['create_time', '<', strtotime($attr['start_time'])];
            }
        }
        if (isset($attr['status'])) {
            $where[] = ['status', '=', $attr['status']];
        }
        if (isset($attr['keyword'])) {
            $where[] = ['title', 'like', '%' . $attr['keyword'] . '%'];
        }
        $with = isset($attr['with']) ? $attr['with'] : '';
        $feedback = model('app\index\model\Feedback')->where($where)->order('create_time desc')->with($with);
        if (isset($attr['tags'])) {
            $feedback = $feedback->where('find_in_set(\'' . $attr['tags'] . '\',tags)');
        }
        $limit = isset($attr['limit']) ? intval($attr['limit']) : 20;
        $page = isset($attr['page']) ? intval($attr['page']) : 1;
        if (isset($attr['id'])) {
            $rs = $feedback->where('id', $attr['id'])->find();
        } else {
            $rs = $feedback->paginate($limit, false, ['page' => $page])->toArray();
        }
        $rs['tags'] = [];
        if ($page == 1 && !isset($attr['id'])) {
            $rs['tags'] = action('index/api/feedback_tags')->getData()['data'];
        }
        return $return ? json(['code' => 1, 'data' => $rs]) : $rs;
    }

}
