<?php
/**
 * +------------------------------------------------------------
 * | 数据-入口 (index/controller/Index.php)
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-01-09 10:58:53
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 11:29:53
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\controller;

class Index extends Module
{

    protected function initialize()
    {
        parent::initialize();
        //解析栏目
        self::$columns = \load_columns(0);

        if (!empty(self::$column)) {
            $this->assign('column', self::$column);
            //解析地区
            if (self::$column['model'] == 'info') {
                self::$areas = \load_areas(0);
                if (input('param.area') && isset(self::$areas[input('param.area')])) self::$area = self::$areas[input('param.area')];
                $this->assign('area', self::$area);
            }
        }
        if (in_array(self::$sys['action'], ['view', 'column'])) $this->check_login();
    }

    /**
     * 栏目
     */
    public function column($key)
    {
        //检测栏目
        if (!empty(self::$column)) {
            if (self::$column['model'] != 'common') {
                $attr = ['cid' => self::$column['id'], 'model' => self::$column['model'], 'page' => input('param.page', 1), 'limit' => self::$column['setting']['pagesize']];
                if (self::$column['model'] == 'info') {
                    $attr['order'] = 'top_end_time desc,create_time desc';
                }
                $attr['where'] = $this->filters('lists');
                $attr['where'][] = ['status', '=', 1];
                self::$temp = $this->load_fields(self::$column['id'], 0, 1);
                $this->assign('fields', self::$temp);
                $rs = $this->query($attr);
                if (self::$column['model'] != 'pages') {
                    if (!empty($rs['data'])) $rs['data'] = $this->_init_data($rs['data']);
                    $this->init_pager($rs['total'], self::$column['setting']['pagesize']);
                    $this->assign('data', $rs['data']);
                } else {
                    $this->assign('data', $rs);
                }
            }
            $tpl = $this->_template('column');
            return view($tpl);
        }
        //检测模板
        if (template_exists($key)) return view(template_exists($key));
        return $this->_404();
    }

    /**
     * 搜索
     */
    public function search()
    {
        if (empty(input('param.keyword'))) $this->redirect(url('/'));
        if (!empty($_GET)) {
            $input = input('get.');
            $get = $_GET;
            $param = array_merge($input, $get);
            $this->redirect(url('index/index/search', $param));
        }
        $rs = $this->_search(input('param.'));
        $data = $rs['data'];
        $this->init_pager($data['total']);
        if (!empty($data['data'])) $data['data'] = $this->_init_data($data['data']);
        if (!empty($rs['column'])) {
            $filters['columns'] = ['cid', '栏目', array_column($rs['column'], null, 'column_id')];
        }
        if (!empty($rs['area'])) {
            $filters['area'] = ['area', '地区', array_column($rs['area'], null, 'area_id')];
        }
        $filters = empty($filters) ? [] : $this->init_filters($filters);
        return view('../search', [
            'data' => $data['data'],
            'keyword' => input('param.keyword'),
            'filters' => $filters
        ]);
    }

    /**
     * 详情
     */
    public function view($key, $id = '')
    {
        if (!$id) return $this->column($key);
        $with = '';
        $where = '';
        if (isset(self::$column['model'])) {
            if (isset(self::$models[self::$column['model']]['table'])) {
                $with = join(',', self::$models[self::$column['model']]['table']);
            }
        }
        $rs = model('app\index\model\Data');
        if (!empty(session('admin.id'))) $rs = $rs->withTrashed();
        $rs = $rs->with($with)->where($where)->find($id);
        if (!empty($rs->image)) $this->_init_image($rs->image);
        if (empty(self::$column)) {
            self::$column = load_column($rs['column_id']);
            if (!empty(self::$column)) {
                $this->assign('column', self::$column);
            } else {
                return $this->_404();
            }
        }
        if (empty($rs)) return $this->_404();
        $rs['url'] = $this->_url($id, $key);
        $rs['time'] = time_format($rs['create_time']);
        if (!empty($rs['behavior'])) $rs['behavior'] = json_decode($rs['behavior'], 1);
        if (self::$column['model'] == 'article') {
            if (isset($rs['article']['keywords']) && !empty($rs['article']['keywords'])) {
                $this->assign('tags', tags($rs['article']['keywords']));
            } else {
                $this->assign('tags', []);
            }
        }
        $rs['fields'] = $this->_init_fields($rs['fields'], $this->load_fields($rs['column_id']));
        $this->assign('rs', $rs->toArray());
        return view($this->_template('view'));
    }

    /**
     * 发布信息
     */
    public function add($id = 0)
    {
        if (!empty(self::$column)) {
            if (self::$column['setting']['group'][self::$user['group_id']]['add_limit'] < 0) {
                $this->error('您暂时不能在《' . self::$column['name'] . '》发布信息。');
            }
        }
        if (!action('index/api/allow_area')) $this->error('当前区域禁止发布，请联系管理员...');
        if (request()->isPost()) {
            $data = request()->except(['create_time', 'update_time']);
            if (!$id) $data['id'] = $id;
            $rs = $this->_add($data);
            if ($rs['code'] == 1) {
                return $this->redirect(url('index/index/add', ['key' => self::$column['key'], 'id' => $rs['id']]));
            } else {
                return $this->error('出了点问题，重新提交试试。问题原因：' . $rs['msg']);
            }
        } else {
            $step = 1;
            if (!empty(self::$column)) {
                if (input('param.id')) {
                    $step = 3;
                } else {
                    $step = 2;
                    $before = $this->before_add();
                    if (!empty($before)) $this->error($before['msg']);
                    if (isset(self::$column['setting']['group'][self::$user['group_id']]['upload_limit'])) {
                        $this->assign('upload_limit', self::$column['setting']['group'][self::$user['group_id']]['upload_limit']);
                    } else {
                        $this->assign('upload_limit', 3);
                    }
                    $this->assign('fields', $this->load_fields(self::$column['id']));
                }
            }
            return view('../add', [
                'step' => $step,
                'columns' => action('api/columns', ['use' => 'form', 'return' => 0]),
                'areas' => \load_areas(),
            ]);
        }
    }


    /**
     * 筛选项
     */
    private function filters($type = 'lists')
    {
        $columns = load_columns();
        $areas = load_areas();
        $ops = [];
        $where = [];
        $params = input('param.');
        if (!empty($areas)) {
            $ops['area'] = ['area', '区域', $areas];
            if (isset($areas[self::$area['id']]['child'])) {
                $ops['area'] = ['area', $areas[self::$area['id']]['name'], $areas[self::$area['id']]['child']];
            }
            if (self::$area['parent_id'] > 0) {
                $ops['area'] = ['area', $areas[self::$area['parent_id']]['name'], $areas[self::$area['parent_id']]['child']];
            }
            if (isset($params['area'])) {
                $areas = load_areas(1);
                if (!empty($areas[$params['area']]['child'])) {
                    $area_ids = array_merge([$params['area']], array_keys($areas[$params['area']]['child']));
                    $where[] = ['area_id', 'in', $area_ids];
                } else {
                    $where[] = ['area_id', '=', $params['area']];
                }
            }
        }
        //处理自定义字段条件  TODO  BUG待解决 2018.06.06
        $fields = $this->load_fields(self::$column['id']);
        foreach ($fields as $k => $v) {
            if ($v['type'] > 0 && isset($v['options'])) $ops[$v['key']] = [$v['key'], $v['name'], $v['options']];
            if (isset($params[$v['key']])) $where[] = ['fields->' . $v['key'], '=', $params[$v['key']]];
        }
        $filters = [
            $type => $this->init_filters($ops),
        ];
        $this->assign('filters', $filters);
        return $where;
    }

    /**
     * 空方法解析
     */
    public function _empty($name)
    {
        //检测模板
        if (template_exists($name)) return view(template_exists($name));
        return $this->_404();
    }

    /**
     * 解析数据
     */
    protected function _init_data($rs)
    {
        foreach ($rs as $key => &$v) {
            $v['column'] = self::$columns[$v['column_id']];
            $v['url'] = url('index/index/view', ['key' => $v['column']['key'], 'id' => $v['id']]);
            if (isset($v['area_id'])) $v['area'] = empty(self::$areas[$v['area_id']]) ? '' : self::$areas[$v['area_id']];
            if (!empty($v['behavior'])) $v['behavior'] = json_decode($v['behavior'], 1);
            if (!empty($v['fields'])) {
                $v['fields'] = $this->_init_fields($v['fields'], $this->load_fields($v['column_id'], 0, 1));
            }
            $v['thumb'] = action('files/api/_init_thumb', [$v['thumb']]);
            $v['time'] = time_format($v['create_time']);
            $v['end_time'] = $v['end_time'] ? time_format($v['end_time']) : '';
        }
        return $rs;
    }

    /**
     * 解析模板
     */
    private function _template($type, $column = [])
    {
        if (!empty(self::$column['setting']['template'][$type])) return '../' . $type . '/' . self::$column['setting']['template'][$type];
        return '../' . $type . '/' . self::$column['model'];
    }

    /**
     * 信息置顶
     */
    function top($id = 0, $cid = 0)
    {
        $info = $this->query([
            'id' => $id,
            'cid' => $cid,
            'where' => ''
        ]);
        if (!empty($info)) {
            $info['top_money'] = $this->_init_top_money();
        }
        return view('../top', [
            'rs' => empty($info) ? [] : $info
        ]);
    }

    /**
     * 红包
     */
    function redpacket($id = 0, $cid = 0)
    {
        $info = $this->query([
            'id' => $id,
            'cid' => $cid,
            'where' => ''
        ]);
        return view('../redpacket', [
            'rs' => empty($info) ? [] : $info
        ]);
    }

}
