<?php
/**
 * +------------------------------------------------------------
 * | 数据 data/model/Data.php
 * +------------------------------------------------------------
 * | @author: zhx (10630650@qq.com)
 * | @create_time: 2018-03-09 15:48:38
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: zhx
 * | @last_modified_time: 2018-03-09 15:48:38
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\index\model;

use app\common\model\Init;
use think\model\concern\SoftDelete;

class Data extends Init
{
    use SoftDelete;

    private static $areas = [];

    // 设置json类型字段
    protected $json = ['fields'];

    // 设置JSON数据返回数组
    protected $jsonAssoc = true;

    protected $auto = ['thumb'];

    protected $deleteTime = 'delete_time';

    protected $defaultSoftDelete = 0;

    protected $append = ['area'];

    protected static function init()
    {
        self::$areas = load_areas(0);
    }

    public function image()
    {
        return $this->hasMany('Image');
    }

    public function article()
    {
        return $this->hasOne('Article');
    }

    public function info()
    {
        return $this->hasOne('Info');
    }

    public function phone()
    {
        return $this->hasOne('Phone');
    }

    public function links()
    {
        return $this->hasOne('Links');
    }

    /**
     * 处理地区字段
     */
    public function getAreaAttr($value, $data)
    {
        if (isset(self::$areas[$data['area_id']])) return self::$areas[$data['area_id']];
        return ['id' => '', 'name' => ''];
    }

    public function getThumbAttr($value)
    {
        return action('files/api/_init_thumb', [$value]);
    }

    public function setThumbAttr($value)
    {
        if ($value == '' || $value == config('files.url') . config('files.nopic')) {
            return '';
        } else {
            if (config('files.engine')['name'] == 'qiniu') {
                return ltrim($value, config('files.qiniu')['domain'] . '/');
            } else {
                return ltrim($value, config('files.url'));
            }
        }
    }

    public function setEndTimeAttr($value)
    {
        return is_numeric($value) ? (time() + $value * 86400) : 0;
    }

    public function getEndTimeAttr($value, $data)
    {
        return $value ? time_format($data['end_time']) : 0;
    }

    public function getEndTimeDayAttr($value, $data)
    {
        return $data['end_time'] < time() ? 0 : (ceil(($data['end_time'] - time()) / 86400));
    }

}
