<?php

/**
 * +------------------------------------------------------------
 * | 用户 user/controller/Api.php
 * +------------------------------------------------------------
 * | @author: bsh (844783437@qq.com)
 * | @create_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @copyright: CIM城市信息聚合系统 http://cim.wandu.net
 * +------------------------------------------------------------
 * | @last_modified_by: bsh
 * | @last_modified_time: 2018-04-28 19:14:25
 * +------------------------------------------------------------
 * | @todo:
 * +------------------------------------------------------------
 */

namespace app\user\controller;


use think\Hook;
use think\facade\Env;
use think\Request;
use app\common\controller\Check;
use app\common\controller\Mail;
use app\common\controller\Sms;
use think\captcha\Captcha;
use think\Validate;
use app\common\controller\QRcode;

class Api extends Module
{
    function read($attr = [])
    {
        if (!isset($attr['id']) && empty(session('user.id'))) {
            return json(['code' => 1000, 'msg' => '请登录...']);
        }
        return json($this->query($attr));
    }

    /**
     * 用户头像
     */
    function avatar($id)
    {
        $id = $id ?: session('user.id');
        $path = 'avatar/' . ceil($id / 10000) . '/' . $id . '.png?rand=' . rand(1, 100);
        return action('files/api/_init_thumb', [$path, 1]);
    }

    /**
     * 创建日志
     * @param array $ops
     */
    function log($event, $memo = '', $user_id = 0)
    {
        if (empty($event) || (empty(session('user')) && empty($user_id)))
            return;
        $ops['event'] = $event;
        $ops['memo'] = $memo;
        $ops['user_id'] = session('user.id') ?: $user_id;
        $ops['module'] = self::$sys['module'];
        $ops['action'] = self::$sys['action'];
        $ops['ip'] = self::$sys['ip'];
        $ops['port'] = input('server.REMOTE_PORT');
        $ops['os'] = get_client_os();
        $ops['browser'] = get_client_browser();
        $ops['create_time'] = time();
        return db('user_log')->insert($ops);
    }

    /**
     * 发送短信
     */
    function send_sms($type = '', $content = '', $phone = '', $gateways = [], $verify = '')
    {
        $sms = new Sms();
        $validate = new Validate([
            'type' => 'require',
            'phone' => 'require',
            'verify' => 'require'
        ], [
            'type.require' => '短信类型不能为空',
            'phone.require' => '手机号不能为空',
            'verify.require' => '验证码不能为空'
        ]);
        $data = [
            'phone' => $phone,
            'verify' => $verify,
            'content' => $content,
            'type' => $type,
            'gateways' => $gateways
        ];
        if ($validate->check($data) !== true) {
            return json(['code' => 0, 'msg' => $validate->getError()]);
        }
        return json($sms->phone($phone)->type($type)->content($content)->gateways($gateways)->verify($verify)->send());
    }

    /**
     * 发送邮件
     */
    function send_email($attr = [], $return = 1)
    {
        if ($this->validate($attr, ['email' => 'require|email', 'type' => 'require']) !== true) {
            $result = ['code' => 0, 'msg' => '请检查邮件格式'];
        } else {
            $mail = new Mail();
            $data = empty($attr['data']) ? '' : $attr['data'];
            $result = $mail->address($attr['email'])->type($attr['type'], $data)->send();
        }
        return $return ? json($result) : $result;
    }

    /**
     * 异步验证手机
     */
    public function check_phone($phone = '')
    {
        if (!request()->isAjax())
            halt('页面不存在');
        $where = array('phone' => $phone);
        $count = db('user')->where($where)->count();
        if ($count)
            echo '手机号已被注册，请更换。';
    }

    /**
     * 异步验证用户名
     */
    public function check_name($name = '')
    {
        if (!request()->isAjax())
            halt('页面不存在');
        $where = ['name' => $name];
        if (db('user')->where($where)->count()) {
            echo '用户名已被注册，请更换。';
        }
    }

    /**
     * 异步验证手机
     */
    public function check_forget_phone($name = '')
    {
        if (!request()->isAjax())
            halt('页面不存在');
        $where = array('phone' => $name);
        $count = db('user')->where($where)->count();
        if (!$count)
            echo '该手机号未注册，请先注册。';
    }

    /**
     * 异步校验验证码
     */
    public function check_captcha($captcha = '')
    {
        if (!request()->isAjax())
            halt('页面不存在');
        if (!captcha_check($captcha)) {
            echo '您输入的验证码错误';
        }
    }

    /**
     * 异步验证身份证
     */
    public function check_id_card($id_card = '')
    {
        if (!request()->isAjax())
            halt('页面不存在');
        $where = array('id_card' => $id_card);
        $where['status'] = 3;
        $count = db('user_auth')->where($where)->count();
        if ($count)
            echo '该身份证已绑定用户';
    }

    /**
     * 统一注册接口
     * 参数：注册方式，注册数据
     */
    function register($type = '', $attr = [], $json = 1)
    {
        if (!empty($this->user_setting['close_register'])) {
            if (!empty($type) && !empty($attr)) {
                if (!empty($attr['email'])) {
                    if (db('user')->where('email', $attr['email'])->count()) {
                        $result = ['code' => 0, 'msg' => '邮箱已被注册，请修改后重试...'];
                    }
                }
                if (!empty($attr['phone'])) {
                    if (db('user')->where('phone', $attr['phone'])->count()) {
                        $result = ['code' => 0, 'msg' => '手机号已被注册，请修改后重试...'];
                    }
                }
                if (empty($result)) {
                    switch ($type) {
                        case 1:
                            $filter_result = filter_words($attr['name'], 'register', 'forbid');
                            if (empty($filter_result['level'])) {
                                if (db('user')->where('name', $attr['name'])->count('name')) {
                                    $result = ['code' => 0, 'msg' => '用户名已被占用，请修正后重试..'];
                                } else {
                                    $status = 1;
                                    if (!empty($this->user_setting['reg_check'])) {
                                        if (empty($attr['captcha']) || !captcha_check($attr['captcha'])) {
                                            $status = 0;
                                        }
                                    }
                                    if ($status) {
                                        unset($attr['captcha']);
                                        //账号，邮箱，手机号注册
                                        $validate = validate('Register');
                                        if ($validate->check($attr)) {
                                            $attr['pwd'] = pwd_md5($attr['pwd']);
                                            $attr['group_id'] = 1;
                                            $attr['status'] = 1;
                                            unset($attr['repwd']);
                                            unset($attr['agreed']);
                                            if (!$id = db('user')->insertGetId($attr)) {
                                                $result = ['code' => 0, 'msg' => '注册失败,请重试...'];
                                            } else {
                                                $result = ['code' => 1, 'msg' => '注册成功'];
                                            }
                                        } else {
                                            $result = ['code' => 0, 'msg' => $validate->getError()];
                                        }
                                    } else {
                                        $result = ['code' => 0, 'msg' => '验证码输入错误'];
                                    }
                                }
                            } else {
                                $result = ['code' => 0, 'msg' => '包含敏感词【' . join(',', $filter_result['words']['3']) . '】，禁止注册'];
                            }
                            break;
                        case 2:
                            $msg = $this->validate($attr, ['type' => 'require', 'openid' => 'require'], ['type.require' => '请选择登录方式', 'openid.require' => '参数错误']);
                            if ($msg === true) {
                                $oauth = model('app\user\model\Oauth')->where('type', $attr['type'])->where('openid', $attr['openid'])->find();
                                if (empty($oauth)) {
                                    $user_data = [
                                        'name' => empty($attr['name']) ? '' : ($attr['name'] . rand(1, 99999)),
                                        'pwd' => empty($attr['pwd']) ? '' : pwd_md5($attr['name']),
                                        'email' => empty($attr['email']) ? '' : $attr['email'],
                                        'phone' => empty($attr['phone']) ? '' : $attr['phone'],
                                        'group_id' => 1,
                                        'status' => 1
                                    ];
                                    $id = db('user')->insertGetId($user_data);
                                    $oauth_data = [
                                        'user_id' => $id,
                                        'openid' => $attr['openid'],
                                        'type' => $attr['type'],
                                        'nickname' => $attr['name']
                                    ];
                                    db('user_oauth')->insert($oauth_data);
                                    $result = ['code' => 1, 'msg' => '注册成功'];
                                } else {
                                    $result = ['code' => 0, 'msg' => '已注册，请直接登录...'];
                                }
                            } else {
                                $result = ['code' => 0, 'msg' => '注册失败'];
                            }
                            break;
                        default :
                            $result = ['code' => 0, 'msg' => '注册失败'];
                    }
                }
            } else {
                $result = ['code' => 0, 'msg' => '注册失败'];
            }
        } else {
            $result = ['code' => 0, 'msg' => '系统暂时关闭了注册，请稍后再来。'];
        }
        if ($result['code'] == 1) {
            $this->log('用户注册', '', $id);
            $result['data'] = model('app\user\model\User')::with('register')->where('id', $id)->find()->append(['login'])->toArray();
            $result['data']['token'] = get_token($result['data']);
            session('user', $result['data']);
            //执行注册相关行为
            //注册赠送积分
            if (!empty($this->user_setting['register_credit'])) {
                $credit = intval($this->user_setting['register_credit']);
                $attr = [
                    'balance' => 1,
                    'money' => $credit,
                    'user_id' => $id,
                    'payment' => 4,
                    'type' => 0,
                    'memo' => '注册赠送【' . $credit . '】积分'
                ];
                //创建赠送积分订单
                $order = action('finance/api/order', [$attr, 0]);
                if ($order['code'] == 1) {
                    //进行支付
                    action('finance/api/credit', [['order' => $order['order']]]);
                }
            }
        }
        return $json ? json($result) : $result;
    }

    /**
     * 统一登录入口
     * 参数：类型，凭证
     * 类型：1，凭证：账号，密码
     * 类型：2，凭证：openid,oauth_type
     */
    function login($type = '', $attr = [], $json = 1)
    {
        if (!empty($type) && !empty($attr)) {
            switch ($type) {
                case 1:
                    $status = 1;
                    if (!empty($this->user_setting['login_check']) && !self::$sys['is_mobile']) {
                        if (empty($attr['captcha']) || !captcha_check($attr['captcha'])) {
                            $status = 0;
                        }
                    }
                    if (!$status) {
                        $result = ['code' => 0, 'msg' => '验证码错误'];
                    } else {
                        $msg = $this->validate($attr, ['name' => 'require', 'pwd' => 'require'], ['name.require' => '请填写用户名', 'pwd' => '请填写密码']);
                        if ($msg === true) {
                            $where['name'] = $attr['name'];
                            $where['pwd'] = pwd_md5($attr['pwd']);
                            $info = model('app\user\model\User')->with('register')->where($where)->field('pwd', true)->find();
                            if (!empty($info)) {
                                $result = ['code' => 1, 'msg' => '登录成功', 'data' => $info->append(['login'])->toArray()];
                            } else {
                                $result = ['code' => 0, 'msg' => '用户不存在或密码错误'];
                            }
                        } else {
                            $result = ['code' => 0, 'msg' => $msg];
                        }
                    }
                    break;
                case 2:
                    $msg = $this->validate($attr, ['openid' => 'require', 'oauth_type' => 'require'], ['openid.require' => '缺少登录凭证', 'oauth_type' => '登录凭证类型错误']);
                    if ($msg === true) {
                        $oauth = model('app\user\model\Oauth');
                        $where['type'] = $attr['oauth_type'];
                        $where['openid'] = $attr['openid'];
                        $info = $oauth->where($where)->find();
                        if (!empty($info)) {
                            $user_id = $info['user_id'];
                            $info = model('app\user\model\User')->with('register')->where('id', $user_id)->find();
                            if (!empty($info)) {
                                $result = ['code' => 1, 'msg' => '登录成功', 'data' => $info->append(['login'])->toArray()];
                            } else {
                                $result = ['code' => 0, 'msg' => '登录失败'];
                            }
                        } else {
                            $result = ['code' => 0, 'msg' => '用户不存在'];
                        }
                    } else {
                        $result = ['code' => 0, 'msg' => $msg];
                    }
                    break;
                default :
                    $result = ['code' => 0, 'msg' => '用户登录失败'];
            }
        } else {
            $result = ['code' => 0, 'msg' => '用户登录失败'];
        }

        if ($result['code'] == 1) {
            session('user', $result['data']);
            $this->log('用户登录');
            //todo 不参与主体逻辑的用behavior
            //执行用户组相关行为
            $group = array_column($this->group(['id' => $info['group_id']]), null, 'id')[$info['group_id']];
            $allow_login = 1;
            if (!empty($group['setting'])) {
                $group['setting'] = json_decode($group['setting'], 1);
                if (isset($group['setting']['base']['allow_login']) && empty($group['setting']['base']['allow_login'])) $allow_login = 0;
            }
            //判断用户组禁止登录
            if (empty($allow_login) || session('user.status') == 0) {
                session('user', null);
                $result = ['code' => 0, 'msg' => '该用户禁止登录,请联系管理员....'];
            } else {
                $result['data']['token'] = get_token($result['data']);
                if (empty(session('user')['login']['create_time']) || session('user')['login']['create_time'] < strtotime(date('Y-m-d'))) {
                    //判断登录送积分
                    if (!empty($group['setting']->credit->login)) {
                        $credit = intval($group['setting']->credit->login);
                        $attr = [
                            'balance' => 1,
                            'money' => $credit,
                            'user_id' => $info['id'],
                            'type' => '0',
                            'payment' => '4',
                            'memo' => '登录赠送【' . $credit . '】积分'
                        ];
                        //创建赠送积分订单
                        $order = action('finance/api/order', [$attr, 0]);
                        if ($order['code'] == 1) {
                            //进行支付
                            action('finance/api/credit', [['order' => $order['order']]]);
                        }
                    }
                }
            }
        }
        return $json ? json($result) : $result;
    }

    /**
     * 获得用户组
     * @param array $attr
     * @return \think\response\Json
     */
    function group($refresh = 0, $group_id = [], $status = [])
    {
        $key = 'user_group';
        if ($refresh) cache($key, null);
        if (!empty(cache($key))) {
            $rs = cache($key);
        } else {
            $group = model('app\user\model\Group');
            $rs = $group->select()->toArray();
            $config = include(Env::get('app_path') . 'user' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'app.php');
            $sys_group = array_column($config['group'], null, 'id');
            if (!empty($rs)) {
                $rs = array_column((array)$rs, null, 'id');
                $rs = array_values(array_replace($sys_group, $rs));
            } else {
                $rs = $sys_group;
            }
            cache($key, $rs);
        }
        if (!empty($rs)) {
            $data = [];
            if (!empty($status)) {
                foreach ($rs as $k => $v) {
                    if (in_array($v['status'], (array)$status)) $data[] = $v;
                }
                $rs = $data;
            }
            if (!empty($group_id)) {
                foreach ($rs as $k => $v) {
                    if (in_array($v['id'], (array)$group_id)) $data[] = $v;
                }
                $rs = $data;
            }

        }
        return $rs;
    }

    /**
     * 验证码
     * @return \think\Response
     */
    function captcha()
    {
        $config = [
            'length' => 3,
            'codeSet' => '0123456789'
        ];
        $captcha = new Captcha($config);
        return $captcha->entry();
    }

    /*
     * 用户解绑手机号
     */
    function unbind_phone($attr = [], $return = 1)
    {
        $attr['user_id'] = session('user.id');
        $validate = $this->validate($attr, [
            'phone' => 'require|mobile',
            'user_id' => 'require',
        ], [
            'phone.require' => '手机号码不能为空',
            'user_id.require' => '请登录',
            'phone.mobile' => '手机号格式错误'
        ]);
        if ($validate === true) {
            if (db('user')->where('id', session('user.id'))->where('phone', $attr['phone'])->find()) {
                db('user')->where('id', session('user.id'))->update(['phone' => '']);
                $result = ['code' => 1, 'msg' => '手机解绑成功'];
                $this->log('解绑手机');
            } else {
                $result = ['code' => 0, 'msg' => '输入手机号与源手机不符，请重新输入...'];
            }
        } else {
            $result = ['code' => 0, 'msg' => $validate];
        }
        return $return ? json($result) : $result;
    }

    /**
     * 用户修改密码
     */
    function pwd($attr = [], $return = 1)
    {
        $attr['user_id'] = session('user.id');
        $validate = $this->validate($attr, [
            'pwd' => 'require',
            'user_id' => 'require',
            'newpwd' => 'require',
            're_newpwd' => 'confirm:newpwd'
        ], [
            'pwd.require' => '密码不能为空',
            'user_id.require' => '请登录',
            'newpwd.require' => '新密码不能为空',
            're_newpwd.confirm' => '两次输入密码不一致'
        ]);
        if ($validate === true) {
            $pwd = db('user')->where('id', session('user.id'))->value('pwd');
            if (pwd_md5($attr['pwd']) == $pwd) {
                db('user')->where('id', $attr['user_id'])->update(['pwd' => pwd_md5($attr['newpwd'])]);
                $result = ['code' => 1, 'msg' => '密码已更新，下次可使用新密码进行登录'];
                $this->log('修改密码');
            } else {
                $result = ['code' => 0, 'msg' => '原密码不正确'];
            }
        } else {
            $result = ['code' => 0, 'msg' => $validate];
        }
        return $return ? json($result) : $result;
    }

    /*
     * 解绑邮箱
     */
    public function unbind_email($attr = [], $return = 1)
    {
        $attr['user_id'] = session('user.id');
        $validate = $this->validate($attr, [
            'email' => 'require|email',
            'user_id' => 'require',
        ], [
            'email.require' => '邮箱不能为空',
            'user_id.require' => '请登录',
            'email.email' => '邮箱格式错误'
        ]);
        if ($validate === true) {
            if (db('user')->where('id', session('user.id'))->where('email', $attr['email'])->find()) {
                db('user')->where('id', session('user.id'))->update(['email' => '']);
                $result = ['code' => 1, 'msg' => '邮箱解绑成功'];
                $this->log('解绑邮箱');
            } else {
                $result = ['code' => 0, 'msg' => '输入邮箱与原邮箱不符，请重新输入...'];
            }
        } else {
            $result = ['code' => 0, 'msg' => $validate];
        }
        return $return ? json($result) : $result;
    }

    /*
     * 用户绑定手机号
     */
    function bind_phone($attr = [], $return = 1)
    {
        $attr['user_id'] = session('user.id');
        $validate = $this->validate($attr, [
            'phone' => 'require|mobile',
            'user_id' => 'require',
            'code' => 'require'
        ], [
            'phone.require' => '手机号不能为空',
            'user_id.require' => '请登录',
            'phone.mobile' => '手机格式错误'
        ]);
        if ($validate === true) {
            if (empty(cache($attr['phone'])) || $attr['code'] != cache($attr['phone'])['code'] || cache($attr['phone'])['time'] + 180 < time()) {
                $result = ['code' => 0, 'msg' => '手机验证码错误'];
            } else {
                db('user')->where('id', session('user.id'))->update(['phone' => $attr['phone']]);
                $log = db('user_log')->where('user_id', '=', $attr['user_id'])->where('action', '=', 'bind_phone')->count();
                if (empty($log)) {
                    if (!empty($this->user_setting['bind_phone_credit'])) {
                        $credit = intval($this->user_setting['bind_phone_credit']);
                        $attr = [
                            'balance' => 1,
                            'money' => $credit,
                            'user_id' => $attr['user_id'],
                            'payment' => 4,
                            'type' => 0,
                            'memo' => '绑定手机号赠送【' . $credit . '】积分'
                        ];
                        //创建赠送积分订单
                        $order = action('finance/api/order', [$attr, 0]);
                        if ($order['code'] == 1) {
                            //进行支付
                            action('finance/api/credit', [['order' => $order['order']]]);
                        }
                    }
                }
                $this->log('绑定手机号');
                $result = ['code' => 1, 'msg' => '手机号绑定成功'];
            }
        } else {
            $result = ['code' => 0, 'msg' => $validate];
        }
        return $return ? json($result) : $result;
    }

    /**
     * 生成二维码
     */
    function qr_code($content = '')
    {
        $text = urldecode($content);
        return response(QRcode::png($text, false, QR_ECLEVEL_L, $size = 8, $margin = 2, false))->header(['Content-type' => 'image/png']);
    }

    /**
     * 根据扫码信息返回用户信息
     */
    function qrcode_user($key = '', $token = '')
    {
        if (empty($key)) return json(['code' => -2, 'msg' => '参数错误']);
        $cache_data = cache('apps_qrcode');
        if (empty($cache_data)) return json(['code' => 0, 'msg' => '非法操作']);
        $cache_data = array_column($cache_data, null, 'key');
        if (empty($cache_data[$key]) || $cache_data[$key]['time'] < time()) return json(['code' => -3, 'msg' => '二维码已失效']);
        if (!empty($token)) {
            $user = cache($token);
            if (!empty($user)) {
                cache($key, $user);
                return json(['code' => 1, 'msg' => '用户登录成功']);
            } else {
                return json(['code' => 0, 'msg' => '用户不存在']);
            }
        }
        if (!empty(cache($key))) {
            session('user', cache($key));
            //清除缓存数据
            cache($key, null);
            return json(['code' => 1, 'msg' => '登录成功']);
        } else {
            return json(['code' => 0, 'msg' => '登录失败']);
        }
    }

}
