/**
 * share 插件
 * author : zhx <10630650@qq.com>
 * 分享种类 ： QQ，QQ空间，新浪微博，豆瓣，微信
 */
;
(function($, window, document, undefined) {
    function _init(target, options) {
        var settings = $.extend({}, $.fn.share.defaults, options);
        var $share_wrap = "<span class='share_wrap'></span>";
        var $share_group = "<div class='share_group'>" +
            "<a target='_blank' class='btn-share weixin' data-target='weixin'>weixin</a>" +
            "<a target='_blank' class='btn-share weibo' data-target='weibo'>weibo</a>" +
            "<a target='_blank' class='btn-share qq' data-target='qq'>qq</a>" +
            "<a target='_blank' class='btn-share qzone' data-target='qzone'>qzone</a>" +
            "<a target='_blank' class='btn-share douban' data-target='douban'>douban</a>" +
            "</div>";
        if ($('.share_wrap').length < 1) $(target).append($share_wrap);
        $(target).append($share_group);
        $(target).addClass("share");

        $(document).on("click", ".btn-share", function() {
            _share(this, $(this).data('target'), settings);
        });

        $(document).on("click", ".share_wrap", function() {
            if ($(this).hasClass("disabled")) return;
            var e = 500; //动画时间
            var t = 250; //延迟时间
            var r = $(this).parent().find(".btn-share").length; //分享组件的个数
            var i = 60;
            var s = e + (r - 1) * t;
            var o = 1;
            var a = $(this).outerWidth();
            var f = $(this).outerHeight();
            var c = $(this).parent().find(".btn-share:eq(0)").outerWidth();
            var h = $(this).parent().find(".btn-share:eq(0)").outerHeight();
            var p = (a - c) / 2; //起始位置
            var d = (f - h) / 2; //起始位置
            var v = 0 / 180 * Math.PI;
            if (!$(this).hasClass("active")) {
                $(this).addClass("disabled").delay(s).queue(function(e) {
                    $(this).removeClass("disabled").addClass("active");
                    e()
                });
                $(this).parent().find(".btn-share").each(function() {
                    var n = p + (p + i * o) * Math.cos(v); //结束位置
                    var r = d + (d + i * o) * Math.sin(v); //结束位置
                    $(this).css({
                        display: "block",
                        left: p + "px",
                        top: d + "px"
                    }).stop().delay(t * o).animate({
                        left: n + "px",
                        top: r + "px"
                    }, e);
                    o++
                });
            } else {
                o = r;
                $(this).addClass("disabled").delay(s).queue(function(e) {
                    $(this).removeClass("disabled").removeClass("active");
                    e()
                });
                $(this).parent().find(".btn-share").each(function() {
                    $(this).stop().delay(t * o).animate({
                        left: p,
                        top: d
                    }, e);
                    o--
                });
            }
        });
    }

    function _replace(api, options) {
        api = api.replace('{url}', options.url);
        api = api.replace('{title}', options.title);
        api = api.replace('{content}', options.content);
        api = api.replace('{pic}', options.pic);
        return api;
    }

    function _share(target, type, options) {
        window.open(_replace($url[type], $.extend({}, $.fn.share.defaults, options)));
    }

    $.fn.share = function(options, param) {
        if (typeof options == 'string') {
            var method = $.fn.share.methods[(options != 'init' ? 'share' : 'init')];
            if (method)
                return method(this, options, param);
        } else {
            _init(this, options);
        }
    }
    $.fn.share.defaults = {
        url: window.location.href,
        title: document.title,
        content: $('meata[name=description]').attr('content'),
        pic: ''
    };
    $.fn.share.methods = {
        init: function(jq, options) {
            return jq.each(function() {
                _init(this, options);
            });
        },
        share: function(jq, type, options) {
            return jq.each(function() {
                _share(this, type, options);
            })
        }
    };
    var $url = {
        qzone: 'http://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?url={url}&title={title}&pics={pic}&summary={content}',
        weibo: 'http://service.weibo.com/share/share.php?url={url}&title={title}&pic={pic}&searchPic=false',
        qq: 'http://connect.qq.com/widget/shareqq/index.html?url={url}&title={title}&desc={content}&pics={pic}&summary={content}&site=',
        douban: 'http://www.douban.com/share/service?href={url}&name={title}&text={content}&image={pic}',
        weixin: 'http://qr.liantu.com/api.php?text={url}'
    };
})(jQuery, window, document);
