<?php
header("Content-type: text/html; charset=utf-8"); 

/* WordPress 后台禁用Google Open Sans字体
/* -------------------------------- */
add_filter( 'gettext_with_context', 'wpdx_disable_open_sans', 888, 4 );
function wpdx_disable_open_sans( $translations, $text, $context, $domain ) {
  if ( 'Open Sans font: on or off' == $context && 'on' == $text ) {
    $translations = 'off';
  }
  return $translations;
}

/* SSL avatar */
function um_get_ssl_avatar($avatar) {
	$avatar = preg_replace('/.*\/avatar\/(.*)\?s=([\d]+)(&?.*)/','<img src="https://secure.gravatar.com/avatar/$1?s=$2" class="avatar" height="$2" width="$2">',$avatar);	
	return $avatar;
}
add_filter( 'get_avatar', 'um_get_ssl_avatar');

/* 默认不显示工具栏
/* -------------------------------- */
add_action("user_register", "set_user_admin_bar_false_by_default", 10, 1);
function set_user_admin_bar_false_by_default($user_id) {
    update_user_meta( $user_id, 'show_admin_bar_front', 'false' );
    update_user_meta( $user_id, 'show_admin_bar_admin', 'false' );
}

/* 前台不加载语言包
/* -------------------------------- */
add_filter( 'locale', 'wpjam_locale' );
function wpjam_locale($locale) {
    $locale = ( is_admin() ) ? $locale : 'en_US';
    return $locale;
}

/* 移除wp-json链接
/* -------------------------------- */
add_filter('rest_enabled', '_return_false');
add_filter('rest_jsonp_enabled', '_return_false');
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );

/* 禁用embeds功能
/* -------------------------------- */
function disable_embeds_init() {
    /* @var WP $wp */
    global $wp;
    $wp->public_query_vars = array_diff( $wp->public_query_vars, array(
        'embed',
    ) );
    remove_action( 'rest_api_init', 'wp_oembed_register_route' );
    add_filter( 'embed_oembed_discover', '__return_false' );
    remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
    remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
    remove_action( 'wp_head', 'wp_oembed_add_host_js' );
    add_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' );
    add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
}
 
add_action( 'init', 'disable_embeds_init', 9999 );
function disable_embeds_tiny_mce_plugin( $plugins ) {
    return array_diff( $plugins, array( 'wpembed' ) );
}
function disable_embeds_rewrites( $rules ) {
    foreach ( $rules as $rule => $rewrite ) {
        if ( false !== strpos( $rewrite, 'embed=true' ) ) {
            unset( $rules[ $rule ] );
        }
    }
 
    return $rules;
}
function disable_embeds_remove_rewrite_rules() {
    add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
    flush_rewrite_rules();
}
 
register_activation_hook( __FILE__, 'disable_embeds_remove_rewrite_rules' );
function disable_embeds_flush_rewrite_rules() {
    remove_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
    flush_rewrite_rules();
}
 
register_deactivation_hook( __FILE__, 'disable_embeds_flush_rewrite_rules' );

/* 后台显示选项功能修复
/* -------------------------------- */
function Uazoh_remove_help_tabs($old_help, $screen_id, $screen){
    $screen->remove_help_tabs();
    return $old_help;
}
add_filter('contextual_help', 'Uazoh_remove_help_tabs', 10, 3 );

/* 删除emoji脚本
/* -------------------------------- */
remove_action( 'admin_print_scripts',	'print_emoji_detection_script');
remove_action( 'admin_print_styles',	'print_emoji_styles');
remove_action( 'wp_head',		'print_emoji_detection_script',	7);
remove_action( 'wp_print_styles',	'print_emoji_styles');
remove_filter( 'the_content_feed',	'wp_staticize_emoji');
remove_filter( 'comment_text_rss',	'wp_staticize_emoji');
remove_filter( 'wp_mail',		'wp_staticize_emoji_for_email');

/* 注册菜单项目
/* -------------------------------- */
register_nav_menus(
   array(
      'left-nav' => __( '主导航菜单' ),
	   'footer-nav' => __( '底部导航菜单' ),
	   'right-nav' => __( '侧边分类菜单' ),
	   'index-nav' => __( '首页列表菜单' ),
      'mini-nav' => __( '移动版菜单' )
   )
);

/* 禁止加载WP自带的jquery.js
/* -------------------------------- */
add_action( 'pre_get_posts', 'jquery_register' );
function jquery_register() {
if ( !is_admin() ) {
wp_deregister_script( 'jquery' );
wp_register_script( 'jquery', get_template_directory_uri() . '/js/jquery.js' , false, '1.1', false );
wp_enqueue_script( 'jquery' );
}
}

/* 移除头部冗余代码
/* -------------------------------- */
remove_action( 'wp_head', 'wp_generator' );// WP版本信息
remove_action( 'wp_head', 'rsd_link' );// 离线编辑器接口
remove_action( 'wp_head', 'wlwmanifest_link' );// 同上
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );// 上下文章的url
remove_action( 'wp_head', 'feed_links', 2 );// 文章和评论feed
remove_action( 'wp_head', 'feed_links_extra', 3 );// 去除评论feed
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );// 短链接

/* 高亮显示搜索词
/* -------------------------------- */
function search_word_replace($buffer){
    if(is_search()){
        $arr = explode(" ", get_search_query());
        $arr = array_unique($arr);
        foreach($arr as $v)
            if($v)
                $buffer = preg_replace("/(".$v.")/i", "<span style=\"color: #ff8598;;\"><strong>$1</strong></span>", $buffer);
    }
    return $buffer;
}
add_filter("the_excerpt", "search_word_replace", 200);
add_filter("the_content", "search_word_replace", 200);
add_filter('pre_get_posts','wpjam_exclude_page_from_search');
function wpjam_exclude_page_from_search($query) {
    if ($query->is_search) {
        $query->set('post_type', 'post');
    }
    return $query;
}

/* 评论回复添加@前缀
/* -------------------------------- */
function ludou_comment_add_at( $comment_text, $comment = '') {
  if( $comment->comment_parent > 0) {
    $comment_text = '<font color="#FF0000"><b>@</b></font><a href="#comment-' . $comment->comment_parent . '">'.get_comment_author( $comment->comment_parent ) . '</a> ' . $comment_text;
  }

  return $comment_text;
}
add_filter( 'comment_text' , 'ludou_comment_add_at', 20, 2);

/* 垃圾评论拦截
/* -------------------------------- */
class anti_spam {
	function anti_spam() {
		if ( !current_user_can('level_0') ) {
			add_action('template_redirect', array($this, 'w_tb'), 1);
			add_action('init', array($this, 'gate'), 1);
			add_action('preprocess_comment', array($this, 'sink'), 1);
		}
	}
	function w_tb() {
		if ( is_singular() ) {
			ob_start(create_function('$input','return preg_replace("#textarea(.*?)name=([\"\'])comment([\"\'])(.+)/textarea>#",
				"textarea$1name=$2w$3$4/textarea><textarea name=\"comment\" cols=\"100%\" rows=\"4\" style=\"display:none\"></textarea>",$input);') );
		}
	}
	function gate() {
		if ( !empty($_POST['w']) && empty($_POST['comment']) ) {
			$_POST['comment'] = $_POST['w'];
		} else {
			$request = $_SERVER['REQUEST_URI'];
			$referer = isset($_SERVER['HTTP_REFERER'])         ? $_SERVER['HTTP_REFERER']         : '隐瞒';
			$IP      = isset($_SERVER["HTTP_X_FORWARDED_FOR"]) ? $_SERVER["HTTP_X_FORWARDED_FOR"] . ' (透过代理)' : $_SERVER["REMOTE_ADDR"];
			$way     = isset($_POST['w'])                      ? '手动操作'                       : '未经评论表格';
			$spamcom = isset($_POST['comment'])                ? $_POST['comment']                : null;
			$_POST['spam_confirmed'] = "请求: ". $request. "\n来路: ". $referer. "\nIP: ". $IP. "\n方式: ". $way. "\n內容: ". $spamcom. "\n -- 记录成功 --";
		}
	}
	function sink( $comment ) {
		if ( !empty($_POST['spam_confirmed']) ) {
			if ( in_array( $comment['comment_type'], array('pingback', 'trackback') ) ) return $comment;
			die();
		}
		return $comment;
	}
}
$anti_spam = new anti_spam();

/* 评论链接新窗口
/* -------------------------------- */
function commentauthor($comment_ID = 0) {
    $url    = get_comment_author_url( $comment_ID );
    $author = get_comment_author( $comment_ID );
    if ( empty( $url ) || 'http://' == $url )
		echo $author;
    else
		echo "<a href='$url' rel='external nofollow' target='_blank' class='url'>$author</a>";
}

/* title标题输出
/* -------------------------------- */
function theme_slug_setup() {
 add_theme_support( 'title-tag' );
 }
 add_action( 'after_setup_theme', 'theme_slug_setup' );

/* 输出缩略图地址
/* -------------------------------- */
function post_thumbnail_src(){
	global $post;
	if( $values = get_post_custom_values("thumb") ) {	//输出自定义域图片地址
		$values = get_post_custom_values("thumb");
		$post_thumbnail_src = $values [0];
	} elseif( has_post_thumbnail() ){    //如果有特色缩略图，则输出缩略图地址
		$thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
		$post_thumbnail_src = $thumbnail_src [0];
	} else {
		$post_thumbnail_src = '';
		ob_start();
		ob_end_clean();
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		if(!empty($matches[1][0])){
			$post_thumbnail_src = $matches[1][0];   //获取该图片 src
		}else{	//如果日志中没有图片，则显示随机图片
			$random = mt_rand(1, 2);
			$post_thumbnail_src = get_template_directory_uri().'/images/demo/'.$random.'.jpg';
		}
	};
	echo $post_thumbnail_src;
}

/* 添加文章形式
/* -------------------------------- */
add_theme_support( 'post-formats', array(
	'aside', 'image',
) );

/* 注册小工具位置信息
/* -------------------------------- */
if (function_exists('register_sidebar')){
	register_sidebar( array(
		'name'          => '网站侧边栏',
		'id'            => 'sidebar-1',
		'description'   => '显示在网页侧边栏',
		'before_widget' => '<aside id="%1$s" class="widget-container %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="si-title"><h2>',
		'after_title'   => '</h2></div>',
	) );
}

if (function_exists('register_sidebar')){
	register_sidebar( array(
		'name'          => '跟随侧边栏',
		'id'            => 'sidebar-3',
		'description'   => '跟随侧边栏',
		'before_widget' => '<aside id="%1$s" class="widget-container %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="si-title"><h2>',
		'after_title'   => '</h2></div>',
	) );
}

/* 加载前端脚本及样式
/* -------------------------------- */
function ality_scripts() {
wp_enqueue_style( 'style', get_stylesheet_uri(), array(), '2016.03.09' );
wp_enqueue_style( 'font-awesome',get_template_directory_uri() . '/css/font-awesome.min.css', array(), '1.0' );
wp_enqueue_script( 'SerupSidle', get_template_directory_uri() . '/js/SerupSidle.js', array(), '1.0', false);
if ( is_single() ) {
wp_enqueue_style( 'highlightx',get_template_directory_uri() . '/css/highlightx.css', array(), '1.0' );
wp_enqueue_script( 'ajax-comment', get_template_directory_uri() . '/js/app.js', array(), '1.0' , true );
wp_enqueue_script( 'share', 'http://bdimg.share.baidu.com/static/api/js/share.js', array(), '1.0' , false );
wp_localize_script( 'ajax-comment', 'ajaxcomment', array('ajax_url'   => admin_url('admin-ajax.php'),'order' => get_option('comment_order'),'formpostion' => 'bottom',) );	
}
}
add_action( 'wp_enqueue_scripts', 'ality_scripts' );


/* 彩色静态标签云 Color Tag Cloud 
/* -------------------------------- */
function colorCloud($text) {
  $text = preg_replace_callback('|<a (.+?)>|i', 'colorCloudCallback', $text);
  $text=preg_replace('/<a /','<a rel="nofollow" ',$text);
  return $text;
}
function colorCloudCallback($matches) {
  $text = $matches[1];
  $color = dechex(rand(0,16777215));
  $pattern = '/style=(\'|\")(.*)(\'|\")/i';
  $text = preg_replace($pattern, "style=\"color:#{$color};$2;\"", $text);
  return "<a $text>";
}
add_filter('wp_tag_cloud', 'colorCloud', 1);

/* 添加特色缩略图支持
/* -------------------------------- */
if ( function_exists('add_theme_support') )add_theme_support('post-thumbnails');
add_filter('pre_option_link_manager_enabled','__return_true'); //添加链接功能

/* 给标签添加rel="nofollow"属性 
/* -------------------------------- */
function cx_tags() {
    $posttags = get_the_tags();
    if ($posttags) {
        foreach($posttags as $tag) {
            echo '<a class="tag-link' . $tag->term_id . '" href="'.get_tag_link($tag).'">'.$tag->name.'</a>';
        }
    }
}

/* 文章底部版权
/* -------------------------------- */
function banquan_chenxing($content){
        $content .= '<div class="bq_cx">来源：本文由<a href="http://www.chenxingweb.com" >晨星博客</a>原创撰写，欢迎分享本文，转载请保留出处和链接！</div>';
	return $content;
}
add_filter('the_content','banquan_chenxing',96);

/* 外部文件引入
/* -------------------------------- */
require get_template_directory() . '/inc/functions/breadcrumb.php';// 面包屑导航
require get_template_directory() . '/inc/functions/framework_core.php'; //引入后台设置框架
require get_template_directory() . '/inc/functions/ajax-comment.php';// 异步评论
require get_template_directory() . '/inc/functions/comment-template.php'; //评论评论模板
require get_template_directory() . '/inc/functions/options_feild.php';
require get_template_directory() . '/inc/functions/termmeta_feild.php'; 
require get_template_directory() . '/inc/functions/postmeta_feild.php';
require get_template_directory() . '/inc/functions/import_export.php'; 
require get_template_directory() . '/inc/functions/options_config.php'; 

/* 添加首页幻灯片代码
/* -------------------------------- */
function home_slide() {
if(is_home() && !is_paged()){
		$shouye = get_template_part( 'inc/template/web', 'slide' );
	}
}

/* 添加侧边登陆模块
/* -------------------------------- */
function sidebar_login() {
	global $ashu_option;
	if(isset($ashu_option['general']['_logion_off3']) && $ashu_option['general']['_logion_off3']=='off'){
      $out = get_template_part( 'inc/template/web', 'login' );		
	}
}

/* 文章列表模板
/* -------------------------------- */
function archives_post() {
		$shouye = get_template_part( 'inc/template/web', 'archives' );
	}

/* 手气不错页面
/* -------------------------------- */
function random_posts($posts_num=1){
	global $wpdb;
	$sql = "SELECT ID, post_title,guid
			FROM $wpdb->posts
			WHERE post_status = 'publish' ";
	$sql .= "AND post_title != '' ";
	$sql .= "AND post_password ='' ";
	$sql .= "AND post_type = 'post' ";
	$sql .= "ORDER BY RAND() LIMIT 0 , $posts_num ";
	$randposts = $wpdb->get_results($sql);
	$output = '';
	foreach ($randposts as $randpost) {
		$post_title = stripslashes($randpost->post_title);
		$permalink = get_permalink($randpost->ID);
		$output .= '<a href="'. $permalink . '"  rel="bookmark" title="';
		$output .= $post_title . '">手气不错</a>';
	}
	echo $output;
}

/* 分类摘要支持html
/* -------------------------------- */
remove_filter( 'pre_term_description', 'wp_filter_kses' );  
remove_filter( 'pre_link_description', 'wp_filter_kses' );  
remove_filter( 'pre_link_notes', 'wp_filter_kses' );  
remove_filter( 'term_description', 'wp_kses_data' ); 
function get_excerpt($excerpt){
$content = get_the_content();
$content = strip_tags($content,'<h2><ul><ol><li><a><strong><h3><blockquote><strong>');
$content = mb_strimwidth($content,0,400,'...');
return wpautop($content);
}
add_filter('the_excerpt','get_excerpt');


/* 二维码图片获取
/* -------------------------------- */
function er_weima(){
	global $ashu_option;
	$_sidebar_off4 = $ashu_option['general']['_sidebar_off4'];
	$logo_url = $ashu_option['general']['_erwei_upload'];	
if(isset($_sidebar_off4) && $_sidebar_off4 =='off'){
	$right_nav = array('container' => false,'echo'=> false, 'items_wrap' => '%3$s', 'theme_location' => 'right-nav');
	$output = '';
	$output .= '<h2 class="deanrsidet" ><span>热门话题</span></h2><ul class="s_bian cl">';
	$output .= wp_nav_menu( $right_nav );
	$output .= '</ul>';
	if(isset($logo_url) && $logo_url !=''){
	$output .= '<h2 class="deanrsidet" ><span>手机扫码</span></h2>';
	$output .= '<div class="erwei cl">';
	$output .= '<img src="'.$logo_url.'" width="338" height="187" alt="网站二维码扫描" />';
	$output .= '</div>';
		}
  	echo $output;
	}
}					  
				  
/* 底部版权获取
/* -------------------------------- */
function cx_foot(){
	global $ashu_option;
	$_bq_txt = $ashu_option['general']['_bq_txt'];
	$_foot_ba = $ashu_option['general']['_foot_ba'];
	$_foot_ba_url = $ashu_option['general']['_foot_ba_url'];
	$menuParameters = array('container'=> false,'echo'=> false,'items_wrap' => '%3$s','theme_location'=>'footer-nav','depth'	=> 0,);
	$output = '';
	$output .= '<div class="deanftbm"><p>';
	$output .= strip_tags(wp_nav_menu( $menuParameters ), '<a>' );	
	if(isset($_foot_ba_url) && $_foot_ba_url =='off'){
     $output .= '<span><a href="http://www.miitbeian.gov.cn/" rel="nofollow" target="_blank">'.$_foot_ba.'</a></span></p>';	
	} else {
	$output .= '<span>'.$_foot_ba.'</span></p>';
	}	
	$output .= '<p>'.$_bq_txt.'</p>';
	$output .= '</div>';
	echo $output;
  }	
  

/* 网站友情链接模块
/* -------------------------------- */
function links_off() {
	global $ashu_option;
	$_links_off = $ashu_option['general']['_links_off'];
	if(isset($_links_off) && $_links_off=='off'){
	  $out = get_template_part( 'inc/template/web', 'links' );	  
	}
}

/* 网站icon图标显示
/* -------------------------------- */
function icon_off() {
	global $ashu_option;
	$_icon_off = $ashu_option['general']['_icon_off'];
	if(isset($_icon_off) && $_icon_off !=''){
	  $output = '';
	  $output .= '<link rel="shortcut icon" href="'. $_icon_off .'" type="image/x-icon" />';			
   	echo $output;	  
	}
}

add_action('wp_head', 'icon_off');


/* 分类封面图片设置
/* -------------------------------- */
function term_img() {
	$currentterm = get_queried_object();
    $img_url = get_term_meta($currentterm->term_id , '_fl_upload',true);
	
	$category = get_the_category();
	if(isset($img_url) && $img_url !=''){	
		echo '<img src="'.$img_url.'" width="600" height="50" alt="'.$category[0]->cat_name .'" />';	  
	}
}

/* 时间显示方式xx以前
/* -------------------- */
function time_ago( $type = 'commennt', $day = 7 ) {
  $d = $type == 'post' ? 'get_post_time' : 'get_comment_time';
  if (time() - $d('U') > 60*60*24*$day) return;
  echo human_time_diff($d('U'), strtotime(current_time('mysql', 0))), '前';
}

function timeago( $ptime ) {
	date_default_timezone_set ('ETC/GMT');
    $ptime = strtotime($ptime);
    $etime = time() - $ptime;
    if($etime < 1) return '刚刚';
    $interval = array (
        12 * 30 * 24 * 60 * 60  =>  '年前 ('.date('Y/m', $ptime).')',
        30 * 24 * 60 * 60       =>  '个月前',
        7 * 24 * 60 * 60        =>  '周前',
        24 * 60 * 60            =>  '天前',
        60 * 60                 =>  '小时前',
        60                      =>  '分钟前',
        1                       =>  '秒前'
    );
    foreach ($interval as $secs => $str) {
        $d = $etime / $secs;
        if ($d >= 1) {
            $r = round($d);
            return $r . $str;
        }
    };
}
//主题代码全部结束
 ?>