<?php
/**
 * 会创拼团模块微站定义
 *
 * @author huichuang
 * @url 
 */
defined('IN_IA') or exit('Access Denied');
require_once IA_ROOT."/addons/hc_groups/inc/model.class.php"; 
class Hc_groupsModuleSite extends WeModuleSite {

	public function doWebSetting() {
		global $_W,$_GPC;
		if($_GPC['act']=='add'){
			$data['uniacid'] = $_W['uniacid'];

			empty($_GPC['shop_name'])?'':$data['shop_name'] = $_GPC['shop_name'];
			empty($_GPC['share_title'])?'':$data['share_title'] = $_GPC['share_title'];
			empty($_GPC['shop_logo'])?'':$data['shop_logo'] = $_GPC['shop_logo'];
			empty($_GPC['telnumber'])?'':$data['telnumber'] = $_GPC['telnumber'];
			empty($_GPC['copyright'])?'':$data['copyright'] = $_GPC['copyright'];
			empty($_GPC['desc'])?'':$data['desc'] = $_GPC['desc'];
			empty($_GPC['autosign'])?'':$data['autosign'] = $_GPC['autosign'];
			empty($_GPC['autorefund'])?'':$data['autorefund'] = $_GPC['autorefund'];
			empty($_GPC['autocancel'])?'':$data['autocancel'] = $_GPC['autocancel'];
			$data['tpl_msg'] = json_encode($_GPC['tpl_msg']);
			if(!empty($_GPC['cert'])){
				file_put_contents(dirname(__FILE__)."/cert/apiclient_cert_".$_W['uniacid'].".pem",$_GPC['cert']);
			}
			if(!empty($_GPC['key'])){
				file_put_contents(dirname(__FILE__)."/cert/apiclient_key_".$_W['uniacid'].".pem",$_GPC['key']);
			}
			if(!empty($_GPC['rootca'])){
				file_put_contents(dirname(__FILE__)."/cert/rootca_".$_W['uniacid'].".pem",$_GPC['rootca']);
			}
			
			$ishave = pdo_get('hcgroup_set', array('uniacid' => $_W['uniacid']));
			if(!empty($ishave)){
				$result = pdo_update('hcgroup_set', $data ,array('uniacid'=>$_W['uniacid']));
			}else{
				$result = pdo_insert('hcgroup_set', $data);
			}
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('setting'));
			}
		}
		$info = pdo_get('hcgroup_set', array('uniacid' => $_W['uniacid']));
		$tpl_msg = json_decode($info['tpl_msg'],true);
		include $this->template('setting');
	}
	/**
	 * 商品列表
	 * @return [type] [description]
	 */
	public function doWebGoods() {
		global $_W,$_GPC;
		$type = $_GPC['keywordtype'];
		$keyword = $_GPC['keyword'];
		if($type==1 && !empty($keyword)){
			$where['goods_id'] = $keyword;
		}else if($type==2 && !empty($keyword)){
			$where['title like'] = '%'.$keyword.'%';
		}
		$where['status'] = $status = empty($_GPC['status'])?1:$_GPC['status'];
		$where['uniacid'] = $_W['uniacid'];
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$goods = pdo_getslice('hcgroup_goods',$where,array($pageindex, $pagesize),$total,array() ,'','goods_id desc');

		
		$page = pagination($total, $pageindex, $pagesize);

		include $this->template('goods');
	}
	/**
	 * 下架、售罄
	 * @return [type] [description]
	 */
	public function doWebGoodsstatus() {
		global $_W,$_GPC;
		$ids = $_GPC['ids'];
		$status = $_GPC['status'];
		foreach (explode(',',$ids) as $key) {
			$res = pdo_update('hcgroup_goods',array('status'=>$status),array('goods_id in'=>$key));
			if(empty($res)){
				message('操作失败',$this->createWebUrl('Goods'));
			}
		}
		message('操作成功',$this->createWebUrl('Goods',array('status'=>$status)));
	}
	/**
	 * 删除商品
	 * @return [type] [description]
	 */
	public function doWebGoodsdel(){
		global $_W,$_GPC;
		$result = pdo_delete('hcgroup_goods',array('goods_id'=>$_GPC['id']));
		if (!empty($result)) {
		    message('操作成功',$this->createWebUrl('Goods'));
		}
	}
	/**
	 * 商品排序
	 * @return [type] [description]
	 */
	public function doWebGoodssort(){
		global $_W,$_GPC;
		$result = pdo_update('hcgroup_goods',array('displayorder'=>$_GPC['displayorder']),array('goods_id'=>$_GPC['id']));
		if (!empty($result)) {
		    message('操作成功',$this->createWebUrl('Goods'));
		}
	}
	public function doWebSpec() {
		global $_W,$_GPC;
		if($_GPC['act'] == 'option'){
			$rand= time().rand(1000,9999);
			echo '
			<div class="alert alert-new spec_item" style="width:100%;" id="spec_'.$rand.'" >
				<input name="spec_id[]" type="hidden" class="form-control spec_id" value="'.$rand.'"/>
				<div class="form-group">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-1 control-label"> 规格名</label>
					<div class="col-xs-12 col-sm-8 col-lg-9">
						<input name="spec_title['.$rand.']" type="text" class="form-control  spec_title" value="" placeholder="(比如: 颜色)"/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-1 control-label">规格项</label>
					<div class="col-xs-12 col-sm-8 col-lg-9">
						<div id="spec_item_'.$rand.'" class="spec_item_items"></div>
					</div>
					<div class="col-xs-12 col-sm-8 col-lg-9">
						<label class="col-xs-12 col-sm-2 col-md-2 col-lg-1 control-label">&nbsp;&nbsp;&nbsp;</label>
						<div class="col-xs-12 col-sm-8 col-lg-9">
							<a href="javascript:;" id="add-specitem-'.$rand.'" specid="'.$rand.'" class="btn btn-info add-specitem" onclick="addSpecItem('.$rand.')"><i class="fa fa-plus"></i> 添加规格项</a>
							<a href="javascript:void(0);" class="btn btn-danger" onclick="removeSpec('.$rand.')"><i class="fa fa-plus"></i> 删除规格</a>
						</div>
					</div>
				</div>
			</div>
			';
		}
		else if($_GPC['act'] == 'item'){
			$specid = $_GPC['specid'];
			$rand = 's'.time().rand(1000,9999);
			echo '
				<div class="spec_item_item" style="float:left;margin:0 5px 10px 0;">
					<input type="hidden" class="form-control spec_item_show" name="spec_item_show_'.$specid.'[]" VALUE="1" />
					<input type="hidden" class="form-control spec_item_id" name="spec_item_id_'.$specid.'[]" VALUE="'.$rand.'" />
					<div class="input-group"  style="margin:10px 0;">
						<span class="input-group-addon">
							<label class="checkbox-inline" style="margin-top:-20px;">
								<input type="checkbox" checked value="1" onclick="showItem(this)">
							</label>
						</span>
						<input type="text" class="form-control spec_item_title error" name="spec_item_title_'.$specid.'[]" VALUE="" />
						<span class="input-group-addon">
							<a href="javascript:;" onclick="removeSpecItem(this)" title="删除""><i class="fa fa-times"></i></a>
					  		<a href="javascript:;" class="fa fa-arrows" title="拖动调整显示顺序" ></a>
						</span>
					</div>
					<div>
				';
				echo tpl_form_field_image('spec_item_thumb_'.$specid.'[]');
				echo '
					</div>
				</div>';
		}
	}
	public function doWebPost() {
		global $_W,$_GPC;
		$goods_id = $_GPC['goods_id'];
		if($_GPC['act'] =='add'){
			$arr['uniacid'] = $_W['uniacid'];

			$data = $_GPC['goods'];
			$nav = $_GPC['nav'];
            empty($data['displayorder'])?'':$arr['displayorder'] = $data['displayorder'];
            empty($nav['parentid'])?'':$arr['nav_pcate'] = $nav['parentid'];
            empty($nav['childid'])?'':$arr['nav_ccate'] = $nav['childid'];
            empty($data['parentid'])?'':$arr['pcate'] = $data['parentid'];
            empty($data['childid'])?'':$arr['ccate'] = $data['childid'];
            empty($data['theme'])?'':$arr['theme'] = $data['theme'];
            empty($data['goodssn'])?'':$arr['goodssn'] = $data['goodssn'];
            empty($data['title'])?'':$arr['title'] = $data['title'];
            empty($data['unit'])?'':$arr['unit'] = $data['unit'];
            empty($data['groupprice'])?'':$arr['groupprice'] = $data['groupprice'];
            empty($data['singleprice'])?'':$arr['singleprice'] = $data['singleprice'];
            empty($data['marketprice'])?'':$arr['marketprice'] = $data['marketprice'];
            empty($data['peoplenumber'])?'':$arr['peoplenumber'] = $data['peoplenumber'];
            empty($data['thumb'])?'':$arr['thumb'] = $data['thumb'];
            empty($data['status'])?'':$arr['status'] = $data['status'];
            empty($data['free_shipping'])?'':$arr['free_shipping'] = $data['free_shipping'];
            empty($data['postage'])?'':$arr['postage'] = $data['postage'];
            empty($data['description'])?'':$arr['description'] = $data['description'];
            empty($data['content'])?'':$arr['content'] = $data['content'];
            empty($data['headdiscount'])?'':$arr['headdiscount'] = $data['headdiscount'];
            empty($data['headdiscountprice'])?'':$arr['headdiscountprice'] = $data['headdiscountprice'];
            empty($data['timelimit'])?'':$arr['timelimit'] = $data['timelimit'];
            empty($data['timelimittime'])?'':$arr['timelimittime'] = $data['timelimittime'];
            empty($data['hotstyle'])?'':$arr['hotstyle'] = $data['hotstyle'];
            empty($data['stock'])?'':$arr['stock'] = $data['stock'];
            empty($data['void_num'])?'':$arr['void_num'] = $data['void_num'];
            empty($data['groupbuy_limit'])?'':$arr['groupbuy_limit'] = $data['groupbuy_limit'];
            empty($data['singlebuy_limit'])?'':$arr['singlebuy_limit'] = $data['singlebuy_limit'];
            empty($data['totalbuy_limit'])?'':$arr['totalbuy_limit'] = $data['totalbuy_limit'];
            empty($data['is_new'])?'':$arr['is_new'] = $data['is_new'];
            empty($data['is_rec'])?'':$arr['is_rec'] = $data['is_rec'];
            empty($data['is_hot'])?'':$arr['is_hot'] = $data['is_hot'];
            empty($data['is_luck'])?'':$arr['is_luck'] = $data['is_luck'];
            empty($data['luckdrawprice'])?'':$arr['luckdrawprice'] = $data['luckdrawprice'];
            empty($data['luckdrawcon'])?'':$arr['luckdrawcon'] = $data['luckdrawcon'];
            empty($data['hasoption'])?'':$arr['hasoption'] = $data['hasoption'];
            $arr['createtime'] = time();
            $arr['actno'] = $actno = date('YmdHis').time().rand(1111,9999);
            //echo "<pre>";print_r($arr);die;
            $res = pdo_insert('hcgroup_goods', $arr);
            if (!empty($res)) {
            	$goods_id = pdo_insertid();
            	//判断一分拼活动，添加活动
	            if($arr['is_luck']==1){
	            	$activ = array(
	            		'uniacid' => $_W['uniacid'],
            			'actno'=> $actno,
            			'goods_id'=>$goods_id,
            			'start_time'=>time(),
            			'end_time'=>strtotime($arr['timelimittime']),
        				'neednum'=>$arr['luckdrawcon']
            		);
	            	$act = pdo_insert('hcgroup_activ',$activ);
	            	if (!empty($act)) {
            			$activid = pdo_insertid();
            		}
	            }
            	if(!empty($data['thumbs'])){
	            	foreach($data['thumbs'] as $key){
		            	$result = pdo_insert('hcgroup_goods_image', array('goods_id'=>$goods_id,'thumb'=>$key));
		            }
		        }

		        if($data['hasoption']==1){
		        	/*规格处理*/
					
					$spec_id = $_GPC['spec_id'];
					foreach ($spec_id as $key => $val) {

						$spec[$key]['spec_number'] = $val;//规格编号
						$spec[$key]['spec_title'] = $_GPC['spec_title'][$val];//规格名称
						foreach ($_GPC['spec_item_id_'.$val] as $k => $v) {
							$item[$k]['item_id'] = $v;
							$item[$k]['item_show'] = $_GPC['spec_item_show_'.$val][$k];
							$item[$k]['item_title'] = $_GPC['spec_item_title_'.$val][$k];
							$item[$k]['item_thumb'] = $_GPC['spec_item_thumb_'.$val][$k];
						}
						$spec[$key]['spec_item'] = $item;
						$spec[$key]['goods_id'] = $goods_id;
						$spec[$key]['uniacid'] = $_W['uniacid'];
					}
					foreach ($spec as $k => $v) {
						$v['spec_item'] = json_encode($v['spec_item']);
						$result = pdo_insert('hcgroup_goods_spec', $v);
					}

					/*规格项处理*/
					$option_ids = $_GPC['option_ids'];
					foreach ($option_ids as $key => $val) {
						$option_item[$key]['option_id'] = $val;
						$option_item[$key]['option_title'] = $_GPC['option_title_'.$val][0];
						$option_item[$key]['option_marketprice'] = $_GPC['option_marketprice_'.$val][0];
						$option_item[$key]['option_productprice'] = $_GPC['option_productprice_'.$val][0];
						$option_item[$key]['option_costprice'] = $_GPC['option_costprice_'.$val][0];
						$option_item[$key]['option_stock'] = $_GPC['option_stock_'.$val][0];
						$option_item[$key]['uniacid'] = $_W['uniacid'];
						$option_item[$key]['goods_id'] = $goods_id;
					}
					foreach ($option_item as $k => $v) {
						$result = pdo_insert('hcgroup_goods_spec_item', $v);
					}
				}
			    message('操作成功',$this->createWebUrl('goods'));
			}else{
				message('操作失败');
			}
		}else if($_GPC['act'] =='edit'){
			$arr['uniacid'] = $_W['uniacid'];

			$data = $_GPC['goods'];
			$nav = $_GPC['nav'];
            empty($data['displayorder'])?'':$arr['displayorder'] = $data['displayorder'];
            empty($nav['parentid'])?'':$arr['nav_pcate'] = $nav['parentid'];
            empty($nav['childid'])?'':$arr['nav_ccate'] = $nav['childid'];
            empty($data['parentid'])?'':$arr['pcate'] = $data['parentid'];
            empty($data['childid'])?'':$arr['ccate'] = $data['childid'];
            empty($data['theme'])?'':$arr['theme'] = $data['theme'];
            empty($data['goodssn'])?'':$arr['goodssn'] = $data['goodssn'];
            empty($data['title'])?'':$arr['title'] = $data['title'];
            empty($data['unit'])?'':$arr['unit'] = $data['unit'];
            empty($data['groupprice'])?'':$arr['groupprice'] = $data['groupprice'];
            empty($data['singleprice'])?'':$arr['singleprice'] = $data['singleprice'];
            empty($data['marketprice'])?'':$arr['marketprice'] = $data['marketprice'];
            empty($data['peoplenumber'])?'':$arr['peoplenumber'] = $data['peoplenumber'];
            empty($data['thumb'])?'':$arr['thumb'] = $data['thumb'];
            empty($data['status'])?'':$arr['status'] = $data['status'];
            empty($data['free_shipping'])?'':$arr['free_shipping'] = $data['free_shipping'];
            empty($data['postage'])?'':$arr['postage'] = $data['postage'];
            empty($data['description'])?'':$arr['description'] = $data['description'];
            empty($data['content'])?'':$arr['content'] = $data['content'];
            empty($data['headdiscount'])?'':$arr['headdiscount'] = $data['headdiscount'];
            empty($data['headdiscountprice'])?'':$arr['headdiscountprice'] = $data['headdiscountprice'];
            empty($data['timelimit'])?'':$arr['timelimit'] = $data['timelimit'];
            empty($data['timelimittime'])?'':$arr['timelimittime'] = $data['timelimittime'];
			empty($data['hotstyle'])?'':$arr['hotstyle'] = $data['hotstyle'];
            empty($data['stock'])?'':$arr['stock'] = $data['stock'];
            empty($data['void_num'])?'':$arr['void_num'] = $data['void_num'];
            empty($data['groupbuy_limit'])?'':$arr['groupbuy_limit'] = $data['groupbuy_limit'];
            empty($data['singlebuy_limit'])?'':$arr['singlebuy_limit'] = $data['singlebuy_limit'];
            empty($data['totalbuy_limit'])?'':$arr['totalbuy_limit'] = $data['totalbuy_limit'];
            empty($data['is_new'])?'':$arr['is_new'] = $data['is_new'];
            empty($data['is_rec'])?'':$arr['is_rec'] = $data['is_rec'];
            empty($data['is_hot'])?'':$arr['is_hot'] = $data['is_hot'];
            empty($data['is_luck'])?'':$arr['is_luck'] = $data['is_luck'];
            empty($data['luckdrawprice'])?'':$arr['luckdrawprice'] = $data['luckdrawprice'];
            empty($data['luckdrawcon'])?'':$arr['luckdrawcon'] = $data['luckdrawcon'];
            empty($data['hasoption'])?'':$arr['hasoption'] = $data['hasoption'];

            //一份拼操作
	        if($arr['is_luck']==1){
	            $goodsinfo = pdo_get('hcgroup_goods',array('uniacid' => $_W['uniacid'],'goods_id'=>$goods_id));
	            $activ = pdo_get('hcgroup_activ',array('uniacid' => $_W['uniacid'],'goods_id'=>$goods_id,'actno'=>$goodsinfo['actno']));
	            if(!empty($goodsinfo['actno']) && !empty($activ) && strtotime($goodsinfo['timelimittime'])>time()){
	            	$arr['actno'] = $actno = $goodsinfo['actno'];
	            	//判断一分拼活动，修改活动
	            	$activ = array(
	            		'actno' => $actno,
	        			'start_time'=>time(),
	        			'end_time'=>strtotime($arr['timelimittime']),
	        			'neednum'=>$arr['luckdrawcon']
	        		);
	            	pdo_update('hcgroup_activ',$activ,array('uniacid' => $_W['uniacid'],'actno'=>$actno));
	            }else{
	            	$arr['actno'] = $actno = date('YmdHis').time().rand(1111,9999);
	            	$activ = array(
	            		'uniacid' => $_W['uniacid'],
	        			'actno'=> $actno,
	        			'goods_id'=>$goods_id,
	        			'start_time'=>time(),
	        			'end_time'=>strtotime($arr['timelimittime']),
	        			'neednum'=>$arr['luckdrawcon']
	        		);
	            	pdo_insert('hcgroup_activ',$activ);
	            }
	        }
            //echo "<pre>";print_r($arr);die;
            $res = pdo_update('hcgroup_goods', $arr, array('uniacid' => $_W['uniacid'],'goods_id'=>$goods_id));
            //echo "<pre>";print_r($data['thumbs']);die;
        	if(!empty($data['thumbs'])){

        		pdo_delete('hcgroup_goods_image', array('goods_id'=>$goods_id));
            	foreach($data['thumbs'] as $key){
	            	$result = pdo_insert('hcgroup_goods_image', array('goods_id'=>$goods_id,'thumb'=>$key));
	            }
	        }
	        if($data['hasoption']==1){
	        	/*规格处理*/
				$spec_id = $_GPC['spec_id'];
				foreach ($spec_id as $key => $val) {
					$spec[$key]['spec_number'] = $val;//规格编号
					$spec[$key]['spec_title'] = $_GPC['spec_title'][$val];//规格名称
					foreach ($_GPC['spec_item_id_'.$val] as $k => $v) {
						$item[$k]['item_id'] = $v;
						$item[$k]['item_show'] = $_GPC['spec_item_show_'.$val][$k];
						$item[$k]['item_title'] = $_GPC['spec_item_title_'.$val][$k];
						$item[$k]['item_thumb'] = $_GPC['spec_item_thumb_'.$val][$k];
					}
					$spec[$key]['spec_item'] = $item;
					$spec[$key]['goods_id'] = $goods_id;
					$spec[$key]['uniacid'] = $_W['uniacid'];
					unset($item);
				}
				foreach ($spec as $k => $v) {
					//规格是否存在
					$exist_item = pdo_get('hcgroup_goods_spec',array('spec_number'=>$v['spec_number']));
					$v['spec_item'] = json_encode($v['spec_item']);
					if(empty($exist_item)){
						$result = pdo_insert('hcgroup_goods_spec', $v);
					}else{
						$result = pdo_update('hcgroup_goods_spec', $v,array('spec_number'=>$v['spec_number']));
					}
				}
				/*规格项处理*/
				$option_ids = $_GPC['option_ids'];
				foreach ($option_ids as $key => $val) {
					$option_item[$key]['option_id'] = $val;
					$option_item[$key]['option_title'] = $_GPC['option_title_'.$val][0];
					$option_item[$key]['option_marketprice'] = $_GPC['option_marketprice_'.$val][0];
					$option_item[$key]['option_productprice'] = $_GPC['option_productprice_'.$val][0];
					$option_item[$key]['option_costprice'] = $_GPC['option_costprice_'.$val][0];
					$option_item[$key]['option_stock'] = $_GPC['option_stock_'.$val][0];
					$option_item[$key]['uniacid'] = $_W['uniacid'];
					$option_item[$key]['goods_id'] = $goods_id;
				}
				foreach ($option_item as $k => $v) {
					$exist_option = pdo_get('hcgroup_goods_spec_item',array('option_id'=>$v['option_id']));
					if(empty($exist_option)){
						$result = pdo_insert('hcgroup_goods_spec_item', $v);
					}else{
						$result = pdo_update('hcgroup_goods_spec_item', $v,array('option_id'=>$v['option_id']));
					}
				}
			}

		    message('操作成功',$this->createWebUrl('goods'));
			
		}

		//获取二、三级分类
		$first = pdo_getall('hcgroup_goods_category', array('parentid'=>0,'enabled'=>1,'uniacid' => $_W['uniacid']));
		foreach ($first as $key => $val) {
			$second[] = pdo_getall('hcgroup_goods_category', array('parentid'=>$val['id'],'enabled'=>1,'uniacid' => $_W['uniacid']));
		}

		foreach ($second as $key => $val) {
			foreach ($val as $k => $v) {
				$parents[] = $v;
			}
		}

		foreach ($parents as $k => $v) {
			$children[$v['id']] = pdo_getall('hcgroup_goods_category', array('parentid'=>$v['id'],'enabled'=>1,'uniacid' => $_W['uniacid']));
		}
		//获取导航分类
		$nav_parents = pdo_getall('hcgroup_nav', array('parentid'=>0,'status'=>1,'uniacid' => $_W['uniacid']));
		foreach ($nav_parents as $key => $val) {
			$nav_children[$val['id']] = pdo_getall('hcgroup_nav', array('parentid'=>$val['id'],'status'=>1,'uniacid' => $_W['uniacid']));
		}
		//编辑，默认显示
		$info = pdo_get('hcgroup_goods', array('goods_id'=>$goods_id,'uniacid' => $_W['uniacid']));
		$goods_image = pdo_getall('hcgroup_goods_image',array('goods_id'=>$goods_id));
		foreach($goods_image as $key=>$val){
	       	$goods_thumbs[] = $val['thumb'];
	    }
	    //调取规格项
	    $spec = pdo_getall('hcgroup_goods_spec',array('goods_id'=>$goods_id,'uniacid' => $_W['uniacid']), array() , '' , 'spec_id asc');
	    foreach($spec as $key=>$val){
	    	$spec_item = json_decode($val['spec_item'],true);
	    	//echo "<pre>";print_r($spec_item);
	    	foreach ($spec_item as $k => $v) {
	    		$spec[$key]['item'][$k] = $v;
	    	}
	    	unset($spec_item);
	    }
	    //echo "<pre>";print_r($spec);die;
	    $sitem = pdo_getall('hcgroup_goods_spec_item',array('goods_id'=>$goods_id,'uniacid' => $_W['uniacid']), array() , '' , 'id asc');

	    foreach ($sitem as $key => $val) {
	    	$spec_item[$val['option_id']] = $val;
	    }
	    $specitem = json_encode($spec_item);
		//echo "<pre>";print_r($specitem);die;
		include $this->template('post');
	}
	/*
	 * 分类管理 列表
	 */
	public function doWebCategory() {
		global $_W,$_GPC;
		$list = pdo_getall('hcgroup_goods_category', array('parentid'=>0,'uniacid' => $_W['uniacid']));
		foreach ($list as $key => $value) {
			$second = pdo_getall('hcgroup_goods_category', array('parentid'=>$value['id'],'uniacid' => $_W['uniacid']));
			foreach ($second as $k => $v) {
				$second[$k]['children'] = pdo_getall('hcgroup_goods_category', array('parentid'=>$v['id'],'uniacid' => $_W['uniacid']));
			}

			$list[$key]['children'] = $second;
			unset($second);
		}
		include $this->template('category');
	}
	/*
	 * 分类管理 
	 */
	public function doWebCategory_post() {
		global $_W,$_GPC;
		$id = $_GPC['id'];
		if($_GPC['act'] =='add'){
			$data['uniacid'] = $_W['uniacid'];
			empty($_GPC['parentid'])?'':$data['parentid'] = $_GPC['parentid'];
			empty($_GPC['name'])?'':$data['name'] = $_GPC['name'];
			empty($_GPC['thumb'])?'':$data['thumb'] = $_GPC['thumb'];
			empty($_GPC['displayorder'])?'':$data['displayorder'] = $_GPC['displayorder'];
			empty($_GPC['enabled'])?'':$data['enabled'] = $_GPC['enabled'];
			empty($_GPC['isrecommand'])?'':$data['isrecommand'] = $_GPC['isrecommand'];
			$result = pdo_insert('hcgroup_goods_category', $data);
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('category'));
			}
		}
		if($_GPC['act']=='edit'){
			$data['uniacid'] = $_W['uniacid'];
			empty($_GPC['parentid'])?'':$data['parentid'] = $_GPC['parentid'];
			empty($_GPC['name'])?'':$data['name'] = $_GPC['name'];
			empty($_GPC['thumb'])?'':$data['thumb'] = $_GPC['thumb'];
			empty($_GPC['displayorder'])?'':$data['displayorder'] = $_GPC['displayorder'];
			empty($_GPC['enabled'])?$data['enabled'] = 0:$data['enabled'] = $_GPC['enabled'];
			empty($_GPC['isrecommand'])?$data['isrecommand'] = 0:$data['isrecommand'] = $_GPC['isrecommand'];

			$result = pdo_update('hcgroup_goods_category', $data, array('id'=>$_GPC['id']));
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('category'));
			}
		}

		if($_GPC['act']=='del'){
			$result = pdo_delete('hcgroup_goods_category', array('id'=>$_GPC['id']));
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('category'));
			}
		}
		if($_GPC['act']=='display'){
			$result = pdo_update('hcgroup_goods_category',array('displayorder'=>$_GPC['displayorder']),array('id'=>$_GPC['id']));
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('category'));
			}
		}
		$info = pdo_get('hcgroup_goods_category', array('id'=>$id,'uniacid'=>$_W['uniacid']));
		$list = pdo_getall('hcgroup_goods_category', array('parentid'=>0,'uniacid' => $_W['uniacid']));
		foreach ($list as $key => $value) {
			$second = pdo_getall('hcgroup_goods_category', array('parentid'=>$value['id'],'uniacid' => $_W['uniacid']));
			foreach ($second as $k => $v) {
				$second[$k]['children'] = pdo_getall('hcgroup_goods_category', array('parentid'=>$v['id'],'uniacid' => $_W['uniacid']));
			}

			$list[$key]['children'] = $second;
			unset($second);
		}
		//echo "<pre>";print_r($list);die;
		include $this->template('category_post');
	}

	public function doWebComment() {
		global $_W,$_GPC;
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$list = pdo_getslice('hcgroup_order_comment',$where,array($pageindex, $pagesize),$total,array() ,'','createtime desc');
		foreach ($list as $key => $val) {
			$info = pdo_get('hcgroup_goods',array('goods_id'=>$val['goodsid'],'uniacid' => $_W['uniacid']),array('title','thumb'));
			$list[$key]['thumb'] = $info['thumb'];
			$list[$key]['title'] = $info['title'];
		}
		//echo "<pre>";print_R($list);die;
		
		$page = pagination($total, $pageindex, $pagesize);
		include $this->template('comment');
	}

	public function doWebComment_post() {
		global $_W,$_GPC;
		$id = $_GPC['id'];
		if($_GPC['act']=='append'){
			empty($_GPC['append_content'])?'':$data['append_content'] = $_GPC['append_content'];
			$result = pdo_update('hcgroup_order_comment', $data,array('id'=>$id));
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('comment'));
			}
		}
		$info = pdo_get('hcgroup_order_comment',array('id'=>$id));
		$info['img'] = explode(',',$info['images']);
		$goods = pdo_get('hcgroup_goods',array('goods_id'=>$info['goodsid']),array('title','thumb'));
		$info['title'] = $goods['title'];
		$info['thumb'] = $goods['thumb'];
		include $this->template('comment_post');
	}
	/**
	 * [doWebOrder description]
	 * @return [type] [description]
	 */
	public function doWebOrder() {
		global $_W,$_GPC;
		$timetype = $_GPC['timetype'];
		$time = $_GPC['time'];
		$keywordtype = $_GPC['keywordtype'];
		$keyword = $_GPC['keyword'];
		$status = $_GPC['status'];
		if(!empty($_GPC['status'])){
			$where = "uniacid = ".$_W['uniacid']." and status = ".$_GPC['status'];
		}else{
			$where = "uniacid = ".$_W['uniacid'];
		}

		if($timetype==1 & !empty($time)){
			$where .= " and createtime >=".strtotime($time['start'])." and createtime <=".strtotime($time['end']."+1 day")."";
		}else if($timetype==2 & !empty($time)){
			$where .= " and paytime >=".strtotime($time['start'])." and paytime <=".strtotime($time['end']."+1 day")."";
		}else if($timetype==3 & !empty($time)){
			$where .= " and sendtime >=".strtotime($time['start'])." and sendtime <=".strtotime($time['end']."+1 day")."";
		}
		if($keywordtype==1 & !empty($keyword)){
			$where .= " and orderno like '%".$keyword."%'";
		}else if($keywordtype==2 & !empty($keyword)){
			$addressids = pdo_getall('hcgroup_member_address',array('realname LIKE'=>'%'.$keyword.'%','uniacid'=>$_W['uniacid']),array('id'));
			//echo "<pre>";pdo_debug();	
			foreach ($addressids as $k => $v) {
				$ids[$k] = $v['id'];
			}
			implode(',',$ids);

			$where .= " and addressid in(".implode(',',$ids).")";
		}else if($keywordtype==3 & !empty($keyword)){
			$addressids = pdo_getall('hcgroup_member_address',array('mobile'=> $keyword,'uniacid'=>$_W['uniacid']),array('id'));
			foreach ($addressids as $k => $v) {
				$ids[$k] = $v['id'];
			}
			implode(',',$ids);

			$where .= " and addressid in(".implode(',',$ids).")";
		}else if($keywordtype==4 & !empty($keyword)){
			$goodsids = pdo_getall('hcgroup_goods',array('title LIKE'=> '%'.$keyword.'%','uniacid'=>$_W['uniacid']),array('goods_id'));
			foreach ($goodsids as $k => $v) {
				$ids[$k] = $v['goods_id'];
			}
			implode(',',$ids);

			$where .= " and goods_id in(".implode(',',$ids).")";
		}else if($keywordtype==5 & !empty($keyword)){
			$where .= " and goods_id = ".$keyword;
		}
		
		//echo $where;die;



		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;
        
        $count = pdo_fetchall("SELECT * FROM ".tablename('hcgroup_order')." WHERE ".$where." ORDER BY starttime DESC");
        $total = count($count);
		$p = ($pageindex-1) * 10;
        $list = pdo_fetchall("SELECT * FROM ".tablename('hcgroup_order')." WHERE ".$where." ORDER BY starttime DESC LIMIT " . $p . "," . $pagesize);
       // echo "SELECT * FROM ".tablename('hcgroup_order')." WHERE ".$where." ORDER BY starttime DESC LIMIT " . $p . "," . $pagesize;die;
		$page = pagination($total, $pageindex, $pagesize);

		foreach ($list as $key => $val) {
			$goods_info = pdo_get('hcgroup_goods',array('goods_id'=>$val['goods_id'],'uniacid' => $_W['uniacid']),array('title','unit','thumb'));
			$list[$key]['goods_name'] = substr($goods_info['title'],0,40);
			$list[$key]['goods_unit'] = $goods_info['unit'];
			$list[$key]['goods_thumb'] = $goods_info['thumb'];

			$member = pdo_get('hcgroup_member',array('id'=>$val['user_id'],'uniacid' => $_W['uniacid']));
			$list[$key]['openid'] = $member['openid'];
			$list[$key]['avatar'] = $member['avatar'];

			$address = pdo_get('hcgroup_member_address',array('id'=>$val['addressid'],'uniacid' => $_W['uniacid']));
			$list[$key]['realname'] = $address['realname'];
			$list[$key]['mobile'] = $address['mobile'];
			$list[$key]['address'] = $address['province'] .' '. $address['city'] .' '. $address['area'] .' '. $address['address'];
		}


		$total0 = pdo_getcolumn('hcgroup_order',array('uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total1 = pdo_getcolumn('hcgroup_order',array('status'=>1,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total2 = pdo_getcolumn('hcgroup_order',array('status'=>2,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total3 = pdo_getcolumn('hcgroup_order',array('status'=>3,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total4 = pdo_getcolumn('hcgroup_order',array('status'=>4,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total5 = pdo_getcolumn('hcgroup_order',array('status'=>5,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total6 = pdo_getcolumn('hcgroup_order',array('status'=>6,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		$total7 = pdo_getcolumn('hcgroup_order',array('status'=>7,'uniacid' => $_W['uniacid']),array('count(id) as num'));
		//echo $num;die;
		include $this->template('order');
	}

	/**
	 * 删除订单
	 * @return [type] [description]
	 */
	public function doWebOrderdel(){
		global $_W,$_GPC;
		$ids = $_GPC['ids'];
		$res = pdo_delete('hcgroup_order',array('id'=>$ids));
		if(!empty($res)){
			exit(json_encode(array('code'=>1,'msg'=>'删除成功')));
		}
	}
	/**
	 * 店家添加发货备注
	 * @return [type] [description]
	 */
	public function doWebOrderremark(){
		global $_W,$_GPC;
		$id = $_GPC['id'];
		$remark = $_GPC['remark'];
		$res = pdo_update('hcgroup_order',array('sremark'=>$remark),array('id'=>$id));
		if(!empty($res)){
			message('操作成功',$this->createWebUrl('order_detail',array('order_id'=>$id)));
		}else{
			message('操作失败',$this->createWebUrl('order_detail',array('order_id'=>$id)));
		}
	}
	/**
	 * 店家发货
	 * @return [type] [description]
	 */
	public function doWebSendgoods(){
		global $_W,$_GPC;
		$id = $_GPC['id'];
		$data['express']    = $_GPC['express'];
		$data['expresscom'] = $_GPC['expresscom'];
		$data['expresssn']  = $_GPC['expresssn'];
		$data['status']  = 3;
		$data['sendtime']  = time();
		$res = pdo_update('hcgroup_order',$data,array('id'=>$id));
		if(!empty($res)){
			//更新团购发货单数
			$groupid = pdo_getcolumn('hcgroup_order',array('id'=>$id),array('groupid'));
			$shipped = pdo_getcolumn('hcgroup_group',array('id'=>$groupid),array('shipped'));
			pdo_update('hcgroup_group',array('shipped'=>$shipped+1),array('id'=>$groupid));


			$account = pdo_get('account_wxapp',array('uniacid'=>$_W['uniacid']),array('key','secret'));
            $token = $_COOKIE["access_token"];
            if (!$token) {
                $ress = file_get_contents('https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid='.$account['key'].'&secret='.$account['secret']);
                $ress = json_decode($ress, true);
                $token = $ress['access_token'];
                setcookie("access_token", $token, time()+7200);

            }
            $url = 'https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token='.$token;
           
            $info = pdo_fetch("SELECT package,openid,goods_id,orderno,sendtime,expresscom,expresssn FROM ".tablename('hcgroup_order')." as o left join ".tablename('hcgroup_member')." as m ON o.user_id=m.id WHERE o.id = :id AND o.uniacid=:uniacid" , array(':id'=>$id,':uniacid' => $_W['uniacid']));
 			$title = pdo_getcolumn('hcgroup_goods',array('goods_id'=>$info['goods_id']),array('title'));
            
            $data['touser']=$info['openid'];
            $tpl_msg = pdo_getcolumn('hcgroup_set',array('uniacid'=>$_W['uniacid']),array('tpl_msg'));
            $tpl_msg = json_decode($tpl_msg,true);
            $data['template_id'] = $tpl_msg['send_goods'];

            $data['form_id']=$info['package'];
          
            $data['data']['keyword1']['value']=$title;
            $data['data']['keyword1']['color']='#173177';
          
            $data['data']['keyword2']['value']=$info['orderno'];
            $data['data']['keyword2']['color']='#173177';
          
            $data['data']['keyword3']['value']=date('Y-m-d H:i',$info['sendtime']);
            $data['data']['keyword3']['color']='#173177';
          
            $data['data']['keyword4']['value']=$info['expresscom'];
            $data['data']['keyword4']['color']='#173177';
          
            $data['data']['keyword5']['value']=$info['expresssn'];
            $data['data']['keyword5']['color']='#173177';

            $data['page'] = 'hc_groups/pages/order/list/list?cid=WAIT_GET';
            $json = json_encode($data);
            //执行
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
            $output = curl_exec($ch);
            curl_close($ch);
            //file_put_contents(dirname(__FILE__)."/cert/1.txt",$output);
        	message('操作成功',$this->createWebUrl('order_detail',array('order_id'=>$id)));
		}else{
			message('操作失败',$this->createWebUrl('order_detail',array('order_id'=>$id)));
		}
	}

	/**
	 * 店家取消发货
	 * @return [type] [description]
	 */
	public function doWebCancelsend(){
		global $_W,$_GPC;
		$id = $_GPC['id'];
		$data['express']    = '';
		$data['expresscom'] = '';
		$data['expresssn']  = '';
		$data['status']  = 2;
		$data['sendtime']  = '';
		$res = pdo_update('hcgroup_order',$data,array('id'=>$id));
		if(!empty($res)){
			$groupid = pdo_getcolumn('hcgroup_order',array('id'=>$id),array('groupid'));
			$shipped = pdo_getcolumn('hcgroup_group',array('id'=>$groupid),array('shipped'));
			pdo_update('hcgroup_group',array('shipped'=>$shipped-1),array('id'=>$groupid));
			message('操作成功',$this->createWebUrl('order_detail',array('order_id'=>$id)));
		}else{
			message('操作失败',$this->createWebUrl('order_detail',array('order_id'=>$id)));
		}
	}
	public function doWebOrder_detail() {
		global $_W,$_GPC;
		$id = $_GPC['order_id'];
		$info = pdo_get('hcgroup_order',array('id'=>$id,'uniacid' => $_W['uniacid']));

		$address = pdo_get('hcgroup_member_address',array('id'=>$info['addressid']));
		$info['realname'] = $address['realname'];
		$info['mobile'] = $address['mobile'];
		$info['address'] = $address['province'] .' '. $address['city'] .' '. $address['area'] .' '. $address['address'];

		$goods_info = pdo_get('hcgroup_goods',array('goods_id'=>$info['goods_id']),array('title','unit','thumb'));
		$info['goods_name'] = $goods_info['title'];
		$info['goods_unit'] = $goods_info['unit'];
		$info['goods_thumb'] = $goods_info['thumb'];

		$express = array(
		    'ems'=>'EMS快递',
		    'shentong'=>'申通快递',
		    'shunfeng'=>'顺丰快递',
		    'yuantong'=>'圆通快递',
		    'yunda'=>'韵达快递',
		    'huitong'=>'百世汇通快递',
		    'tiantian'=>'天天快递',
		    'zhongtong'=>'中通快递',
		    'zhaijisong'=>'宅急送快递',
		    'pingyou'=>'中国邮政',
		    'quanfeng'=>'全峰快递',
		    'guotong'=>'国通快递',
		    'jingdong'=>'京东快递',
		    'yousu'=>'优速快递',
		    'debang'=>'德邦物流',
		    'rufeng'=>'如风达快递',
		);
		include $this->template('order_detail');
	}

	public function doWebGroup() {
		global $_W,$_GPC;
		$timetype = $_GPC['timetype'];
		$time = $_GPC['time'];
		$keywordtype = $_GPC['keywordtype'];
		$keyword = $_GPC['keyword'];
		$status = $_GPC['status'];
		if(!empty($_GPC['status'])){
			$where ="uniacid =". $_W['uniacid']." and status = ".$_GPC['status'];
		}else{
			$where = "uniacid =". $_W['uniacid'];
		}
		if($timetype==1 && !empty($time)){
			$where .= " and starttime >=".strtotime($time['start'])." and starttime <=".strtotime($time['end']."+1 day")."";
		}else if($timetype==2 & !empty($time)){
			$where .= " and endtime >=".strtotime($time['start'])." and endtime <=".strtotime($time['end']."+1 day")."";
		}
		if($keywordtype==1 && !empty($keyword)){
			$where .= " and id = ".$keyword."";
		}else if($keywordtype==2 && !empty($keyword)){
			$goodsids = pdo_getall('hcgroup_goods',array('title LIKE'=> '%'.$keyword.'%'),array('goods_id'));
			foreach ($goodsids as $k => $v) {
				$ids[$k] = $v['goods_id'];
			}
			implode(',',$ids);

			$where .= " and goods_id in(".implode(',',$ids).")";
		}else if($keywordtype==3 && !empty($keyword)){
			$where .= " and goods_id = ".$keyword."";
		}

		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$count = pdo_fetchall("SELECT * FROM ".tablename('hcgroup_group')." WHERE ".$where." ORDER BY starttime DESC");
        $total = count($count);
		$p = ($pageindex-1) * 10;
        $list = pdo_fetchall("SELECT * FROM ".tablename('hcgroup_group')." WHERE ".$where." ORDER BY starttime DESC LIMIT " . $p . "," . $pagesize);
		$page = pagination($total, $pageindex, $pagesize);




		$total0 = pdo_getcolumn('hcgroup_order',array(),array('count(id) as num'));
		$total1 = pdo_getcolumn('hcgroup_group',array('status'=>1),array('count(id) as num'));
		$total2 = pdo_getcolumn('hcgroup_group',array('status'=>2),array('count(id) as num'));
		$total3 = pdo_getcolumn('hcgroup_group',array('status'=>3),array('count(id) as num'));
		include $this->template('group');
	}
	public function doWebGroup_post() {
		global $_W,$_GPC;
		$id = $_GPC['id'];
		$group = pdo_get('hcgroup_group',array('id'=>$id));
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;
		$list = pdo_getslice('hcgroup_order',array('groupid'=>$id),array($pageindex, $pagesize),$total,array(),'','starttime desc');
		$page = pagination($total, $pageindex, $pagesize);
		//echo "<pre>";print_r($list);die;
		foreach ($list as $key => $val) {
			$goods_info = pdo_get('hcgroup_goods',array('goods_id'=>$val['goods_id']),array('title','unit','thumb'));
			$list[$key]['goods_name'] = substr($goods_info['title'],0,40);
			$list[$key]['goods_unit'] = $goods_info['unit'];
			$list[$key]['goods_thumb'] = $goods_info['thumb'];

			$member = pdo_get('hcgroup_member',array('id'=>$val['user_id']));
			$list[$key]['openid'] = $member['openid'];
			$list[$key]['avatar'] = $member['avatar'];

			$address = pdo_get('hcgroup_member_address',array('id'=>$val['addressid']));
			$list[$key]['realname'] = $address['realname'];
			$list[$key]['mobile'] = $address['mobile'];
			$list[$key]['address'] = $address['province'] .' '. $address['city'] .' '. $address['area'] .' '. $address['address'];
		}
		
		include $this->template('group_post');
	}

	public function doWebRefund() {
		global $_W,$_GPC;
		$where['uniacid'] = $_W['uniacid'];

		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$list = pdo_getslice('hcgroup_order_refund',$where,array($pageindex, $pagesize),$total,array(),'','applytime desc');
		foreach ($list as $key => $val) {
			$info = pdo_fetch("SELECT m.title,m.thumb FROM ".tablename('hcgroup_order')." as o left join ".tablename('hcgroup_goods')." as m ON o.goods_id=m.goods_id WHERE o.id = :orderid AND o.uniacid=:uniacid" , array(':orderid'=>$val['orderid'],':uniacid' => $_W['uniacid']));
			$user = pdo_get('hcgroup_member',array('id'=>$val['user_id'],'uniacid' => $_W['uniacid']),array('nickname','avatar'));
			$list[$key]['thumb'] = $info['thumb'];
			$list[$key]['title'] = $info['title'];
			$list[$key]['nickname'] = $user['nickname'];
			$list[$key]['avatar'] = $user['avatar'];
		}
		//echo "<pre>";print_r($list);die;
		$page = pagination($total, $pageindex, $pagesize);
		include $this->template('refund');
	}

	public function doWebRefund_post() {
		global $_W,$_GPC;
		$info = pdo_get('hcgroup_order_refund',array('id'=>$_GPC['id']));
		$order = pdo_get('hcgroup_order',array('id'=>$info['orderid']));
		$user = pdo_get('hcgroup_member',array('id'=>$info['user_id']),array('nickname'));
		$goods = pdo_get('hcgroup_goods',array('goods_id'=>$order['goods_id']),array('title','unit'));
		if($_GPC['act']=='dealrefund'){
			$id = $_GPC['id'];
			$data['refundstatus'] = $_GPC['refundstatus'];
			if($data['refundstatus']==1){
				$account = pdo_get('account_wxapp',array('uniacid'=>$_W['uniacid']));
		        $appid = $account['key'];
		        $wxapp = pdo_get('uni_settings',array('uniacid'=>$_W['uniacid']));
		        
		        $payment = unserialize($wxapp['payment']);
		        $mch_id = $payment['wechat']['mchid'];
		        $signkey = $payment['wechat']['signkey'];
		       	$this->do_refund($appid,$mch_id,$signkey,$order,$id);
		       	message('操作成功',$this->createWebUrl('Refund_post',array('id'=>$id)));
			}else if($data['refundstatus']==3){
				$data['reject_time'] = time();
				$data['reject_reason'] = $_GPC['reject_reason'];
				$data['reject_remark'] = $_GPC['reject_remark'];
				$res = pdo_update('hcgroup_order_refund',$data,array('id'=>$id));
				if(!empty($res)){
					message('操作成功',$this->createWebUrl('Refund_post',array('id'=>$id)));
				}
			}
		}
		include $this->template('refund_post');
	}
	public function doWebUser() {
		global $_W,$_GPC;
		$keyword = $_GPC['keyword'];
		if(!empty($_GPC['keyword'])){
			$where['nickname LIKE'] = '%'.$keyword.'%';
		}
		$where['uniacid'] = $_W['uniacid'];
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$list = pdo_getslice('hcgroup_member',$where,array($pageindex, $pagesize),$total,array(),'','createtime desc');
		$page = pagination($total, $pageindex, $pagesize);
		include $this->template('user');
	}
	public function doWebUser_del() {
		global $_W,$_GPC;
		$user_id = $_GPC['user_id'];
		$result = pdo_delete('hcgroup_member',array('id'=>$user_id));
		if (!empty($result)) {
		    message('操作成功',$this->createWebUrl('user'));
		}
	}

	public function doWebData() {
		global $_W,$_GPC;

		$order = pdo_getcolumn('hcgroup_order',array('status'=>1,'uniacid' => $_W['uniacid']),array('count(*)'));
		$amount = pdo_getcolumn('hcgroup_order',array('status'=>1,'uniacid' => $_W['uniacid']),array('sum(fact_amount)'));
		$payorder = pdo_getcolumn('hcgroup_order',array('status'=>2,'uniacid' => $_W['uniacid']),array('count(*)'));
		$payamount = pdo_getcolumn('hcgroup_order',array('status'=>2,'uniacid' => $_W['uniacid']),array('sum(fact_amount)'));
 
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;
        $count = pdo_fetchall("SELECT * FROM ".tablename('hcgroup_order')." AS o LEFT JOIN ".tablename('hcgroup_goods')." AS g ON o.goods_id=g.goods_id WHERE isdelete=0 AND o.status=4 and o.uniacid'=".$_W['uniacid']." GROUP BY g.goods_id");
		$total = count($count);
		$p = ($pageindex-1) * 10;
		$list = pdo_fetchall("SELECT g.title,g.thumb,sum(number) AS num,sum(fact_amount) AS amount FROM ".tablename('hcgroup_order')." AS o LEFT JOIN ".tablename('hcgroup_goods')." AS g ON o.goods_id=g.goods_id WHERE isdelete=0 AND o.status=4 and o.uniacid'=".$_W['uniacid']." GROUP BY g.goods_id ORDER BY amount DESC LIMIT " . $p . "," . $pagesize);
		$page = pagination($total, $pageindex, $pagesize);
		include $this->template('data');
	}

	public function doWebNotice() {
		global $_W,$_GPC;

		$where['uniacid'] = $_W['uniacid'];
		
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$list = pdo_getslice('hcgroup_notice',$where,array($pageindex, $pagesize),$total,array(),'','displayorder asc');
		foreach($list as $key=>$val){
			$list[$key]['createtime'] = date('Y-m-d H:i',$val['createtime']);
		}
		$page = pagination($total, $pageindex, $pagesize);

		include $this->template('notice');
	}



	public function doWebNotice_post() {
		global $_W,$_GPC;
		$id = $_GPC['id'];

		if($_GPC['act']=='add'){
			$data['uniacid'] = $_W['uniacid'];
			$data['createtime'] = time();
			empty($_GPC['title'])?'':$data['title'] = $_GPC['title'];
			empty($_GPC['content'])?'':$data['content'] = $_GPC['content'];
			empty($_GPC['enabled'])?'':$data['enabled'] = $_GPC['enabled'];

			$result = pdo_insert('hcgroup_notice', $data);
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('notice'));
			}
		}

		if($_GPC['act']=='edit'){
			$data['uniacid'] = $_W['uniacid'];
			$data['createtime'] = time();
			empty($_GPC['title'])?'':$data['title'] = $_GPC['title'];
			empty($_GPC['content'])?'':$data['content'] = $_GPC['content'];
			empty($_GPC['enabled'])?'':$data['enabled'] = $_GPC['enabled'];

			$result = pdo_update('hcgroup_notice', $data, array('id'=>$_GPC['id']));
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('notice'));
			}
		}

		if($_GPC['act']=='del'){
			$result = pdo_delete('hcgroup_notice', array('id'=>$_GPC['id']));
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('notice'));
			}
		}
		$info = pdo_get('hcgroup_notice',array('id'=>$id));

		include $this->template('notice_post');
	}
	/**
	 * 导航列表
	 * @return $list
	 */
	public function doWebNav() {
		global $_W,$_GPC;

		$list = pdo_getslice('hcgroup_nav',array('parentid'=>0,'uniacid' => $_W['uniacid']));
		foreach ($list as $key => $value) {
			$second = pdo_getall('hcgroup_nav', array('parentid'=>$value['id'],'uniacid' => $_W['uniacid']));
			$list[$key]['children'] = $second;
			unset($second);
		}
		include $this->template('nav');
	}

	public function doWebNav_post() {
		global $_W,$_GPC;
		$id = $_GPC['id'];

		if($_GPC['act']=='add'){
			$data['uniacid'] = $_W['uniacid']; 
			empty($_GPC['parentid'])?'':$data['parentid'] = $_GPC['parentid'];
			empty($_GPC['name'])?'':$data['name'] = $_GPC['name'];
			empty($_GPC['icon'])?'':$data['icon'] = $_GPC['icon'];
			empty($_GPC['tpl'])?'':$data['tpl'] = $_GPC['tpl'];
			empty($_GPC['url'])?'':$data['url'] = $_GPC['url'];
			empty($_GPC['displayorder'])?'':$data['displayorder'] = $_GPC['displayorder'];
			empty($_GPC['status'])?'':$data['status'] = $_GPC['status'];

			$result = pdo_insert('hcgroup_nav', $data);
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('nav'));
			}
		}

		if($_GPC['act']=='edit'){

			$data['uniacid'] = $_W['uniacid']; 
			empty($_GPC['parentid'])?'':$data['parentid'] = $_GPC['parentid'];
			empty($_GPC['name'])?'':$data['name'] = $_GPC['name'];
			empty($_GPC['icon'])?'':$data['icon'] = $_GPC['icon'];
			empty($_GPC['tpl'])?'':$data['tpl'] = $_GPC['tpl'];
			empty($_GPC['url'])?'':$data['url'] = $_GPC['url'];
			empty($_GPC['displayorder'])?'':$data['displayorder'] = $_GPC['displayorder'];
			empty($_GPC['status'])?'':$data['status'] = $_GPC['status'];

			//$result = pdo_update('hcgroup_nav', array('id'=>$_GPC['id']), $data);
			$result = pdo_update('hcgroup_nav', $data, array('id' => $_GPC['id']));
			if (!empty($result)) {
			    message('更新成功',$this->createWebUrl('nav'));
			}
			message('操作失败');
		}

		if($_GPC['act']=='del'){
			$result = pdo_delete('hcgroup_nav', array('id'=>$_GPC['id']));
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('nav'));
			}
		}
		if($_GPC['act']=='display'){
			$result = pdo_update('hcgroup_nav',array('displayorder'=>$_GPC['displayorder']),array('id'=>$_GPC['id']));
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('nav'));
			}
		}
		$category = pdo_getall('hcgroup_nav',array('parentid'=>0,'status'=>1));
		$info = pdo_get('hcgroup_nav',array('id'=>$id));

		include $this->template('nav_post');
	}

	public function doWebAdv() {
		global $_W,$_GPC;
		$where['uniacid'] = $_W['uniacid'];
		
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$list = pdo_getslice('hcgroup_adv',$where,array($pageindex, $pagesize),$total,array(),'','displayorder asc');
		$page = pagination($total, $pageindex, $pagesize);

		

		include $this->template('adv');
	}
	public function doWebAdv_post() {
		global $_W,$_GPC;
		$id = $_GPC['id'];

		if($_GPC['act']=='add'){
			$data['uniacid'] = $_W['uniacid'];
			empty($_GPC['displayorder'])?'':$data['displayorder'] = $_GPC['displayorder'];
			empty($_GPC['advname'])?'':$data['advname'] = $_GPC['advname'];
			empty($_GPC['link'])?'':$data['link'] = $_GPC['link'];
			empty($_GPC['thumb'])?'':$data['thumb'] = $_GPC['thumb'];
			empty($_GPC['enabled'])?'':$data['enabled'] = $_GPC['enabled'];

			$result = pdo_insert('hcgroup_adv', $data);
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('adv'));
			}
		}

		if($_GPC['act']=='edit'){
			$data['uniacid'] = $_W['uniacid'];
			empty($_GPC['displayorder'])?'':$data['displayorder'] = $_GPC['displayorder'];
			empty($_GPC['advname'])?'':$data['advname'] = $_GPC['advname'];
			empty($_GPC['link'])?'':$data['link'] = $_GPC['link'];
			empty($_GPC['thumb'])?'':$data['thumb'] = $_GPC['thumb'];
			empty($_GPC['enabled'])?'':$data['enabled'] = $_GPC['enabled'];

			$result = pdo_update('hcgroup_adv', $data, array('id'=>$_GPC['id']));
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('adv'));
			}
		}

		if($_GPC['act']=='del'){
			$result = pdo_delete('hcgroup_adv', array('id'=>$_GPC['id']));
			
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('adv'));
			}
		}
		if($_GPC['act']=='display'){
			$result = pdo_update('hcgroup_adv',array('displayorder'=>$_GPC['displayorder']),array('id'=>$_GPC['id']));
			if (!empty($result)) {
			    message('操作成功',$this->createWebUrl('nav'));
			}
		}
		$info = pdo_get('hcgroup_adv',array('id'=>$id));

		include $this->template('adv_post');
	}
	public function doWebActiv(){
		global $_W,$_GPC;

		$where['uniacid'] = $_W['uniacid'];
		
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;

		$list = pdo_getslice('hcgroup_activ',$where,array($pageindex, $pagesize),$total,array(),'','start_time desc');
		foreach($list as $key=>$val){
			$list[$key]['start_time'] = date('Y-m-d H:i',$val['start_time']);
			$list[$key]['end_time'] = date('Y-m-d H:i',$val['end_time']);
			$list[$key]['luck_time'] = date('Y-m-d H:i',$val['luck_time']);

			$list[$key]['luck_name'] = pdo_getcolumn('hcgroup_member',array('id'=>$val['luck_user_id'],'uniacid'=>$_W['uniacid']),array('nickname'));
		}
		$page = pagination($total, $pageindex, $pagesize);
		include $this->template('activ');
	}

	public function doWebActiv_post(){
		global $_W,$_GPC;
		$where['uniacid'] = $uniacid = $_W['uniacid'];
		$actno = $_GPC['actno'];
		$activ = pdo_get('hcgroup_activ',array('actno'=>$actno,'uniacid'=>$uniacid));
		if(!empty($activ['luck_user_id'])){
			$nickname = pdo_getcolumn('hcgroup_member',array('id'=>$activ['luck_user_id']),array('nickname'));
			$orderstatus = pdo_getcolumn('hcgroup_order',array('actno'=>$actno,'user_id'=>$activ['luck_user_id'],'uniacid'=>$uniacid),array('status'));
		}
		$pageindex = max(1, intval($_GPC['page']));
        $pagesize = 10;
		$list = pdo_getslice('hcgroup_order',array('actno'=>$actno,'uniacid'=>$uniacid),array($pageindex, $pagesize),$total,array(),'','starttime desc');
		$page = pagination($total, $pageindex, $pagesize);
		//echo "<pre>";print_r($list);die;
		foreach ($list as $key => $val) {
			$goods_info = pdo_get('hcgroup_goods',array('goods_id'=>$val['goods_id']),array('title','unit','thumb'));
			$list[$key]['goods_name'] = $goods_info['title'];
			$list[$key]['goods_unit'] = $goods_info['unit'];
			$list[$key]['goods_thumb'] = $goods_info['thumb'];

			$member = pdo_get('hcgroup_member',array('id'=>$val['user_id']));
			$list[$key]['openid'] = $member['openid'];
			$list[$key]['avatar'] = $member['avatar'];

			$address = pdo_get('hcgroup_member_address',array('id'=>$val['addressid']));
			$list[$key]['realname'] = $address['realname'];
			$list[$key]['mobile'] = $address['mobile'];
			$list[$key]['address'] = $address['province'] .' '. $address['city'] .' '. $address['area'] .' '. $address['address'];
		}
		include $this->template('activ_post');
	}

	public function doWebSendluck(){
		global $_W,$_GPC;
		$actno = $_GPC['actno'];
		$uniacid = $_W['uniacid'];

		$account = pdo_get('account_wxapp',array('uniacid'=>$uniacid));
        $appid = $account['key'];
        $wxapp = pdo_get('uni_settings',array('uniacid'=>$uniacid));
        
        $payment = unserialize($wxapp['payment']);
        $mch_id = $payment['wechat']['mchid'];
        $signkey = $payment['wechat']['signkey'];

		$activ = pdo_get('hcgroup_activ',array('actno'=>$actno,'uniacid'=>$uniacid));

		$ids = explode(',',$activ['user_ids']);
		$rand=array_rand($ids,1);
		$user_id = $ids[$rand];
		//获取这个人的订单
		$orders = pdo_get('hcgroup_order',array('actno'=>$actno,'user_id'=>$user_id,'uniacid'=>$uniacid));
		$act_arr = array('luck_user_id'=>$orders['user_id'],'luck_order_id'=>$orders['id'],'luck_time'=>time());
		pdo_update('hcgroup_activ',$act_arr,array('actno'=>$actno,'uniacid'=>$uniacid));
		pdo_update('hcgroup_order',array('status'=>5),array('actno'=>$actno,'user_id !='=>$orders['user_id'],'id'=>$orders['id'],'uniacid'=>$uniacid));

		//给未中奖用户退款
		$waitrefund =  pdo_getall('hcgroup_order',array('uniacid'=>$uniacid,'status'=>5,'actno'=>$actno));
       	foreach($waitrefund as $key=>$val){
       		$this->do_refund($appid,$mch_id,$signkey,$val);
       	}
       	//给中奖用户发送通知
       	$account = pdo_get('account_wxapp',array('uniacid'=>$orders['uniacid']),array('key','secret'));
        $token = $_COOKIE["access_token"];
        if (!$token) {
            $ress = file_get_contents('https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid='.$account['key'].'&secret='.$account['secret']);
            $ress = json_decode($ress, true);
            $token = $ress['access_token'];
            setcookie("access_token", $token, time()+7200);

        }
        $url = 'https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token='.$token;

       	$openid = pdo_getcolumn('hcgroup_member',array('id'=>$orders['user_id'],'uniacid'=>$orders['uniacid']),array('openid'));
       	$title = pdo_getcolumn('hcgroup_goods',array('goods_id'=>$orders['goods_id'],'uniacid'=>$orders['uniacid']),array('title'));
       	$data['touser']=$openid;
        $tpl_msg = pdo_getcolumn('hcgroup_set',array('uniacid'=>$orders['uniacid']),array('tpl_msg'));
        $tpl_msg = json_decode($tpl_msg,true);
        $data['template_id'] = $tpl_msg['luck_result'];

        $data['form_id']=$orders['package'];
      
        $data['data']['keyword1']['value']=$title;
        $data['data']['keyword1']['color']='#173177';
      
        $data['data']['keyword2']['value']=date('Y-m-d H:i',time());
        $data['data']['keyword2']['color']='#173177';
      
        $data['data']['keyword3']['value']='如果未按承诺时间发货，系统将按照规则进行赔偿。';
        $data['data']['keyword3']['color']='#173177';

        $data['page'] = 'hc_groups/pages/order/list/list?cid=WAIT_SEND';
        $json = json_encode($data);
        //执行
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        $output = curl_exec($ch);
        curl_close($ch);
        unset($json);

		message('操作成功',$this->createWebUrl('activ_post',array('actno'=>$actno)));
	}

	/**
	 * 服务器计划 -- 自动签收
	 */
	public function doWebServerplan_finish() {
		ignore_user_abort(true);
		set_time_limit(0);
		$interval=10;
		global $_W,$_GPC;
		if(!empty($_GPC['status'])){
			pdo_update('hcgroup_set',array('autosign_status'=>$_GPC['status']),array('uniacid'=>$_W['uniacid']));
			cache_write('plan2_uniacid', $_W['uniacid']);
		}
		do{
		    $run = $this->config();
		    if($run['autosign_status']==1){
		    	$uniacid = cache_load('plan2_uniacid');
		    	pdo_update('hcgroup_order',array('uniacid'=>$uniacid,'status'=>4,'finishtime'=>time()),array('status'=>3,'createtime <'=>time()-$run['autosign_status']*86400));
				flush();  
				ob_flush();
				sleep($interval);
		    }else{
		    	cache_delete('plan2_uniacid');
		    }
		}while(true);
	}
	/**
	 * 服务器计划 -- 自动退款
	 */
	public function doWebServerplan_refund() {
		ignore_user_abort(true);
		set_time_limit(0);
		$interval=5;
		global $_W,$_GPC;
		if(!empty($_GPC['status'])){
			pdo_update('hcgroup_set',array('autorefund_status'=>$_GPC['status']),array('uniacid'=>$_W['uniacid']));
			cache_write('plan_uniacid', $_W['uniacid']);
		}
		
		do{
		    $run = $this->config();
		    if($run['autorefund_status']==1){
		    	$uniacid = cache_load('plan_uniacid');
		    	$account = pdo_get('account_wxapp',array('uniacid'=>$uniacid));
		        $appid = $account['key'];
		        $wxapp = pdo_get('uni_settings',array('uniacid'=>$uniacid));
		        
		        $payment = unserialize($wxapp['payment']);
		        $mch_id = $payment['wechat']['mchid'];
		        $signkey = $payment['wechat']['signkey'];
		        //查看待退款订单
		        $config = $this->config();
		       	$waitrefund =  pdo_getall('hcgroup_order',array('uniacid'=>$uniacid,'status'=>2,'createtime <'=>time()-$config['autorefund']*86400));
		       	foreach($waitrefund as $key=>$val){
		       		$this->do_refund($appid,$mch_id,$signkey,$val);
		       	}
				flush();  
				ob_flush();
				sleep($interval);
		    }else{
		    	cache_delete('plan_uniacid');
		    }
		}while(true);
	}
	/**
	 * 服务器计划 -- 自动取消订单
	 */
	public function doWebServerplan_cancel() {
		ignore_user_abort(true);
		set_time_limit(0);
		$interval=15;
		global $_W,$_GPC;
		if(!empty($_GPC['status'])){
			pdo_update('hcgroup_set',array('autocancel_status'=>$_GPC['status']),array('uniacid'=>$_W['uniacid']));
			cache_write('plan1_uniacid', $_W['uniacid']);
		}
		do{
		    $run = $this->config();
		    if($run['autocancel_status']==1){
		    	$uniacid = cache_load('plan1_uniacid');
		    	pdo_update('hcgroup_order',array('uniacid'=>$uniacid,'status'=>7,'isshare'=>0,'canceltime'=>time()),array('status'=>1,'createtime <'=>time()-$run['autocancel']*3600));
		    	pdo_update('hcgroup_group',array('uniacid'=>$uniacid,'status'=>3),array('status'=>1,'starttime <'=>time()-$run['autocancel']*3600));
				flush();  
				ob_flush();
				sleep($interval);
		    }else{
		    	cache_delete('plan1_uniacid');
		    }
		}while(true);
	}


	public function config(){
		global $_W,$_GPC;
		return $config = pdo_get('hcgroup_set',array('uniacid'=>$_W['uniacid']),array('autosign','autosign_status','autorefund','autorefund_status','autocancel','autocancel_status'));
	}
	
	public function do_refund($appid,$mch_id,$signkey,$info,$refundid=''){
		global $_W,$_GPC;
		$model = new HcfkModel();
        //$info = pdo_get('hcgroup_order',array('id'=>$order_id));
        $total_fee = $info['fact_amount']*100;
        $refund_fee = $info['fact_amount']*100;
        $nonce_str = $model->getRandChar(32);
        $out_refund_no = empty($info['refundno'])?date('YmdHis').rand(111111,999999):$info['refundno'];
        $out_trade_no = $info['orderno'];
        $ref= strtoupper(md5("appid=".$appid."&mch_id=".$mch_id."&nonce_str=".$nonce_str."&out_refund_no=".$out_refund_no."&out_trade_no=".$out_trade_no."&refund_fee=".$refund_fee."&total_fee=".$total_fee."&key=".$signkey));//sign加密MD5

        $refund=array(
          'appid'=>$appid,//应用ID，固定
          'mch_id'=>$mch_id,//商户号，固定
          'nonce_str'=>$nonce_str,//随机字符串
          'out_refund_no'=>$out_refund_no,//商户内部唯一退款单号
          'out_trade_no'=>$out_trade_no,//商户订单号,pay_sn码 1.1二选一,微信生成的订单号，在支付通知中有返回
          'refund_fee'=>$refund_fee,
          'total_fee'=>$total_fee,
          'sign'=>$ref
        );

        $url="https://api.mch.weixin.qq.com/secapi/pay/refund";;//微信退款地址，post请求
        $xml=$model->arrayToXml($refund);

        $ch=curl_init();
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_HEADER,1);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,1);//证书检查
        curl_setopt($ch,CURLOPT_SSLCERTTYPE,'pem');
        curl_setopt($ch,CURLOPT_SSLCERT,dirname(__FILE__).'/cert/apiclient_cert_'.$info['uniacid'].'.pem');
        curl_setopt($ch,CURLOPT_SSLCERTTYPE,'pem');
        curl_setopt($ch,CURLOPT_SSLKEY,dirname(__FILE__).'/cert/apiclient_key_'.$info['uniacid'].'.pem');
        curl_setopt($ch,CURLOPT_SSLCERTTYPE,'pem');
        curl_setopt($ch,CURLOPT_CAINFO,dirname(__FILE__).'/cert/rootca_'.$info['uniacid'].'.pem');
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,$xml);

        $data=curl_exec($ch);
        if($data){
        	$data = $model->xmlstr_to_array($data);
	        if($data['result_code']!='FAIL'){
	        	if(empty($refundid)){
	        		$auto = array(
	        			'uniacid'=>$_W['uniacid'],
	        			'user_id'=>$info['user_id'],
	        			'orderid'=>$info['id'],
	        			'refundno'=>$out_refund_no,
	        			'refundtype'=>'后台自动退款',
	        			'refundstatus'=>1,
	        			'paytime'=>$info['paytime'],
	        			'paymoney'=>$info['fact_amount'],
	        			'reason'=>'后台自动退款',
	        			'content'=>'后台自动退款',
	        			'refundtime'=>time(),
	        			'refundmoney'=>$refund_fee/100,
	        			'applyprice' =>$refund_fee/100,
	        			'applytime' => time(),
	        			'backtime' => time()
		        	);
		          	pdo_insert('hcgroup_order_refund',$auto);
		        }else{
		          	$hand = array(
		          		'refundstatus'=>1,
		          		'refundtime'=>time(),
	        			'refundmoney'=>$refund_fee/100,
		          		'backtime' => time()
		          	);
		          	pdo_update('hcgroup_order_refund',$hand,array('id'=>$refundid));
		        }
	        	pdo_update('hcgroup_order',array('isshare'=>0,'status'=>6),array('id'=>$info['id']));//更改订单状态
	        	if($info['ishead']==1){
	        		pdo_update('hcgroup_group',array('status'=>3),array('id'=>$info['groupid']));//团长开团失败
	        	}else{
	        		$buynum = pdo_getcolumn('hcgroup_group',array('id'=>$_GPC['id']),array('buynum'));
	        		pdo_update('hcgroup_group',array('buynum'=>$buynum-1),array('id'=>$info['groupid']));
	        	}
	        }else{
	        	exit(json_encode(array('status'=>0,'msg'=>$data['err_code_des'])));
	        }
        }else{
          $error=curl_errno($ch);
          exit(json_encode(array('status'=>0,'msg'=>'退款失败',$error)));
        }
	}

}