<?php 
$sql="CREATE TABLE IF NOT EXISTS `ims_hcgroup_activ` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `actno` varchar(28) NOT NULL,
  `acttype` tinyint(3) NOT NULL DEFAULT '1' COMMENT '1一分拼',
  `goods_id` int(11) NOT NULL,
  `start_time` char(10) NOT NULL,
  `end_time` char(10) NOT NULL,
  `user_ids` text NOT NULL,
  `luck_user_id` int(11) NOT NULL,
  `luck_order_id` int(11) NOT NULL,
  `luck_time` char(10) NOT NULL,
  `neednum` int(11) NOT NULL DEFAULT '0',
  `currnum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_adv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `advname` varchar(50) DEFAULT '',
  `link` varchar(255) DEFAULT '',
  `thumb` varchar(255) DEFAULT '',
  `displayorder` int(11) DEFAULT '0',
  `enabled` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_enabled` (`enabled`),
  KEY `idx_displayorder` (`displayorder`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_goods` (
  `goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT NULL,
  `pcate` int(11) DEFAULT NULL COMMENT '一级分类',
  `ccate` int(11) DEFAULT NULL COMMENT '二级分类',
  `nav_pcate` tinyint(4) NOT NULL COMMENT '导航一级分类',
  `nav_ccate` tinyint(4) NOT NULL COMMENT '导航2级分类',
  `theme` varchar(100) NOT NULL COMMENT '主题',
  `type` tinyint(1) DEFAULT NULL COMMENT '类型',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态1上架2下架',
  `displayorder` int(11) DEFAULT '0' COMMENT '排序',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `thumb` varchar(255) DEFAULT NULL COMMENT '首页图片',
  `unit` varchar(5) DEFAULT NULL COMMENT '单位',
  `description` varchar(1000) DEFAULT NULL COMMENT '商品简介',
  `content` text COMMENT '商品详情',
  `goodssn` varchar(50) DEFAULT NULL COMMENT '编号',
  `groupprice` decimal(10,2) DEFAULT '0.00' COMMENT '团购价',
  `singleprice` decimal(10,2) DEFAULT '0.00' COMMENT '单买价',
  `marketprice` decimal(10,2) DEFAULT '0.00' COMMENT '市场价',
  `peoplenumber` tinyint(3) DEFAULT '0' COMMENT '起团人数',
  `timelimit` int(11) DEFAULT '0' COMMENT '团购限时',
  `timelimittime` datetime NOT NULL COMMENT '限时截止日期',
  `hotstyle` tinyint(1) NOT NULL COMMENT '特价爆款',
  `headdiscount` tinyint(1) DEFAULT '0' COMMENT '团长优惠1优惠',
  `headdiscountprice` decimal(10,2) DEFAULT '0.00' COMMENT '团长优惠金额',
  `stock` int(11) DEFAULT '0' COMMENT '库存',
  `sales_num` int(11) DEFAULT '0' COMMENT '销量',
  `void_num` int(11) DEFAULT '0' COMMENT '虚拟销量',
  `groupbuy_limit` int(11) DEFAULT '0' COMMENT '团购单次购买上限',
  `singlebuy_limit` int(11) DEFAULT '0' COMMENT '单买单词购买上限',
  `totalbuy_limit` int(11) DEFAULT '0' COMMENT '购买总数量上限',
  `free_shipping` tinyint(1) DEFAULT '0' COMMENT '1包邮',
  `postage` decimal(10,2) DEFAULT NULL COMMENT '邮费',
  `hasoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1启用规格',
  `is_rec` tinyint(1) NOT NULL,
  `is_hot` tinyint(1) NOT NULL,
  `is_new` tinyint(1) NOT NULL,
  `createtime` char(10) NOT NULL,
  `is_luck` char(1) NOT NULL,
  `luckdrawprice` decimal(10,2) NOT NULL,
  `luckdrawcon` int(11) NOT NULL,
  `actno` varchar(28) NOT NULL,
  PRIMARY KEY (`goods_id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_goods_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `parentid` int(11) DEFAULT '0' COMMENT '上级ID',
  `name` varchar(50) DEFAULT NULL COMMENT '分类标题',
  `thumb` varchar(255) DEFAULT NULL COMMENT '图片',
  `displayorder` tinyint(3) unsigned DEFAULT '0' COMMENT '排序',
  `enabled` tinyint(1) DEFAULT '1' COMMENT '是否显示',
  `isrecommand` tinyint(3) DEFAULT '0' COMMENT '是否推荐1',
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_displayorder` (`displayorder`),
  KEY `idx_enabled` (`enabled`)
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_goods_image` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=499 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_goods_spec` (
  `spec_id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT NULL,
  `spec_number` varchar(15) NOT NULL,
  `goods_id` int(11) DEFAULT NULL COMMENT '商品ID',
  `spec_title` varchar(100) DEFAULT NULL COMMENT '规格名称',
  `spec_item` text NOT NULL COMMENT '规格项',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_goods_spec_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT NULL,
  `goods_id` int(11) NOT NULL,
  `option_id` varchar(100) DEFAULT NULL COMMENT '规格项编号',
  `option_title` varchar(100) DEFAULT NULL COMMENT '规格项',
  `option_marketprice` decimal(10,2) DEFAULT NULL COMMENT '团购价',
  `option_productprice` decimal(10,2) NOT NULL COMMENT '单买价',
  `option_costprice` decimal(10,2) NOT NULL COMMENT '市场价',
  `option_stock` int(11) NOT NULL COMMENT '库存',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `goods_id` int(11) NOT NULL,
  `goods_name` varchar(255) NOT NULL DEFAULT '',
  `buynum` int(11) NOT NULL COMMENT '已买人数',
  `neednum` int(11) NOT NULL COMMENT '总需人数',
  `shipped` int(11) NOT NULL COMMENT '已发货数量',
  `starttime` char(10) NOT NULL COMMENT '开团时间',
  `endtime` char(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1团购中2成功3失败',
  `actno` varchar(28) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_enabled` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3015 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_hotsearch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `num` int(11) NOT NULL,
  `uniacid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_member` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `openid` varchar(50) DEFAULT '',
  `realname` varchar(20) DEFAULT '',
  `mobile` varchar(11) DEFAULT '',
  `content` text,
  `createtime` int(10) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `nickname` varchar(255) DEFAULT '',
  `birthday` varchar(255) DEFAULT '',
  `gender` tinyint(3) DEFAULT '0',
  `avatar` varchar(255) DEFAULT '',
  `country` varchar(255) DEFAULT NULL,
  `province` varchar(255) NOT NULL,
  `city` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_openid` (`openid`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_member_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `realname` varchar(20) DEFAULT '',
  `mobile` varchar(11) DEFAULT '',
  `province` varchar(30) DEFAULT '',
  `city` varchar(30) DEFAULT '',
  `area` varchar(30) DEFAULT '',
  `address` varchar(300) DEFAULT '',
  `isdefault` tinyint(1) DEFAULT '0',
  `zipcode` varchar(255) DEFAULT '',
  `deleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_isdefault` (`isdefault`),
  KEY `idx_deleted` (`deleted`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_nav` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `parentid` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `displayorder` int(11) DEFAULT '0',
  `status` tinyint(3) DEFAULT '0',
  `tpl` varchar(50) NOT NULL COMMENT '模板类型',
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`),
  KEY `idx_uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `displayorder` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `thumb` varchar(200) NOT NULL,
  `link` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `enabled` tinyint(3) NOT NULL,
  `createtime` char(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `user_id` varchar(45) NOT NULL,
  `orderno` varchar(45) NOT NULL,
  `groupid` int(11) DEFAULT NULL,
  `paytime` int(11) DEFAULT NULL,
  `unit_price` decimal(11,2) DEFAULT '0.00',
  `number` int(11) DEFAULT NULL COMMENT '购买数量',
  `status` int(9) DEFAULT '1' COMMENT '1待支付2已支付代发货3已发货，待收货4收货,已完成5待退款6已退款7已取消',
  `isshare` char(1) NOT NULL DEFAULT '0',
  `addressid` int(11) DEFAULT '0',
  `goods_id` int(11) DEFAULT NULL,
  `option_id` varchar(500) DEFAULT NULL COMMENT '规格项ID',
  `option_title` varchar(500) DEFAULT NULL COMMENT '规格项名称',
  `ishead` tinyint(1) DEFAULT '0' COMMENT '1团长',
  `discount` decimal(10,2) DEFAULT '0.00',
  `fact_amount` decimal(10,2) DEFAULT NULL COMMENT '实际支付金额',
  `starttime` int(11) DEFAULT NULL,
  `canceltime` int(11) DEFAULT '0',
  `endtime` int(45) DEFAULT NULL,
  `createtime` int(11) DEFAULT NULL,
  `finishtime` int(11) DEFAULT '0',
  `refundid` int(11) DEFAULT '0',
  `refundstate` tinyint(2) DEFAULT '0',
  `refundtime` int(11) DEFAULT '0',
  `express` varchar(45) DEFAULT NULL,
  `expresscom` varchar(100) DEFAULT NULL,
  `expresssn` varchar(45) DEFAULT NULL,
  `sendtime` int(45) DEFAULT '0',
  `isdelete` char(1) NOT NULL DEFAULT '0' COMMENT '1删除订单',
  `remark` varchar(255) DEFAULT NULL COMMENT '买家备注',
  `sremark` varchar(2000) NOT NULL COMMENT '发货备注',
  `deletetime` char(10) NOT NULL COMMENT '订单删除时间',
  `iscomment` char(1) NOT NULL DEFAULT '0' COMMENT '1已评价',
  `package` varchar(50) NOT NULL COMMENT '微信支付返回',
  `actno` varchar(28) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_order_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT '0',
  `orderid` int(11) DEFAULT '0',
  `goodsid` int(11) DEFAULT '0',
  `openid` varchar(50) DEFAULT '',
  `nickname` varchar(50) DEFAULT '',
  `headimgurl` varchar(255) DEFAULT '',
  `level` tinyint(3) DEFAULT '0' COMMENT '1好2中3差',
  `desc_score` tinyint(1) NOT NULL,
  `express_score` tinyint(1) NOT NULL,
  `serve_score` tinyint(1) NOT NULL,
  `content` varchar(255) DEFAULT '',
  `images` text,
  `createtime` int(11) DEFAULT '0',
  `deleted` tinyint(3) DEFAULT '0',
  `append_content` varchar(255) DEFAULT '',
  `append_images` text,
  `reply_content` varchar(255) DEFAULT '',
  `reply_images` text,
  `append_reply_content` varchar(255) DEFAULT '',
  `append_reply_images` text,
  `istop` tinyint(3) DEFAULT '0',
  `checked` tinyint(3) NOT NULL DEFAULT '0',
  `replychecked` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_goodsid` (`goodsid`),
  KEY `idx_openid` (`openid`),
  KEY `idx_createtime` (`createtime`),
  KEY `idx_orderid` (`orderid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_order_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `mobile` varchar(11) NOT NULL COMMENT '联系电话',
  `orderid` int(11) NOT NULL DEFAULT '0',
  `refundno` varchar(45) NOT NULL DEFAULT '0',
  `refundstatus` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0未退1已退2撤销3驳回',
  `refundtype` varchar(50) NOT NULL COMMENT '退款类型',
  `shipstatus` varchar(10) NOT NULL COMMENT '收货状态',
  `content` varchar(500) NOT NULL COMMENT '退款说明',
  `reason` varchar(100) NOT NULL COMMENT '退款原因',
  `paytime` char(10) NOT NULL COMMENT '支付时间',
  `paymoney` decimal(11,2) NOT NULL COMMENT '实付金额',
  `refundtime` varchar(45) NOT NULL,
  `refundmoney` decimal(10,2) NOT NULL COMMENT '退款金额',
  `images` varchar(500) NOT NULL COMMENT '退款凭证，',
  `applyprice` decimal(11,2) NOT NULL COMMENT '申请退款金额',
  `applytime` char(10) NOT NULL COMMENT '申请退款时间',
  `reject_reason` varchar(500) NOT NULL COMMENT '驳回理由',
  `reject_remark` varchar(1000) NOT NULL COMMENT '驳回备注',
  `reject_time` char(10) NOT NULL COMMENT '驳回时间',
  `cancel_time` char(10) NOT NULL COMMENT '用户撤销时间',
  `cancel_remark` varchar(100) NOT NULL COMMENT '用户撤销备注',
  `backtime` char(10) NOT NULL COMMENT '到账时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `refundno` (`refundno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_paylog` (
  `plid` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `uniacid` int(11) NOT NULL,
  `acid` int(10) unsigned NOT NULL,
  `openid` varchar(40) NOT NULL,
  `tid` varchar(64) NOT NULL,
  `credit` int(10) NOT NULL DEFAULT '0',
  `creditmoney` decimal(10,2) NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `module` varchar(50) NOT NULL,
  `tag` varchar(2000) NOT NULL,
  `is_usecard` tinyint(3) unsigned NOT NULL,
  `card_type` tinyint(3) unsigned NOT NULL,
  `card_id` varchar(50) NOT NULL,
  `card_fee` decimal(10,2) unsigned NOT NULL,
  `encrypt_code` varchar(100) NOT NULL,
  `uniontid` varchar(50) NOT NULL,
  PRIMARY KEY (`plid`),
  KEY `idx_openid` (`openid`),
  KEY `idx_tid` (`tid`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `uniontid` (`uniontid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `ims_hcgroup_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL COMMENT '商城名称',
  `share_title` varchar(100) NOT NULL,
  `shop_logo` varchar(200) DEFAULT NULL COMMENT '商城logo',
  `telnumber` varchar(20) NOT NULL COMMENT '联系方式',
  `copyright` varchar(100) DEFAULT NULL COMMENT '版权',
  `desc` text COMMENT '描述',
  `autosign` char(1) DEFAULT '5' COMMENT '自动确认收货时间',
  `autosign_status` char(1) NOT NULL DEFAULT '0' COMMENT '1开启',
  `autorefund` tinyint(4) DEFAULT '3' COMMENT '自动退款时间',
  `autorefund_status` char(1) NOT NULL DEFAULT '0' COMMENT '1开启',
  `autocancel` tinyint(4) DEFAULT '1' COMMENT '自动取消订单时间',
  `autocancel_status` char(1) NOT NULL DEFAULT '0' COMMENT '1开启',
  `cert` text COMMENT '商户支付证书',
  `key` text COMMENT '支付证书私钥',
  `rootca` text COMMENT 'rootca证书',
  `tpl_msg` varchar(2000) NOT NULL COMMENT '模板消息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
";
pdo_run($sql);
if(!pdo_fieldexists("hcgroup_activ", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_activ", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `uniacid` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "actno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `actno` varchar(28) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "acttype")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `acttype` tinyint(3) NOT NULL DEFAULT '1' COMMENT '1一分拼';");
}
if(!pdo_fieldexists("hcgroup_activ", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `goods_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "start_time")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `start_time` char(10) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "end_time")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `end_time` char(10) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "user_ids")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `user_ids` text NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "luck_user_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `luck_user_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "luck_order_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `luck_order_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "luck_time")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `luck_time` char(10) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_activ", "neednum")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `neednum` int(11) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_activ", "currnum")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  `currnum` int(11) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_activ", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_activ")." ADD 
  UNIQUE KEY `id` (`id`)
;");
}
if(!pdo_fieldexists("hcgroup_adv", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_adv", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `uniacid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_adv", "advname")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `advname` varchar(50) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_adv", "link")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `link` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_adv", "thumb")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `thumb` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_adv", "displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `displayorder` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_adv", "enabled")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  `enabled` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_adv", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_adv", "idx_enabled")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  KEY `idx_enabled` (`enabled`);");
}
if(!pdo_fieldexists("hcgroup_adv", "idx_displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_adv")." ADD 
  KEY `idx_displayorder` (`displayorder`)
;");
}
if(!pdo_fieldexists("hcgroup_goods", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `goods_id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_goods", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `uniacid` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "pcate")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `pcate` int(11) DEFAULT NULL COMMENT '一级分类';");
}
if(!pdo_fieldexists("hcgroup_goods", "ccate")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `ccate` int(11) DEFAULT NULL COMMENT '二级分类';");
}
if(!pdo_fieldexists("hcgroup_goods", "nav_pcate")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `nav_pcate` tinyint(4) NOT NULL COMMENT '导航一级分类';");
}
if(!pdo_fieldexists("hcgroup_goods", "nav_ccate")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `nav_ccate` tinyint(4) NOT NULL COMMENT '导航2级分类';");
}
if(!pdo_fieldexists("hcgroup_goods", "theme")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `theme` varchar(100) NOT NULL COMMENT '主题';");
}
if(!pdo_fieldexists("hcgroup_goods", "type")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `type` tinyint(1) DEFAULT NULL COMMENT '类型';");
}
if(!pdo_fieldexists("hcgroup_goods", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `status` tinyint(1) DEFAULT '1' COMMENT '状态1上架2下架';");
}
if(!pdo_fieldexists("hcgroup_goods", "displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `displayorder` int(11) DEFAULT '0' COMMENT '排序';");
}
if(!pdo_fieldexists("hcgroup_goods", "title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `title` varchar(100) DEFAULT NULL COMMENT '标题';");
}
if(!pdo_fieldexists("hcgroup_goods", "thumb")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `thumb` varchar(255) DEFAULT NULL COMMENT '首页图片';");
}
if(!pdo_fieldexists("hcgroup_goods", "unit")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `unit` varchar(5) DEFAULT NULL COMMENT '单位';");
}
if(!pdo_fieldexists("hcgroup_goods", "description")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `description` varchar(1000) DEFAULT NULL COMMENT '商品简介';");
}
if(!pdo_fieldexists("hcgroup_goods", "content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `content` text COMMENT '商品详情';");
}
if(!pdo_fieldexists("hcgroup_goods", "goodssn")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `goodssn` varchar(50) DEFAULT NULL COMMENT '编号';");
}
if(!pdo_fieldexists("hcgroup_goods", "groupprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `groupprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 2) DEFAULT '0.00' COMMENT '团购价';");
}
if(!pdo_fieldexists("hcgroup_goods", "singleprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `singleprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 2) DEFAULT '0.00' COMMENT '单买价';");
}
if(!pdo_fieldexists("hcgroup_goods", "marketprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `marketprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 2) DEFAULT '0.00' COMMENT '市场价';");
}
if(!pdo_fieldexists("hcgroup_goods", "peoplenumber")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `peoplenumber` tinyint(3) DEFAULT '0' COMMENT '起团人数';");
}
if(!pdo_fieldexists("hcgroup_goods", "timelimit")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `timelimit` int(11) DEFAULT '0' COMMENT '团购限时';");
}
if(!pdo_fieldexists("hcgroup_goods", "timelimittime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `timelimittime` datetime NOT NULL COMMENT '限时截止日期';");
}
if(!pdo_fieldexists("hcgroup_goods", "hotstyle")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `hotstyle` tinyint(1) NOT NULL COMMENT '特价爆款';");
}
if(!pdo_fieldexists("hcgroup_goods", "headdiscount")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `headdiscount` tinyint(1) DEFAULT '0' COMMENT '团长优惠1优惠';");
}
if(!pdo_fieldexists("hcgroup_goods", "headdiscountprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `headdiscountprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 2) DEFAULT '0.00' COMMENT '团长优惠金额';");
}
if(!pdo_fieldexists("hcgroup_goods", "stock")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `stock` int(11) DEFAULT '0' COMMENT '库存';");
}
if(!pdo_fieldexists("hcgroup_goods", "sales_num")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `sales_num` int(11) DEFAULT '0' COMMENT '销量';");
}
if(!pdo_fieldexists("hcgroup_goods", "void_num")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `void_num` int(11) DEFAULT '0' COMMENT '虚拟销量';");
}
if(!pdo_fieldexists("hcgroup_goods", "groupbuy_limit")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `groupbuy_limit` int(11) DEFAULT '0' COMMENT '团购单次购买上限';");
}
if(!pdo_fieldexists("hcgroup_goods", "singlebuy_limit")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `singlebuy_limit` int(11) DEFAULT '0' COMMENT '单买单词购买上限';");
}
if(!pdo_fieldexists("hcgroup_goods", "totalbuy_limit")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `totalbuy_limit` int(11) DEFAULT '0' COMMENT '购买总数量上限';");
}
if(!pdo_fieldexists("hcgroup_goods", "free_shipping")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `free_shipping` tinyint(1) DEFAULT '0' COMMENT '1包邮';");
}
if(!pdo_fieldexists("hcgroup_goods", "postage")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `postage` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 2) DEFAULT NULL COMMENT '邮费';");
}
if(!pdo_fieldexists("hcgroup_goods", "hasoption")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `hasoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1启用规格';");
}
if(!pdo_fieldexists("hcgroup_goods", "is_rec")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `is_rec` tinyint(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "is_hot")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `is_hot` tinyint(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "is_new")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `is_new` tinyint(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "createtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `createtime` char(10) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "is_luck")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `is_luck` char(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "luckdrawprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `luckdrawprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 2) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "luckdrawcon")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `luckdrawcon` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods", "actno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods")." ADD 
  `actno` varchar(28) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_category", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_goods_category", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `uniacid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "parentid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `parentid` int(11) DEFAULT '0' COMMENT '上级ID';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "name")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `name` varchar(50) DEFAULT NULL COMMENT '分类标题';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "thumb")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `thumb` varchar(255) DEFAULT NULL COMMENT '图片';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `displayorder` tinyint(3) unsigned DEFAULT '0' COMMENT '排序';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "enabled")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `enabled` tinyint(1) DEFAULT '1' COMMENT '是否显示';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "isrecommand")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  `isrecommand` tinyint(3) DEFAULT '0' COMMENT '是否推荐1';");
}
if(!pdo_fieldexists("hcgroup_goods_category", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_goods_category", "idx_displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  KEY `idx_displayorder` (`displayorder`);");
}
if(!pdo_fieldexists("hcgroup_goods_category", "idx_enabled")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_category")." ADD 
  KEY `idx_enabled` (`enabled`)
;");
}
if(!pdo_fieldexists("hcgroup_goods_image", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_image")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_goods_image", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_image")." ADD 
  `goods_id` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_image", "thumb")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_image")." ADD 
  `thumb` varchar(255) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_image", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_image")." ADD 
  `status` tinyint(1) DEFAULT '1';");
}
if(!pdo_fieldexists("hcgroup_goods_spec", "spec_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec")." ADD 
  `spec_id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_goods_spec", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec")." ADD 
  `uniacid` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_spec", "spec_number")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec")." ADD 
  `spec_number` varchar(15) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_spec", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec")." ADD 
  `goods_id` int(11) DEFAULT NULL COMMENT '商品ID';");
}
if(!pdo_fieldexists("hcgroup_goods_spec", "spec_title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec")." ADD 
  `spec_title` varchar(100) DEFAULT NULL COMMENT '规格名称';");
}
if(!pdo_fieldexists("hcgroup_goods_spec", "spec_item")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec")." ADD 
  `spec_item` text NOT NULL COMMENT '规格项';");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `uniacid` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `goods_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "option_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `option_id` varchar(100) DEFAULT NULL COMMENT '规格项编号';");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "option_title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `option_title` varchar(100) DEFAULT NULL COMMENT '规格项';");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "option_marketprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `option_marketprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 2) DEFAULT NULL COMMENT '团购价';");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "option_productprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `option_productprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 2) NOT NULL COMMENT '单买价';");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "option_costprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `option_costprice` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 2) NOT NULL COMMENT '市场价';");
}
if(!pdo_fieldexists("hcgroup_goods_spec_item", "option_stock")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_goods_spec_item")." ADD 
  `option_stock` int(11) NOT NULL COMMENT '库存';");
}
if(!pdo_fieldexists("hcgroup_group", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_group", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `uniacid` int(11) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_group", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `goods_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_group", "goods_name")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `goods_name` varchar(255) NOT NULL DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_group", "buynum")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `buynum` int(11) NOT NULL COMMENT '已买人数';");
}
if(!pdo_fieldexists("hcgroup_group", "neednum")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `neednum` int(11) NOT NULL COMMENT '总需人数';");
}
if(!pdo_fieldexists("hcgroup_group", "shipped")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `shipped` int(11) NOT NULL COMMENT '已发货数量';");
}
if(!pdo_fieldexists("hcgroup_group", "starttime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `starttime` char(10) NOT NULL COMMENT '开团时间';");
}
if(!pdo_fieldexists("hcgroup_group", "endtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `endtime` char(10) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_group", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1团购中2成功3失败';");
}
if(!pdo_fieldexists("hcgroup_group", "actno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  `actno` varchar(28) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_group", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_group", "idx_enabled")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_group")." ADD 
  KEY `idx_enabled` (`status`)
;");
}
if(!pdo_fieldexists("hcgroup_hotsearch", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_hotsearch")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_hotsearch", "title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_hotsearch")." ADD 
  `title` varchar(200) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_hotsearch", "num")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_hotsearch")." ADD 
  `num` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_hotsearch", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_hotsearch")." ADD 
  `uniacid` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_member", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_member", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `uniacid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_member", "openid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `openid` varchar(50) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "realname")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `realname` varchar(20) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "mobile")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `mobile` varchar(11) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `content` text;");
}
if(!pdo_fieldexists("hcgroup_member", "createtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `createtime` int(10) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_member", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `status` tinyint(1) DEFAULT '1';");
}
if(!pdo_fieldexists("hcgroup_member", "nickname")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `nickname` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "birthday")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `birthday` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "gender")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `gender` tinyint(3) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_member", "avatar")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `avatar` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "country")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `country` varchar(255) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_member", "province")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `province` varchar(255) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_member", "city")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  `city` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_member", "idx_openid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  KEY `idx_openid` (`openid`);");
}
if(!pdo_fieldexists("hcgroup_member", "idx_status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member")." ADD 
  KEY `idx_status` (`status`)
;");
}
if(!pdo_fieldexists("hcgroup_member_address", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_member_address", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `uniacid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_member_address", "user_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `user_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_member_address", "realname")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `realname` varchar(20) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "mobile")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `mobile` varchar(11) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "province")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `province` varchar(30) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "city")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `city` varchar(30) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "area")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `area` varchar(30) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "address")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `address` varchar(300) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "isdefault")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `isdefault` tinyint(1) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_member_address", "zipcode")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `zipcode` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_member_address", "deleted")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  `deleted` tinyint(1) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_member_address", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_member_address", "idx_isdefault")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  KEY `idx_isdefault` (`isdefault`);");
}
if(!pdo_fieldexists("hcgroup_member_address", "idx_deleted")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_member_address")." ADD 
  KEY `idx_deleted` (`deleted`)
;");
}
if(!pdo_fieldexists("hcgroup_nav", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_nav", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `uniacid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_nav", "parentid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `parentid` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_nav", "name")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `name` varchar(255) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_nav", "icon")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `icon` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_nav", "url")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `url` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_nav", "displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `displayorder` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_nav", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `status` tinyint(3) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_nav", "tpl")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  `tpl` varchar(50) NOT NULL COMMENT '模板类型';");
}
if(!pdo_fieldexists("hcgroup_nav", "idx_status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  KEY `idx_status` (`status`);");
}
if(!pdo_fieldexists("hcgroup_nav", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_nav")." ADD 
  KEY `idx_uniacid` (`uniacid`)
;");
}
if(!pdo_fieldexists("hcgroup_notice", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_notice", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `uniacid` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "displayorder")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `displayorder` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `title` varchar(200) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "thumb")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `thumb` varchar(200) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "link")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `link` varchar(200) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `content` text NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "enabled")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `enabled` tinyint(3) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "createtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  `createtime` char(10) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_notice", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_notice")." ADD 
  UNIQUE KEY `id` (`id`)
;");
}
if(!pdo_fieldexists("hcgroup_order", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_order", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `uniacid` int(11) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "user_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `user_id` varchar(45) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "orderno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `orderno` varchar(45) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "groupid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `groupid` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "paytime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `paytime` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "unit_price")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `unit_price` decimal(11;");
}
if(!pdo_fieldexists("hcgroup_order", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 2) DEFAULT '0.00';");
}
if(!pdo_fieldexists("hcgroup_order", "number")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `number` int(11) DEFAULT NULL COMMENT '购买数量';");
}
if(!pdo_fieldexists("hcgroup_order", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `status` int(9) DEFAULT '1' COMMENT '1待支付2已支付代发货3已发货，待收货4收货;");
}
if(!pdo_fieldexists("hcgroup_order", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 已完成5待退款6已退款7已取消';");
}
if(!pdo_fieldexists("hcgroup_order", "isshare")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `isshare` char(1) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "addressid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `addressid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "goods_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `goods_id` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "option_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `option_id` varchar(500) DEFAULT NULL COMMENT '规格项ID';");
}
if(!pdo_fieldexists("hcgroup_order", "option_title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `option_title` varchar(500) DEFAULT NULL COMMENT '规格项名称';");
}
if(!pdo_fieldexists("hcgroup_order", "ishead")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `ishead` tinyint(1) DEFAULT '0' COMMENT '1团长';");
}
if(!pdo_fieldexists("hcgroup_order", "discount")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `discount` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_order", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 2) DEFAULT '0.00';");
}
if(!pdo_fieldexists("hcgroup_order", "fact_amount")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `fact_amount` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_order", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 2) DEFAULT NULL COMMENT '实际支付金额';");
}
if(!pdo_fieldexists("hcgroup_order", "starttime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `starttime` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "canceltime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `canceltime` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "endtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `endtime` int(45) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "createtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `createtime` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "finishtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `finishtime` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "refundid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `refundid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "refundstate")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `refundstate` tinyint(2) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "refundtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `refundtime` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "express")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `express` varchar(45) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "expresscom")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `expresscom` varchar(100) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "expresssn")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `expresssn` varchar(45) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "sendtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `sendtime` int(45) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order", "isdelete")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `isdelete` char(1) NOT NULL DEFAULT '0' COMMENT '1删除订单';");
}
if(!pdo_fieldexists("hcgroup_order", "remark")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `remark` varchar(255) DEFAULT NULL COMMENT '买家备注';");
}
if(!pdo_fieldexists("hcgroup_order", "sremark")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `sremark` varchar(2000) NOT NULL COMMENT '发货备注';");
}
if(!pdo_fieldexists("hcgroup_order", "deletetime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `deletetime` char(10) NOT NULL COMMENT '订单删除时间';");
}
if(!pdo_fieldexists("hcgroup_order", "iscomment")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `iscomment` char(1) NOT NULL DEFAULT '0' COMMENT '1已评价';");
}
if(!pdo_fieldexists("hcgroup_order", "package")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `package` varchar(50) NOT NULL COMMENT '微信支付返回';");
}
if(!pdo_fieldexists("hcgroup_order", "actno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  `actno` varchar(28) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order")." ADD 
  UNIQUE KEY `id` (`id`)
;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `uniacid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "orderid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `orderid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "goodsid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `goodsid` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "openid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `openid` varchar(50) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "nickname")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `nickname` varchar(50) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "headimgurl")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `headimgurl` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "level")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `level` tinyint(3) DEFAULT '0' COMMENT '1好2中3差';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "desc_score")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `desc_score` tinyint(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "express_score")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `express_score` tinyint(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "serve_score")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `serve_score` tinyint(1) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `content` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "images")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `images` text;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "createtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `createtime` int(11) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "deleted")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `deleted` tinyint(3) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "append_content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `append_content` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "append_images")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `append_images` text;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "reply_content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `reply_content` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "reply_images")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `reply_images` text;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "append_reply_content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `append_reply_content` varchar(255) DEFAULT '';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "append_reply_images")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `append_reply_images` text;");
}
if(!pdo_fieldexists("hcgroup_order_comment", "istop")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `istop` tinyint(3) DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "checked")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `checked` tinyint(3) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "replychecked")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  `replychecked` tinyint(3) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_comment", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_order_comment", "idx_goodsid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  KEY `idx_goodsid` (`goodsid`);");
}
if(!pdo_fieldexists("hcgroup_order_comment", "idx_openid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  KEY `idx_openid` (`openid`);");
}
if(!pdo_fieldexists("hcgroup_order_comment", "idx_createtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  KEY `idx_createtime` (`createtime`);");
}
if(!pdo_fieldexists("hcgroup_order_comment", "idx_orderid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_comment")." ADD 
  KEY `idx_orderid` (`orderid`)
;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `uniacid` int(11) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "user_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `user_id` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "mobile")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `mobile` varchar(11) NOT NULL COMMENT '联系电话';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "orderid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `orderid` int(11) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "refundno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `refundno` varchar(45) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "refundstatus")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `refundstatus` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0未退1已退2撤销3驳回';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "refundtype")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `refundtype` varchar(50) NOT NULL COMMENT '退款类型';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "shipstatus")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `shipstatus` varchar(10) NOT NULL COMMENT '收货状态';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "content")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `content` varchar(500) NOT NULL COMMENT '退款说明';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "reason")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `reason` varchar(100) NOT NULL COMMENT '退款原因';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "paytime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `paytime` char(10) NOT NULL COMMENT '支付时间';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "paymoney")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `paymoney` decimal(11;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 2) NOT NULL COMMENT '实付金额';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "refundtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `refundtime` varchar(45) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "refundmoney")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `refundmoney` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 2) NOT NULL COMMENT '退款金额';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "images")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `images` varchar(500) NOT NULL COMMENT '退款凭证，';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "applyprice")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `applyprice` decimal(11;");
}
if(!pdo_fieldexists("hcgroup_order_refund", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 2) NOT NULL COMMENT '申请退款金额';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "applytime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `applytime` char(10) NOT NULL COMMENT '申请退款时间';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "reject_reason")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `reject_reason` varchar(500) NOT NULL COMMENT '驳回理由';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "reject_remark")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `reject_remark` varchar(1000) NOT NULL COMMENT '驳回备注';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "reject_time")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `reject_time` char(10) NOT NULL COMMENT '驳回时间';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "cancel_time")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `cancel_time` char(10) NOT NULL COMMENT '用户撤销时间';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "cancel_remark")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `cancel_remark` varchar(100) NOT NULL COMMENT '用户撤销备注';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "backtime")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  `backtime` char(10) NOT NULL COMMENT '到账时间';");
}
if(!pdo_fieldexists("hcgroup_order_refund", "refundno")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_order_refund")." ADD 
  UNIQUE KEY `refundno` (`refundno`)
;");
}
if(!pdo_fieldexists("hcgroup_paylog", "plid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `plid` bigint(11) unsigned NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_paylog", "type")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `type` varchar(20) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `uniacid` int(11) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "acid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `acid` int(10) unsigned NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "openid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `openid` varchar(40) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "tid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `tid` varchar(64) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "credit")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `credit` int(10) NOT NULL DEFAULT '0';");
}
if(!pdo_fieldexists("hcgroup_paylog", "creditmoney")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `creditmoney` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_paylog", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 2) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "fee")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `fee` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_paylog", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 2) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `status` tinyint(4) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "module")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `module` varchar(50) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "tag")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `tag` varchar(2000) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "is_usecard")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `is_usecard` tinyint(3) unsigned NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "card_type")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `card_type` tinyint(3) unsigned NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "card_id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `card_id` varchar(50) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "card_fee")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `card_fee` decimal(10;");
}
if(!pdo_fieldexists("hcgroup_paylog", "")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 2) unsigned NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "encrypt_code")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `encrypt_code` varchar(100) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "uniontid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  `uniontid` varchar(50) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_paylog", "idx_openid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  KEY `idx_openid` (`openid`);");
}
if(!pdo_fieldexists("hcgroup_paylog", "idx_tid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  KEY `idx_tid` (`tid`);");
}
if(!pdo_fieldexists("hcgroup_paylog", "idx_uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  KEY `idx_uniacid` (`uniacid`);");
}
if(!pdo_fieldexists("hcgroup_paylog", "uniontid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_paylog")." ADD 
  KEY `uniontid` (`uniontid`)
;");
}
if(!pdo_fieldexists("hcgroup_set", "id")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `id` int(11) NOT NULL AUTO_INCREMENT;");
}
if(!pdo_fieldexists("hcgroup_set", "uniacid")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `uniacid` int(11) DEFAULT NULL;");
}
if(!pdo_fieldexists("hcgroup_set", "shop_name")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `shop_name` varchar(100) DEFAULT NULL COMMENT '商城名称';");
}
if(!pdo_fieldexists("hcgroup_set", "share_title")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `share_title` varchar(100) NOT NULL;");
}
if(!pdo_fieldexists("hcgroup_set", "shop_logo")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `shop_logo` varchar(200) DEFAULT NULL COMMENT '商城logo';");
}
if(!pdo_fieldexists("hcgroup_set", "telnumber")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `telnumber` varchar(20) NOT NULL COMMENT '联系方式';");
}
if(!pdo_fieldexists("hcgroup_set", "copyright")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `copyright` varchar(100) DEFAULT NULL COMMENT '版权';");
}
if(!pdo_fieldexists("hcgroup_set", "desc")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `desc` text COMMENT '描述';");
}
if(!pdo_fieldexists("hcgroup_set", "autosign")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `autosign` char(1) DEFAULT '5' COMMENT '自动确认收货时间';");
}
if(!pdo_fieldexists("hcgroup_set", "autosign_status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `autosign_status` char(1) NOT NULL DEFAULT '0' COMMENT '1开启';");
}
if(!pdo_fieldexists("hcgroup_set", "autorefund")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `autorefund` tinyint(4) DEFAULT '3' COMMENT '自动退款时间';");
}
if(!pdo_fieldexists("hcgroup_set", "autorefund_status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `autorefund_status` char(1) NOT NULL DEFAULT '0' COMMENT '1开启';");
}
if(!pdo_fieldexists("hcgroup_set", "autocancel")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `autocancel` tinyint(4) DEFAULT '1' COMMENT '自动取消订单时间';");
}
if(!pdo_fieldexists("hcgroup_set", "autocancel_status")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `autocancel_status` char(1) NOT NULL DEFAULT '0' COMMENT '1开启';");
}
if(!pdo_fieldexists("hcgroup_set", "cert")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `cert` text COMMENT '商户支付证书';");
}
if(!pdo_fieldexists("hcgroup_set", "key")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `key` text COMMENT '支付证书私钥';");
}
if(!pdo_fieldexists("hcgroup_set", "rootca")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `rootca` text COMMENT 'rootca证书';");
}
if(!pdo_fieldexists("hcgroup_set", "tpl_msg")) {
 pdo_query("ALTER TABLE ".tablename("hcgroup_set")." ADD 
  `tpl_msg` varchar(2000) NOT NULL COMMENT '模板消息';");
}

 ?>