<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 */
function optionsframework_option_name() {
	// Change this to use your theme slug
	return 'options-framework-theme';
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'theme-textdomain'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	
	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}

	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}


	// Pull all the pages into an array
	$options_pages = array();
	$options_pages_obj = get_pages( 'sort_column=post_parent,menu_order' );
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
		$options_pages[$page->ID] = $page->post_title;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/images/';

	$options = array();

	//基本设置
	$options[] = array(
		'name' => __( '基本设置', 'qzt' ),
		'type' => 'heading'
	);
	
	$options[] = array(
		'name' => '网站LOGO',
		'desc' => '上传你的网站logo',
		'id' => 'logo',
		'std' => 'http://www.qiuzhuti.com/images/logo.png',
		'type' => 'upload'
	);
			
	$options[] = array(
		'name' => '网站favicon',
		'desc' => '',
		'id' => 'favicon',
		'type' => 'upload'
	);
	
	$options[] = array(
		'name' => '关键词',
		'desc' => '',
		'id' => 'keywords',
		'std' => 'qiuzhuti,求主题,WordPress网站开发',
		'type' => 'textarea'
	);
	
	$options[] = array(
		'name' => '网站描述',
		'desc' => '',
		'id' => 'description',
		'std' => '专业提供wordpress主题定制开发，wordpress主题、wordpress模板、wordpress插件、wordpress企业主题免费下载。',
		'type' => 'textarea'
	);

	$options[] = array(
		'name' => '邮箱',
		'desc' => '',
		'id' => 'email',
		'std' => '15213335@qq.com',
		'type' => 'text'
	);
	
	$options[] = array(
		'name' => '底部版权',
		'desc' => '可加html标签',
		'id' => 'copyright',
		'std' => '<p>Copyright © 2017 [<a href="http://www.qiuzhuti.com">求主题</a>]',
		'type' => 'textarea'
	);
	
	$options[] = array(
		'name' => '统计代码',
		'desc' => '添加你的百度统计或者cnzz统计代码',
		'id' => 'tongji',
		'std' => '',
		'type' => 'textarea'
	);

	$options[] = array(
		'name' => __( '主页分类', 'theme-textdomain' ),
		'type' => 'heading'
	);
	
	$options[] = array(
			'name' => '主页分类一',
			'desc' => '主页电影分类，请把电影分类别名设置为“movie”',
			'id' => 'movie',
			'type' => 'select',
			'options' => $options_categories
		);
	$options[] = array(
			'name' => '主页分类二', 'theme-textdomain',
			'desc' => '主页电视剧分类，请把电视剧分类别名设置为“tv”',
			'id' => 'tv',
			'type' => 'select',
			'options' => $options_categories
		);
	$options[] = array(
			'name' => '主页分类三',
			'desc' => '主页动漫分类，请把动漫分类别名设置为“anime”',
			'id' => 'anime',
			'type' => 'select',
			'options' => $options_categories
		);
	$options[] = array(
			'name' => '主页分类四',
			'desc' => '主页综艺分类，请把综艺分类别名设置为“variety”',
			'id' => 'variety',
			'type' => 'select',
			'options' => $options_categories
		);
	
		$options[] = array(
		'name' => '分类页筛选',
		'id' => 'filter',
		'type' => "checkbox",
		'std' => false,
		'desc' => '开启（分类页标签/排序筛选）');

	$options[] = array(
		'name' => '筛选标签IDs',
		'desc' => '输入标签ID列表，多个用英文半角逗号隔开',
		'id' => 'filter_tags',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'name' => '筛选标签IDs2',
		'desc' => '输入标签ID列表，多个用英文半角逗号隔开',
		'id' => 'filter_tags2',
		'std' => '',
		'type' => 'text');
	
//幻灯片
		
	$options[] = array(
		'name' => __( '幻灯片设置', 'qzt' ),
		'type' => 'heading'
	);
	
    $options[] = array(
        'name' => '开启自定义幻灯',
        'desc' => '勾选显示',
        'id' => 'slidercustom',
        'std' => true, /* 默认值 */
        'type' => 'checkbox'
    );

	// 幻灯片01
    $options[] = array(
        'name' => '幻灯片1',
        'desc' => '宽度大于等于760px，高度保持统一。',
        'id' => 'slidermedia1',
        "std" => "",
        'type' => 'upload'
    );
    $options[] = array(
        'name' => '幻灯片1链接地址',
        'desc' => '链接地址，留空则无链接。',
        'id' => 'sliderurl1',
        'std' => '',
        'type' => 'text'
    );
    $options[] = array(
        'name' => '幻灯片1描述',
        'desc' => '描述内容',
        'id' => 'slidertitle1',
        'std' => '',
        'type' => 'text'
    );
	// 幻灯片02
    $options[] = array(
        'name' => '幻灯片2',
        'desc' => '宽度大于等于760px，高度保持统一。',
        'id' => 'slidermedia2',
        "std" => "",
        'type' => 'upload'
    );
    $options[] = array(
        'name' => '幻灯片2链接地址',
        'desc' => '链接地址，留空则无链接。',
        'id' => 'sliderurl2',
        'std' => '',
        'type' => 'text'
    );
    $options[] = array(
        'name' => '幻灯片2描述',
        'desc' => '描述内容',
        'id' => 'slidertitle2',
        'std' => '',
        'type' => 'text'
    );
	// 幻灯片03
    $options[] = array(
        'name' => '幻灯片3',
        'desc' => '宽度大于等于760px，高度保持统一。',
        'id' => 'slidermedia3',
        "std" => "",
        'type' => 'upload'
    );
    $options[] = array(
        'name' => '幻灯片3链接地址',
        'desc' => '链接地址，留空则无链接。',
        'id' => 'sliderurl3',
        'std' => '',
        'type' => 'text'
    );
    $options[] = array(
        'name' => '幻灯片3描述',
        'desc' => '描述内容',
        'id' => 'slidertitle3',
        'std' => '',
        'type' => 'text'
    );
	// 幻灯片04
    $options[] = array(
        'name' => '幻灯片4',
        'desc' => '宽度大于等于760px，高度保持统一。',
        'id' => 'slidermedia4',
        "std" => "",
        'type' => 'upload'
    );
    $options[] = array(
        'name' => '幻灯片4链接地址',
        'desc' => '链接地址，留空则无链接。',
        'id' => 'sliderurl4',
        'std' => '',
        'type' => 'text'
    );
    $options[] = array(
        'name' => '幻灯片4描述',
        'desc' => '描述内容',
        'id' => 'slidertitle4',
        'std' => '',
        'type' => 'text'
    );
	// 幻灯片05
    $options[] = array(
        'name' => '幻灯片5',
        'desc' => '宽度大于等于760px，高度保持统一。',
        'id' => 'slidermedia5',
        "std" => "",
        'type' => 'upload'
    );
    $options[] = array(
        'name' => '幻灯片5链接地址',
        'desc' => '链接地址，留空则无链接。',
        'id' => 'sliderurl5',
        'std' => '',
        'type' => 'text'
    );
    $options[] = array(
        'name' => '幻灯片5描述',
        'desc' => '描述内容',
        'id' => 'slidertitle5',
        'std' => '',
        'type' => 'text'
    );
	// 幻灯片06
    $options[] = array(
        'name' => '幻灯片6',
        'desc' => '宽度大于等于760px，高度保持统一。',
        'id' => 'slidermedia6',
        "std" => "",
        'type' => 'upload'
    );
    $options[] = array(
        'name' => '幻灯片6链接地址',
        'desc' => '链接地址，留空则无链接。',
        'id' => 'sliderurl6',
        'std' => '',
        'type' => 'text'
    );
    $options[] = array(
        'name' => '幻灯片6描述',
        'desc' => '描述内容',
        'id' => 'slidertitle6',
        'std' => '',
        'type' => 'text'
    );


	
	return $options;
	
}