<?php 


/* 
 * 菜单								 www.qiuzhuti.com
 * ====================================================
 */
if (function_exists('register_nav_menus')){
    register_nav_menus( array(
        'main' => __('主页导航'),
    ));
}

/* 
 * 小工具								 www.qiuzhuti.com
 * ====================================================
 */
if (function_exists('register_sidebar')){
  register_sidebar(array(
    'name'          => '文章侧栏',
    'id'            => 'sidebar',
    'before_widget' => '<div class="widget %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>'
  ));
}

/* 
 * 下载按钮								www.qiuzhuti.com
 * ====================================================
 */
function appthemes_add_quicktags() {
?><script type="text/javascript">// <![CDATA[
 
QTags.addButton( 'xydowns', '下载按钮', '<li><a title="填写影片名" href="填写影片下载链接" target="_blank" class="ico_1">填写影片名</a><span><a class="d1" href="填写影片下载链接">迅雷下载</a></span></li>' );
// ]]></script><?php } add_action('admin_print_footer_scripts', 'appthemes_add_quicktags' );

/* 
 * 去掉Category					 	 www.qiuzhuti.com
 * ====================================================
 */

register_activation_hook(__FILE__, 'no_category_base_refresh_rules');
add_action('created_category', 'no_category_base_refresh_rules');
add_action('edited_category', 'no_category_base_refresh_rules');
add_action('delete_category', 'no_category_base_refresh_rules');
function no_category_base_refresh_rules() {
    global $wp_rewrite;
    $wp_rewrite -> flush_rules();
}
 
register_deactivation_hook(__FILE__, 'no_category_base_deactivate');
function no_category_base_deactivate() {
    remove_filter('category_rewrite_rules', 'no_category_base_rewrite_rules');
    // We don't want to insert our custom rules again
    no_category_base_refresh_rules();
}
 
// Remove category base
add_action('init', 'no_category_base_permastruct');
function no_category_base_permastruct() {
    global $wp_rewrite, $wp_version;
    if (version_compare($wp_version, '3.4', '<')) {
        // For pre-3.4 support
        $wp_rewrite -> extra_permastructs['category'][0] = '%category%';
    } else {
        $wp_rewrite -> extra_permastructs['category']['struct'] = '%category%';
    }
}
 
// Add our custom category rewrite rules
add_filter('category_rewrite_rules', 'no_category_base_rewrite_rules');
function no_category_base_rewrite_rules($category_rewrite) {
    //var_dump($category_rewrite); // For Debugging
 
    $category_rewrite = array();
    $categories = get_categories(array('hide_empty' => false));
    foreach ($categories as $category) {
        $category_nicename = $category -> slug;
        if ($category -> parent == $category -> cat_ID)// recursive recursion
            $category -> parent = 0;
        elseif ($category -> parent != 0)
            $category_nicename = get_category_parents($category -> parent, false, '/', true) . $category_nicename;
        $category_rewrite['(' . $category_nicename . ')/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$'] = 'index.php?category_name=$matches[1]&feed=$matches[2]';
        $category_rewrite['(' . $category_nicename . ')/page/?([0-9]{1,})/?$'] = 'index.php?category_name=$matches[1]&paged=$matches[2]';
        $category_rewrite['(' . $category_nicename . ')/?$'] = 'index.php?category_name=$matches[1]';
    }
    // Redirect support from Old Category Base
    global $wp_rewrite;
    $old_category_base = get_option('category_base') ? get_option('category_base') : 'category';
    $old_category_base = trim($old_category_base, '/');
    $category_rewrite[$old_category_base . '/(.*)$'] = 'index.php?category_redirect=$matches[1]';
 
    //var_dump($category_rewrite); // For Debugging
    return $category_rewrite;
}
 
// For Debugging
//add_filter('rewrite_rules_array', 'no_category_base_rewrite_rules_array');
//function no_category_base_rewrite_rules_array($category_rewrite) {
//  var_dump($category_rewrite); // For Debugging
//}
 
// Add 'category_redirect' query variable
add_filter('query_vars', 'no_category_base_query_vars');
function no_category_base_query_vars($public_query_vars) {
    $public_query_vars[] = 'category_redirect';
    return $public_query_vars;
}
 
// Redirect if 'category_redirect' is set
add_filter('request', 'no_category_base_request');
function no_category_base_request($query_vars) {
    //print_r($query_vars); // For Debugging
    if (isset($query_vars['category_redirect'])) {
        $catlink = trailingslashit(get_option('home')) . user_trailingslashit($query_vars['category_redirect'], 'category');
        status_header(301);
        header("Location: $catlink");
        exit();
    }
    return $query_vars;
}
/* 
 * 标题截断							    www.qiuzhuti.com
 * ====================================================
 */
function cut_str($src_str,$cut_length){$return_str='';$i=0;$n=0;$str_length=strlen($src_str);
		while (($n<$cut_length) && ($i<=$str_length))
		{$tmp_str=substr($src_str,$i,1);$ascnum=ord($tmp_str);
		if ($ascnum>=224){$return_str=$return_str.substr($src_str,$i,3); $i=$i+3; $n=$n+2;}
        elseif ($ascnum>=192){$return_str=$return_str.substr($src_str,$i,2);$i=$i+2;$n=$n+2;}
        elseif ($ascnum>=65 && $ascnum<=90){$return_str=$return_str.substr($src_str,$i,1);$i=$i+1;$n=$n+2;}
        else {$return_str=$return_str.substr($src_str,$i,1);$i=$i+1;$n=$n+1;}
    }
    if ($i<$str_length){$return_str = $return_str . '...';}
    if (get_post_status() == 'private'){ $return_str = $return_str . '（private）';}
    return $return_str;};

/* 
 * 页码							     www.qiuzhuti.com
 * ====================================================
 */ 
function qzthemes_paging() {
    $p = 2;
    if ( is_singular() ) return;
    global $wp_query, $paged;
    $max_page = $wp_query->max_num_pages;
    if ( $max_page == 1 ) return;
    echo '<ul class="pagination">';
    if ( empty( $paged ) )$paged = 1;
    // echo '<span class="pages">Page: ' . $paged . ' of ' . $max_page . ' </span> '; 
    echo '<li class="prev-page">';
    previous_posts_link( '上一页' );
    echo '</li>';

    if ( $paged > $p + 1 )p_link( 1, '<li>第一页</li>' );
    if ( $paged > $p + 2 )echo "<li><span>···</span></li>";
    for ( $i = $paged - $p; $i <= $paged + $p; $i++ ) {
        if ( $i > 0 && $i <= $max_page )$i == $paged ? print "<li class=\"active\"><span>{$i}</span></li>" : p_link( $i );
    }
    if ( $paged < $max_page - $p - 1 )echo "<li><span> ... </span></li>";
    if ( $paged < $max_page - $p )p_link( $max_page, '&raquo;' );
    echo '<li class="next-page">';
    next_posts_link( '下一页' );
    echo '</li>';
    echo '<li><span>共 ' . $max_page . ' 页</span></li>';
    echo '</ul>';
}

function qzthemes_custom_paging( $paged, $max_page ) {
    $p = 2;
    global $wp_query;
    if ( $max_page == 1 ) return;
    echo '<div class="pagination"><ul>';
    if ( empty( $paged ) )$paged = 1;
    // echo '<span class="pages">Page: ' . $paged . ' of ' . $max_page . ' </span> '; 
    echo '<li class="prev-page">';
    previous_posts_link( '上一页' );
    echo '</li>';

    if ( $paged > $p + 1 )p_link( 1, '<li>第一页</li>' );
    if ( $paged > $p + 2 )echo "<li><span>···</span></li>";
    for ( $i = $paged - $p; $i <= $paged + $p; $i++ ) {
        if ( $i > 0 && $i <= $max_page )$i == $paged ? print "<li class=\"active\"><span>{$i}</span></li>" : p_link( $i );
    }
    if ( $paged < $max_page - $p - 1 )echo "<li><span> ... </span></li>";
    if ( $paged < $max_page - $p )p_link( $max_page, '&raquo;' );
    echo '<li class="next-page">';
    next_posts_link( '下一页' );
    echo '</li>';
    echo '<li><span>共 ' . $max_page . ' 页</span></li>';
    echo '</ul></div>';
}

function p_link( $i, $title = '' ) {
    if ( $title == '' )$title = "第 {$i} 页";
    echo "<li><a href='", esc_html( get_pagenum_link( $i ) ), "'>{$i}</a></li>";
}

function p_curr_link( $i ) {
    echo '<li><span class="page-numbers current">' . $i . '</span></li>';
}


/* 
 * 添加特色缩略图支持							www.qiuzhuti.com
 * ============================================================
 */
if ( function_exists('add_theme_support') )add_theme_support('post-thumbnails');

/* 
 * 输出缩略图地址							www.qiuzhuti.com
 * ======================================================
 */
function post_thumbnail_src(){
	global $post;
	if( $values = get_post_custom_values("thumb") ) {	//输出自定义域图片地址
		$values = get_post_custom_values("thumb");
		$post_thumbnail_src = $values [0];
	} elseif( has_post_thumbnail() ){    //如果有特色缩略图，则输出缩略图地址
		$thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
		$post_thumbnail_src = $thumbnail_src [0];
	} else {
		$post_thumbnail_src = '';
		ob_start();
		ob_end_clean();
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		if(!empty($matches[1][0])){
			$post_thumbnail_src = $matches[1][0];   //获取该图片 src
		}else{	//如果日志中没有图片，则显示随机图片
			$random = mt_rand(1, 5);
			$post_thumbnail_src = get_template_directory_uri().'/img/random/'.$random.'.jpg';
			//如果日志中没有图片，则显示默认图片
			//$post_thumbnail_src = get_template_directory_uri().'/images/default_thumb.jpg';
		}
	};
	echo $post_thumbnail_src;
} 

/* 
 * 返回缩略图地址  				    	www.qiuzhuti.com
 * ======================================================
 */
function post_thumbnail_src_return(){
  global $post;
  if( $values = get_post_custom_values("thumb") ) { //输出自定义域图片地址
    $values = get_post_custom_values("thumb");
    $post_thumbnail_src = $values [0];
  } elseif( has_post_thumbnail() ){    //如果有特色缩略图，则输出缩略图地址
    $thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
    $post_thumbnail_src = $thumbnail_src [0];
  } else {
    $post_thumbnail_src = '';
    ob_start();
    ob_end_clean();
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  
    if(!empty($matches[1][0])){
      $post_thumbnail_src = $matches[1][0];   //获取该图片 src
    }else{  //如果日志中没有图片，则显示随机图片
      //$random = mt_rand(1, 5);
      //$post_thumbnail_src = get_template_directory_uri().'/img/random/'.$random.'.jpg';
      //如果日志中没有图片，则显示默认图片
      $post_thumbnail_src = get_template_directory_uri().'/img/default_thumb.png';
    }
  };
  return $post_thumbnail_src;
} 


/* 
 * 去除顶部工具栏  				    	www.qiuzhuti.com
 * ======================================================
 */
show_admin_bar( false );


/* 
 * 修改后台底部左侧版权   			    	www.qiuzhuti.com
 * ========================================================
 */
function modify_footer_admin() {
	echo 'Design By <a href="http://www.qiuzhuti.com" target="_blank">求主题出品</a>';
}
add_filter( 'admin_footer_text', 'modify_footer_admin' );

/* 
 * 移除后台底部右侧版权   			    	www.qiuzhuti.com
 * ========================================================
 */ 
function modify_footer_version() {
	return '<a href="http://www.qiuzhuti.com" target="_blank">求主题出品</a>';
}
add_filter( 'update_footer', 'modify_footer_version', 9999 );

/* 
 * 去掉无用的小工具   			    	www.qiuzhuti.com
 * ========================================================
 */  
add_action('widgets_init','unregister_mobantu_widget');
function unregister_mobantu_widget(){
    unregister_widget ('WP_Widget_Search');
    unregister_widget ('WP_Nav_Menu_Widget');
    unregister_widget ( 'WP_Widget_Calendar' );
	unregister_widget ( 'WP_Widget_Pages' );
	unregister_widget ( 'WP_Widget_Archives' );
	unregister_widget ( 'WP_Widget_Links' );
	unregister_widget ( 'WP_Widget_Meta' );
	unregister_widget ( 'WP_Widget_Text' );
	unregister_widget ( 'WP_Widget_Categories' );
	unregister_widget ( 'WP_Widget_Recent_Posts' );
	unregister_widget ( 'WP_Widget_Recent_Comments' );
	unregister_widget ( 'WP_Widget_RSS' );
	unregister_widget ( 'WP_Widget_Tag_Cloud' );
}

/* 
 * WordPress 去除后台标题中的"—— WordPress"   			    	www.qiuzhuti.com
 * ===========================================================================
 */ 
add_filter('admin_title', 'wpdx_custom_admin_title', 10, 2);
function wpdx_custom_admin_title($admin_title, $title){
    return $title.' &lsaquo; 欢迎使用求主题模板 - www.qiuzhuti.com - '.get_bloginfo('name');
}

/* 
 * 修改 WordPress 后台显示字体 			    	www.qiuzhuti.com
 * ===========================================================
 */ 
function admin_lettering(){
    echo'<style type="text/css">
     body{ font-family: Microsoft YaHei;}
    </style>';
    }
add_action('admin_head', 'admin_lettering');

/* 
 * 禁止WordPress头部加载s.w.org			    	www.qiuzhuti.com
 * =============================================================
 */
remove_action( 'wp_head', 'wp_resource_hints', 2 );



//
//// 类型
//  
//add_action( 'init', 'create_types_nonhierarchical_taxonomy', 0 );  
//  
//function create_types_nonhierarchical_taxonomy() {  
//  
//// Labels part for the GUI  
//  
//  $labels = array(  
//    'name' => _x( '电影的类型', 'taxonomy general name' ),  
//    'singular_name' => _x( 'type', 'taxonomy singular name' ),  
//    'search_items' =>  __( 'Search type' ),  
//    'popular_items' => __( 'Popular type' ),  
//    'all_items' => __( 'All type' ),  
//    'parent_item' => null,  
//    'parent_item_colon' => null,  
//    'edit_item' => __( 'Edit type' ),   
//    'update_item' => __( 'Update type' ),  
//    'add_new_item' => __( '添加新的类型' ),  
//    'new_item_name' => __( 'New type Name' ),  
//    'separate_items_with_commas' => __( '电影的类多个类型请用英文逗号（,）分开' ),  
//    'add_or_remove_items' => __( 'Add or remove types' ),  
//    'choose_from_most_used' => __( '从常用类型中选择' ),  
//    'menu_name' => __( '电影的类型' ),  
//  );   
//  
//// Now register the non-hierarchical taxonomy like tag  
//  
//  register_taxonomy('types','post',array(  
//    'hierarchical' => false,  
//    'labels' => $labels,  
//    'show_ui' => true,  
//    'show_admin_column' => true,  
//    'update_count_callback' => '_update_post_term_count',  
//    'query_var' => true,  
//    'rewrite' => array( 'slug' => 'type' ),  
//  ));  
//}  
//// 地区
//  
//add_action( 'init', 'create_areas_nonhierarchical_taxonomy', 0 );  
//  
//function create_areas_nonhierarchical_taxonomy() {  
//  
//// Labels part for the GUI  
//  
//  $labels = array(  
//    'name' => _x( '电影地区', 'taxonomy general name' ),  
//    'singular_name' => _x( 'area', 'taxonomy singular name' ),  
//    'search_items' =>  __( 'Search area' ),  
//    'popular_items' => __( 'Popular area' ),  
//    'all_items' => __( 'All area' ),  
//    'parent_item' => null,  
//    'parent_item_colon' => null,  
//    'edit_item' => __( 'Edit area' ),   
//    'update_item' => __( 'Update area' ),  
//    'add_new_item' => __( '添加新的电影地区' ),  
//    'new_item_name' => __( 'New area Name' ),  
//    'separate_items_with_commas' => __( '多个电影地区请用英文逗号（,）分开' ),  
//    'add_or_remove_items' => __( 'Add or remove areas' ),  
//    'choose_from_most_used' => __( '从常用电影地区中选择' ),  
//    'menu_name' => __( '电影的地区' ),  
//  );   
//  
//// Now register the non-hierarchical taxonomy like tag  
//  
//  register_taxonomy('areas','post',array(  
//    'hierarchical' => false,  
//    'labels' => $labels,  
//    'show_ui' => true,  
//    'show_admin_column' => true,  
//    'update_count_callback' => '_update_post_term_count',  
//    'query_var' => true,  
//    'rewrite' => array( 'slug' => 'area' ),  
//  ));  
//}  
//
//// 年代
//  
//add_action( 'init', 'create_years_nonhierarchical_taxonomy', 0 );  
//  
//function create_years_nonhierarchical_taxonomy() {  
//  
//// Labels part for the GUI  
//  
//  $labels = array(  
//    'name' => _x( '电影年代', 'taxonomy general name' ),  
//    'singular_name' => _x( 'year', 'taxonomy singular name' ),  
//    'search_items' =>  __( 'Search year' ),  
//    'popular_items' => __( 'Popular year' ),  
//    'all_items' => __( 'All year' ),  
//    'parent_item' => null,  
//    'parent_item_colon' => null,  
//    'edit_item' => __( 'Edit year' ),   
//    'update_item' => __( 'Update year' ),  
//    'add_new_item' => __( '添加新的电影年代' ),  
//    'new_item_name' => __( 'New year Name' ),  
//    'separate_items_with_commas' => __( '多个电影年代选请用英文逗号（,）分开' ),  
//    'add_or_remove_items' => __( 'Add or remove years' ),  
//    'choose_from_most_used' => __( '从常用电影年代中选择' ),  
//    'menu_name' => __( '电影的年代' ),  
//  );   
//  
//// Now register the non-hierarchical taxonomy like tag  
//  
//  register_taxonomy('years','post',array(  
//    'hierarchical' => false,  
//    'labels' => $labels,  
//    'show_ui' => true,  
//    'show_admin_column' => true,  
//    'update_count_callback' => '_update_post_term_count',  
//    'query_var' => true,  
//    'rewrite' => array( 'slug' => 'year' ),  
//  ));  
//}  