<?php
function my_custom_post_watch() {
	$labels = array(
			'name'               => _x( '手表', 'post type 名称' ),
			'singular_name'      => _x( '手表', 'post type 单个 item 时的名称，因为英文有复数' ),
			'add_new'            => _x( '新建手表', '添加新内容的链接名称' ),
			'add_new_item'       => __( '新建一个手表' ),
			'edit_item'          => __( '编辑手表' ),
			'new_item'           => __( '新手表' ),
			'all_items'          => __( '所有手表' ),
			'view_item'          => __( '查看手表' ),
			'search_items'       => __( '搜索手表' ),
			'not_found'          => __( '没有找到有关手表' ),
			'not_found_in_trash' => __( '回收站里面没有相关手表' ),
			'parent_item_colon'  => '',
			'menu_name'          => 'Watchs'
	);
	$args = array(
			'labels'        => $labels,
			'description'   => '手表信息',
			'public'        => true,
			'menu_position' => 5,
			'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
			'has_archive'   => true
	);
	register_post_type( 'watch', $args );
}
add_action( 'init', 'my_custom_post_watch' );


add_action( 'init', 'watch_brand' );
function watch_brand() {
	$labels = array(
			'name' => _x( '品牌', 'taxonomy general name' ),
			'singular_name' => _x( '品牌', 'taxonomy singular name' ),
			'search_items' =>  __( '按品牌搜索' ),
			'all_items' => __( '所有品牌' ),
			'parent_item' => __( '上级品牌' ),
			'parent_item_colon' => __( '上级品牌:' ),
			'edit_item' => __( '编辑品牌' ),
			'update_item' => __( '更新品牌' ),
			'add_new_item' => __( '新增品牌' ),
			'new_item_name' => __( '新品牌' ),
	);

	register_taxonomy('brand','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}


add_action( 'init', 'watch_movement' );
function watch_movement() {
	$labels = array(
			'name' => _x( '机芯', 'taxonomy general name' ),
			'singular_name' => _x( '机芯', 'taxonomy singular name' ),
			'search_items' =>  __( '按机芯搜索' ),
			'all_items' => __( '所有机芯' ),
			'parent_item' => __( '上级机芯' ),
			'parent_item_colon' => __( '上级机芯:' ),
			'edit_item' => __( '编辑机芯' ),
			'update_item' => __( '更新机芯' ),
			'add_new_item' => __( '新增机芯' ),
			'new_item_name' => __( '新机芯' ),
	);

	register_taxonomy('movement','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}

add_action( 'init', 'watch_dia' );
function watch_dia() {
	$labels = array(
			'name' => _x( '直径', 'taxonomy general name' ),
			'singular_name' => _x( '直径', 'taxonomy singular name' ),
			'search_items' =>  __( '按直径搜索' ),
			'all_items' => __( '所有直径' ),
			'parent_item' => __( '上级直径' ),
			'parent_item_colon' => __( '上级直径:' ),
			'edit_item' => __( '编辑直径' ),
			'update_item' => __( '更新直径' ),
			'add_new_item' => __( '新增直径' ),
			'new_item_name' => __( '新直径' ),
	);

	register_taxonomy('dia','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}

add_action( 'init', 'watch_case' );
function watch_case() {
	$labels = array(
			'name' => _x( '表壳', 'taxonomy general name' ),
			'singular_name' => _x( '表壳', 'taxonomy singular name' ),
			'search_items' =>  __( '按表壳搜索' ),
			'all_items' => __( '所有表壳' ),
			'parent_item' => __( '上级表壳' ),
			'parent_item_colon' => __( '上级表壳:' ),
			'edit_item' => __( '编辑表壳' ),
			'update_item' => __( '更新表壳' ),
			'add_new_item' => __( '新增表壳' ),
			'new_item_name' => __( '新表壳' ),
	);

	register_taxonomy('case','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}

add_action( 'init', 'watch_strap' );
function watch_strap() {
	$labels = array(
			'name' => _x( '表带', 'taxonomy general name' ),
			'singular_name' => _x( '表带', 'taxonomy singular name' ),
			'search_items' =>  __( '按表带搜索' ),
			'all_items' => __( '所有表带' ),
			'parent_item' => __( '上级表带' ),
			'parent_item_colon' => __( '上级表带:' ),
			'edit_item' => __( '编辑表带' ),
			'update_item' => __( '更新表带' ),
			'add_new_item' => __( '新增表带' ),
			'new_item_name' => __( '新表带' ),
	);

	register_taxonomy('strap','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}


add_action( 'init', 'watch_gender' );
function watch_gender() {
	$labels = array(
			'name' => _x( '性别', 'taxonomy general name' ),
			'singular_name' => _x( '性别', 'taxonomy singular name' ),
			'search_items' =>  __( '按性别搜索' ),
			'all_items' => __( '所有性别' ),
			'parent_item' => __( '上级性别' ),
			'parent_item_colon' => __( '上级性别:' ),
			'edit_item' => __( '编辑性别' ),
			'update_item' => __( '更新性别' ),
			'add_new_item' => __( '新增性别' ),
			'new_item_name' => __( '新性别' ),
	);

	register_taxonomy('gender','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}



add_action( 'init', 'watch_style' );
function watch_style() {
	$labels = array(
			'name' => _x( '风格', 'taxonomy general name' ),
			'singular_name' => _x( '风格', 'taxonomy singular name' ),
			'search_items' =>  __( '按风格搜索' ),
			'all_items' => __( '所有风格' ),
			'parent_item' => __( '上级风格' ),
			'parent_item_colon' => __( '上级风格:' ),
			'edit_item' => __( '编辑风格' ),
			'update_item' => __( '更新风格' ),
			'add_new_item' => __( '新增风格' ),
			'new_item_name' => __( '新风格' ),
	);

	register_taxonomy('style','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}




add_action( 'init', 'watch_price' );
function watch_price() {
	$labels = array(
			'name' => _x( '价格', 'taxonomy general name' ),
			'singular_name' => _x( '价格', 'taxonomy singular name' ),
			'search_items' =>  __( '按价格搜索' ),
			'all_items' => __( '所有价格' ),
			'parent_item' => __( '上级价格' ),
			'parent_item_colon' => __( '上级价格:' ),
			'edit_item' => __( '编辑价格' ),
			'update_item' => __( '更新价格' ),
			'add_new_item' => __( '新增价格' ),
			'new_item_name' => __( '新价格' ),
	);

	register_taxonomy('price','watch',array(
			'hierarchical' => true,
			'labels' => $labels
	));
}


function selfURL(){  
    $pageURL = 'http';
    $pageURL .= (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on")?"s":"";
    $pageURL .= "://";
    $pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
    return $pageURL;      
}