﻿(function(jQuery){

	jq.fn.BreakingNews = function(settings){
			var defaults={
					background		:'#FFF',
					title			:'NEWS',
					titlecolor		:'#FFF',
					titlebgcolor	:'#5aa628',
					linkcolor		:'#333',
					linkhovercolor	:'#5aa628',
					fonttextsize	:16,
					isbold			:false,
					border			:'none',
					width			:'100%',
					autoplay		:true,
					timer			:3000,
					modulid			:'brekingnews',
					effect			:'fade'	//or slide	
				};
			var settings=jq.extend(defaults,settings);
			
			return this.each(function(){
				settings.modulid="#"+jq(this).attr("id");
				var timername=settings.modulid;
				var activenewsid=1;
				
				if (settings.isbold==true)
					fontw='bold';
				else
					fontw='normal';	
					
				if (settings.effect=='slide')
					jq(settings.modulid+' ul li').css({'display':'block'});
				else
					jq(settings.modulid+' ul li').css({'display':'none'});				
				
				jq(settings.modulid+' .bn-title').html(settings.title);
				jq(settings.modulid).css({'width':settings.width, 'background':settings.background, 'border':settings.border, 'font-size':settings.fonttextsize });
				jq(settings.modulid+' ul').css({'left':jq(settings.modulid+' .bn-title').width()+40});
				jq(settings.modulid+' .bn-title').css({'background':settings.titlebgcolor,'color':settings.titlecolor,'font-weight':fontw});
				jq(settings.modulid+' ul li a').css({'color':settings.linkcolor,'font-weight':fontw,'height':parseInt(settings.fonttextsize)+6});
				jq(settings.modulid+' ul li').eq( parseInt(activenewsid-1) ).css({'display':'block'});
				
				// Links hover events ......
				jq(settings.modulid+' ul li a').hover(function() 
					{
                    	jq(this).css({'color':settings.linkhovercolor});
					},
					function ()
					{
						jq(this).css({'color':settings.linkcolor});
					}
				);
				
				
				// Arrows Click Events ......
				jq(settings.modulid+' .bn-arrows span').click(function(e) {
                    if ( jq(this).attr('class')=="bn-arrows-left" )
						BnAutoPlay('prev');
					else
						BnAutoPlay('next');
                });
				
				// Timer events ...............
				if (settings.autoplay==true)
				{
					timername=setInterval(function(){BnAutoPlay('next')},settings.timer);					
					jq(settings.modulid).hover(function()
						{
							clearInterval(timername);
						},
						function()
						{
							timername=setInterval(function(){BnAutoPlay('next')},settings.timer);
						}
					);
				}
				else
				{
					clearInterval(timername);
				}
				
				//timer and click events function ...........
				function BnAutoPlay(pos)
				{
					if ( pos=="next" )
					{
						if ( jq(settings.modulid+' ul li').length>activenewsid )
							activenewsid++;
						else
							activenewsid=1;
					}
					else
					{
						if (activenewsid-2==-1)
							activenewsid=jq(settings.modulid+' ul li').length;
						else
							activenewsid=activenewsid-1;						
					}
					
					if (settings.effect=='fade')
					{
						jq(settings.modulid+' ul li').css({'display':'none'});
						jq(settings.modulid+' ul li').eq( parseInt(activenewsid-1) ).fadeIn();
					}
					else
					{
						jq(settings.modulid+' ul').animate({'marginTop':-(jq(settings.modulid+' ul li').height()+20)*(activenewsid-1)});
					}
				}
				
				// links size calgulating function ...........
				jq(window).resize(function(e) {
                    if ( jq(settings.modulid).width()<360 )
					{
						jq(settings.modulid+' .bn-title').html('&nbsp;');
						jq(settings.modulid+' .bn-title').css({ 'width':'4px', 'padding':'10px 0px'});
						jq(settings.modulid+' ul').css({'left':4});
					}else
					{
						jq(settings.modulid+' .bn-title').html(settings.title);
						jq(settings.modulid+' .bn-title').css({ 'width':'auto', 'padding':'10px 20px'});
						jq(settings.modulid+' ul').css({'left':jq(settings.modulid+' .bn-title').width()+40});
					}
                });
			});
			
		};
		
})(jQuery);